/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMenuElement.h"

#include "HTMLMenuElement.h"
#include "HTMLNames.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLMenuElementTableValues[] =
{
    { "compact", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMenuElementCompact), (intptr_t)setJSHTMLMenuElementCompact, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMenuElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMenuElementTable = { 4, 3, JSHTMLMenuElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLMenuElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMenuElementConstructorTable = { 1, 0, JSHTMLMenuElementConstructorTableValues, 0 };
const ClassInfo JSHTMLMenuElementConstructor::s_info = { "HTMLMenuElementConstructor", &Base::s_info, &JSHTMLMenuElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLMenuElementConstructor) };

JSHTMLMenuElementConstructor::JSHTMLMenuElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLMenuElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLMenuElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLMenuElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMenuElementConstructor, JSDOMWrapper>(exec, &JSHTMLMenuElementConstructorTable, jsCast<JSHTMLMenuElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLMenuElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMenuElementConstructor, JSDOMWrapper>(exec, &JSHTMLMenuElementConstructorTable, jsCast<JSHTMLMenuElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMenuElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMenuElementPrototypeTable = { 1, 0, JSHTMLMenuElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLMenuElementPrototype::s_info = { "HTMLMenuElementPrototype", &Base::s_info, &JSHTMLMenuElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLMenuElementPrototype) };

JSObject* JSHTMLMenuElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMenuElement>(exec, globalObject);
}

const ClassInfo JSHTMLMenuElement::s_info = { "HTMLMenuElement", &Base::s_info, &JSHTMLMenuElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLMenuElement) };

JSHTMLMenuElement::JSHTMLMenuElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLMenuElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLMenuElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLMenuElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLMenuElementPrototype::create(exec->vm(), globalObject, JSHTMLMenuElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLMenuElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLMenuElement* thisObject = jsCast<JSHTMLMenuElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLMenuElement, Base>(exec, &JSHTMLMenuElementTable, thisObject, propertyName, slot);
}

bool JSHTMLMenuElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLMenuElement* thisObject = jsCast<JSHTMLMenuElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLMenuElement, Base>(exec, &JSHTMLMenuElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLMenuElementCompact(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMenuElement* castedThis = jsCast<JSHTMLMenuElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMenuElement* impl = static_cast<HTMLMenuElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::compactAttr));
    return result;
}


JSValue jsHTMLMenuElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMenuElement* domObject = jsCast<JSHTMLMenuElement*>(asObject(slotBase));
    return JSHTMLMenuElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLMenuElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLMenuElement* thisObject = jsCast<JSHTMLMenuElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLMenuElement, Base>(exec, propertyName, value, &JSHTMLMenuElementTable, thisObject, slot);
}

void setJSHTMLMenuElementCompact(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMenuElement* castedThis = jsCast<JSHTMLMenuElement*>(thisObject);
    HTMLMenuElement* impl = static_cast<HTMLMenuElement*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setBooleanAttribute(WebCore::HTMLNames::compactAttr, nativeValue);
}


JSValue JSHTMLMenuElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMenuElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
