/*
 * This file contains D-Bus adaptor classes generated by qt-svc-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#include <TelepathyQt/AbstractAdaptor>
#include <TelepathyQt/Global>
#include <TelepathyQt/Types>

#include <QObject>
#include <QtDBus>

namespace Tp
{
namespace Service
{

/**
 * \class CallContentAdaptor
 * \headerfile TelepathyQt/_gen/svc-call.h <TelepathyQt/_gen/svc-call.h>
 * \ingroup servicecall
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content".
 */
class  CallContentAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Call1.Content")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Call1.Content\">\n"
"    <property access=\"read\" type=\"as\" name=\"Interfaces\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Name\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"Type\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"Disposition\"/>\n"
"    <property access=\"read\" type=\"ao\" name=\"Streams\"/>\n"
"    <method name=\"Remove\"/>\n"
"    <signal name=\"StreamsAdded\">\n"
"      <arg type=\"ao\" name=\"streams\"/>\n"
"    </signal>\n"
"    <signal name=\"StreamsRemoved\">\n"
"      <arg type=\"ao\" name=\"streams\"/>\n"
"      <arg type=\"(uuss)\" name=\"reason\">\n"
"        <annotation value=\"Tp::CallStateReason\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList Interfaces READ Interfaces )
    Q_PROPERTY(QString Name READ Name )
    Q_PROPERTY(uint Type READ Type )
    Q_PROPERTY(uint Disposition READ Disposition )
    Q_PROPERTY(Tp::ObjectPathList Streams READ Streams )

public:
    CallContentAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~CallContentAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > RemoveContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Interfaces of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'interfaces' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>Extra interfaces provided by this content, such as  \endhtmlonly CallContentInterfaceMediaInterface \htmlonly ,
     *    \endhtmlonly ChannelInterfaceHoldInterface \htmlonly  or
     *    \endhtmlonly CallInterfaceMuteInterface \htmlonly .
     *   This SHOULD NOT include the Content interface itself, and cannot
     *   change once the content has been created.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Interfaces.
     */
    QStringList Interfaces() const;
    /**
     * Return the value of the exported D-Bus object property \c Name of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'name' with type QString.
     *
     * 
     * \htmlonly
     * <p>The name of the content.</p>
     * 
     * <div class="rationale">
     *   The content name property should be meaningful, so should be
     *   given a name which is significant to the user. The name
     *   could be the &quot;audio&quot; or &quot;video&quot; string localized, or perhaps
     *   include some string identifying the source, such as a webcam
     *   identifier.
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Name.
     */
    QString Name() const;
    /**
     * Return the value of the exported D-Bus object property \c Type of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'type' with type uint.
     *
     * 
     * \htmlonly
     * <p>The media type of this content.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Type.
     */
    uint Type() const;
    /**
     * Return the value of the exported D-Bus object property \c Disposition of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'disposition' with type uint.
     *
     * 
     * The disposition of this content.
     *
     * \return The value of exported property \c Disposition.
     */
    uint Disposition() const;
    /**
     * Return the value of the exported D-Bus object property \c Streams of type \c Tp::ObjectPathList.
     *
     * Adaptees should export this property as a Qt property named
     * 'streams' with type Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>The list of  \endhtmlonly CallStreamInterface \htmlonly  objects that exist in this
     *   content.</p>
     * 
     * <div class="rationale">
     *   In a conference call multiple parties can share one media
     *   content (say, audio), but the streaming of that media can
     *   either be shared or separate. For example, in a multicast
     *   conference all contacts would share one stream, while in a
     *   Muji conference there would be a stream for each
     *   participant.
     * </div>
     * 
     * <p>Change notification is through the
     *    \endhtmlonly StreamsAdded() \htmlonly  and
     *    \endhtmlonly StreamsRemoved() \htmlonly  signals.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Streams.
     */
    Tp::ObjectPathList Streams() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Remove on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void remove(const Tp::Service::CallContentAdaptor::RemoveContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Remove the content from the call. This will cause 
     * Call1.ContentRemoved((self_handle, User_Requested, &quot;&quot;, 
     * &quot;&quot;)) to be emitted.
     *
     */
    void Remove(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c StreamsAdded on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void streamsAdded(const Tp::ObjectPathList& streams);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param streams
     *     
     *     The Streams which were added.
     */
    void StreamsAdded(const Tp::ObjectPathList& streams);
    /**
     * Represents the exported D-Bus signal \c StreamsRemoved on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void streamsRemoved(const Tp::ObjectPathList& streams, const Tp::CallStateReason& reason);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param streams
     *     
     *     The Streams which were removed.
     * \param reason
     *     
     *     Why the content was removed.
     */
    void StreamsRemoved(const Tp::ObjectPathList& streams, const Tp::CallStateReason& reason);
};

/**
 * \class CallContentInterfaceDTMFAdaptor
 * \headerfile TelepathyQt/_gen/svc-call.h <TelepathyQt/_gen/svc-call.h>
 * \ingroup servicecall
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.Interface.DTMF".
 */
class  CallContentInterfaceDTMFAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Call1.Content.Interface.DTMF")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Call1.Content.Interface.DTMF\">\n"
"    <property access=\"read\" type=\"b\" name=\"CurrentlySendingTones\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"DeferredTones\"/>\n"
"    <method name=\"StartTone\">\n"
"      <arg direction=\"in\" type=\"y\" name=\"event\"/>\n"
"    </method>\n"
"    <method name=\"StopTone\"/>\n"
"    <method name=\"MultipleTones\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"tones\"/>\n"
"    </method>\n"
"    <signal name=\"TonesDeferred\">\n"
"      <arg type=\"s\" name=\"tones\"/>\n"
"    </signal>\n"
"    <signal name=\"SendingTones\">\n"
"      <arg type=\"s\" name=\"tones\"/>\n"
"    </signal>\n"
"    <signal name=\"StoppedTones\">\n"
"      <arg type=\"b\" name=\"cancelled\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool CurrentlySendingTones READ CurrentlySendingTones )
    Q_PROPERTY(QString DeferredTones READ DeferredTones )

public:
    CallContentInterfaceDTMFAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~CallContentInterfaceDTMFAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > StartToneContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > StopToneContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > MultipleTonesContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c CurrentlySendingTones of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'currentlySendingTones' with type bool.
     *
     * 
     * Indicates whether there are DTMF tones currently being sent in the 
     * channel. If so, the client should wait for StoppedTones signal before 
     * trying to send more tones.
     *
     * \return The value of exported property \c CurrentlySendingTones.
     */
    bool CurrentlySendingTones() const;
    /**
     * Return the value of the exported D-Bus object property \c DeferredTones of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'deferredTones' with type QString.
     *
     * 
     * \htmlonly
     * <p>The tones waiting for the user to continue, if any.</p>
     * 
     * <p>When this property is set to a non-empty value,
     *    \endhtmlonly TonesDeferred() \htmlonly  is emitted.
     *   When any tones are played (i.e. whenever
     *    \endhtmlonly SendingTones() \htmlonly  is emitted),
     *   this property is reset to the empty string.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c DeferredTones.
     */
    QString DeferredTones() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c StartTone on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void startTone(uchar event, const Tp::Service::CallContentInterfaceDTMFAdaptor::StartToneContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Start sending a DTMF tone to all eligible streams in the channel. Where 
     * possible, the tone will continue until StopTone is called. On certain 
     * protocols, it may only be possible to send events with a predetermined 
     * length. In this case, the implementation MAY emit a fixed-length tone, 
     * and the StopTone method call SHOULD return NotAvailable. The client may 
     * wish to control the exact duration and timing of the tones sent as a 
     * result of user&apos;s interaction with the dialpad, thus starting and 
     * stopping the tone sending explicitly. Tone overlaping or queueing is 
     * not supported, so this method can only be called if no DTMF tones are 
     * already being played.
     *
     * \param event
     *     
     *     A numeric event code from the DTMF_Event enum.
     */
    void StartTone(uchar event, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c StopTone on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void stopTone(const Tp::Service::CallContentInterfaceDTMFAdaptor::StopToneContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Stop sending any DTMF tones which have been started using the StartTone 
     * or MultipleTones methods. If there is no current tone, this method will 
     * do nothing. If MultipleTones was used, the client should not assume the 
     * sending has stopped immediately; instead, the client should wait for 
     * the StoppedTones signal. On some protocols it might be impossible to 
     * cancel queued tones immediately.
     *
     */
    void StopTone(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c MultipleTones on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void multipleTones(const QString& tones, const Tp::Service::CallContentInterfaceDTMFAdaptor::MultipleTonesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Send multiple DTMF events to all eligible streams in the channel. Each 
     * tone will be played for an implementation-defined number of 
     * milliseconds (typically 250ms), followed by a gap before the next tone 
     * is played (typically 100ms). The duration and gap are defined by the 
     * protocol or connection manager. In cases where the client knows in 
     * advance the tone sequence it wants to send, it&apos;s easier to use 
     * this method than manually start and stop each tone in the sequence. The 
     * tone and gap lengths may need to vary for interoperability, according 
     * to the protocol and other implementations&apos; ability to recognise 
     * tones. At the time of writing, GStreamer uses a minimum of 250ms tones 
     * and 100ms gaps when playing in-band DTMF in the normal audio stream, or 
     * 70ms tones and 50ms gaps when encoding DTMF as audio/telephone-event. 
     * Tone overlaping or queueing is not supported, so this method can only 
     * be called if no DTMF tones are already being played.
     *
     * \param tones
     *     
     *     \htmlonly
     *     <p>A string representation of one or more DTMF
     *       events. Implementations of this method MUST support all of the
     *       following characters in this string:</p>
     *     
     *     <ul>
     *       <li>the digits 0-9, letters A-D and a-d, and symbols '*' and '#'
     *         correspond to the members of <tp:type>DTMF_Event</tp:type></li>
     *     
     *       <li>any of 'p', 'P', 'x', 'X' or ',' (comma) results in an
     *         implementation-defined pause, typically for 3 seconds</li>
     *     
     *       <li>'w' or 'W' waits for the user to continue, by stopping
     *         interpretation of the string, and if there is more to be played,
     *         emitting the  \\\\endhtmlonly TonesDeferred() \\\\htmlonly  signal
     *         with the rest of the string as its argument: see that signal
     *         for details</li>
     *     </ul>
     *     \endhtmlonly
     */
    void MultipleTones(const QString& tones, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c TonesDeferred on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void tonesDeferred(const QString& tones);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param tones
     *     
     *     The new non-empty value of DeferredTones.
     */
    void TonesDeferred(const QString& tones);
    /**
     * Represents the exported D-Bus signal \c SendingTones on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void sendingTones(const QString& tones);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param tones
     *     
     *     DTMF string (one or more events) that is to be played.
     */
    void SendingTones(const QString& tones);
    /**
     * Represents the exported D-Bus signal \c StoppedTones on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void stoppedTones(bool cancelled);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param cancelled
     *     
     *     True if the DTMF tones were actively cancelled via StopTone.
     */
    void StoppedTones(bool cancelled);
};

/**
 * \class CallInterfaceMuteAdaptor
 * \headerfile TelepathyQt/_gen/svc-call.h <TelepathyQt/_gen/svc-call.h>
 * \ingroup servicecall
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Interface.Mute".
 */
class  CallInterfaceMuteAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Call1.Interface.Mute")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Call1.Interface.Mute\">\n"
"    <property access=\"read\" type=\"u\" name=\"LocalMuteState\"/>\n"
"    <method name=\"RequestMuted\">\n"
"      <arg direction=\"in\" type=\"b\" name=\"muted\"/>\n"
"    </method>\n"
"    <signal name=\"MuteStateChanged\">\n"
"      <arg type=\"u\" name=\"muteState\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint LocalMuteState READ LocalMuteState )

public:
    CallInterfaceMuteAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~CallInterfaceMuteAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > RequestMutedContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c LocalMuteState of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'localMuteState' with type uint.
     *
     * 
     * The current mute state of this part of the call. New Contents should 
     * inherit the value of this property from the parent Call1. Similarly, 
     * Streams should inherit it from the parent Content.
     *
     * \return The value of exported property \c LocalMuteState.
     */
    uint LocalMuteState() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c RequestMuted on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestMuted(bool muted, const Tp::Service::CallInterfaceMuteAdaptor::RequestMutedContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Inform the CM that the Call, Content or Stream should be muted or 
     * unmuted. The CM will tell the streaming implementation to Mute Streams 
     * as required, and emit MuteStateChanged when done.
     *
     * \param muted
     *     
     *     True if the client wishes to mute the Content or Call.
     */
    void RequestMuted(bool muted, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c MuteStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void muteStateChanged(uint muteState);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param muteState
     *     
     *     The new mute state.
     */
    void MuteStateChanged(uint muteState);
};

}
}