#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2021 Hoël Bézier <hoelbezier@riseup.net>
set -o errexit

###
# 140
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250325.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='140-game'
GAME_NAME='140'

ARCHIVE_BASE_GOG_3_NAME='140_1010_2019_33250.sh'
ARCHIVE_BASE_GOG_3_MD5='cbfdc455cf49c88aea3cb62d23fccb55'
ARCHIVE_BASE_GOG_3_SIZE='130000'
ARCHIVE_BASE_GOG_3_VERSION='2019.10.10.r473-gog33250'
ARCHIVE_BASE_GOG_3_URL='https://www.gog.com/game/140_game'

ARCHIVE_BASE_GOG_2_NAME='140_en_171409_r400_22641.sh'
ARCHIVE_BASE_GOG_2_MD5='69a67be9632ad2b7db02b3d11486d81b'
ARCHIVE_BASE_GOG_2_SIZE='130000'
ARCHIVE_BASE_GOG_2_VERSION='2017.09.14.r400-gog22641'

ARCHIVE_BASE_GOG_1_NAME='gog_140_2.2.0.3.sh'
ARCHIVE_BASE_GOG_1_MD5='03e760fa1b667059db7713a9e6c06b6d'
ARCHIVE_BASE_GOG_1_SIZE='130000'
ARCHIVE_BASE_GOG_1_VERSION='2017.07.19.r370-gog2.2.0.3'

ARCHIVE_BASE_GOG_0_NAME='gog_140_2.1.0.2.sh'
ARCHIVE_BASE_GOG_0_MD5='6139b77721657a919085aea9f13cf42b'
ARCHIVE_BASE_GOG_0_SIZE='130000'
ARCHIVE_BASE_GOG_0_VERSION='2017.06.19-gog2.1.0.2'

ARCHIVE_BASE_GOG_OLDNAME_0_NAME='gog_140_2.0.0.1.sh'
ARCHIVE_BASE_GOG_OLDNAME_0_MD5='49ec4cff5fa682517e640a2d0eb282c8'
ARCHIVE_BASE_GOG_OLDNAME_0_SIZE='110000'
ARCHIVE_BASE_GOG_OLDNAME_0_VERSION='2.0-gog2.0.0.1'

ARCHIVE_BASE_HUMBLE_1_NAME='140-2019-09-10-145438-r473-linux-nodrm.zip'
ARCHIVE_BASE_HUMBLE_1_MD5='5b5e46c1c4c4dd31f8f29d8fa1207562'
ARCHIVE_BASE_HUMBLE_1_SIZE='130000'
ARCHIVE_BASE_HUMBLE_1_VERSION='2019.10.10.r473-humble.2019.10.11'
ARCHIVE_BASE_HUMBLE_1_URL='https://www.humblebundle.com/store/140'

ARCHIVE_BASE_HUMBLE_ALTPATH_0_NAME='140-nodrm-linux-2017-07-19-r370.zip'
ARCHIVE_BASE_HUMBLE_ALTPATH_0_MD5='2444ec7803c5d6dcf161b722705f0402'
ARCHIVE_BASE_HUMBLE_ALTPATH_0_SIZE='130000'
ARCHIVE_BASE_HUMBLE_ALTPATH_0_VERSION='2017.07.19.r370-humble.2017.08.04'

ARCHIVE_BASE_HUMBLE_0_NAME='140-nodrm-linux-2017-06-20.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='5bbc48b203291ca9a0b141e3d07dacbe'
ARCHIVE_BASE_HUMBLE_0_SIZE='130000'
ARCHIVE_BASE_HUMBLE_0_VERSION='2017.06.19-humble.2017.06.20'

ARCHIVE_BASE_HUMBLE_OLDNAME_0_NAME='140_Linux.zip'
ARCHIVE_BASE_HUMBLE_OLDNAME_0_MD5='0829eb743010653633571b3da20502a8'
ARCHIVE_BASE_HUMBLE_OLDNAME_0_SIZE='110000'
ARCHIVE_BASE_HUMBLE_OLDNAME_0_VERSION='2.0-humble.2016.09.14'

UNITY3D_NAME='140Linux'
UNITY3D_NAME_HUMBLE_OLDNAME='140'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='linux'
CONTENT_PATH_DEFAULT_HUMBLE_ALTPATH='.'
CONTENT_PATH_DEFAULT_HUMBLE_OLDNAME='.'

CONTENT_GAME_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'

# Use persistent storage for game progress

USER_PERSISTENT_FILES='
140.sav'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

pkg_setup() {
	option_package=$(option_value 'package')
	case "$option_package" in
		('arch'|'gentoo')
			PKG_BIN64_ARCH='64'
			PKG_BIN64_DEPENDENCIES_LIBRARIES="$CONTENT_GAME_BIN_DEPENDENCIES_LIBRARIES"
			PKG_BIN32_ARCH='32'
			PKG_BIN32_DEPENDENCIES_LIBRARIES="$CONTENT_GAME_BIN_DEPENDENCIES_LIBRARIES"
		;;
		('deb')
			PKG_DATA_ID="${GAME_ID}-data"
			PKG_DATA_DESCRIPTION='data'
			PKG_BIN64_ARCH='64'
			PKG_BIN64_DEPENDENCIES_SIBLINGS='
			PKG_DATA'
			PKG_BIN64_DEPENDENCIES_LIBRARIES="$CONTENT_GAME_BIN_DEPENDENCIES_LIBRARIES"
			PKG_BIN32_ARCH='32'
			PKG_BIN32_DEPENDENCIES_SIBLINGS='
			PKG_DATA'
			PKG_BIN32_DEPENDENCIES_LIBRARIES="$CONTENT_GAME_BIN_DEPENDENCIES_LIBRARIES"
		;;
		('egentoo')
			PKG_BIN64_ARCH='64'
			PKG_BIN32_ARCH='32'
			PKG_DEPENDENCIES_LIBRARIES="$CONTENT_GAME_BIN_DEPENDENCIES_LIBRARIES"
			PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_DEPENDENCIES_LIBRARIES" # play.it 2.20 uses 64-bit binary packages dependencies
		;;
		(*)
			error_option_invalid 'package' "$option_package"
			return 1
		;;
	esac
}

src_extract() {
	archive_extraction_default
}

src_prepare() {
	# Nothing to do here
	return 0
}

pkg_prepare() {
	option_package=$(option_value 'package')
	case "$option_package" in
		('deb'|'egentoo')
			content_inclusion_default
		;;
		('arch'|'gentoo')
			content_inclusion_default
			# Copy data files into both binary packages
			local GAME_DATA_PATH target_path_bin32 target_path_bin64
			GAME_DATA_PATH="${PLAYIT_WORKDIR}/gamedata/$(content_path 'GAME_DATA')"
			target_path_bin32="$(realpath --canonicalize-missing "$(package_path 'PKG_BIN32')$(path_game_data)")"
			target_path_bin64="$(realpath --canonicalize-missing "$(package_path 'PKG_BIN64')$(path_game_data)")"

			(
				cd "$GAME_DATA_PATH"
				local file_pattern file_path
				while read -r file_pattern; do
					pwd
					if [ -z "$file_pattern" ]; then
						continue
					fi
					if [ -e "$file_pattern" ]; then
						mkdir --parents "$target_path_bin32"
						mkdir --parents "$target_path_bin64"
						cp \
							--force \
							--link \
							--recursive \
							--no-dereference \
							--parents \
							--preserve=links \
							"$file_pattern" "$target_path_bin32"
						cp \
							--force \
							--link \
							--recursive \
							--no-dereference \
							--parents \
							--preserve=links \
							"$file_pattern" "$target_path_bin64"
						rm --force --recursive "$file_pattern"
					else
						while read -r file_path; do
							mkdir --parents "$target_path_bin32"
							mkdir --parents "$target_path_bin64"
							cp \
								--force \
								--link \
								--recursive \
								--no-dereference \
								--parents \
								--preserve=links \
								"$file_pattern" "$target_path_bin32"
							cp \
								--force \
								--link \
								--recursive \
								--no-dereference \
								--parents \
								--preserve=links \
								"$file_pattern" "$target_path_bin64"
							rm --force --recursive "$file_pattern"
						done <<- EOF
						$(find . -path "./${file_pattern#./}")
						EOF
					fi
				done <<- EOF
				$(content_files 'GAME_DATA')
				EOF
			)
		;;
		(*)
			error_option_invalid 'package' "$option_package"
			return 1
		;;
	esac
}

src_clean() {
	# Nothing to do here
	return 0
}

pkg_icons() {
	option_package=$(option_value 'package')
	case "$option_package" in
		('deb'|'egentoo')
			content_inclusion_icons 'PKG_DATA'
		;;
		('arch'|'gentoo')
			content_inclusion_icons 'PKG_BIN64'
			content_inclusion_icons 'PKG_BIN32'
		;;
		(*)
			error_option_invalid 'package' "$option_package"
			return 1
		;;
	esac
}

pkg_launchers() {
	launchers_generation 'PKG_BIN64'
	launchers_generation 'PKG_BIN32'
}

pkg_build() {
	packages_generation
}

pkg_clean() {
	working_directory_cleanup
}

pkg_instructions() {
	print_instructions
}

## Ensure that the default package is correctly set,
## despite PACKAGES_LIST not being set early
init_package() {
	option_package=$(option_value 'package')
	case "$option_package" in
		('arch'|'gentoo')
			PACKAGES_LIST='
			PKG_BIN64
			PKG_BIN32'
		;;
		('deb')
			PACKAGES_LIST='
			PKG_BIN64
			PKG_BIN32
			PKG_DATA'
		;;
		('egentoo')
			PACKAGES_LIST='
			PKG_BIN64
			PKG_BIN32
			PKG_DATA'
		;;
		(*)
			error_option_invalid 'package' "$option_package"
			return 1
		;;
	esac
	set_default_package 'PKG_BIN64'
}

## Run the default initialization actions
initialization_default "$@"

pkg_setup
src_extract
src_prepare
pkg_icons ## must be called before pkg_prepare
pkg_prepare
src_clean
pkg_launchers
pkg_build
pkg_instructions
pkg_clean ## must be called after pkg_instructions

exit 0
