#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# Ascendant
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250615.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='ascendant'
GAME_NAME='Ascendant'

ARCHIVE_BASE_0_NAME='gog_ascendant_2.2.0.7.sh'
ARCHIVE_BASE_0_MD5='8cdcd59a2f8363b7237e9cbe2675adda'
ARCHIVE_BASE_0_SIZE='2400000'
ARCHIVE_BASE_0_VERSION='1.2.2-gog2.2.0.7'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/ascendant'

UNITY3D_NAME='Ascendant'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libatk-1.0.so.0
libcairo.so.2
libc.so.6
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libgdk-x11-2.0.so.0
libgio-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgmodule-2.0.so.0
libgobject-2.0.so.0
libgthread-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpango-1.0.so.0
libpangocairo-1.0.so.0
libpangoft2-1.0.so.0
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXext.so.6
libXrandr.so.2'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "$PLAYIT_WORKDIR/gamedata/$(content_path_default)"

	# Work around massive files duplication between 32-bit and 64-bit builds.
	## Merge data directories for 32-bit and 64-bit builds.
	UNITY3D_NAME_64BIT='Ascendant_64'
	cp --force --recursive --link "${UNITY3D_NAME_64BIT}_Data"/* "$(unity3d_name)_Data"
	rm --force --recursive "${UNITY3D_NAME_64BIT}_Data"
	## Rename 64-bit binary.
	mv "${UNITY3D_NAME_64BIT}.x86_64" "$(unity3d_name).x86_64"
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Do not disable MAP_32BIT flag, as it would lead to the following crash:
##
## #0  __pthread_kill_implementation (threadid=<optimized out>, signo=signo@entry=11, no_tid=no_tid@entry=0) at ./nptl/pthread_kill.c:44
## #1  0x00007ffff7a9c9ff in __pthread_kill_internal (threadid=<optimized out>, signo=11) at ./nptl/pthread_kill.c:89
## #2  0x00007ffff7a47cc2 in __GI_raise (sig=11) at ../sysdeps/posix/raise.c:26
## #3  0x00007ffff239a244 in ?? () from (…)/Ascendant_Data/Mono/x86_64/libmono.so
## #4  0x00007ffff239a2ce in ?? () from (…)/Ascendant_Data/Mono/x86_64/libmono.so
## #5  0x00007ffff22d186c in ?? () from (…)/Ascendant_Data/Mono/x86_64/libmono.so
## #6  0x00007ffff22946ef in ?? () from (…)/Ascendant_Data/Mono/x86_64/libmono.so
## #7  0x00007ffff7fa7171 in ?? ()
## #8  0x00007ffff23affb9 in ?? () from (…)/Ascendant_Data/Mono/x86_64/libmono.so
## #9  0x0000000001ec3120 in ?? ()
## #10 0x00007ffff7344d48 in ?? ()
## #11 0x00007ffff2230986 in ?? () from (…)/Ascendant_Data/Mono/x86_64/libmono.so
## #12 0x00007ffff7aa8690 in _int_free_chunk (av=av@entry=0x7ffff7befac0 <main_arena>, p=p@entry=0x1ec8390, size=4112, have_lock=<optimized out>, have_lock@entry=0) at ./malloc/malloc.c:4667
## #13 0x00007ffff7aab3c0 in _int_free (av=0x7ffff7befac0 <main_arena>, p=0x1ec8390, have_lock=0) at ./malloc/malloc.c:4699
## #14 __GI___libc_free (mem=<optimized out>) at ./malloc/malloc.c:3476
## #15 0x0000000000000060 in ?? ()
## #16 0x0000000001eb9470 in ?? ()
## #17 0x00007ffff7befac0 in ?? () from /lib/x86_64-linux-gnu/libc.so.6
## #18 0x0000000000004040 in ?? ()
## #19 0x00007ffff7befac0 in ?? () from /lib/x86_64-linux-gnu/libc.so.6
## #20 0x0000000000000000 in ?? ()
unity3d_disable_map32bit() { return 0; }

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
