#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Giana Sisters series:
# - Giana Sisters: Twisted Dreams
# - Giana Sisters: Rise of the Owlverlord
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250630.4

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_DREAMS='giana-sisters-twisted-dreams'
GAME_NAME_DREAMS='Giana Sisters: Twisted Dreams'

GAME_ID_OWL='giana-sisters-rise-of-the-owlverlord'
GAME_NAME_OWL='Giana Sisters: Rise of the Owlverlord'

# Archives

## Giana Sisters: Twisted Dreams

ARCHIVE_BASE_DREAMS_1_NAME='setup_giana_sisters_twisted_dreams_1.2.1_(19142).exe'
ARCHIVE_BASE_DREAMS_1_MD5='e5605f4890984375192bd37545e51ff8'
ARCHIVE_BASE_DREAMS_1_TYPE='innosetup'
ARCHIVE_BASE_DREAMS_1_SIZE='2800000'
ARCHIVE_BASE_DREAMS_1_VERSION='1.2.1-gog19142'
ARCHIVE_BASE_DREAMS_1_URL='https://www.gog.com/game/giana_sisters_twisted_dreams'

ARCHIVE_BASE_DREAMS_0_NAME='setup_giana_sisters_twisted_dreams_2.2.0.16.exe'
ARCHIVE_BASE_DREAMS_0_MD5='31b2a0431cfd764198834faec314f0b2'
ARCHIVE_BASE_DREAMS_0_TYPE='innosetup'
ARCHIVE_BASE_DREAMS_0_SIZE='2900000'
ARCHIVE_BASE_DREAMS_0_VERSION='1.0-gog2.2.0.16'

## Giana Sisters: Rise of the Owlverlord

ARCHIVE_BASE_OWL_1_NAME='setup_giana_sisters_rise_of_the_owlverlord_2.1.0.8.exe'
ARCHIVE_BASE_OWL_1_MD5='bebb3a09c10b8e34b88b6d9f64dedeab'
ARCHIVE_BASE_OWL_1_TYPE='innosetup'
ARCHIVE_BASE_OWL_1_SIZE='2556034'
ARCHIVE_BASE_OWL_1_VERSION='1.0-gog2.1.0.8'
ARCHIVE_BASE_OWL_1_URL='https://www.gog.com/game/giana_sisters_rise_of_the_owlverlord'


CONTENT_PATH_DEFAULT_DREAMS='.'
CONTENT_PATH_DEFAULT_DREAMS_0='app'
CONTENT_PATH_DEFAULT_OWL='app'
CONTENT_GAME_BIN_FILES='
launcher
7z.dll
gsgameexe.exe
gsgameexe_dx9.exe'
CONTENT_GAME_DATA_FILES='
bundles
added_content
data_common'
CONTENT_GAME0_DATA_PATH='__support/app'
CONTENT_GAME0_DATA_FILES='
data_common'
CONTENT_DOC_DATA_FILES='
7z_copying.txt
7z_license.txt
7z_readme.txt'

WINE_PERSISTENT_DIRECTORIES_DREAMS='
users/${USER}/Documents/Giana Sisters - Twisted Dreams'
WINE_PERSISTENT_DIRECTORIES_OWL='
users/${USER}/Documents/Giana Sisters - Rise of the Owlverlord'
## Despite the needed GStreamer decoders being available, the game freezes when it should play the introduction video:
##
## mmap() failed: Cannot allocate memory
## mmap() failed: Cannot allocate memory
## 0024:err:pulse:pulse_test_connect Failed to create context
##
## (wine:388328): GStreamer-WARNING **: 17:59:53.832: Failed to load plugin '/usr/lib/i386-linux-gnu/gstreamer-1.0/libgstlibav.so': libopenmpt.so.0: failed to map segment from shared object
## winegstreamer error: decodebin1: Your GStreamer installation is missing a plug-in.
## winegstreamer error: decodebin1: ../gst/playback/gstdecodebin2.c(4720): gst_decode_bin_expose (): /GstBin:bin0/GstDecodeBin:decodebin1:
## no suitable plugins found:
## Missing decoder: Windows Media Video 9 (video/x-wmv, wmvversion=(int)3, format=(string)WMV3, width=(int)1920, height=(int)1080, codec_data=(buffer)4ff1080100, pixel-aspect-ratio=(fraction)1/1, framerate=(fraction)10000000/333333)
##
## 0:00:00.034232127 388328 0x58932820 ERROR                   WINE dlls/winegstreamer/wg_parser.c:1616:wg_parser_connect: Failed to play stream.
## winegstreamer error: decodebin2: Your GStreamer installation is missing a plug-in.
## winegstreamer error: decodebin2: ../gst/playback/gstdecodebin2.c(4720): gst_decode_bin_expose (): /GstBin:bin0/GstDecodeBin:decodebin2:
## no suitable plugins found:
## Missing decoder: Windows Media Audio 8 (audio/x-wma, wmaversion=(int)2, bitrate=(int)48024, depth=(int)16, rate=(int)44100, channels=(int)2, block_align=(int)2230, codec_data=(buffer)008800001f0000000000)
##
## 0024:err:wmvcore:init_stream Failed to connect parser, hr 0x80004005.
##
## Using native Windows codecs instead of relying on GStreamers decoders works around this freeze.
## (WINE 10.0)
WINE_WINETRICKS_VERBS='wmp9'
## The game launcher, used to tweaks settings, relies on .NET/Mono support.
WINE_WINEPREFIX_TWEAKS='mono'
## Both games suffer from problems using the default wined3d renderer:
## - Twisted Dreams is badly rendered, making it unplayable;
## - Rise of the Owlverlord crashes a couple seconds into the first level.
## (WINE 10.0)
WINE_DIRECT3D_RENDERER='dxvk'

APP_MAIN_EXE='gsgameexe.exe'

APP_SETTINGS_ID_DREAMS="${GAME_ID_DREAMS}-settings"
APP_SETTINGS_ID_OWL="${GAME_ID_OWL}-settings"
APP_SETTINGS_NAME_DREAMS="$GAME_NAME_DREAMS - Settings"
APP_SETTINGS_NAME_OWL="$GAME_NAME_OWL - Settings"
APP_SETTINGS_CAT='Settings'
APP_SETTINGS_EXE='launcher/gslauncher.exe'
## Ensure the settings application is run through WINE, not Mono.
APP_SETTINGS_TYPE='wine'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
decodebin
audio/x-wma
video/x-wmv
video/x-ms-asf'

PKG_DATA_ID_DREAMS="${GAME_ID_DREAMS}-data"
PKG_DATA_ID_OWL="${GAME_ID_OWL}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
