#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dragon Age: Origins
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250828.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='dragon-age-origins'
GAME_NAME='Dragon Age: Origins'

ARCHIVE_BASE_2_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.8_(78205).exe'
ARCHIVE_BASE_2_MD5='18e2e1f3fba4184ca15d6170d0a2ce51'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_PART1_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.8_(78205)-1.bin'
ARCHIVE_BASE_2_PART1_MD5='0735b7a919fe9b1a7e7d31cfea156ee5'
ARCHIVE_BASE_2_PART2_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.8_(78205)-2.bin'
ARCHIVE_BASE_2_PART2_MD5='c7f59542be194793d3f1664b2b079d64'
ARCHIVE_BASE_2_PART3_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.8_(78205)-3.bin'
ARCHIVE_BASE_2_PART3_MD5='87ef8829f56c5b985b7f3eb1893249de'
ARCHIVE_BASE_2_PART4_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.8_(78205)-4.bin'
ARCHIVE_BASE_2_PART4_MD5='04f49cccc87d268fef2a7a4cafce27e8'
ARCHIVE_BASE_2_PART5_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.8_(78205)-5.bin'
ARCHIVE_BASE_2_PART5_MD5='e44d862bd7221d065be30cd80de4d568'
ARCHIVE_BASE_2_PART6_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.8_(78205)-6.bin'
ARCHIVE_BASE_2_PART6_MD5='e97793771570a38174e202704297fe37'
ARCHIVE_BASE_2_SIZE='38342773'
ARCHIVE_BASE_2_VERSION='1.05-gog78205'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/dragon_age_origins'

ARCHIVE_BASE_1_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.5_(76885).exe'
ARCHIVE_BASE_1_MD5='fa14b944ca5ce04e462afe61e932f1b0'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.5_(76885)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='910ff0ff7db44dd44c9b7fbc01439226'
ARCHIVE_BASE_1_PART2_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.5_(76885)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='317484fbbe084fdfac86af933a3827d3'
ARCHIVE_BASE_1_PART3_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.5_(76885)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='c7a236056afe1e24070e747760cab8d9'
ARCHIVE_BASE_1_PART4_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.5_(76885)-4.bin'
ARCHIVE_BASE_1_PART4_MD5='0b08303e31e29708cc679d92b5b9c607'
ARCHIVE_BASE_1_PART5_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.5_(76885)-5.bin'
ARCHIVE_BASE_1_PART5_MD5='dead382df73a84c02ee54a5b34050fcc'
ARCHIVE_BASE_1_PART6_NAME='setup_dragon_age_origins_-_ultimate_edition_1.05_gog_0.5_(76885)-6.bin'
ARCHIVE_BASE_1_PART6_MD5='9c94a20453a52d5284c89aa4507949e0'
ARCHIVE_BASE_1_SIZE='38343327'
ARCHIVE_BASE_1_VERSION='1.05-gog76885'

ARCHIVE_BASE_0_NAME='setup_dragon_age_origins_ultimate_2.1.0.4.exe'
ARCHIVE_BASE_0_MD5='2bfdbc94523ef4c21476f64ef8029479'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--gog'
ARCHIVE_BASE_0_PART1_NAME='setup_dragon_age_origins_ultimate_2.1.0.4-1.bin'
ARCHIVE_BASE_0_PART1_MD5='b6e68b1b3b11fdddea809a5f11368036'
ARCHIVE_BASE_0_PART1_EXTRACTOR='unar'
ARCHIVE_BASE_0_PART2_NAME='setup_dragon_age_origins_ultimate_2.1.0.4-2.bin'
ARCHIVE_BASE_0_PART2_MD5='71d813d6827941a90422a40088d64b78'
ARCHIVE_BASE_0_PART3_NAME='setup_dragon_age_origins_ultimate_2.1.0.4-3.bin'
ARCHIVE_BASE_0_PART3_MD5='2ff9cc2bb41435429ee6277106a6a568'
ARCHIVE_BASE_0_PART4_NAME='setup_dragon_age_origins_ultimate_2.1.0.4-4.bin'
ARCHIVE_BASE_0_PART4_MD5='a25c58b43a2e468fcf72446f57542115'
ARCHIVE_BASE_0_PART5_NAME='setup_dragon_age_origins_ultimate_2.1.0.4-5.bin'
ARCHIVE_BASE_0_PART5_MD5='4ce5f6dceb01c9a1fc85c759c436b7b2'
ARCHIVE_BASE_0_PART6_NAME='setup_dragon_age_origins_ultimate_2.1.0.4-6.bin'
ARCHIVE_BASE_0_PART6_MD5='e2d13b236af30f210e0eb65aec5d137e'
ARCHIVE_BASE_0_SIZE='39000000'
ARCHIVE_BASE_0_VERSION='1.05-gog2.1.0.4'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='game'
CONTENT_GAME_BIN_FILES='
bin_ship
daoriginslauncher.exe'
CONTENT_GAME_L10N_TEXT_EN_FILES='
*_en-us.tlk'
CONTENT_GAME_L10N_TEXT_DE_FILES='
*/locale/de-de/prelude_map.bik
*/locale/de-de/game_intro.cub
*/locale/de-de/game_intro.cut
*_de-de.tlk
*_de-de_f.tlk'
CONTENT_GAME_L10N_TEXT_FR_FILES='
*/locale/fr-fr/prelude_map.bik
*/locale/fr-fr/game_intro.cub
*/locale/fr-fr/game_intro.cut
*_fr-fr.tlk
*_fr-fr_f.tlk'
CONTENT_GAME_L10N_TEXT_PL_FILES='
*/locale/pl-pl/dragon_age_main.bik
*/locale/pl-pl/prelude_map.bik
*/locale/pl-pl/game_intro.cub
*/locale/pl-pl/game_intro.cut
*_pl-pl.tlk
*_pl-pl_f.tlk'
CONTENT_GAME_L10N_TEXT_RU_FILES='
*/locale/ru-ru/dragon_age_main.bik
*/locale/ru-ru/prelude_map.bik
*/locale/ru-ru/game_intro.cub
*/locale/ru-ru/game_intro.cut
*_ru-ru.tlk
*_ru-ru_f.tlk'
CONTENT_GAME_L10N_TEXT_CS_FILES='
*/locale/cs-cz/dragon_age_main.bik
*/locale/cs-cz/prelude_map.bik
*/locale/cs-cz/game_intro.cub
*/locale/cs-cz/game_intro.cut
*_cs-cz.tlk
*_cs-cz_f.tlk'
CONTENT_GAME_L10N_TEXT_ES_FILES='
*/locale/es-es/prelude_map.bik
*/locale/es-es/game_intro.cub
*/locale/es-es/game_intro.cut
*_es-es.tlk
*_es-es_f.tlk'
CONTENT_GAME_L10N_TEXT_HU_FILES='
*/locale/hu-hu/dragon_age_main.bik
*/locale/hu-hu/prelude_map.bik
*/locale/hu-hu/game_intro.cub
*/locale/hu-hu/game_intro.cut
*_hu-hu.tlk
*_hu-hu_f.tlk'
CONTENT_GAME_L10N_TEXT_IT_FILES='
*/locale/it-it/prelude_map.bik
*/locale/it-it/game_intro.cub
*/locale/it-it/game_intro.cut
*_it-it.tlk
*_it-it_f.tlk'
CONTENT_GAME_L10N_VOICES_EN_FILES='
*/audio/vo/en-us'
CONTENT_GAME_L10N_VOICES_DE_FILES='
*/locale/de-de/betrayal.bik
*/locale/de-de/charge.bik
*/locale/de-de/mnp100cs_loghain_event*.bik
*/audio/vo/de-de'
CONTENT_GAME_L10N_VOICES_FR_FILES='
*/locale/fr-fr/betrayal.bik
*/locale/fr-fr/charge.bik
*/locale/fr-fr/mnp100cs_loghain_event*.bik
*/audio/vo/fr-fr'
CONTENT_GAME_L10N_VOICES_PL_FILES='
*/locale/pl-pl/betrayal.bik
*/locale/pl-pl/charge.bik
*/locale/pl-pl/mnp100cs_loghain_event*.bik
*/audio/vo/pl-pl'
CONTENT_GAME_L10N_VOICES_RU_FILES='
*/audio/vo/ru-ru'
CONTENT_GAME_ENVIRONMENT_FILES='
addins/*/*/env
packages/*/env'
CONTENT_GAME_MOVIES_FILES='
addins/*/core/data/movies
modules/*/data/movies
packages/*/data/movies'
## TODO: The add-ons could be moved to a dedicated package
CONTENT_GAME_DATA_FILES='
addins
data
modules
offers
packages'
CONTENT_DOC_DATA_FILES='
manual.pdf'
## TODO: This should be split into localisation packages.
CONTENT_DOC0_DATA_RELATIVE_PATH='docs'
CONTENT_DOC0_DATA_FILES='
*.rtf
*.txt'
CONTENT_SETTINGS_RELATIVE_PATH='__support/userdocs'
CONTENT_SETTINGS_RELATIVE_PATH_0='../userdocs/bioware/dragon age/settings'
CONTENT_SETTINGS_FILES='
addins.xml'
CONTENT_PHYSX_RELATIVE_PATH='redist'
CONTENT_PHYSX_FILES='
physx_9.09.0408_systemsoftware.exe'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/BioWare/Dragon Age'

APP_MAIN_EXE='bin_ship/daorigins.exe'

APP_CONFIG_ID="${GAME_ID}-config"
APP_CONFIG_NAME="$GAME_NAME - Configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_EXE='bin_ship/daoriginsconfig.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_TEXT_EN
PKG_L10N_TEXT_DE
PKG_L10N_TEXT_FR
PKG_L10N_TEXT_PL
PKG_L10N_TEXT_RU
PKG_L10N_TEXT_CS
PKG_L10N_TEXT_ES
PKG_L10N_TEXT_HU
PKG_L10N_TEXT_IT
PKG_L10N_VOICES_EN
PKG_L10N_VOICES_DE
PKG_L10N_VOICES_FR
PKG_L10N_VOICES_PL
PKG_L10N_VOICES_RU
PKG_ENVIRONMENT
PKG_MOVIES
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_TEXT
PKG_L10N_VOICES
PKG_ENVIRONMENT
PKG_MOVIES
PKG_DATA'

PKG_L10N_TEXT_ID="${GAME_ID}-l10n-text"
PKG_L10N_TEXT_EN_ID="${PKG_L10N_TEXT_ID}-en"
PKG_L10N_TEXT_DE_ID="${PKG_L10N_TEXT_ID}-de"
PKG_L10N_TEXT_FR_ID="${PKG_L10N_TEXT_ID}-fr"
PKG_L10N_TEXT_PL_ID="${PKG_L10N_TEXT_ID}-pl"
PKG_L10N_TEXT_RU_ID="${PKG_L10N_TEXT_ID}-ru"
PKG_L10N_TEXT_CS_ID="${PKG_L10N_TEXT_ID}-cs"
PKG_L10N_TEXT_ES_ID="${PKG_L10N_TEXT_ID}-es"
PKG_L10N_TEXT_HU_ID="${PKG_L10N_TEXT_ID}-hu"
PKG_L10N_TEXT_IT_ID="${PKG_L10N_TEXT_ID}-it"
PKG_L10N_TEXT_PROVIDES="
$PKG_L10N_TEXT_ID"
PKG_L10N_TEXT_EN_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_DE_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_FR_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_PL_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_RU_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_CS_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_ES_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_HU_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_IT_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_EN_DESCRIPTION='English localization - text'
PKG_L10N_TEXT_DE_DESCRIPTION='German localization - text'
PKG_L10N_TEXT_FR_DESCRIPTION='French localization - text'
PKG_L10N_TEXT_PL_DESCRIPTION='Polish localization - text'
PKG_L10N_TEXT_RU_DESCRIPTION='Russian localization - text'
PKG_L10N_TEXT_CS_DESCRIPTION='Czech localization - text'
PKG_L10N_TEXT_ES_DESCRIPTION='Spanish localization - text'
PKG_L10N_TEXT_HU_DESCRIPTION='Hungarian localization - text'
PKG_L10N_TEXT_IT_DESCRIPTION='Italian localization - text'
## Easier upgrades from pre-20250808.6 packages
PKG_L10N_TEXT_PROVIDES="$PKG_L10N_TEXT_PROVIDES
dragon-age-origins-l10n"
PKG_L10N_TEXT_EN_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_DE_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_FR_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_PL_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_RU_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_CS_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_ES_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_HU_PROVIDES="$PKG_L10N_TEXT_PROVIDES"
PKG_L10N_TEXT_IT_PROVIDES="$PKG_L10N_TEXT_PROVIDES"

PKG_L10N_VOICES_ID="${GAME_ID}-l10n-voices"
PKG_L10N_VOICES_EN_ID="${PKG_L10N_VOICES_ID}-en"
PKG_L10N_VOICES_DE_ID="${PKG_L10N_VOICES_ID}-de"
PKG_L10N_VOICES_FR_ID="${PKG_L10N_VOICES_ID}-fr"
PKG_L10N_VOICES_PL_ID="${PKG_L10N_VOICES_ID}-pl"
PKG_L10N_VOICES_RU_ID="${PKG_L10N_VOICES_ID}-ru"
PKG_L10N_VOICES_PROVIDES="
$PKG_L10N_VOICES_ID"
PKG_L10N_VOICES_EN_PROVIDES="$PKG_L10N_VOICES_PROVIDES"
PKG_L10N_VOICES_DE_PROVIDES="$PKG_L10N_VOICES_PROVIDES"
PKG_L10N_VOICES_FR_PROVIDES="$PKG_L10N_VOICES_PROVIDES"
PKG_L10N_VOICES_PL_PROVIDES="$PKG_L10N_VOICES_PROVIDES"
PKG_L10N_VOICES_RU_PROVIDES="$PKG_L10N_VOICES_PROVIDES"
PKG_L10N_VOICES_EN_DESCRIPTION='English localization - voices'
PKG_L10N_VOICES_DE_DESCRIPTION='German localization - voices'
PKG_L10N_VOICES_FR_DESCRIPTION='French localization - voices'
PKG_L10N_VOICES_PL_DESCRIPTION='Polish localization - voices'
PKG_L10N_VOICES_RU_DESCRIPTION='Russian localization - voices'

PKG_ENVIRONMENT_ID="${GAME_ID}-environment"
PKG_ENVIRONMENT_DESCRIPTION='environment'

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

## convmv is used to convert file paths to lower case.
REQUIREMENTS_LIST='
convmv'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Convert all file paths to lower case.
case "$(current_archive)" in
	('ARCHIVE_BASE_0')
		tolower "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	;;
esac

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion 'SETTINGS' 'PKG_DATA' "$(path_game_data)/settings"
content_inclusion 'PHYSX' 'PKG_BIN' "$(path_game_data)/physx"
content_inclusion_default

# Write launchers.

## - Include shipped settings, to unlock expansions.
## - Install shipped build of PhysX.
wineprefix_init_custom() {
	cat <<- 'EOF'
	    ## Include shipped settings, to unlock expansions.
	    settings_path="${PATH_PERSISTENT}/wineprefix/users/${USER}/Documents/BioWare/Dragon Age/Settings"
	    if [ ! -e "$settings_path" ]; then
	        mkdir --parents "$(dirname "$settings_path")"
	        cp --recursive "${PATH_GAME_DATA}/settings" "$settings_path"
	    fi
	EOF
	cat <<- EOF
	    ## Install shipped build of PhysX.
	    (
	        ## env --chdir does not work here, it leads to the following error:
	        ## Corrupt installation detected.
	        cd "\${WINEPREFIX}/drive_c/${GAME_ID}"
	        "\$(wine_command)" 'physx/physx_9.09.0408_systemsoftware.exe'
	    )
	EOF
}

launchers_generation

# Build packages.

packages_generation
case "$(messages_language)" in
	('fr')
		lang_string='version %s :'
		lang_en='anglaise'
		lang_de='allemande'
		lang_fr='française'
		lang_pl='polonaise'
		lang_ru='russe'
		lang_cs='tchèque'
		lang_es='espagnole'
		lang_hu='hongroise'
		lang_it='italienne'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_en='English'
		lang_de='German'
		lang_fr='French'
		lang_pl='Polish'
		lang_ru='Russian'
		lang_cs='Czech'
		lang_es='Spanish'
		lang_hu='Hungarian'
		lang_it='Italian'
	;;
esac
printf '\n'
printf "$lang_string" "$lang_en"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_EN' 'PKG_L10N_VOICES_EN'
printf "$lang_string" "$lang_de"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_DE' 'PKG_L10N_VOICES_DE'
printf "$lang_string" "$lang_fr"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_FR' 'PKG_L10N_VOICES_FR'
printf "$lang_string" "$lang_pl"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_PL' 'PKG_L10N_VOICES_PL'
printf "$lang_string" "$lang_ru"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_RU' 'PKG_L10N_VOICES_RU'
printf "$lang_string" "$lang_cs"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_CS' 'PKG_L10N_VOICES_EN'
printf "$lang_string" "$lang_es"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_ES' 'PKG_L10N_VOICES_EN'
printf "$lang_string" "$lang_hu"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_HU' 'PKG_L10N_VOICES_EN'
printf "$lang_string" "$lang_it"
print_instructions 'PKG_BIN' 'PKG_ENVIRONMENT' 'PKG_MOVIES' 'PKG_DATA' 'PKG_L10N_TEXT_IT' 'PKG_L10N_VOICES_EN'

# Clean up.

working_directory_cleanup

exit 0
