// Copyright 2020 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.devtools.build.skydoc.fakebuildapi.android;

import com.google.devtools.build.lib.rules.android.ProguardMappingProvider;
import com.google.devtools.build.lib.starlarkbuildapi.FileApi;
import com.google.devtools.build.lib.starlarkbuildapi.android.ProguardMappingProviderApi;
import com.google.devtools.build.lib.syntax.EvalException;

/** Fake implementation of {@link ProguardMappingProvider}. */
public class FakeProguardMappingProvider implements ProguardMappingProviderApi<FileApi> {

  @Override
  public FileApi getProguardMapping() {
    return null;
  }

  @Override
  public String toProto() throws EvalException {
    return null;
  }

  @Override
  public String toJson() throws EvalException {
    return null;
  }

  /** Fake implementation of {@link ProguardMappingProviderApi.Provider}. */
  public static class FakeProvider implements ProguardMappingProviderApi.Provider<FileApi> {

    @Override
    public ProguardMappingProviderApi<FileApi> createInfo(FileApi proguardMapping)
        throws EvalException {
      return new FakeProguardMappingProvider();
    }
  }
}
