// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file ContentFilterTestTypeTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "ContentFilterTestTypeTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "ContentFilterTestType.hpp"


using namespace eprosima::fastdds::dds::xtypes;

void register_Color_type_identifier(
        TypeIdentifierPair& type_ids_Color)
{
    ReturnCode_t return_code_Color {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Color =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Color", type_ids_Color);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Color)
    {
        EnumTypeFlag enum_flags_Color = 0;
        BitBound bit_bound_Color = 32;
        CommonEnumeratedHeader common_Color = TypeObjectUtils::build_common_enumerated_header(bit_bound_Color);
        QualifiedTypeName type_name_Color = "Color";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Color;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Color;
        CompleteTypeDetail detail_Color = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Color, ann_custom_Color, type_name_Color.to_string());
        CompleteEnumeratedHeader header_Color = TypeObjectUtils::build_complete_enumerated_header(common_Color, detail_Color);
        CompleteEnumeratedLiteralSeq literal_seq_Color;
        {
            EnumeratedLiteralFlag flags_RED = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_RED = TypeObjectUtils::build_common_enumerated_literal(0, flags_RED);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_RED;
            ann_custom_Color.reset();
            MemberName name_RED = "RED";
            CompleteMemberDetail detail_RED = TypeObjectUtils::build_complete_member_detail(name_RED, member_ann_builtin_RED, ann_custom_Color);
            CompleteEnumeratedLiteral literal_RED = TypeObjectUtils::build_complete_enumerated_literal(common_RED, detail_RED);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Color, literal_RED);
        }
        {
            EnumeratedLiteralFlag flags_GREEN = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_GREEN = TypeObjectUtils::build_common_enumerated_literal(1, flags_GREEN);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_GREEN;
            ann_custom_Color.reset();
            MemberName name_GREEN = "GREEN";
            CompleteMemberDetail detail_GREEN = TypeObjectUtils::build_complete_member_detail(name_GREEN, member_ann_builtin_GREEN, ann_custom_Color);
            CompleteEnumeratedLiteral literal_GREEN = TypeObjectUtils::build_complete_enumerated_literal(common_GREEN, detail_GREEN);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Color, literal_GREEN);
        }
        {
            EnumeratedLiteralFlag flags_BLUE = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_BLUE = TypeObjectUtils::build_common_enumerated_literal(2, flags_BLUE);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_BLUE;
            ann_custom_Color.reset();
            MemberName name_BLUE = "BLUE";
            CompleteMemberDetail detail_BLUE = TypeObjectUtils::build_complete_member_detail(name_BLUE, member_ann_builtin_BLUE, ann_custom_Color);
            CompleteEnumeratedLiteral literal_BLUE = TypeObjectUtils::build_complete_enumerated_literal(common_BLUE, detail_BLUE);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Color, literal_BLUE);
        }
        {
            EnumeratedLiteralFlag flags_YELLOW = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_YELLOW = TypeObjectUtils::build_common_enumerated_literal(3, flags_YELLOW);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_YELLOW;
            ann_custom_Color.reset();
            MemberName name_YELLOW = "YELLOW";
            CompleteMemberDetail detail_YELLOW = TypeObjectUtils::build_complete_member_detail(name_YELLOW, member_ann_builtin_YELLOW, ann_custom_Color);
            CompleteEnumeratedLiteral literal_YELLOW = TypeObjectUtils::build_complete_enumerated_literal(common_YELLOW, detail_YELLOW);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Color, literal_YELLOW);
        }
        {
            EnumeratedLiteralFlag flags_MAGENTA = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_MAGENTA = TypeObjectUtils::build_common_enumerated_literal(4, flags_MAGENTA);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_MAGENTA;
            ann_custom_Color.reset();
            MemberName name_MAGENTA = "MAGENTA";
            CompleteMemberDetail detail_MAGENTA = TypeObjectUtils::build_complete_member_detail(name_MAGENTA, member_ann_builtin_MAGENTA, ann_custom_Color);
            CompleteEnumeratedLiteral literal_MAGENTA = TypeObjectUtils::build_complete_enumerated_literal(common_MAGENTA, detail_MAGENTA);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Color, literal_MAGENTA);
        }
        CompleteEnumeratedType enumerated_type_Color = TypeObjectUtils::build_complete_enumerated_type(enum_flags_Color, header_Color,
                literal_seq_Color);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_Color, type_name_Color.to_string(), type_ids_Color))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "Color already registered in TypeObjectRegistry for a different type.");
        }
    }
}void register_Material_type_identifier(
        TypeIdentifierPair& type_ids_Material)
{
    ReturnCode_t return_code_Material {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Material =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Material", type_ids_Material);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Material)
    {
        EnumTypeFlag enum_flags_Material = 0;
        BitBound bit_bound_Material = 32;
        CommonEnumeratedHeader common_Material = TypeObjectUtils::build_common_enumerated_header(bit_bound_Material);
        QualifiedTypeName type_name_Material = "Material";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Material;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Material;
        CompleteTypeDetail detail_Material = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Material, ann_custom_Material, type_name_Material.to_string());
        CompleteEnumeratedHeader header_Material = TypeObjectUtils::build_complete_enumerated_header(common_Material, detail_Material);
        CompleteEnumeratedLiteralSeq literal_seq_Material;
        {
            EnumeratedLiteralFlag flags_WOOD = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_WOOD = TypeObjectUtils::build_common_enumerated_literal(0, flags_WOOD);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_WOOD;
            ann_custom_Material.reset();
            MemberName name_WOOD = "WOOD";
            CompleteMemberDetail detail_WOOD = TypeObjectUtils::build_complete_member_detail(name_WOOD, member_ann_builtin_WOOD, ann_custom_Material);
            CompleteEnumeratedLiteral literal_WOOD = TypeObjectUtils::build_complete_enumerated_literal(common_WOOD, detail_WOOD);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Material, literal_WOOD);
        }
        {
            EnumeratedLiteralFlag flags_PLASTIC = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_PLASTIC = TypeObjectUtils::build_common_enumerated_literal(1, flags_PLASTIC);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_PLASTIC;
            ann_custom_Material.reset();
            MemberName name_PLASTIC = "PLASTIC";
            CompleteMemberDetail detail_PLASTIC = TypeObjectUtils::build_complete_member_detail(name_PLASTIC, member_ann_builtin_PLASTIC, ann_custom_Material);
            CompleteEnumeratedLiteral literal_PLASTIC = TypeObjectUtils::build_complete_enumerated_literal(common_PLASTIC, detail_PLASTIC);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Material, literal_PLASTIC);
        }
        {
            EnumeratedLiteralFlag flags_METAL = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_METAL = TypeObjectUtils::build_common_enumerated_literal(2, flags_METAL);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_METAL;
            ann_custom_Material.reset();
            MemberName name_METAL = "METAL";
            CompleteMemberDetail detail_METAL = TypeObjectUtils::build_complete_member_detail(name_METAL, member_ann_builtin_METAL, ann_custom_Material);
            CompleteEnumeratedLiteral literal_METAL = TypeObjectUtils::build_complete_enumerated_literal(common_METAL, detail_METAL);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Material, literal_METAL);
        }
        {
            EnumeratedLiteralFlag flags_CONCRETE = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_CONCRETE = TypeObjectUtils::build_common_enumerated_literal(3, flags_CONCRETE);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_CONCRETE;
            ann_custom_Material.reset();
            MemberName name_CONCRETE = "CONCRETE";
            CompleteMemberDetail detail_CONCRETE = TypeObjectUtils::build_complete_member_detail(name_CONCRETE, member_ann_builtin_CONCRETE, ann_custom_Material);
            CompleteEnumeratedLiteral literal_CONCRETE = TypeObjectUtils::build_complete_enumerated_literal(common_CONCRETE, detail_CONCRETE);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Material, literal_CONCRETE);
        }
        {
            EnumeratedLiteralFlag flags_STONE = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_STONE = TypeObjectUtils::build_common_enumerated_literal(4, flags_STONE);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_STONE;
            ann_custom_Material.reset();
            MemberName name_STONE = "STONE";
            CompleteMemberDetail detail_STONE = TypeObjectUtils::build_complete_member_detail(name_STONE, member_ann_builtin_STONE, ann_custom_Material);
            CompleteEnumeratedLiteral literal_STONE = TypeObjectUtils::build_complete_enumerated_literal(common_STONE, detail_STONE);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_Material, literal_STONE);
        }
        CompleteEnumeratedType enumerated_type_Material = TypeObjectUtils::build_complete_enumerated_type(enum_flags_Material, header_Material,
                literal_seq_Material);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_Material, type_name_Material.to_string(), type_ids_Material))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "Material already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructType_type_identifier(
        TypeIdentifierPair& type_ids_StructType)
{

    ReturnCode_t return_code_StructType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "StructType", type_ids_StructType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructType)
    {
        StructTypeFlag struct_flags_StructType = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                true, false);
        QualifiedTypeName type_name_StructType = "StructType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructType;
        AppliedAnnotationSeq tmp_ann_custom_StructType;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_StructType;
        if (!tmp_ann_custom_StructType.empty())
        {
            ann_custom_StructType = tmp_ann_custom_StructType;
        }

        CompleteTypeDetail detail_StructType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructType, ann_custom_StructType, type_name_StructType.to_string());
        CompleteStructHeader header_StructType;
        header_StructType = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructType);
        CompleteStructMemberSeq member_seq_StructType;
        {
            TypeIdentifierPair type_ids_char_field;
            ReturnCode_t return_code_char_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_char_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_char_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_char_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "char_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_char_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_char_field = 0x00000000;
            bool common_char_field_ec {false};
            CommonStructMember common_char_field {TypeObjectUtils::build_common_struct_member(member_id_char_field, member_flags_char_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_char_field, common_char_field_ec))};
            if (!common_char_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure char_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_char_field = "char_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_char_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_char_field = TypeObjectUtils::build_complete_member_detail(name_char_field, member_ann_builtin_char_field, ann_custom_StructType);
            CompleteStructMember member_char_field = TypeObjectUtils::build_complete_struct_member(common_char_field, detail_char_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_char_field);
        }
        {
            TypeIdentifierPair type_ids_uint8_field;
            ReturnCode_t return_code_uint8_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint8_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_uint8_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint8_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint8_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint8_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint8_field = 0x00000001;
            bool common_uint8_field_ec {false};
            CommonStructMember common_uint8_field {TypeObjectUtils::build_common_struct_member(member_id_uint8_field, member_flags_uint8_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint8_field, common_uint8_field_ec))};
            if (!common_uint8_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint8_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint8_field = "uint8_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint8_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_uint8_field = TypeObjectUtils::build_complete_member_detail(name_uint8_field, member_ann_builtin_uint8_field, ann_custom_StructType);
            CompleteStructMember member_uint8_field = TypeObjectUtils::build_complete_struct_member(common_uint8_field, detail_uint8_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_uint8_field);
        }
        {
            TypeIdentifierPair type_ids_int16_field;
            ReturnCode_t return_code_int16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_int16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_int16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_int16_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "int16_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_int16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_int16_field = 0x00000002;
            bool common_int16_field_ec {false};
            CommonStructMember common_int16_field {TypeObjectUtils::build_common_struct_member(member_id_int16_field, member_flags_int16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_int16_field, common_int16_field_ec))};
            if (!common_int16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure int16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_int16_field = "int16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_int16_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_int16_field = TypeObjectUtils::build_complete_member_detail(name_int16_field, member_ann_builtin_int16_field, ann_custom_StructType);
            CompleteStructMember member_int16_field = TypeObjectUtils::build_complete_struct_member(common_int16_field, detail_int16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_int16_field);
        }
        {
            TypeIdentifierPair type_ids_uint16_field;
            ReturnCode_t return_code_uint16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_uint16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint16_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint16_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint16_field = 0x00000003;
            bool common_uint16_field_ec {false};
            CommonStructMember common_uint16_field {TypeObjectUtils::build_common_struct_member(member_id_uint16_field, member_flags_uint16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint16_field, common_uint16_field_ec))};
            if (!common_uint16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint16_field = "uint16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint16_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_uint16_field = TypeObjectUtils::build_complete_member_detail(name_uint16_field, member_ann_builtin_uint16_field, ann_custom_StructType);
            CompleteStructMember member_uint16_field = TypeObjectUtils::build_complete_struct_member(common_uint16_field, detail_uint16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_uint16_field);
        }
        {
            TypeIdentifierPair type_ids_int32_field;
            ReturnCode_t return_code_int32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_int32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_int32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_int32_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "int32_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_int32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_int32_field = 0x00000004;
            bool common_int32_field_ec {false};
            CommonStructMember common_int32_field {TypeObjectUtils::build_common_struct_member(member_id_int32_field, member_flags_int32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_int32_field, common_int32_field_ec))};
            if (!common_int32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure int32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_int32_field = "int32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_int32_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_int32_field = TypeObjectUtils::build_complete_member_detail(name_int32_field, member_ann_builtin_int32_field, ann_custom_StructType);
            CompleteStructMember member_int32_field = TypeObjectUtils::build_complete_struct_member(common_int32_field, detail_int32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_int32_field);
        }
        {
            TypeIdentifierPair type_ids_uint32_field;
            ReturnCode_t return_code_uint32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_uint32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint32_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint32_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint32_field = 0x00000005;
            bool common_uint32_field_ec {false};
            CommonStructMember common_uint32_field {TypeObjectUtils::build_common_struct_member(member_id_uint32_field, member_flags_uint32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint32_field, common_uint32_field_ec))};
            if (!common_uint32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint32_field = "uint32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint32_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_uint32_field = TypeObjectUtils::build_complete_member_detail(name_uint32_field, member_ann_builtin_uint32_field, ann_custom_StructType);
            CompleteStructMember member_uint32_field = TypeObjectUtils::build_complete_struct_member(common_uint32_field, detail_uint32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_uint32_field);
        }
        {
            TypeIdentifierPair type_ids_int64_field;
            ReturnCode_t return_code_int64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_int64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_int64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_int64_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "int64_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_int64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_int64_field = 0x00000006;
            bool common_int64_field_ec {false};
            CommonStructMember common_int64_field {TypeObjectUtils::build_common_struct_member(member_id_int64_field, member_flags_int64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_int64_field, common_int64_field_ec))};
            if (!common_int64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure int64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_int64_field = "int64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_int64_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_int64_field = TypeObjectUtils::build_complete_member_detail(name_int64_field, member_ann_builtin_int64_field, ann_custom_StructType);
            CompleteStructMember member_int64_field = TypeObjectUtils::build_complete_struct_member(common_int64_field, detail_int64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_int64_field);
        }
        {
            TypeIdentifierPair type_ids_uint64_field;
            ReturnCode_t return_code_uint64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_uint64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint64_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint64_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint64_field = 0x00000007;
            bool common_uint64_field_ec {false};
            CommonStructMember common_uint64_field {TypeObjectUtils::build_common_struct_member(member_id_uint64_field, member_flags_uint64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint64_field, common_uint64_field_ec))};
            if (!common_uint64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint64_field = "uint64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint64_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_uint64_field = TypeObjectUtils::build_complete_member_detail(name_uint64_field, member_ann_builtin_uint64_field, ann_custom_StructType);
            CompleteStructMember member_uint64_field = TypeObjectUtils::build_complete_struct_member(common_uint64_field, detail_uint64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_uint64_field);
        }
        {
            TypeIdentifierPair type_ids_float_field;
            ReturnCode_t return_code_float_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_float_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_float_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_float_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "float_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_float_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_float_field = 0x00000008;
            bool common_float_field_ec {false};
            CommonStructMember common_float_field {TypeObjectUtils::build_common_struct_member(member_id_float_field, member_flags_float_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_float_field, common_float_field_ec))};
            if (!common_float_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure float_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_float_field = "float_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_float_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_float_field = TypeObjectUtils::build_complete_member_detail(name_float_field, member_ann_builtin_float_field, ann_custom_StructType);
            CompleteStructMember member_float_field = TypeObjectUtils::build_complete_struct_member(common_float_field, detail_float_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_float_field);
        }
        {
            TypeIdentifierPair type_ids_double_field;
            ReturnCode_t return_code_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_double_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "double_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_double_field = 0x00000009;
            bool common_double_field_ec {false};
            CommonStructMember common_double_field {TypeObjectUtils::build_common_struct_member(member_id_double_field, member_flags_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_double_field, common_double_field_ec))};
            if (!common_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_double_field = "double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_double_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_double_field = TypeObjectUtils::build_complete_member_detail(name_double_field, member_ann_builtin_double_field, ann_custom_StructType);
            CompleteStructMember member_double_field = TypeObjectUtils::build_complete_struct_member(common_double_field, detail_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_double_field);
        }
        {
            TypeIdentifierPair type_ids_long_double_field;
            ReturnCode_t return_code_long_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_long_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_long_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_double_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "long_double_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_long_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_long_double_field = 0x0000000a;
            bool common_long_double_field_ec {false};
            CommonStructMember common_long_double_field {TypeObjectUtils::build_common_struct_member(member_id_long_double_field, member_flags_long_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_long_double_field, common_long_double_field_ec))};
            if (!common_long_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure long_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_long_double_field = "long_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_long_double_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_long_double_field = TypeObjectUtils::build_complete_member_detail(name_long_double_field, member_ann_builtin_long_double_field, ann_custom_StructType);
            CompleteStructMember member_long_double_field = TypeObjectUtils::build_complete_struct_member(common_long_double_field, detail_long_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_long_double_field);
        }
        {
            TypeIdentifierPair type_ids_bool_field;
            ReturnCode_t return_code_bool_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bool_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_bool_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bool_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "bool_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_bool_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bool_field = 0x0000000b;
            bool common_bool_field_ec {false};
            CommonStructMember common_bool_field {TypeObjectUtils::build_common_struct_member(member_id_bool_field, member_flags_bool_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bool_field, common_bool_field_ec))};
            if (!common_bool_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bool_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bool_field = "bool_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bool_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_bool_field = TypeObjectUtils::build_complete_member_detail(name_bool_field, member_ann_builtin_bool_field, ann_custom_StructType);
            CompleteStructMember member_bool_field = TypeObjectUtils::build_complete_struct_member(common_bool_field, detail_bool_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_bool_field);
        }
        {
            TypeIdentifierPair type_ids_string_field;
            ReturnCode_t return_code_string_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_string_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_string_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_field)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_string_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_string_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_string_field = 0x0000000c;
            bool common_string_field_ec {false};
            CommonStructMember common_string_field {TypeObjectUtils::build_common_struct_member(member_id_string_field, member_flags_string_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_field, common_string_field_ec))};
            if (!common_string_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure string_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_string_field = "string_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_string_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_string_field = TypeObjectUtils::build_complete_member_detail(name_string_field, member_ann_builtin_string_field, ann_custom_StructType);
            CompleteStructMember member_string_field = TypeObjectUtils::build_complete_struct_member(common_string_field, detail_string_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_string_field);
        }
        {
            TypeIdentifierPair type_ids_enum_field;
            ReturnCode_t return_code_enum_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_enum_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Color", type_ids_enum_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_enum_field)
            {
            ::register_Color_type_identifier(type_ids_enum_field);
            }
            StructMemberFlag member_flags_enum_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_enum_field = 0x0000000d;
            bool common_enum_field_ec {false};
            CommonStructMember common_enum_field {TypeObjectUtils::build_common_struct_member(member_id_enum_field, member_flags_enum_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_enum_field, common_enum_field_ec))};
            if (!common_enum_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure enum_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum_field = "enum_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_enum_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_enum_field = TypeObjectUtils::build_complete_member_detail(name_enum_field, member_ann_builtin_enum_field, ann_custom_StructType);
            CompleteStructMember member_enum_field = TypeObjectUtils::build_complete_struct_member(common_enum_field, detail_enum_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_enum_field);
        }
        {
            TypeIdentifierPair type_ids_enum2_field;
            ReturnCode_t return_code_enum2_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_enum2_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Material", type_ids_enum2_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_enum2_field)
            {
            ::register_Material_type_identifier(type_ids_enum2_field);
            }
            StructMemberFlag member_flags_enum2_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_enum2_field = 0x0000000e;
            bool common_enum2_field_ec {false};
            CommonStructMember common_enum2_field {TypeObjectUtils::build_common_struct_member(member_id_enum2_field, member_flags_enum2_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_enum2_field, common_enum2_field_ec))};
            if (!common_enum2_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure enum2_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum2_field = "enum2_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_enum2_field;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_enum2_field = TypeObjectUtils::build_complete_member_detail(name_enum2_field, member_ann_builtin_enum2_field, ann_custom_StructType);
            CompleteStructMember member_enum2_field = TypeObjectUtils::build_complete_struct_member(common_enum2_field, detail_enum2_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_enum2_field);
        }
        CompleteStructType struct_type_StructType = TypeObjectUtils::build_complete_struct_type(struct_flags_StructType, header_StructType, member_seq_StructType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructType, type_name_StructType.to_string(), type_ids_StructType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "StructType already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ContentFilterTestType_type_identifier(
        TypeIdentifierPair& type_ids_ContentFilterTestType)
{

    ReturnCode_t return_code_ContentFilterTestType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ContentFilterTestType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ContentFilterTestType", type_ids_ContentFilterTestType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ContentFilterTestType)
    {
        StructTypeFlag struct_flags_ContentFilterTestType = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ContentFilterTestType = "ContentFilterTestType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ContentFilterTestType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ContentFilterTestType;
        CompleteTypeDetail detail_ContentFilterTestType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ContentFilterTestType, ann_custom_ContentFilterTestType, type_name_ContentFilterTestType.to_string());
        CompleteStructHeader header_ContentFilterTestType;
        header_ContentFilterTestType = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ContentFilterTestType);
        CompleteStructMemberSeq member_seq_ContentFilterTestType;
        {
            TypeIdentifierPair type_ids_char_field;
            ReturnCode_t return_code_char_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_char_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_char_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_char_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "char_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_char_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_char_field = 0x00000000;
            bool common_char_field_ec {false};
            CommonStructMember common_char_field {TypeObjectUtils::build_common_struct_member(member_id_char_field, member_flags_char_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_char_field, common_char_field_ec))};
            if (!common_char_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure char_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_char_field = "char_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_char_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_char_field = TypeObjectUtils::build_complete_member_detail(name_char_field, member_ann_builtin_char_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_char_field = TypeObjectUtils::build_complete_struct_member(common_char_field, detail_char_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_char_field);
        }
        {
            TypeIdentifierPair type_ids_uint8_field;
            ReturnCode_t return_code_uint8_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint8_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_uint8_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint8_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint8_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint8_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint8_field = 0x00000001;
            bool common_uint8_field_ec {false};
            CommonStructMember common_uint8_field {TypeObjectUtils::build_common_struct_member(member_id_uint8_field, member_flags_uint8_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint8_field, common_uint8_field_ec))};
            if (!common_uint8_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint8_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint8_field = "uint8_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint8_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_uint8_field = TypeObjectUtils::build_complete_member_detail(name_uint8_field, member_ann_builtin_uint8_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_uint8_field = TypeObjectUtils::build_complete_struct_member(common_uint8_field, detail_uint8_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_uint8_field);
        }
        {
            TypeIdentifierPair type_ids_int16_field;
            ReturnCode_t return_code_int16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_int16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_int16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_int16_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "int16_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_int16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_int16_field = 0x00000002;
            bool common_int16_field_ec {false};
            CommonStructMember common_int16_field {TypeObjectUtils::build_common_struct_member(member_id_int16_field, member_flags_int16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_int16_field, common_int16_field_ec))};
            if (!common_int16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure int16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_int16_field = "int16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_int16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_int16_field = TypeObjectUtils::build_complete_member_detail(name_int16_field, member_ann_builtin_int16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_int16_field = TypeObjectUtils::build_complete_struct_member(common_int16_field, detail_int16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_int16_field);
        }
        {
            TypeIdentifierPair type_ids_uint16_field;
            ReturnCode_t return_code_uint16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_uint16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint16_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint16_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint16_field = 0x00000003;
            bool common_uint16_field_ec {false};
            CommonStructMember common_uint16_field {TypeObjectUtils::build_common_struct_member(member_id_uint16_field, member_flags_uint16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint16_field, common_uint16_field_ec))};
            if (!common_uint16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint16_field = "uint16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_uint16_field = TypeObjectUtils::build_complete_member_detail(name_uint16_field, member_ann_builtin_uint16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_uint16_field = TypeObjectUtils::build_complete_struct_member(common_uint16_field, detail_uint16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_uint16_field);
        }
        {
            TypeIdentifierPair type_ids_int32_field;
            ReturnCode_t return_code_int32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_int32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_int32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_int32_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "int32_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_int32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_int32_field = 0x00000004;
            bool common_int32_field_ec {false};
            CommonStructMember common_int32_field {TypeObjectUtils::build_common_struct_member(member_id_int32_field, member_flags_int32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_int32_field, common_int32_field_ec))};
            if (!common_int32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure int32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_int32_field = "int32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_int32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_int32_field = TypeObjectUtils::build_complete_member_detail(name_int32_field, member_ann_builtin_int32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_int32_field = TypeObjectUtils::build_complete_struct_member(common_int32_field, detail_int32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_int32_field);
        }
        {
            TypeIdentifierPair type_ids_uint32_field;
            ReturnCode_t return_code_uint32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_uint32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint32_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint32_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint32_field = 0x00000005;
            bool common_uint32_field_ec {false};
            CommonStructMember common_uint32_field {TypeObjectUtils::build_common_struct_member(member_id_uint32_field, member_flags_uint32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint32_field, common_uint32_field_ec))};
            if (!common_uint32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint32_field = "uint32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_uint32_field = TypeObjectUtils::build_complete_member_detail(name_uint32_field, member_ann_builtin_uint32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_uint32_field = TypeObjectUtils::build_complete_struct_member(common_uint32_field, detail_uint32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_uint32_field);
        }
        {
            TypeIdentifierPair type_ids_int64_field;
            ReturnCode_t return_code_int64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_int64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_int64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_int64_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "int64_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_int64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_int64_field = 0x00000006;
            bool common_int64_field_ec {false};
            CommonStructMember common_int64_field {TypeObjectUtils::build_common_struct_member(member_id_int64_field, member_flags_int64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_int64_field, common_int64_field_ec))};
            if (!common_int64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure int64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_int64_field = "int64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_int64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_int64_field = TypeObjectUtils::build_complete_member_detail(name_int64_field, member_ann_builtin_int64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_int64_field = TypeObjectUtils::build_complete_struct_member(common_int64_field, detail_int64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_int64_field);
        }
        {
            TypeIdentifierPair type_ids_uint64_field;
            ReturnCode_t return_code_uint64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_uint64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_uint64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_uint64_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "uint64_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_uint64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_uint64_field = 0x00000007;
            bool common_uint64_field_ec {false};
            CommonStructMember common_uint64_field {TypeObjectUtils::build_common_struct_member(member_id_uint64_field, member_flags_uint64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_uint64_field, common_uint64_field_ec))};
            if (!common_uint64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure uint64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_uint64_field = "uint64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_uint64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_uint64_field = TypeObjectUtils::build_complete_member_detail(name_uint64_field, member_ann_builtin_uint64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_uint64_field = TypeObjectUtils::build_complete_struct_member(common_uint64_field, detail_uint64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_uint64_field);
        }
        {
            TypeIdentifierPair type_ids_float_field;
            ReturnCode_t return_code_float_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_float_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_float_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_float_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "float_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_float_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_float_field = 0x00000008;
            bool common_float_field_ec {false};
            CommonStructMember common_float_field {TypeObjectUtils::build_common_struct_member(member_id_float_field, member_flags_float_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_float_field, common_float_field_ec))};
            if (!common_float_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure float_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_float_field = "float_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_float_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_float_field = TypeObjectUtils::build_complete_member_detail(name_float_field, member_ann_builtin_float_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_float_field = TypeObjectUtils::build_complete_struct_member(common_float_field, detail_float_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_float_field);
        }
        {
            TypeIdentifierPair type_ids_double_field;
            ReturnCode_t return_code_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_double_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "double_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_double_field = 0x00000009;
            bool common_double_field_ec {false};
            CommonStructMember common_double_field {TypeObjectUtils::build_common_struct_member(member_id_double_field, member_flags_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_double_field, common_double_field_ec))};
            if (!common_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_double_field = "double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_double_field = TypeObjectUtils::build_complete_member_detail(name_double_field, member_ann_builtin_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_double_field = TypeObjectUtils::build_complete_struct_member(common_double_field, detail_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_double_field);
        }
        {
            TypeIdentifierPair type_ids_long_double_field;
            ReturnCode_t return_code_long_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_long_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_long_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_long_double_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "long_double_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_long_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_long_double_field = 0x0000000a;
            bool common_long_double_field_ec {false};
            CommonStructMember common_long_double_field {TypeObjectUtils::build_common_struct_member(member_id_long_double_field, member_flags_long_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_long_double_field, common_long_double_field_ec))};
            if (!common_long_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure long_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_long_double_field = "long_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_long_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_long_double_field = TypeObjectUtils::build_complete_member_detail(name_long_double_field, member_ann_builtin_long_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_long_double_field = TypeObjectUtils::build_complete_struct_member(common_long_double_field, detail_long_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_long_double_field);
        }
        {
            TypeIdentifierPair type_ids_bool_field;
            ReturnCode_t return_code_bool_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bool_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_bool_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bool_field)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "bool_field Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_bool_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bool_field = 0x0000000b;
            bool common_bool_field_ec {false};
            CommonStructMember common_bool_field {TypeObjectUtils::build_common_struct_member(member_id_bool_field, member_flags_bool_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bool_field, common_bool_field_ec))};
            if (!common_bool_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bool_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bool_field = "bool_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bool_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bool_field = TypeObjectUtils::build_complete_member_detail(name_bool_field, member_ann_builtin_bool_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bool_field = TypeObjectUtils::build_complete_struct_member(common_bool_field, detail_bool_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bool_field);
        }
        {
            TypeIdentifierPair type_ids_string_field;
            ReturnCode_t return_code_string_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_string_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_string_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_string_field)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_string_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_string_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_string_field = 0x0000000c;
            bool common_string_field_ec {false};
            CommonStructMember common_string_field {TypeObjectUtils::build_common_struct_member(member_id_string_field, member_flags_string_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_string_field, common_string_field_ec))};
            if (!common_string_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure string_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_string_field = "string_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_string_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_string_field = TypeObjectUtils::build_complete_member_detail(name_string_field, member_ann_builtin_string_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_string_field = TypeObjectUtils::build_complete_struct_member(common_string_field, detail_string_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_string_field);
        }
        {
            TypeIdentifierPair type_ids_enum_field;
            ReturnCode_t return_code_enum_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_enum_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Color", type_ids_enum_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_enum_field)
            {
            ::register_Color_type_identifier(type_ids_enum_field);
            }
            StructMemberFlag member_flags_enum_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_enum_field = 0x0000000d;
            bool common_enum_field_ec {false};
            CommonStructMember common_enum_field {TypeObjectUtils::build_common_struct_member(member_id_enum_field, member_flags_enum_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_enum_field, common_enum_field_ec))};
            if (!common_enum_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure enum_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum_field = "enum_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_enum_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_enum_field = TypeObjectUtils::build_complete_member_detail(name_enum_field, member_ann_builtin_enum_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_enum_field = TypeObjectUtils::build_complete_struct_member(common_enum_field, detail_enum_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_enum_field);
        }
        {
            TypeIdentifierPair type_ids_enum2_field;
            ReturnCode_t return_code_enum2_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_enum2_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Material", type_ids_enum2_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_enum2_field)
            {
            ::register_Material_type_identifier(type_ids_enum2_field);
            }
            StructMemberFlag member_flags_enum2_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_enum2_field = 0x0000000e;
            bool common_enum2_field_ec {false};
            CommonStructMember common_enum2_field {TypeObjectUtils::build_common_struct_member(member_id_enum2_field, member_flags_enum2_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_enum2_field, common_enum2_field_ec))};
            if (!common_enum2_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure enum2_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum2_field = "enum2_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_enum2_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_enum2_field = TypeObjectUtils::build_complete_member_detail(name_enum2_field, member_ann_builtin_enum2_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_enum2_field = TypeObjectUtils::build_complete_struct_member(common_enum2_field, detail_enum2_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_enum2_field);
        }
        {
            TypeIdentifierPair type_ids_struct_field;
            ReturnCode_t return_code_struct_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_struct_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "StructType", type_ids_struct_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_struct_field)
            {
            ::register_StructType_type_identifier(type_ids_struct_field);
            }
            StructMemberFlag member_flags_struct_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_struct_field = 0x0000000f;
            bool common_struct_field_ec {false};
            CommonStructMember common_struct_field {TypeObjectUtils::build_common_struct_member(member_id_struct_field, member_flags_struct_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_struct_field, common_struct_field_ec))};
            if (!common_struct_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure struct_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_struct_field = "struct_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_struct_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_struct_field = TypeObjectUtils::build_complete_member_detail(name_struct_field, member_ann_builtin_struct_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_struct_field = TypeObjectUtils::build_complete_struct_member(common_struct_field, detail_struct_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_struct_field);
        }
        {
            TypeIdentifierPair type_ids_array_char_field;
            ReturnCode_t return_code_array_char_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_char_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_char_3", type_ids_array_char_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_char_field)
            {
                return_code_array_char_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_array_char_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_char_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_char_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_char_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_char_field, element_identifier_anonymous_array_char_3_ec))};
                if (!element_identifier_anonymous_array_char_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_char_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_char_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_char_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_char_3 = 0;
                PlainCollectionHeader header_anonymous_array_char_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_char_3, element_flags_anonymous_array_char_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_char_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_char_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_char_3", type_ids_array_char_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_char_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_char_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_char_field = 0x00000010;
            bool common_array_char_field_ec {false};
            CommonStructMember common_array_char_field {TypeObjectUtils::build_common_struct_member(member_id_array_char_field, member_flags_array_char_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_char_field, common_array_char_field_ec))};
            if (!common_array_char_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_char_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_char_field = "array_char_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_char_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_char_field = TypeObjectUtils::build_complete_member_detail(name_array_char_field, member_ann_builtin_array_char_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_char_field = TypeObjectUtils::build_complete_struct_member(common_array_char_field, detail_array_char_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_char_field);
        }
        {
            TypeIdentifierPair type_ids_array_uint8_field;
            ReturnCode_t return_code_array_uint8_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_uint8_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_byte_3", type_ids_array_uint8_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint8_field)
            {
                return_code_array_uint8_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_array_uint8_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint8_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_byte_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_byte_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint8_field, element_identifier_anonymous_array_byte_3_ec))};
                if (!element_identifier_anonymous_array_byte_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_byte_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_uint8_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_byte_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_byte_3 = 0;
                PlainCollectionHeader header_anonymous_array_byte_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_byte_3, element_flags_anonymous_array_byte_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_byte_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_byte_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_byte_3", type_ids_array_uint8_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_byte_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_uint8_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_uint8_field = 0x00000011;
            bool common_array_uint8_field_ec {false};
            CommonStructMember common_array_uint8_field {TypeObjectUtils::build_common_struct_member(member_id_array_uint8_field, member_flags_array_uint8_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint8_field, common_array_uint8_field_ec))};
            if (!common_array_uint8_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_uint8_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_uint8_field = "array_uint8_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_uint8_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_uint8_field = TypeObjectUtils::build_complete_member_detail(name_array_uint8_field, member_ann_builtin_array_uint8_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_uint8_field = TypeObjectUtils::build_complete_struct_member(common_array_uint8_field, detail_array_uint8_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_uint8_field);
        }
        {
            TypeIdentifierPair type_ids_array_int16_field;
            ReturnCode_t return_code_array_int16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_int16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int16_t_3", type_ids_array_int16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_int16_field)
            {
                return_code_array_int16_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_array_int16_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_int16_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int16_t_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int16_t_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_int16_field, element_identifier_anonymous_array_int16_t_3_ec))};
                if (!element_identifier_anonymous_array_int16_t_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int16_t_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_int16_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int16_t_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int16_t_3 = 0;
                PlainCollectionHeader header_anonymous_array_int16_t_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int16_t_3, element_flags_anonymous_array_int16_t_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int16_t_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int16_t_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int16_t_3", type_ids_array_int16_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int16_t_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_int16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_int16_field = 0x00000012;
            bool common_array_int16_field_ec {false};
            CommonStructMember common_array_int16_field {TypeObjectUtils::build_common_struct_member(member_id_array_int16_field, member_flags_array_int16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_int16_field, common_array_int16_field_ec))};
            if (!common_array_int16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_int16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_int16_field = "array_int16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_int16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_int16_field = TypeObjectUtils::build_complete_member_detail(name_array_int16_field, member_ann_builtin_array_int16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_int16_field = TypeObjectUtils::build_complete_struct_member(common_array_int16_field, detail_array_int16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_int16_field);
        }
        {
            TypeIdentifierPair type_ids_array_uint16_field;
            ReturnCode_t return_code_array_uint16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_uint16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint16_t_3", type_ids_array_uint16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint16_field)
            {
                return_code_array_uint16_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_array_uint16_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint16_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint16_t_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint16_t_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint16_field, element_identifier_anonymous_array_uint16_t_3_ec))};
                if (!element_identifier_anonymous_array_uint16_t_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint16_t_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_uint16_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint16_t_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint16_t_3 = 0;
                PlainCollectionHeader header_anonymous_array_uint16_t_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint16_t_3, element_flags_anonymous_array_uint16_t_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint16_t_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint16_t_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint16_t_3", type_ids_array_uint16_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint16_t_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_uint16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_uint16_field = 0x00000013;
            bool common_array_uint16_field_ec {false};
            CommonStructMember common_array_uint16_field {TypeObjectUtils::build_common_struct_member(member_id_array_uint16_field, member_flags_array_uint16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint16_field, common_array_uint16_field_ec))};
            if (!common_array_uint16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_uint16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_uint16_field = "array_uint16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_uint16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_uint16_field = TypeObjectUtils::build_complete_member_detail(name_array_uint16_field, member_ann_builtin_array_uint16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_uint16_field = TypeObjectUtils::build_complete_struct_member(common_array_uint16_field, detail_array_uint16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_uint16_field);
        }
        {
            TypeIdentifierPair type_ids_array_int32_field;
            ReturnCode_t return_code_array_int32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_int32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int32_t_3", type_ids_array_int32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_int32_field)
            {
                return_code_array_int32_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_array_int32_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_int32_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int32_t_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int32_t_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_int32_field, element_identifier_anonymous_array_int32_t_3_ec))};
                if (!element_identifier_anonymous_array_int32_t_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int32_t_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_int32_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int32_t_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int32_t_3 = 0;
                PlainCollectionHeader header_anonymous_array_int32_t_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int32_t_3, element_flags_anonymous_array_int32_t_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int32_t_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int32_t_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int32_t_3", type_ids_array_int32_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int32_t_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_int32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_int32_field = 0x00000014;
            bool common_array_int32_field_ec {false};
            CommonStructMember common_array_int32_field {TypeObjectUtils::build_common_struct_member(member_id_array_int32_field, member_flags_array_int32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_int32_field, common_array_int32_field_ec))};
            if (!common_array_int32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_int32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_int32_field = "array_int32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_int32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_int32_field = TypeObjectUtils::build_complete_member_detail(name_array_int32_field, member_ann_builtin_array_int32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_int32_field = TypeObjectUtils::build_complete_struct_member(common_array_int32_field, detail_array_int32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_int32_field);
        }
        {
            TypeIdentifierPair type_ids_array_uint32_field;
            ReturnCode_t return_code_array_uint32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_uint32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint32_t_3", type_ids_array_uint32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint32_field)
            {
                return_code_array_uint32_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_array_uint32_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint32_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint32_t_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint32_t_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint32_field, element_identifier_anonymous_array_uint32_t_3_ec))};
                if (!element_identifier_anonymous_array_uint32_t_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint32_t_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_uint32_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint32_t_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint32_t_3 = 0;
                PlainCollectionHeader header_anonymous_array_uint32_t_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint32_t_3, element_flags_anonymous_array_uint32_t_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint32_t_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint32_t_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint32_t_3", type_ids_array_uint32_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint32_t_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_uint32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_uint32_field = 0x00000015;
            bool common_array_uint32_field_ec {false};
            CommonStructMember common_array_uint32_field {TypeObjectUtils::build_common_struct_member(member_id_array_uint32_field, member_flags_array_uint32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint32_field, common_array_uint32_field_ec))};
            if (!common_array_uint32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_uint32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_uint32_field = "array_uint32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_uint32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_uint32_field = TypeObjectUtils::build_complete_member_detail(name_array_uint32_field, member_ann_builtin_array_uint32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_uint32_field = TypeObjectUtils::build_complete_struct_member(common_array_uint32_field, detail_array_uint32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_uint32_field);
        }
        {
            TypeIdentifierPair type_ids_array_int64_field;
            ReturnCode_t return_code_array_int64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_int64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_int64_t_3", type_ids_array_int64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_int64_field)
            {
                return_code_array_int64_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_array_int64_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_int64_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_int64_t_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_int64_t_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_int64_field, element_identifier_anonymous_array_int64_t_3_ec))};
                if (!element_identifier_anonymous_array_int64_t_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_int64_t_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_int64_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_int64_t_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_int64_t_3 = 0;
                PlainCollectionHeader header_anonymous_array_int64_t_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_int64_t_3, element_flags_anonymous_array_int64_t_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_int64_t_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_int64_t_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_int64_t_3", type_ids_array_int64_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_int64_t_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_int64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_int64_field = 0x00000016;
            bool common_array_int64_field_ec {false};
            CommonStructMember common_array_int64_field {TypeObjectUtils::build_common_struct_member(member_id_array_int64_field, member_flags_array_int64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_int64_field, common_array_int64_field_ec))};
            if (!common_array_int64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_int64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_int64_field = "array_int64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_int64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_int64_field = TypeObjectUtils::build_complete_member_detail(name_array_int64_field, member_ann_builtin_array_int64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_int64_field = TypeObjectUtils::build_complete_struct_member(common_array_int64_field, detail_array_int64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_int64_field);
        }
        {
            TypeIdentifierPair type_ids_array_uint64_field;
            ReturnCode_t return_code_array_uint64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_uint64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_uint64_t_3", type_ids_array_uint64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint64_field)
            {
                return_code_array_uint64_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_array_uint64_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_uint64_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_uint64_t_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_uint64_t_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint64_field, element_identifier_anonymous_array_uint64_t_3_ec))};
                if (!element_identifier_anonymous_array_uint64_t_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_uint64_t_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_uint64_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_uint64_t_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_uint64_t_3 = 0;
                PlainCollectionHeader header_anonymous_array_uint64_t_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_uint64_t_3, element_flags_anonymous_array_uint64_t_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_uint64_t_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_uint64_t_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_uint64_t_3", type_ids_array_uint64_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_uint64_t_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_uint64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_uint64_field = 0x00000017;
            bool common_array_uint64_field_ec {false};
            CommonStructMember common_array_uint64_field {TypeObjectUtils::build_common_struct_member(member_id_array_uint64_field, member_flags_array_uint64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_uint64_field, common_array_uint64_field_ec))};
            if (!common_array_uint64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_uint64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_uint64_field = "array_uint64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_uint64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_uint64_field = TypeObjectUtils::build_complete_member_detail(name_array_uint64_field, member_ann_builtin_array_uint64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_uint64_field = TypeObjectUtils::build_complete_struct_member(common_array_uint64_field, detail_array_uint64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_uint64_field);
        }
        {
            TypeIdentifierPair type_ids_array_float_field;
            ReturnCode_t return_code_array_float_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_float_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_float_3", type_ids_array_float_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_float_field)
            {
                return_code_array_float_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_array_float_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_float_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_float_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_float_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_float_field, element_identifier_anonymous_array_float_3_ec))};
                if (!element_identifier_anonymous_array_float_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_float_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_float_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_float_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_float_3 = 0;
                PlainCollectionHeader header_anonymous_array_float_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_float_3, element_flags_anonymous_array_float_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_float_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_float_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_float_3", type_ids_array_float_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_float_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_float_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_float_field = 0x00000018;
            bool common_array_float_field_ec {false};
            CommonStructMember common_array_float_field {TypeObjectUtils::build_common_struct_member(member_id_array_float_field, member_flags_array_float_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_float_field, common_array_float_field_ec))};
            if (!common_array_float_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_float_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_float_field = "array_float_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_float_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_float_field = TypeObjectUtils::build_complete_member_detail(name_array_float_field, member_ann_builtin_array_float_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_float_field = TypeObjectUtils::build_complete_struct_member(common_array_float_field, detail_array_float_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_float_field);
        }
        {
            TypeIdentifierPair type_ids_array_double_field;
            ReturnCode_t return_code_array_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_double_3", type_ids_array_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_double_field)
            {
                return_code_array_double_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_array_double_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_double_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_double_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_double_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_double_field, element_identifier_anonymous_array_double_3_ec))};
                if (!element_identifier_anonymous_array_double_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_double_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_double_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_double_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_double_3 = 0;
                PlainCollectionHeader header_anonymous_array_double_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_double_3, element_flags_anonymous_array_double_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_double_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_double_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_double_3", type_ids_array_double_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_double_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_double_field = 0x00000019;
            bool common_array_double_field_ec {false};
            CommonStructMember common_array_double_field {TypeObjectUtils::build_common_struct_member(member_id_array_double_field, member_flags_array_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_double_field, common_array_double_field_ec))};
            if (!common_array_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_double_field = "array_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_double_field = TypeObjectUtils::build_complete_member_detail(name_array_double_field, member_ann_builtin_array_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_double_field = TypeObjectUtils::build_complete_struct_member(common_array_double_field, detail_array_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_double_field);
        }
        {
            TypeIdentifierPair type_ids_array_long_double_field;
            ReturnCode_t return_code_array_long_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_long_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_longdouble_3", type_ids_array_long_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_long_double_field)
            {
                return_code_array_long_double_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_array_long_double_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_long_double_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_longdouble_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_longdouble_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_long_double_field, element_identifier_anonymous_array_longdouble_3_ec))};
                if (!element_identifier_anonymous_array_longdouble_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_longdouble_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_long_double_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_longdouble_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_longdouble_3 = 0;
                PlainCollectionHeader header_anonymous_array_longdouble_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_longdouble_3, element_flags_anonymous_array_longdouble_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_longdouble_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_longdouble_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_longdouble_3", type_ids_array_long_double_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_longdouble_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_long_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_long_double_field = 0x0000001a;
            bool common_array_long_double_field_ec {false};
            CommonStructMember common_array_long_double_field {TypeObjectUtils::build_common_struct_member(member_id_array_long_double_field, member_flags_array_long_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_long_double_field, common_array_long_double_field_ec))};
            if (!common_array_long_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_long_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_long_double_field = "array_long_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_long_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_long_double_field = TypeObjectUtils::build_complete_member_detail(name_array_long_double_field, member_ann_builtin_array_long_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_long_double_field = TypeObjectUtils::build_complete_struct_member(common_array_long_double_field, detail_array_long_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_long_double_field);
        }
        {
            TypeIdentifierPair type_ids_array_bool_field;
            ReturnCode_t return_code_array_bool_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_bool_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_bool_3", type_ids_array_bool_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_bool_field)
            {
                return_code_array_bool_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_array_bool_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_bool_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Array element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_array_bool_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_bool_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_bool_field, element_identifier_anonymous_array_bool_3_ec))};
                if (!element_identifier_anonymous_array_bool_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_bool_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_bool_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_bool_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_bool_3 = 0;
                PlainCollectionHeader header_anonymous_array_bool_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_bool_3, element_flags_anonymous_array_bool_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_bool_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_bool_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_bool_3", type_ids_array_bool_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_bool_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_bool_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_bool_field = 0x0000001b;
            bool common_array_bool_field_ec {false};
            CommonStructMember common_array_bool_field {TypeObjectUtils::build_common_struct_member(member_id_array_bool_field, member_flags_array_bool_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_bool_field, common_array_bool_field_ec))};
            if (!common_array_bool_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_bool_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_bool_field = "array_bool_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_bool_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_bool_field = TypeObjectUtils::build_complete_member_detail(name_array_bool_field, member_ann_builtin_array_bool_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_bool_field = TypeObjectUtils::build_complete_struct_member(common_array_bool_field, detail_array_bool_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_bool_field);
        }
        {
            TypeIdentifierPair type_ids_array_string_field;
            ReturnCode_t return_code_array_string_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_string_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_anonymous_string_unbounded_3", type_ids_array_string_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_string_field)
            {
                return_code_array_string_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_array_string_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_string_field)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_array_string_field))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_array_anonymous_string_unbounded_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_anonymous_string_unbounded_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_string_field, element_identifier_anonymous_array_anonymous_string_unbounded_3_ec))};
                if (!element_identifier_anonymous_array_anonymous_string_unbounded_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_anonymous_string_unbounded_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_string_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_anonymous_string_unbounded_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_anonymous_string_unbounded_3 = 0;
                PlainCollectionHeader header_anonymous_array_anonymous_string_unbounded_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_anonymous_string_unbounded_3, element_flags_anonymous_array_anonymous_string_unbounded_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_anonymous_string_unbounded_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_anonymous_string_unbounded_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_anonymous_string_unbounded_3", type_ids_array_string_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_anonymous_string_unbounded_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_string_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_string_field = 0x0000001c;
            bool common_array_string_field_ec {false};
            CommonStructMember common_array_string_field {TypeObjectUtils::build_common_struct_member(member_id_array_string_field, member_flags_array_string_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_string_field, common_array_string_field_ec))};
            if (!common_array_string_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_string_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_string_field = "array_string_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_string_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_string_field = TypeObjectUtils::build_complete_member_detail(name_array_string_field, member_ann_builtin_array_string_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_string_field = TypeObjectUtils::build_complete_struct_member(common_array_string_field, detail_array_string_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_string_field);
        }
        {
            TypeIdentifierPair type_ids_array_enum_field;
            ReturnCode_t return_code_array_enum_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_enum_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_Color_3", type_ids_array_enum_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_enum_field)
            {
                return_code_array_enum_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Color", type_ids_array_enum_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_enum_field)
                {
                ::register_Color_type_identifier(type_ids_array_enum_field);
                }
                bool element_identifier_anonymous_array_Color_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_Color_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_enum_field, element_identifier_anonymous_array_Color_3_ec))};
                if (!element_identifier_anonymous_array_Color_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_Color_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_enum_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_Color_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_Color_3 = 0;
                PlainCollectionHeader header_anonymous_array_Color_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_Color_3, element_flags_anonymous_array_Color_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_Color_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_Color_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_Color_3", type_ids_array_enum_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_Color_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_enum_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_enum_field = 0x0000001d;
            bool common_array_enum_field_ec {false};
            CommonStructMember common_array_enum_field {TypeObjectUtils::build_common_struct_member(member_id_array_enum_field, member_flags_array_enum_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_enum_field, common_array_enum_field_ec))};
            if (!common_array_enum_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_enum_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_enum_field = "array_enum_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_enum_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_enum_field = TypeObjectUtils::build_complete_member_detail(name_array_enum_field, member_ann_builtin_array_enum_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_enum_field = TypeObjectUtils::build_complete_struct_member(common_array_enum_field, detail_array_enum_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_enum_field);
        }
        {
            TypeIdentifierPair type_ids_array_enum2_field;
            ReturnCode_t return_code_array_enum2_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_enum2_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_Material_3", type_ids_array_enum2_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_enum2_field)
            {
                return_code_array_enum2_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Material", type_ids_array_enum2_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_enum2_field)
                {
                ::register_Material_type_identifier(type_ids_array_enum2_field);
                }
                bool element_identifier_anonymous_array_Material_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_Material_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_enum2_field, element_identifier_anonymous_array_Material_3_ec))};
                if (!element_identifier_anonymous_array_Material_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_Material_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_enum2_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_Material_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_Material_3 = 0;
                PlainCollectionHeader header_anonymous_array_Material_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_Material_3, element_flags_anonymous_array_Material_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_Material_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_Material_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_Material_3", type_ids_array_enum2_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_Material_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_enum2_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_enum2_field = 0x0000001e;
            bool common_array_enum2_field_ec {false};
            CommonStructMember common_array_enum2_field {TypeObjectUtils::build_common_struct_member(member_id_array_enum2_field, member_flags_array_enum2_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_enum2_field, common_array_enum2_field_ec))};
            if (!common_array_enum2_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_enum2_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_enum2_field = "array_enum2_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_enum2_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_enum2_field = TypeObjectUtils::build_complete_member_detail(name_array_enum2_field, member_ann_builtin_array_enum2_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_enum2_field = TypeObjectUtils::build_complete_struct_member(common_array_enum2_field, detail_array_enum2_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_enum2_field);
        }
        {
            TypeIdentifierPair type_ids_array_struct_field;
            ReturnCode_t return_code_array_struct_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_array_struct_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_array_StructType_3", type_ids_array_struct_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_struct_field)
            {
                return_code_array_struct_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "StructType", type_ids_array_struct_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_array_struct_field)
                {
                ::register_StructType_type_identifier(type_ids_array_struct_field);
                }
                bool element_identifier_anonymous_array_StructType_3_ec {false};
                TypeIdentifier* element_identifier_anonymous_array_StructType_3 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_struct_field, element_identifier_anonymous_array_StructType_3_ec))};
                if (!element_identifier_anonymous_array_StructType_3_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Array element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_array_StructType_3 = EK_COMPLETE;
                if (TK_NONE == type_ids_array_struct_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_array_StructType_3 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_array_StructType_3 = 0;
                PlainCollectionHeader header_anonymous_array_StructType_3 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_array_StructType_3, element_flags_anonymous_array_StructType_3);
                {
                    SBoundSeq array_bound_seq;
                        TypeObjectUtils::add_array_dimension(array_bound_seq, static_cast<SBound>(3));

                    PlainArraySElemDefn array_sdefn = TypeObjectUtils::build_plain_array_s_elem_defn(header_anonymous_array_StructType_3, array_bound_seq,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_array_StructType_3));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_array_type_identifier(array_sdefn, "anonymous_array_StructType_3", type_ids_array_struct_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_array_StructType_3 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_array_struct_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_array_struct_field = 0x0000001f;
            bool common_array_struct_field_ec {false};
            CommonStructMember common_array_struct_field {TypeObjectUtils::build_common_struct_member(member_id_array_struct_field, member_flags_array_struct_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_array_struct_field, common_array_struct_field_ec))};
            if (!common_array_struct_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure array_struct_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_array_struct_field = "array_struct_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_array_struct_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_array_struct_field = TypeObjectUtils::build_complete_member_detail(name_array_struct_field, member_ann_builtin_array_struct_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_array_struct_field = TypeObjectUtils::build_complete_struct_member(common_array_struct_field, detail_array_struct_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_array_struct_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_char_field;
            ReturnCode_t return_code_bounded_sequence_char_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_char_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_char_5", type_ids_bounded_sequence_char_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_char_field)
            {
                return_code_bounded_sequence_char_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_bounded_sequence_char_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_char_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_char_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_char_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_char_field, element_identifier_anonymous_sequence_char_5_ec))};
                if (!element_identifier_anonymous_sequence_char_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_char_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_char_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_char_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_char_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_char_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_char_5, element_flags_anonymous_sequence_char_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_char_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_char_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_char_5", type_ids_bounded_sequence_char_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_char_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_char_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_char_field = 0x00000020;
            bool common_bounded_sequence_char_field_ec {false};
            CommonStructMember common_bounded_sequence_char_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_char_field, member_flags_bounded_sequence_char_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_char_field, common_bounded_sequence_char_field_ec))};
            if (!common_bounded_sequence_char_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_char_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_char_field = "bounded_sequence_char_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_char_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_char_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_char_field, member_ann_builtin_bounded_sequence_char_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_char_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_char_field, detail_bounded_sequence_char_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_char_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_uint8_field;
            ReturnCode_t return_code_bounded_sequence_uint8_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_uint8_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_byte_5", type_ids_bounded_sequence_uint8_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint8_field)
            {
                return_code_bounded_sequence_uint8_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_bounded_sequence_uint8_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint8_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_byte_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_byte_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint8_field, element_identifier_anonymous_sequence_byte_5_ec))};
                if (!element_identifier_anonymous_sequence_byte_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_byte_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_uint8_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_byte_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_byte_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_byte_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_byte_5, element_flags_anonymous_sequence_byte_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_byte_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_byte_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_byte_5", type_ids_bounded_sequence_uint8_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_byte_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_uint8_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_uint8_field = 0x00000021;
            bool common_bounded_sequence_uint8_field_ec {false};
            CommonStructMember common_bounded_sequence_uint8_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_uint8_field, member_flags_bounded_sequence_uint8_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint8_field, common_bounded_sequence_uint8_field_ec))};
            if (!common_bounded_sequence_uint8_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_uint8_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_uint8_field = "bounded_sequence_uint8_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_uint8_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_uint8_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_uint8_field, member_ann_builtin_bounded_sequence_uint8_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_uint8_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_uint8_field, detail_bounded_sequence_uint8_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_uint8_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_int16_field;
            ReturnCode_t return_code_bounded_sequence_int16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_int16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_5", type_ids_bounded_sequence_int16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_int16_field)
            {
                return_code_bounded_sequence_int16_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_bounded_sequence_int16_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_int16_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_int16_field, element_identifier_anonymous_sequence_int16_t_5_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_int16_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_5, element_flags_anonymous_sequence_int16_t_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_5", type_ids_bounded_sequence_int16_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_int16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_int16_field = 0x00000022;
            bool common_bounded_sequence_int16_field_ec {false};
            CommonStructMember common_bounded_sequence_int16_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_int16_field, member_flags_bounded_sequence_int16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_int16_field, common_bounded_sequence_int16_field_ec))};
            if (!common_bounded_sequence_int16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_int16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_int16_field = "bounded_sequence_int16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_int16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_int16_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_int16_field, member_ann_builtin_bounded_sequence_int16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_int16_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_int16_field, detail_bounded_sequence_int16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_int16_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_uint16_field;
            ReturnCode_t return_code_bounded_sequence_uint16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_uint16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint16_t_5", type_ids_bounded_sequence_uint16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint16_field)
            {
                return_code_bounded_sequence_uint16_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_bounded_sequence_uint16_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint16_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint16_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint16_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint16_field, element_identifier_anonymous_sequence_uint16_t_5_ec))};
                if (!element_identifier_anonymous_sequence_uint16_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint16_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_uint16_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint16_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint16_t_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_uint16_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint16_t_5, element_flags_anonymous_sequence_uint16_t_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint16_t_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint16_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint16_t_5", type_ids_bounded_sequence_uint16_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint16_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_uint16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_uint16_field = 0x00000023;
            bool common_bounded_sequence_uint16_field_ec {false};
            CommonStructMember common_bounded_sequence_uint16_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_uint16_field, member_flags_bounded_sequence_uint16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint16_field, common_bounded_sequence_uint16_field_ec))};
            if (!common_bounded_sequence_uint16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_uint16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_uint16_field = "bounded_sequence_uint16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_uint16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_uint16_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_uint16_field, member_ann_builtin_bounded_sequence_uint16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_uint16_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_uint16_field, detail_bounded_sequence_uint16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_uint16_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_int32_field;
            ReturnCode_t return_code_bounded_sequence_int32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_int32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int32_t_5", type_ids_bounded_sequence_int32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_int32_field)
            {
                return_code_bounded_sequence_int32_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_bounded_sequence_int32_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_int32_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int32_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int32_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_int32_field, element_identifier_anonymous_sequence_int32_t_5_ec))};
                if (!element_identifier_anonymous_sequence_int32_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int32_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_int32_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int32_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int32_t_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_int32_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_5, element_flags_anonymous_sequence_int32_t_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_5", type_ids_bounded_sequence_int32_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int32_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_int32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_int32_field = 0x00000024;
            bool common_bounded_sequence_int32_field_ec {false};
            CommonStructMember common_bounded_sequence_int32_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_int32_field, member_flags_bounded_sequence_int32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_int32_field, common_bounded_sequence_int32_field_ec))};
            if (!common_bounded_sequence_int32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_int32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_int32_field = "bounded_sequence_int32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_int32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_int32_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_int32_field, member_ann_builtin_bounded_sequence_int32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_int32_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_int32_field, detail_bounded_sequence_int32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_int32_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_uint32_field;
            ReturnCode_t return_code_bounded_sequence_uint32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_uint32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint32_t_5", type_ids_bounded_sequence_uint32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint32_field)
            {
                return_code_bounded_sequence_uint32_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_bounded_sequence_uint32_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint32_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint32_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint32_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint32_field, element_identifier_anonymous_sequence_uint32_t_5_ec))};
                if (!element_identifier_anonymous_sequence_uint32_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint32_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_uint32_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint32_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint32_t_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_uint32_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint32_t_5, element_flags_anonymous_sequence_uint32_t_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint32_t_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint32_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint32_t_5", type_ids_bounded_sequence_uint32_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint32_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_uint32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_uint32_field = 0x00000025;
            bool common_bounded_sequence_uint32_field_ec {false};
            CommonStructMember common_bounded_sequence_uint32_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_uint32_field, member_flags_bounded_sequence_uint32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint32_field, common_bounded_sequence_uint32_field_ec))};
            if (!common_bounded_sequence_uint32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_uint32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_uint32_field = "bounded_sequence_uint32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_uint32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_uint32_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_uint32_field, member_ann_builtin_bounded_sequence_uint32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_uint32_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_uint32_field, detail_bounded_sequence_uint32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_uint32_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_int64_field;
            ReturnCode_t return_code_bounded_sequence_int64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_int64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int64_t_5", type_ids_bounded_sequence_int64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_int64_field)
            {
                return_code_bounded_sequence_int64_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_bounded_sequence_int64_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_int64_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int64_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int64_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_int64_field, element_identifier_anonymous_sequence_int64_t_5_ec))};
                if (!element_identifier_anonymous_sequence_int64_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int64_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_int64_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int64_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int64_t_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_int64_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int64_t_5, element_flags_anonymous_sequence_int64_t_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int64_t_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int64_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int64_t_5", type_ids_bounded_sequence_int64_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int64_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_int64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_int64_field = 0x00000026;
            bool common_bounded_sequence_int64_field_ec {false};
            CommonStructMember common_bounded_sequence_int64_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_int64_field, member_flags_bounded_sequence_int64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_int64_field, common_bounded_sequence_int64_field_ec))};
            if (!common_bounded_sequence_int64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_int64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_int64_field = "bounded_sequence_int64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_int64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_int64_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_int64_field, member_ann_builtin_bounded_sequence_int64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_int64_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_int64_field, detail_bounded_sequence_int64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_int64_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_uint64_field;
            ReturnCode_t return_code_bounded_sequence_uint64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_uint64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint64_t_5", type_ids_bounded_sequence_uint64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint64_field)
            {
                return_code_bounded_sequence_uint64_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_bounded_sequence_uint64_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_uint64_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint64_t_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint64_t_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint64_field, element_identifier_anonymous_sequence_uint64_t_5_ec))};
                if (!element_identifier_anonymous_sequence_uint64_t_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint64_t_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_uint64_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint64_t_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint64_t_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_uint64_t_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint64_t_5, element_flags_anonymous_sequence_uint64_t_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint64_t_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint64_t_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint64_t_5", type_ids_bounded_sequence_uint64_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint64_t_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_uint64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_uint64_field = 0x00000027;
            bool common_bounded_sequence_uint64_field_ec {false};
            CommonStructMember common_bounded_sequence_uint64_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_uint64_field, member_flags_bounded_sequence_uint64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_uint64_field, common_bounded_sequence_uint64_field_ec))};
            if (!common_bounded_sequence_uint64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_uint64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_uint64_field = "bounded_sequence_uint64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_uint64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_uint64_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_uint64_field, member_ann_builtin_bounded_sequence_uint64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_uint64_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_uint64_field, detail_bounded_sequence_uint64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_uint64_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_float_field;
            ReturnCode_t return_code_bounded_sequence_float_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_float_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_float_5", type_ids_bounded_sequence_float_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_float_field)
            {
                return_code_bounded_sequence_float_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_bounded_sequence_float_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_float_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_float_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_float_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_float_field, element_identifier_anonymous_sequence_float_5_ec))};
                if (!element_identifier_anonymous_sequence_float_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_float_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_float_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_float_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_float_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_float_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_float_5, element_flags_anonymous_sequence_float_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_float_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_float_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_float_5", type_ids_bounded_sequence_float_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_float_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_float_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_float_field = 0x00000028;
            bool common_bounded_sequence_float_field_ec {false};
            CommonStructMember common_bounded_sequence_float_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_float_field, member_flags_bounded_sequence_float_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_float_field, common_bounded_sequence_float_field_ec))};
            if (!common_bounded_sequence_float_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_float_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_float_field = "bounded_sequence_float_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_float_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_float_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_float_field, member_ann_builtin_bounded_sequence_float_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_float_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_float_field, detail_bounded_sequence_float_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_float_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_double_field;
            ReturnCode_t return_code_bounded_sequence_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_double_5", type_ids_bounded_sequence_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_double_field)
            {
                return_code_bounded_sequence_double_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_bounded_sequence_double_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_double_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_double_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_double_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_double_field, element_identifier_anonymous_sequence_double_5_ec))};
                if (!element_identifier_anonymous_sequence_double_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_double_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_double_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_double_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_double_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_double_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_double_5, element_flags_anonymous_sequence_double_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_double_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_double_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_double_5", type_ids_bounded_sequence_double_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_double_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_double_field = 0x00000029;
            bool common_bounded_sequence_double_field_ec {false};
            CommonStructMember common_bounded_sequence_double_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_double_field, member_flags_bounded_sequence_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_double_field, common_bounded_sequence_double_field_ec))};
            if (!common_bounded_sequence_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_double_field = "bounded_sequence_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_double_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_double_field, member_ann_builtin_bounded_sequence_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_double_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_double_field, detail_bounded_sequence_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_double_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_long_double_field;
            ReturnCode_t return_code_bounded_sequence_long_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_long_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_longdouble_5", type_ids_bounded_sequence_long_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_long_double_field)
            {
                return_code_bounded_sequence_long_double_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_bounded_sequence_long_double_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_long_double_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_longdouble_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_longdouble_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_long_double_field, element_identifier_anonymous_sequence_longdouble_5_ec))};
                if (!element_identifier_anonymous_sequence_longdouble_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_longdouble_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_long_double_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_longdouble_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_longdouble_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_longdouble_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_longdouble_5, element_flags_anonymous_sequence_longdouble_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_longdouble_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_longdouble_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_longdouble_5", type_ids_bounded_sequence_long_double_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_longdouble_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_long_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_long_double_field = 0x0000002a;
            bool common_bounded_sequence_long_double_field_ec {false};
            CommonStructMember common_bounded_sequence_long_double_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_long_double_field, member_flags_bounded_sequence_long_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_long_double_field, common_bounded_sequence_long_double_field_ec))};
            if (!common_bounded_sequence_long_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_long_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_long_double_field = "bounded_sequence_long_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_long_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_long_double_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_long_double_field, member_ann_builtin_bounded_sequence_long_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_long_double_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_long_double_field, detail_bounded_sequence_long_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_long_double_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_bool_field;
            ReturnCode_t return_code_bounded_sequence_bool_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_bool_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_bool_5", type_ids_bounded_sequence_bool_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_bool_field)
            {
                return_code_bounded_sequence_bool_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_bounded_sequence_bool_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_bool_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_bool_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_bool_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_bool_field, element_identifier_anonymous_sequence_bool_5_ec))};
                if (!element_identifier_anonymous_sequence_bool_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_bool_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_bool_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_bool_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_bool_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_bool_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_bool_5, element_flags_anonymous_sequence_bool_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_bool_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_bool_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_bool_5", type_ids_bounded_sequence_bool_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_bool_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_bool_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_bool_field = 0x0000002b;
            bool common_bounded_sequence_bool_field_ec {false};
            CommonStructMember common_bounded_sequence_bool_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_bool_field, member_flags_bounded_sequence_bool_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_bool_field, common_bounded_sequence_bool_field_ec))};
            if (!common_bounded_sequence_bool_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_bool_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_bool_field = "bounded_sequence_bool_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_bool_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_bool_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_bool_field, member_ann_builtin_bounded_sequence_bool_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_bool_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_bool_field, detail_bounded_sequence_bool_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_bool_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_string_field;
            ReturnCode_t return_code_bounded_sequence_string_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_string_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_string_unbounded_5", type_ids_bounded_sequence_string_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_string_field)
            {
                return_code_bounded_sequence_string_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_bounded_sequence_string_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_string_field)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_bounded_sequence_string_field))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_sequence_anonymous_string_unbounded_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_string_unbounded_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_string_field, element_identifier_anonymous_sequence_anonymous_string_unbounded_5_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_string_unbounded_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_string_unbounded_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_string_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_string_unbounded_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_string_unbounded_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_string_unbounded_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_string_unbounded_5, element_flags_anonymous_sequence_anonymous_string_unbounded_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_string_unbounded_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_string_unbounded_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_string_unbounded_5", type_ids_bounded_sequence_string_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_string_unbounded_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_string_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_string_field = 0x0000002c;
            bool common_bounded_sequence_string_field_ec {false};
            CommonStructMember common_bounded_sequence_string_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_string_field, member_flags_bounded_sequence_string_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_string_field, common_bounded_sequence_string_field_ec))};
            if (!common_bounded_sequence_string_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_string_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_string_field = "bounded_sequence_string_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_string_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_string_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_string_field, member_ann_builtin_bounded_sequence_string_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_string_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_string_field, detail_bounded_sequence_string_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_string_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_enum_field;
            ReturnCode_t return_code_bounded_sequence_enum_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_enum_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_Color_5", type_ids_bounded_sequence_enum_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_enum_field)
            {
                return_code_bounded_sequence_enum_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Color", type_ids_bounded_sequence_enum_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_enum_field)
                {
                ::register_Color_type_identifier(type_ids_bounded_sequence_enum_field);
                }
                bool element_identifier_anonymous_sequence_Color_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_Color_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_enum_field, element_identifier_anonymous_sequence_Color_5_ec))};
                if (!element_identifier_anonymous_sequence_Color_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_Color_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_enum_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_Color_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_Color_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_Color_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_Color_5, element_flags_anonymous_sequence_Color_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_Color_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_Color_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_Color_5", type_ids_bounded_sequence_enum_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_Color_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_enum_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_enum_field = 0x0000002d;
            bool common_bounded_sequence_enum_field_ec {false};
            CommonStructMember common_bounded_sequence_enum_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_enum_field, member_flags_bounded_sequence_enum_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_enum_field, common_bounded_sequence_enum_field_ec))};
            if (!common_bounded_sequence_enum_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_enum_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_enum_field = "bounded_sequence_enum_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_enum_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_enum_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_enum_field, member_ann_builtin_bounded_sequence_enum_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_enum_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_enum_field, detail_bounded_sequence_enum_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_enum_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_enum2_field;
            ReturnCode_t return_code_bounded_sequence_enum2_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_enum2_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_Material_5", type_ids_bounded_sequence_enum2_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_enum2_field)
            {
                return_code_bounded_sequence_enum2_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Material", type_ids_bounded_sequence_enum2_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_enum2_field)
                {
                ::register_Material_type_identifier(type_ids_bounded_sequence_enum2_field);
                }
                bool element_identifier_anonymous_sequence_Material_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_Material_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_enum2_field, element_identifier_anonymous_sequence_Material_5_ec))};
                if (!element_identifier_anonymous_sequence_Material_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_Material_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_enum2_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_Material_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_Material_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_Material_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_Material_5, element_flags_anonymous_sequence_Material_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_Material_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_Material_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_Material_5", type_ids_bounded_sequence_enum2_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_Material_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_enum2_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_enum2_field = 0x0000002e;
            bool common_bounded_sequence_enum2_field_ec {false};
            CommonStructMember common_bounded_sequence_enum2_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_enum2_field, member_flags_bounded_sequence_enum2_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_enum2_field, common_bounded_sequence_enum2_field_ec))};
            if (!common_bounded_sequence_enum2_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_enum2_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_enum2_field = "bounded_sequence_enum2_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_enum2_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_enum2_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_enum2_field, member_ann_builtin_bounded_sequence_enum2_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_enum2_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_enum2_field, detail_bounded_sequence_enum2_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_enum2_field);
        }
        {
            TypeIdentifierPair type_ids_bounded_sequence_struct_field;
            ReturnCode_t return_code_bounded_sequence_struct_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bounded_sequence_struct_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_StructType_5", type_ids_bounded_sequence_struct_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_struct_field)
            {
                return_code_bounded_sequence_struct_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "StructType", type_ids_bounded_sequence_struct_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_bounded_sequence_struct_field)
                {
                ::register_StructType_type_identifier(type_ids_bounded_sequence_struct_field);
                }
                bool element_identifier_anonymous_sequence_StructType_5_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_StructType_5 {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_struct_field, element_identifier_anonymous_sequence_StructType_5_ec))};
                if (!element_identifier_anonymous_sequence_StructType_5_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_StructType_5 = EK_COMPLETE;
                if (TK_NONE == type_ids_bounded_sequence_struct_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_StructType_5 = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_StructType_5 = 0;
                PlainCollectionHeader header_anonymous_sequence_StructType_5 = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_StructType_5, element_flags_anonymous_sequence_StructType_5);
                {
                    SBound bound = static_cast<SBound>(5);
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_StructType_5, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_StructType_5));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_StructType_5", type_ids_bounded_sequence_struct_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_StructType_5 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_bounded_sequence_struct_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bounded_sequence_struct_field = 0x0000002f;
            bool common_bounded_sequence_struct_field_ec {false};
            CommonStructMember common_bounded_sequence_struct_field {TypeObjectUtils::build_common_struct_member(member_id_bounded_sequence_struct_field, member_flags_bounded_sequence_struct_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bounded_sequence_struct_field, common_bounded_sequence_struct_field_ec))};
            if (!common_bounded_sequence_struct_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bounded_sequence_struct_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bounded_sequence_struct_field = "bounded_sequence_struct_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bounded_sequence_struct_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_bounded_sequence_struct_field = TypeObjectUtils::build_complete_member_detail(name_bounded_sequence_struct_field, member_ann_builtin_bounded_sequence_struct_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_bounded_sequence_struct_field = TypeObjectUtils::build_complete_struct_member(common_bounded_sequence_struct_field, detail_bounded_sequence_struct_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_bounded_sequence_struct_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_char_field;
            ReturnCode_t return_code_unbounded_sequence_char_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_char_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_char_unbounded", type_ids_unbounded_sequence_char_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_char_field)
            {
                return_code_unbounded_sequence_char_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_char", type_ids_unbounded_sequence_char_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_char_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_char_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_char_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_char_field, element_identifier_anonymous_sequence_char_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_char_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_char_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_char_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_char_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_char_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_char_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_char_unbounded, element_flags_anonymous_sequence_char_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_char_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_char_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_char_unbounded", type_ids_unbounded_sequence_char_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_char_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_char_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_char_field = 0x00000030;
            bool common_unbounded_sequence_char_field_ec {false};
            CommonStructMember common_unbounded_sequence_char_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_char_field, member_flags_unbounded_sequence_char_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_char_field, common_unbounded_sequence_char_field_ec))};
            if (!common_unbounded_sequence_char_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_char_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_char_field = "unbounded_sequence_char_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_char_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_char_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_char_field, member_ann_builtin_unbounded_sequence_char_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_char_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_char_field, detail_unbounded_sequence_char_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_char_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_uint8_field;
            ReturnCode_t return_code_unbounded_sequence_uint8_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_uint8_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_byte_unbounded", type_ids_unbounded_sequence_uint8_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint8_field)
            {
                return_code_unbounded_sequence_uint8_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_byte", type_ids_unbounded_sequence_uint8_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint8_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_byte_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_byte_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint8_field, element_identifier_anonymous_sequence_byte_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_byte_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_byte_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_uint8_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_byte_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_byte_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_byte_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_byte_unbounded, element_flags_anonymous_sequence_byte_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_byte_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_byte_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_byte_unbounded", type_ids_unbounded_sequence_uint8_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_byte_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_uint8_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_uint8_field = 0x00000031;
            bool common_unbounded_sequence_uint8_field_ec {false};
            CommonStructMember common_unbounded_sequence_uint8_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_uint8_field, member_flags_unbounded_sequence_uint8_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint8_field, common_unbounded_sequence_uint8_field_ec))};
            if (!common_unbounded_sequence_uint8_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_uint8_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_uint8_field = "unbounded_sequence_uint8_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_uint8_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_uint8_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_uint8_field, member_ann_builtin_unbounded_sequence_uint8_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_uint8_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_uint8_field, detail_unbounded_sequence_uint8_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_uint8_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_int16_field;
            ReturnCode_t return_code_unbounded_sequence_int16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_int16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int16_t_unbounded", type_ids_unbounded_sequence_int16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_int16_field)
            {
                return_code_unbounded_sequence_int16_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int16_t", type_ids_unbounded_sequence_int16_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_int16_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_int16_field, element_identifier_anonymous_sequence_int16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_int16_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int16_t_unbounded, element_flags_anonymous_sequence_int16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int16_t_unbounded", type_ids_unbounded_sequence_int16_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_int16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_int16_field = 0x00000032;
            bool common_unbounded_sequence_int16_field_ec {false};
            CommonStructMember common_unbounded_sequence_int16_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_int16_field, member_flags_unbounded_sequence_int16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_int16_field, common_unbounded_sequence_int16_field_ec))};
            if (!common_unbounded_sequence_int16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_int16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_int16_field = "unbounded_sequence_int16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_int16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_int16_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_int16_field, member_ann_builtin_unbounded_sequence_int16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_int16_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_int16_field, detail_unbounded_sequence_int16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_int16_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_uint16_field;
            ReturnCode_t return_code_unbounded_sequence_uint16_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_uint16_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint16_t_unbounded", type_ids_unbounded_sequence_uint16_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint16_field)
            {
                return_code_unbounded_sequence_uint16_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint16_t", type_ids_unbounded_sequence_uint16_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint16_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint16_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint16_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint16_field, element_identifier_anonymous_sequence_uint16_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_uint16_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint16_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_uint16_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint16_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint16_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_uint16_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint16_t_unbounded, element_flags_anonymous_sequence_uint16_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint16_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint16_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint16_t_unbounded", type_ids_unbounded_sequence_uint16_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint16_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_uint16_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_uint16_field = 0x00000033;
            bool common_unbounded_sequence_uint16_field_ec {false};
            CommonStructMember common_unbounded_sequence_uint16_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_uint16_field, member_flags_unbounded_sequence_uint16_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint16_field, common_unbounded_sequence_uint16_field_ec))};
            if (!common_unbounded_sequence_uint16_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_uint16_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_uint16_field = "unbounded_sequence_uint16_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_uint16_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_uint16_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_uint16_field, member_ann_builtin_unbounded_sequence_uint16_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_uint16_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_uint16_field, detail_unbounded_sequence_uint16_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_uint16_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_int32_field;
            ReturnCode_t return_code_unbounded_sequence_int32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_int32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int32_t_unbounded", type_ids_unbounded_sequence_int32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_int32_field)
            {
                return_code_unbounded_sequence_int32_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int32_t", type_ids_unbounded_sequence_int32_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_int32_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_int32_field, element_identifier_anonymous_sequence_int32_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int32_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_int32_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int32_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int32_t_unbounded, element_flags_anonymous_sequence_int32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int32_t_unbounded", type_ids_unbounded_sequence_int32_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_int32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_int32_field = 0x00000034;
            bool common_unbounded_sequence_int32_field_ec {false};
            CommonStructMember common_unbounded_sequence_int32_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_int32_field, member_flags_unbounded_sequence_int32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_int32_field, common_unbounded_sequence_int32_field_ec))};
            if (!common_unbounded_sequence_int32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_int32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_int32_field = "unbounded_sequence_int32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_int32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_int32_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_int32_field, member_ann_builtin_unbounded_sequence_int32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_int32_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_int32_field, detail_unbounded_sequence_int32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_int32_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_uint32_field;
            ReturnCode_t return_code_unbounded_sequence_uint32_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_uint32_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint32_t_unbounded", type_ids_unbounded_sequence_uint32_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint32_field)
            {
                return_code_unbounded_sequence_uint32_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint32_t", type_ids_unbounded_sequence_uint32_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint32_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint32_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint32_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint32_field, element_identifier_anonymous_sequence_uint32_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_uint32_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint32_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_uint32_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint32_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint32_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_uint32_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint32_t_unbounded, element_flags_anonymous_sequence_uint32_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint32_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint32_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint32_t_unbounded", type_ids_unbounded_sequence_uint32_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint32_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_uint32_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_uint32_field = 0x00000035;
            bool common_unbounded_sequence_uint32_field_ec {false};
            CommonStructMember common_unbounded_sequence_uint32_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_uint32_field, member_flags_unbounded_sequence_uint32_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint32_field, common_unbounded_sequence_uint32_field_ec))};
            if (!common_unbounded_sequence_uint32_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_uint32_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_uint32_field = "unbounded_sequence_uint32_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_uint32_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_uint32_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_uint32_field, member_ann_builtin_unbounded_sequence_uint32_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_uint32_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_uint32_field, detail_unbounded_sequence_uint32_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_uint32_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_int64_field;
            ReturnCode_t return_code_unbounded_sequence_int64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_int64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_int64_t_unbounded", type_ids_unbounded_sequence_int64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_int64_field)
            {
                return_code_unbounded_sequence_int64_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_int64_t", type_ids_unbounded_sequence_int64_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_int64_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_int64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_int64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_int64_field, element_identifier_anonymous_sequence_int64_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_int64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_int64_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_int64_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_int64_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_int64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_int64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_int64_t_unbounded, element_flags_anonymous_sequence_int64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_int64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_int64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_int64_t_unbounded", type_ids_unbounded_sequence_int64_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_int64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_int64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_int64_field = 0x00000036;
            bool common_unbounded_sequence_int64_field_ec {false};
            CommonStructMember common_unbounded_sequence_int64_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_int64_field, member_flags_unbounded_sequence_int64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_int64_field, common_unbounded_sequence_int64_field_ec))};
            if (!common_unbounded_sequence_int64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_int64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_int64_field = "unbounded_sequence_int64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_int64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_int64_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_int64_field, member_ann_builtin_unbounded_sequence_int64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_int64_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_int64_field, detail_unbounded_sequence_int64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_int64_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_uint64_field;
            ReturnCode_t return_code_unbounded_sequence_uint64_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_uint64_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_uint64_t_unbounded", type_ids_unbounded_sequence_uint64_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint64_field)
            {
                return_code_unbounded_sequence_uint64_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_uint64_t", type_ids_unbounded_sequence_uint64_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_uint64_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_uint64_t_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_uint64_t_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint64_field, element_identifier_anonymous_sequence_uint64_t_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_uint64_t_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_uint64_t_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_uint64_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_uint64_t_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_uint64_t_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_uint64_t_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_uint64_t_unbounded, element_flags_anonymous_sequence_uint64_t_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_uint64_t_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_uint64_t_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_uint64_t_unbounded", type_ids_unbounded_sequence_uint64_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_uint64_t_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_uint64_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_uint64_field = 0x00000037;
            bool common_unbounded_sequence_uint64_field_ec {false};
            CommonStructMember common_unbounded_sequence_uint64_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_uint64_field, member_flags_unbounded_sequence_uint64_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_uint64_field, common_unbounded_sequence_uint64_field_ec))};
            if (!common_unbounded_sequence_uint64_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_uint64_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_uint64_field = "unbounded_sequence_uint64_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_uint64_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_uint64_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_uint64_field, member_ann_builtin_unbounded_sequence_uint64_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_uint64_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_uint64_field, detail_unbounded_sequence_uint64_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_uint64_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_float_field;
            ReturnCode_t return_code_unbounded_sequence_float_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_float_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_float_unbounded", type_ids_unbounded_sequence_float_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_float_field)
            {
                return_code_unbounded_sequence_float_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_float", type_ids_unbounded_sequence_float_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_float_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_float_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_float_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_float_field, element_identifier_anonymous_sequence_float_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_float_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_float_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_float_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_float_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_float_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_float_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_float_unbounded, element_flags_anonymous_sequence_float_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_float_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_float_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_float_unbounded", type_ids_unbounded_sequence_float_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_float_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_float_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_float_field = 0x00000038;
            bool common_unbounded_sequence_float_field_ec {false};
            CommonStructMember common_unbounded_sequence_float_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_float_field, member_flags_unbounded_sequence_float_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_float_field, common_unbounded_sequence_float_field_ec))};
            if (!common_unbounded_sequence_float_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_float_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_float_field = "unbounded_sequence_float_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_float_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_float_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_float_field, member_ann_builtin_unbounded_sequence_float_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_float_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_float_field, detail_unbounded_sequence_float_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_float_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_double_field;
            ReturnCode_t return_code_unbounded_sequence_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_double_unbounded", type_ids_unbounded_sequence_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_double_field)
            {
                return_code_unbounded_sequence_double_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_double", type_ids_unbounded_sequence_double_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_double_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_double_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_double_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_double_field, element_identifier_anonymous_sequence_double_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_double_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_double_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_double_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_double_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_double_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_double_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_double_unbounded, element_flags_anonymous_sequence_double_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_double_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_double_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_double_unbounded", type_ids_unbounded_sequence_double_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_double_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_double_field = 0x00000039;
            bool common_unbounded_sequence_double_field_ec {false};
            CommonStructMember common_unbounded_sequence_double_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_double_field, member_flags_unbounded_sequence_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_double_field, common_unbounded_sequence_double_field_ec))};
            if (!common_unbounded_sequence_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_double_field = "unbounded_sequence_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_double_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_double_field, member_ann_builtin_unbounded_sequence_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_double_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_double_field, detail_unbounded_sequence_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_double_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_long_double_field;
            ReturnCode_t return_code_unbounded_sequence_long_double_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_long_double_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_longdouble_unbounded", type_ids_unbounded_sequence_long_double_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_long_double_field)
            {
                return_code_unbounded_sequence_long_double_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_longdouble", type_ids_unbounded_sequence_long_double_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_long_double_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_longdouble_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_longdouble_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_long_double_field, element_identifier_anonymous_sequence_longdouble_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_longdouble_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_longdouble_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_long_double_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_longdouble_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_longdouble_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_longdouble_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_longdouble_unbounded, element_flags_anonymous_sequence_longdouble_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_longdouble_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_longdouble_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_longdouble_unbounded", type_ids_unbounded_sequence_long_double_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_longdouble_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_long_double_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_long_double_field = 0x0000003a;
            bool common_unbounded_sequence_long_double_field_ec {false};
            CommonStructMember common_unbounded_sequence_long_double_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_long_double_field, member_flags_unbounded_sequence_long_double_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_long_double_field, common_unbounded_sequence_long_double_field_ec))};
            if (!common_unbounded_sequence_long_double_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_long_double_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_long_double_field = "unbounded_sequence_long_double_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_long_double_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_long_double_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_long_double_field, member_ann_builtin_unbounded_sequence_long_double_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_long_double_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_long_double_field, detail_unbounded_sequence_long_double_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_long_double_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_bool_field;
            ReturnCode_t return_code_unbounded_sequence_bool_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_bool_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_bool_unbounded", type_ids_unbounded_sequence_bool_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_bool_field)
            {
                return_code_unbounded_sequence_bool_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "_bool", type_ids_unbounded_sequence_bool_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_bool_field)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "Sequence element TypeIdentifier unknown to TypeObjectRegistry.");
                    return;
                }
                bool element_identifier_anonymous_sequence_bool_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_bool_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_bool_field, element_identifier_anonymous_sequence_bool_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_bool_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_bool_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_bool_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_bool_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_bool_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_bool_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_bool_unbounded, element_flags_anonymous_sequence_bool_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_bool_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_bool_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_bool_unbounded", type_ids_unbounded_sequence_bool_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_bool_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_bool_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_bool_field = 0x0000003b;
            bool common_unbounded_sequence_bool_field_ec {false};
            CommonStructMember common_unbounded_sequence_bool_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_bool_field, member_flags_unbounded_sequence_bool_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_bool_field, common_unbounded_sequence_bool_field_ec))};
            if (!common_unbounded_sequence_bool_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_bool_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_bool_field = "unbounded_sequence_bool_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_bool_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_bool_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_bool_field, member_ann_builtin_unbounded_sequence_bool_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_bool_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_bool_field, detail_unbounded_sequence_bool_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_bool_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_string_field;
            ReturnCode_t return_code_unbounded_sequence_string_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_string_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_anonymous_string_unbounded_unbounded", type_ids_unbounded_sequence_string_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_string_field)
            {
                return_code_unbounded_sequence_string_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "anonymous_string_unbounded", type_ids_unbounded_sequence_string_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_string_field)
                {
                    {
                        SBound bound = 0;
                        StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                                TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                                "anonymous_string_unbounded", type_ids_unbounded_sequence_string_field))
                        {
                            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                        }
                    }
                }
                bool element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_string_field, element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_anonymous_string_unbounded_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_string_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_anonymous_string_unbounded_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_anonymous_string_unbounded_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_anonymous_string_unbounded_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_anonymous_string_unbounded_unbounded, element_flags_anonymous_sequence_anonymous_string_unbounded_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_anonymous_string_unbounded_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_anonymous_string_unbounded_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_anonymous_string_unbounded_unbounded", type_ids_unbounded_sequence_string_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_anonymous_string_unbounded_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_string_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_string_field = 0x0000003c;
            bool common_unbounded_sequence_string_field_ec {false};
            CommonStructMember common_unbounded_sequence_string_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_string_field, member_flags_unbounded_sequence_string_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_string_field, common_unbounded_sequence_string_field_ec))};
            if (!common_unbounded_sequence_string_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_string_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_string_field = "unbounded_sequence_string_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_string_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_string_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_string_field, member_ann_builtin_unbounded_sequence_string_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_string_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_string_field, detail_unbounded_sequence_string_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_string_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_enum_field;
            ReturnCode_t return_code_unbounded_sequence_enum_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_enum_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_Color_unbounded", type_ids_unbounded_sequence_enum_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_enum_field)
            {
                return_code_unbounded_sequence_enum_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Color", type_ids_unbounded_sequence_enum_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_enum_field)
                {
                ::register_Color_type_identifier(type_ids_unbounded_sequence_enum_field);
                }
                bool element_identifier_anonymous_sequence_Color_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_Color_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_enum_field, element_identifier_anonymous_sequence_Color_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_Color_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_Color_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_enum_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_Color_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_Color_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_Color_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_Color_unbounded, element_flags_anonymous_sequence_Color_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_Color_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_Color_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_Color_unbounded", type_ids_unbounded_sequence_enum_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_Color_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_enum_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_enum_field = 0x0000003d;
            bool common_unbounded_sequence_enum_field_ec {false};
            CommonStructMember common_unbounded_sequence_enum_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_enum_field, member_flags_unbounded_sequence_enum_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_enum_field, common_unbounded_sequence_enum_field_ec))};
            if (!common_unbounded_sequence_enum_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_enum_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_enum_field = "unbounded_sequence_enum_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_enum_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_enum_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_enum_field, member_ann_builtin_unbounded_sequence_enum_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_enum_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_enum_field, detail_unbounded_sequence_enum_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_enum_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_enum2_field;
            ReturnCode_t return_code_unbounded_sequence_enum2_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_enum2_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_Material_unbounded", type_ids_unbounded_sequence_enum2_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_enum2_field)
            {
                return_code_unbounded_sequence_enum2_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "Material", type_ids_unbounded_sequence_enum2_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_enum2_field)
                {
                ::register_Material_type_identifier(type_ids_unbounded_sequence_enum2_field);
                }
                bool element_identifier_anonymous_sequence_Material_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_Material_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_enum2_field, element_identifier_anonymous_sequence_Material_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_Material_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_Material_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_enum2_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_Material_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_Material_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_Material_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_Material_unbounded, element_flags_anonymous_sequence_Material_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_Material_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_Material_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_Material_unbounded", type_ids_unbounded_sequence_enum2_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_Material_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_enum2_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_enum2_field = 0x0000003e;
            bool common_unbounded_sequence_enum2_field_ec {false};
            CommonStructMember common_unbounded_sequence_enum2_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_enum2_field, member_flags_unbounded_sequence_enum2_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_enum2_field, common_unbounded_sequence_enum2_field_ec))};
            if (!common_unbounded_sequence_enum2_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_enum2_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_enum2_field = "unbounded_sequence_enum2_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_enum2_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_enum2_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_enum2_field, member_ann_builtin_unbounded_sequence_enum2_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_enum2_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_enum2_field, detail_unbounded_sequence_enum2_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_enum2_field);
        }
        {
            TypeIdentifierPair type_ids_unbounded_sequence_struct_field;
            ReturnCode_t return_code_unbounded_sequence_struct_field {eprosima::fastdds::dds::RETCODE_OK};
            return_code_unbounded_sequence_struct_field =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_sequence_StructType_unbounded", type_ids_unbounded_sequence_struct_field);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_struct_field)
            {
                return_code_unbounded_sequence_struct_field =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "StructType", type_ids_unbounded_sequence_struct_field);

                if (eprosima::fastdds::dds::RETCODE_OK != return_code_unbounded_sequence_struct_field)
                {
                ::register_StructType_type_identifier(type_ids_unbounded_sequence_struct_field);
                }
                bool element_identifier_anonymous_sequence_StructType_unbounded_ec {false};
                TypeIdentifier* element_identifier_anonymous_sequence_StructType_unbounded {new TypeIdentifier(TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_struct_field, element_identifier_anonymous_sequence_StructType_unbounded_ec))};
                if (!element_identifier_anonymous_sequence_StructType_unbounded_ec)
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Sequence element TypeIdentifier inconsistent.");
                    return;
                }
                EquivalenceKind equiv_kind_anonymous_sequence_StructType_unbounded = EK_COMPLETE;
                if (TK_NONE == type_ids_unbounded_sequence_struct_field.type_identifier2()._d())
                {
                    equiv_kind_anonymous_sequence_StructType_unbounded = EK_BOTH;
                }
                CollectionElementFlag element_flags_anonymous_sequence_StructType_unbounded = 0;
                PlainCollectionHeader header_anonymous_sequence_StructType_unbounded = TypeObjectUtils::build_plain_collection_header(equiv_kind_anonymous_sequence_StructType_unbounded, element_flags_anonymous_sequence_StructType_unbounded);
                {
                    SBound bound = 0;
                    PlainSequenceSElemDefn seq_sdefn = TypeObjectUtils::build_plain_sequence_s_elem_defn(header_anonymous_sequence_StructType_unbounded, bound,
                                eprosima::fastcdr::external<TypeIdentifier>(element_identifier_anonymous_sequence_StructType_unbounded));
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_sequence_type_identifier(seq_sdefn, "anonymous_sequence_StructType_unbounded", type_ids_unbounded_sequence_struct_field))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_sequence_StructType_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_unbounded_sequence_struct_field = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_unbounded_sequence_struct_field = 0x0000003f;
            bool common_unbounded_sequence_struct_field_ec {false};
            CommonStructMember common_unbounded_sequence_struct_field {TypeObjectUtils::build_common_struct_member(member_id_unbounded_sequence_struct_field, member_flags_unbounded_sequence_struct_field, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_unbounded_sequence_struct_field, common_unbounded_sequence_struct_field_ec))};
            if (!common_unbounded_sequence_struct_field_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure unbounded_sequence_struct_field member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_unbounded_sequence_struct_field = "unbounded_sequence_struct_field";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_unbounded_sequence_struct_field;
            ann_custom_ContentFilterTestType.reset();
            CompleteMemberDetail detail_unbounded_sequence_struct_field = TypeObjectUtils::build_complete_member_detail(name_unbounded_sequence_struct_field, member_ann_builtin_unbounded_sequence_struct_field, ann_custom_ContentFilterTestType);
            CompleteStructMember member_unbounded_sequence_struct_field = TypeObjectUtils::build_complete_struct_member(common_unbounded_sequence_struct_field, detail_unbounded_sequence_struct_field);
            TypeObjectUtils::add_complete_struct_member(member_seq_ContentFilterTestType, member_unbounded_sequence_struct_field);
        }
        CompleteStructType struct_type_ContentFilterTestType = TypeObjectUtils::build_complete_struct_type(struct_flags_ContentFilterTestType, header_ContentFilterTestType, member_seq_ContentFilterTestType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ContentFilterTestType, type_name_ContentFilterTestType.to_string(), type_ids_ContentFilterTestType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ContentFilterTestType already registered in TypeObjectRegistry for a different type.");
        }
    }
}

