/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *	Mircea Gherzan <mircea.gherzan@intel.com>
 */

#ifndef GEN_DEBUGGER_H
#define GEN_DEBUGGER_H

#include "hw_info.h"

#ifdef __cplusplus
extern "C" {
#endif

int DbgNotifyNewDevice(void *cmDevHandle);

int DbgNotifyDeviceDestruction(void *cmDevHandle);

int DbgNotifyKernelBinary(void *devHandle, void *programHandle,
			     const char *kernelName, void *genBinary,
			     unsigned genBinarySize, void *genDebugInfo,
			     unsigned genDebugInfoSize,
			     const char *debugInfoFile);

int DbgGetSysRoutineBinary(PLATFORM p, unsigned bti,
			      const unsigned char **pSip,
			      unsigned *sipSize, unsigned *resSize);

#ifdef __cplusplus
}
#endif

#endif // GEN_DEBUGGER_H
