/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.DockingDesktop;
import com.vldocking.swing.docking.DockingPreferences;
import com.vldocking.swing.docking.DragControler;
import com.vldocking.swing.docking.HeavyWeightDragControler;
import com.vldocking.swing.docking.LightWeightDragControler;

public class DragControlerFactory {
    private static DragControlerFactory instance;

    public DragControler createDragControler(DockingDesktop desktop) {
        if (DockingPreferences.isLightWeightUsageEnabled()) {
            return new LightWeightDragControler(desktop);
        }
        return new HeavyWeightDragControler(desktop);
    }

    public static DragControlerFactory getInstance() {
        if (instance == null) {
            instance = new DragControlerFactory();
        }
        return instance;
    }

    public static void setInstance(DragControlerFactory instance) {
        DragControlerFactory.instance = instance;
    }
}

