/* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in this distribution.

iem_dp written by IOhannes m zmoelnig, Thomas Musil, Copyright (c) IEM KUG Graz Austria 1999 - 2013 */
/* double precision library */

#ifndef __IEM_DP_H__
#define __IEM_DP_H__

/*  #ifdef __i386__  */

/* more stringent test: anything not between 1e-19 and 1e19 in absolute val */

/*
#define PD_BIGORSMALL(f) ((((*(unsigned int*)&(f))&0x60000000)==0) || \
    (((*(unsigned int*)&(f))&0x60000000)==0x60000000))
#else
#define PD_BIGORSMALL(f) 0
#endif

#endif
*/

t_float iem_dp_cast_to_float(double d);
double iem_dp_cast_to_double(t_float f);
t_float iem_dp_calc_residual(double d, t_float f);

double iem_dp_calc_sum(t_float f, t_float r);

extern int ugen_getsortno(void);

#endif

/*
#ifdef Z_USE_WORD_ARRAYS

#define zarray_t t_word
#define zarray_getarray garray_getfloatwords
#define zarray_getfloat(pointer, index) (pointer[index].w_float)
#define zarray_setfloat(pointer, index, value) (pointer[index].w_float = value)

#else

#define zarray_t t_float
#define zarray_getarray garray_getfloatarray
#define zarray_getfloat(pointer, index) (pointer[index])
#define zarray_setfloat(pointer, index, value) (pointer[index] = value)

#endif*/
