#include "env.h"
#include "exit.h"
#include "scan.h"

extern void doit(void);

main(int argc,char **argv)
{
  char *x;
  unsigned long id;

  x = argv[1];
  if (x) {
    if (chdir(x) == -1) _exit(20);
    if (chroot(".") == -1) _exit(30);
  }

  x = env_get("GID");
  if (x) {
    scan_ulong(x,&id);
    if (prot_gid((int) id) == -1) _exit(30);
  }

  x = env_get("UID");
  if (x) {
    scan_ulong(x,&id);
    if (prot_uid((int) id) == -1) _exit(30);
  }

  doit();
}
