/*
 *----------------------------------------------------------------------
 *
 * PROGRAM  : writeops
 *
 * FILE     : writeops.c
 *
 * CONTENTS : Prints out contents of Clear Text and Character Encoding
 *	      tables. Compile with :-
 *		cc -I../include writeops.c tables.c
 *	      type 'a.out' to run, tables written to standard output.
 *
 * DATE     : 24th April 1988
 *
 *----------------------------------------------------------------------
 */
#include <stdio.h>
#include "defns.h"
#include "tables.h"

extern char *CtOpTable[],
       *CtCgmTable[],
       *CeOpTable[],
       *CeCgmTable[];

/*
 *----------------------------------------------------------------------
 * main:
 *   OpTable printed first, format :-
 *	Annex E item number, Clear Text item name, char encoding opcode
 *   CgmTable format :-
 *	table entry number, Clear Text item name, char encoding opcode
 *----------------------------------------------------------------------
 */
main()
{
	int     i;

	printf("\n\n\t\tOpTable Elements :\n\n");
	for (i = 0; i < 96; i++)
	{
		if (CtOpTable[i][0] != '\0')
		{
			printf("\t\t%5d%20s : ", i, CtOpTable[i]);
			write_encoded(CeOpTable[i]);
			putchar('\n');
		}
	}
	printf("\n\n\t\tCGM Table Elements :\n\n");
	for (i = 0; i < 58; i++)
	{
		printf("\t\t%5d%20s : ", i, CtCgmTable[i]);
		write_encoded(CeCgmTable[i]);
		putchar('\n');
	}
}


/*
 *---------------------------------------------------------------
 * write_encoded:
 *	Writes its parameter value in the x/y format used in the
 * character encoding documents :-
 *	x = the integer part of  str / 16
 *	y = str modulo 16
 *---------------------------------------------------------------
write_encoded (str)
    char *str ;
{
    while (*str != '\0') {
	printf ("%d/%d ", ((int) *str) /16, ((int) *str) % 16) ;
	str++ ;
    }
}

