/*  big5.h - tables for Unicode to Big5, generated by "backend/tools/gen_eci_mb_h.php"
    from "https://unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/OTHER/BIG5.TXT" */
/*
    libzint - the open source barcode library
    Copyright (C) 2021-2022 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef Z_BIG5_H
#define Z_BIG5_H

/* Unicode usage bit-flags for URO (U+4E00-U+9FFF) block */
static const unsigned short big5_uro_u[1307] = {
    0xFF8B, 0xC373, 0x6840, 0x1B0F, 0xE9AC, 0xF34C, 0x0200, 0xC008,
    0x795C, 0xCA3E, 0x7976, 0x0648, 0x2FDF, 0xF7F0, 0x033A, 0xA8FF,
    0xEF37, 0x233F, 0xB004, 0xFD59, 0xF3CA, 0xFFFF, 0xDE9F, 0xFFF9,
    0xABFF, 0x7DF7, 0xC000, 0x8EEC, 0xEEBF, 0xFFDB, 0xD003, 0x45FA,
    0xFAE1, 0xDFFE, 0xBFEF, 0x10AB, 0xFFEB, 0xFCAA, 0xEF3F, 0x24FD,
    0x78AD, 0x7F76, 0xF00C, 0xEDFF, 0xCFF6, 0x2CFA, 0xF7F9, 0xEB6B,
    0x1FFD, 0x95BF, 0x6677, 0xBFBF, 0x3BFB, 0xFEB4, 0x7BAE, 0x11E2,
    0xA681, 0x41BE, 0x1435, 0x72C3, 0x7D70, 0x7191, 0x0003, 0x276B,
    0x57CB, 0x70CF, 0x4732, 0x0DEF, 0x7EDA, 0xFC74, 0xFE06, 0xBDB4,
    0x3F9F, 0x8BCA, 0x7E49, 0x5800, 0x228F, 0xEBEC, 0x8A5C, 0xDDBB,
    0xEF60, 0xB6E7, 0xA40F, 0xF293, 0x37BB, 0x549E, 0xD04B, 0x9BAF,
    0xC414, 0xF7D4, 0x30B0, 0x0A14, 0x2F08, 0x88D0, 0xFF7E, 0x192F,
    0xFFDA, 0xFB07, 0x7FF1, 0x7BEB, 0xC5EF, 0x0010, 0x99FF, 0xFDFF,
    0x79D7, 0x0567, 0xFFE7, 0xFDCB, 0xC3FF, 0x4040, 0x6FF7, 0xBD8E,
    0xDFFA, 0x0497, 0xF4C0, 0x5BFF, 0xED7B, 0xD0E7, 0x047E, 0xF8E0,
    0xFF9F, 0xB73E, 0x7DFE, 0x882E, 0xFFFD, 0xBE7F, 0x83FE, 0xF6C4,
    0xF357, 0xB8FD, 0xD680, 0xEF7D, 0x5767, 0x4788, 0xFF7D, 0xC3DF,
    0xF0FF, 0x37A9, 0x7DE0, 0x70FC, 0x3F6F, 0xEC9A, 0x4CB3, 0x8681,
    0x3F9E, 0xDD5C, 0xF70D, 0x4819, 0xFEA3, 0x0007, 0xAF56, 0x38FF,
    0x980D, 0xEFB8, 0x403D, 0xB760, 0xD8CE, 0x9035, 0x72BF, 0x3FFF,
    0x7FF7, 0x7A11, 0xF7BB, 0xABFF, 0xFF00, 0x6FBE, 0xA93C, 0xFE72,
    0xCFEF, 0xF11B, 0xDB6B, 0xF40A, 0xC3E6, 0xEF7E, 0x9B9C, 0xF610,
    0xF048, 0x16F4, 0xFEB5, 0x5182, 0xC7B1, 0x15BB, 0x6E87, 0xFBDF,
    0xE43F, 0x63CD, 0xC1FF, 0x7E7E, 0xFDEB, 0x7D5F, 0x777B, 0xFCFE,
    0x960B, 0xDBEA, 0x6229, 0x53E8, 0x37DF, 0xFDEF, 0x36F5, 0xBD81,
    0xDC18, 0xFCBD, 0xD2E4, 0xFFFF, 0x3FD7, 0xFFE0, 0x7F6F, 0xABF8,
    0x9BAE, 0x6ED9, 0xF5FB, 0xF115, 0x79A9, 0xBDFB, 0x5A3C, 0xADAF,
    0xDBBA, 0x1FAC, 0x71FC, 0x8379, 0x7CF7, 0xC35F, 0xDFFF, 0x0567,
    0xFF9A, 0x8467, 0x1534, 0xDF8B, 0xF9F3, 0x3373, 0xF7BD, 0x5E1A,
    0xBF40, 0xA03F, 0xFFFF, 0x01EB, 0xDFC0, 0xCFDD, 0x7500, 0xABD3,
    0xF8C3, 0xEED6, 0x43FD, 0xB7FF, 0x5EAF, 0x4227, 0x9BAC, 0xF686,
    0x27D7, 0xF6BC, 0xF787, 0x35B7, 0xAACD, 0xE176, 0x49E7, 0xE29F,
    0x545C, 0xAFF2, 0x2B3F, 0x61D8, 0xFC3B, 0xBBB8, 0xFFCF, 0x7B7D,
    0xBF95, 0x1CE0, 0x7DFD, 0x43FF, 0x5FF6, 0xFFFE, 0xD3EF, 0xC4CE,
    0x8DB6, 0xADBC, 0x63DC, 0x11EB, 0xDF59, 0x23D0, 0xBEB4, 0xF3DB,
    0x1FE7, 0xDBC7, 0xFF63, 0xFAE4, 0xB22B, 0x63F7, 0xED3B, 0xADBA,
    0xFE01, 0x7EFF, 0xFFF7, 0x02BC, 0x32FF, 0xEF39, 0xFFFC, 0x8005,
    0x77FB, 0xBCF5, 0x010D, 0xFFF7, 0xFFFB, 0xBF3A, 0x0057, 0xDFFF,
    0xEF7B, 0xBD7D, 0xDB88, 0xC8D4, 0xFFF3, 0xED7C, 0x5DEE, 0x56FF,
    0x7E0D, 0xAC5F, 0xFF96, 0xD57F, 0x3FEE, 0xC140, 0x6FF9, 0xFFE7,
    0x779B, 0x8E77, 0x6EBF, 0xE45D, 0x6FCF, 0x5F1F, 0xE07F, 0xFEDF,
    0xD7DB, 0x01FE, 0xFF00, 0xFB7B, 0xFFD4, 0x1FDF, 0xF800, 0xFFFF,
    0xFB8F, 0x007B, 0xBF00, 0x7F5C, 0xFFFF, 0x07F3, 0xEBA0, 0x3DE7,
    0xF7BF, 0xFBD7, 0xFFBF, 0x6003, 0xFFFD, 0xBFED, 0xEFBB, 0x027F,
    0xFE40, 0xDDFD, 0xFDFF, 0xE2F9, 0x680B, 0xFB1F, 0xFBE3, 0xAFFD,
    0x9FA4, 0xF7ED, 0x7A7D, 0xF80F, 0xEEBE, 0x0FD5, 0xBB5D, 0xFD9F,
    0xF2DB, 0x3BF9, 0xFE7F, 0xEBCC, 0x876A, 0x73FA, 0x95FC, 0x9FFC,
    0x109F, 0xFAF7, 0xDDB7, 0xBBCD, 0xF87E, 0xECCD, 0xF366, 0x3C3F,
    0xFFFD, 0xB03F, 0xE9F7, 0x067E, 0x96AE, 0xFE06, 0xD576, 0x5FD7,
    0x3FD1, 0xA3F3, 0xCF07, 0x6FB7, 0x9FD1, 0x7F44, 0x7B59, 0xD3DD,
    0xAF3B, 0xA9BD, 0x7DCF, 0xFF3A, 0xFBE0, 0xF6EB, 0xB401, 0xFFFF,
    0x7AFA, 0xB7BF, 0xC000, 0x0FFD, 0xFF7F, 0xFF1F, 0xFEFC, 0x95FF,
    0x0000, 0xB5DC, 0xEF63, 0x3F3E, 0xFB7F, 0x001B, 0xE800, 0xFBF6,
    0x9EEF, 0xB8DF, 0xFF9F, 0x003F, 0x7BD0, 0xF5FF, 0xDFDB, 0x3FFF,
    0xFDF0, 0x00BF, 0x8420, 0xBBBD, 0xDF37, 0xFFDE, 0xFF6D, 0x0FF3,
    0x604C, 0x5EFB, 0xFFFB, 0xFAFB, 0xFE5E, 0x0219, 0x79F4, 0xF9DE,
    0xA7F7, 0xEBFA, 0x01EB, 0xFF34, 0xEBD3, 0xEF73, 0xAFD7, 0xC040,
    0x72BB, 0xDCFF, 0xF17F, 0x2FD8, 0xB8EC, 0xFE0B, 0xDDA3, 0x1F0B,
    0x8F1D, 0x47CF, 0xB12B, 0xFFDE, 0x7FEE, 0xDA73, 0x24FF, 0xCBC4,
    0xF75D, 0xCBF2, 0xECFD, 0xB4ED, 0xBFF9, 0x4DDD, 0x99DD, 0xFB8D,
    0xBB7F, 0xAF7B, 0xDDFB, 0xC959, 0xFC4F, 0xFAB5, 0xAFE3, 0x6D5F,
    0xFFFF, 0x3F7D, 0x7800, 0xFFDB, 0xB6FF, 0x7EFF, 0xFBAF, 0x022F,
    0xFF9B, 0xEFC7, 0xFFA5, 0xFFFF, 0x0007, 0xC700, 0xF7FF, 0xFFF1,
    0x7FFD, 0x01BF, 0xDC00, 0xFDBC, 0xBFF5, 0xFFFF, 0xFF7F, 0x3EFF,
    0x0029, 0xBE00, 0xF9FF, 0xFF7F, 0x6EFB, 0xFD7E, 0xCBFF, 0x039E,
    0xE300, 0xFBDD, 0xCCFF, 0xF6DF, 0xFFFF, 0x117F, 0xF800, 0xFBF6,
    0xE7EF, 0xD73C, 0xFEEF, 0xDFEF, 0xC00B, 0xEDBF, 0xFEDF, 0xFDCD,
    0x7BF5, 0x40FD, 0xFFFF, 0xB75F, 0xFFDF, 0xF930, 0xFBDF, 0xDC97,
    0xFEF3, 0xBFF2, 0x8FDF, 0xDFBF, 0x177F, 0xEDE6, 0x0F7F, 0x3553,
    0x447C, 0x877E, 0xFA12, 0x45BB, 0xEDE0, 0x779E, 0x8017, 0xBFD9,
    0x7E55, 0xDE89, 0xC16F, 0x0447, 0x7ADE, 0xF75D, 0x57FF, 0x2905,
    0x86F7, 0xFE95, 0x97B3, 0xF32F, 0xCFFF, 0x9F75, 0x71F7, 0xFB17,
    0x34EE, 0xEE19, 0x37CC, 0xEF61, 0x9FD6, 0xEF4C, 0xD68F, 0xFBDD,
    0x7B73, 0x6DEF, 0xD7FE, 0xA431, 0x5E7F, 0x97D7, 0x0F5B, 0xFFD8,
    0x9D83, 0x7BCE, 0x22EC, 0xDCFF, 0x763D, 0xEF87, 0xDFE7, 0xFDED,
    0x4FFF, 0xA0FC, 0x3B77, 0xDBFC, 0x3DED, 0x7FDC, 0x6FA9, 0xF570,
    0x3FFB, 0x2C40, 0xFF7F, 0x847F, 0xEC57, 0xDEB7, 0xE69C, 0xF22F,
    0x0FEB, 0xD5B5, 0xAFEB, 0xEDE7, 0x8C2F, 0xFFF0, 0x537F, 0xE8F0,
    0xB99D, 0xB5FF, 0xFF66, 0xE78F, 0xD981, 0xBE10, 0x9C7C, 0xE3C1,
    0x9CD1, 0x2733, 0x0CBC, 0xFF6D, 0xFCB7, 0xEFB7, 0xA0DF, 0xFFFF,
    0xBF0B, 0xFE7B, 0xA3FF, 0x353F, 0x13CC, 0x97CD, 0x7637, 0xFB27,
    0xCFD6, 0x7E6C, 0xEC50, 0xED31, 0x677C, 0xFC1C, 0xF6FA, 0x5FBF,
    0x0FBA, 0xAE2F, 0xA3AD, 0x7FFE, 0xFCF0, 0xDE74, 0xFFEF, 0xF200,
    0xFBBF, 0xFEA2, 0x3DAF, 0xBCFF, 0xF694, 0x5FB9, 0xF3AD, 0x3F8F,
    0xF26C, 0xA01F, 0xFFEF, 0x01BF, 0x7728, 0x7005, 0xFF35, 0xDA03,
    0xD2F9, 0xC7FA, 0x3FBF, 0x5C1D, 0xFF3A, 0xEC33, 0xB7AF, 0xFE9C,
    0x5236, 0x7A9F, 0xBFFA, 0xE722, 0x9FF7, 0xFCFF, 0x2FBB, 0xB61D,
    0xED06, 0x1DFD, 0x7DD7, 0xEFDF, 0xEB23, 0xF166, 0x7ED9, 0x0DC0,
    0x3D3D, 0xDFBF, 0xC945, 0xBA83, 0x7DD1, 0x9DD0, 0x7B87, 0xCF73,
    0x9FF3, 0xC3F5, 0xDF0D, 0xC5FE, 0x0CB3, 0x8302, 0xE879, 0xAEC0,
    0xC773, 0x6F0F, 0xFD7D, 0x093F, 0xFFF1, 0x0157, 0x62FB, 0x01FF,
    0xFDB4, 0x3BF3, 0xB013, 0x43B2, 0x5ED3, 0xFF30, 0x0FFF, 0xEB9F,
    0xFEEF, 0xF203, 0x3FEF, 0xFB89, 0x37A9, 0x9E99, 0xDEF9, 0xA72C,
    0x3733, 0xC1F6, 0x812E, 0xFE3E, 0x5D20, 0xF2F7, 0xD585, 0x69D7,
    0xFFFF, 0xFFFF, 0xDB07, 0xFF6F, 0xC4FF, 0xD97F, 0xEFCE, 0xBE0F,
    0xF17B, 0xF05E, 0xF6CF, 0xFFB7, 0x5EF7, 0xEF84, 0xD7CB, 0x0EDF,
    0xFF08, 0xFCFF, 0xEE3F, 0xFFFF, 0x13FF, 0xD7FF, 0xAF0F, 0x7FFD,
    0xBDC7, 0x1FFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xE740, 0xBD38, 0xF933, 0x7FEB, 0xFEED,
    0x7FE8, 0x7C76, 0xB3F7, 0xFFEF, 0xFEAF, 0xD8B7, 0xFF6F, 0xFBBF,
    0xF8FB, 0xDBF7, 0x1752, 0xE2F9, 0x85C8, 0x7547, 0x9090, 0xE3EF,
    0x9EF4, 0x3F6D, 0xEE2E, 0x0536, 0xF7BC, 0x7FF3, 0xA07B, 0x7F3F,
    0x0567, 0xEB60, 0xBABE, 0x6601, 0xFCD8, 0x583F, 0xCAF7, 0x87DF,
    0xBFCD, 0xFFA0, 0x5BCD, 0xFEBF, 0xB6FD, 0xEFA7, 0x77EF, 0xDF9C,
    0x3FB7, 0xF877, 0x9D27, 0xB7FC, 0xCAB5, 0xDFEF, 0xFB5A, 0xF1B6,
    0xEC39, 0xEF1F, 0xFBBF, 0x7FFB, 0x000D, 0xDAFE, 0xBDFB, 0x4E7F,
    0x33FF, 0x5AC0, 0xBFF5, 0x9FFE, 0xFFBF, 0x005F, 0x0000, 0xFDF8,
    0xFFCA, 0x6FFD, 0xCFFD, 0xA001, 0xDFFF, 0xFBF2, 0xDFBF, 0xFF7F,
    0xFEDA, 0x080F, 0xBA08, 0xBFFF, 0x7AFD, 0xEED7, 0xFBEB, 0x67F9,
    0xE044, 0xFF93, 0xDF97, 0x9F57, 0xFEF7, 0x08DF, 0xDF80, 0xFEDF,
    0xFFC5, 0xF7FE, 0xFFFB, 0x6803, 0x67FB, 0x6BFA, 0x7FFF, 0x5FE2,
    0xFFFF, 0xFF73, 0x87DF, 0xE7FB, 0xEBFD, 0xF7A7, 0xBF7E, 0xEFC7,
    0x1EF3, 0xDF82, 0x76FF, 0xDF7E, 0x79C9, 0xDA7D, 0xEFBE, 0x1E9B,
    0x7CE0, 0x77FB, 0x87BE, 0xFFFB, 0x1BFF, 0xFFDB, 0x3F5C, 0x4FE0,
    0x7FFF, 0x5F0E, 0x77FF, 0xDDBF, 0xF04F, 0xFFFF, 0xFFFF, 0x0FF8,
    0xA3BE, 0xFDDF, 0xFC1C, 0xFFFD, 0x1F7D, 0xFB9E, 0xBDFF, 0xDEDC,
    0x3F6F, 0xBAFB, 0xDF7F, 0xFBEF, 0x7D1B, 0x2EEC, 0xAF8E, 0xF2F7,
    0x7B0F, 0xCFEE, 0x1D96, 0x77C6, 0x7E07, 0xFFF5, 0xD982, 0x7FDF,
    0x5EE6, 0xC7FF, 0xFEEE, 0x79EF, 0x9A56, 0xFFCF, 0xFE5F, 0xDE5E,
    0x896E, 0xF9E8, 0xF45E, 0xE6C4, 0x0001, 0xBE7C, 0x3B7F, 0xDDDF,
    0xD59D, 0xE9EF, 0x34AC, 0xDE53, 0xF573, 0x4BF7, 0x7B4F, 0x9EFF,
    0xB8FE, 0x476E, 0x0DFB, 0xFF45, 0xABFD, 0xFBFE, 0xE9D7, 0xDDFF,
    0xEDF7, 0x7FFF, 0xDDFD, 0x7EEB, 0xCFE7, 0xB7FF, 0xBDE9, 0xEF91,
    0x5D75, 0xD77C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0xFA80, 0xFFEE, 0xB4F1, 0xBF76, 0x2FEF,
    0xB677, 0x77BF, 0x9FBF, 0xFFFD, 0x95BF, 0xF6AE, 0x75FF, 0x7F3B,
    0xA7F5, 0x0AF9, 0x0000, 0x0000, 0x0000, 0x0000, 0xFBD0, 0x2BDD,
    0xF633, 0x9A7F, 0xFDAB, 0xD6FC, 0xF9E6, 0xBFEB, 0xDFDF, 0xF41F,
    0xA6FD, 0xFFFF, 0x4AFF, 0xF37B, 0x7FB7, 0xFEF9, 0xB6FF, 0x1D5C,
    0x7FF6, 0xE5FF, 0x1F7B, 0x2404, 0xBE05, 0xF99E, 0xDBE3, 0xDFF2,
    0x6FEF, 0xFDFF, 0xD679, 0xCBFC, 0xEBFD, 0xEFFF, 0x001F, 0x0000,
    0x0000, 0x9800, 0xE148, 0x8017, 0x6A74, 0x00FE, 0x6D7F, 0xFDF1,
    0xB87F, 0xFEF3, 0xE01F, 0xF176, 0xEE96, 0x7B3F, 0xEB8D, 0xFFFD,
    0xADFF, 0xCBB3, 0x84EF, 0xE17F, 0x4DAA, 0xBFF0, 0xBF3F, 0xFE3F,
    0xEBFF, 0xFFD7, 0xFFDF, 0xCF7F, 0xFFFB, 0x85ED, 0xD73F, 0x07BC,
    0xAEFF, 0xFE0F, 0xFDAF, 0x76BF, 0xFAEF, 0x37BB, 0x7FDC, 0xA3BA,
    0xB6FF, 0x56F7, 0x60F8, 0xE7DF, 0xFF61, 0x4CDF, 0xB0FB, 0xFF45,
    0x7DED, 0x3FFA, 0x1FFF, 0x18FC, 0xFFFF, 0xE3AF, 0xC7D3, 0xDF83,
    0xFB57, 0xEF7D, 0xEFFF, 0x1378, 0xFEC0, 0x5FF7, 0x34BB, 0x5EE3,
    0xF70D, 0xEFF6, 0xD7FE, 0x00BF, 0xF59D, 0xF7F7, 0x51DE, 0xFFE0,
    0xFEC9, 0x037F, 0x5F01, 0xBFEF, 0x9FF1, 0x60A7, 0xEF1D, 0xF1FF,
    0x000F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3C80,
    0xFB4D, 0xD91F, 0x7B3A, 0xFEE3, 0x3FE9, 0xDC7F, 0x003F, 0x0000,
    0x0000, 0x5000, 0xF51F, 0xBE07, 0xFC1D, 0xF91B, 0xBC1E, 0x71FF,
    0x6FF9, 0x5BBE, 0x5796, 0x9B1B, 0x7FFF, 0xFFFC, 0x872E, 0xAFE7,
    0xEBF5, 0xF34F, 0xDFFD, 0xE725, 0x0BDC, 0x5D44, 0x5747, 0xFDDD,
    0xED3F, 0x7790, 0x7D7F, 0x8AC8, 0xFAFA, 0xF3F9, 0x202A, 0xEF4B,
    0xF5FF, 0x79CF, 0xABD3, 0x0BA5, 0xF77A, 0xFB8F, 0x8EBD, 0x001F,
    0x0000, 0x0000, 0xF300, 0xFD4E, 0x1A57, 0x8800, 0xAEAC, 0x7654,
    0x17AD, 0xCDFF, 0xFFB2, 0xF42F, 0x5BAA, 0xDBFF, 0x0002, 0x0000,
    0x0000, 0x73C0, 0xF9EA, 0x2E3F, 0xFA8E, 0xBBFF, 0x76BC, 0xFFD3,
    0xEEFE, 0x7E72, 0x7EBD, 0xE7F7, 0xF77F, 0xCEFD, 0x0FF5, 0x0000,
    0x0000, 0x0000, 0xA900, 0xDB9B, 0xA4C7, 0x917F, 0xF8CA, 0x7ECE,
    0x7D7A, 0xC7E7, 0xCBBD, 0xDCAE, 0xFD7E, 0x8F76, 0x91D3, 0x7CF3,
    0x01E5, 0x4C2F, 0xED77, 0xA360, 0x07DB, 0x5EF8, 0x1DF7, 0x2181,
    0x6BE0, 0x309C, 0x3B3A, 0xFADE, 0x7F53, 0xC3F5, 0x61CD, 0x07BA,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x26E0, 0xBEFE,
    0x03F9, 0xEBB5, 0xE36D, 0xE9CB, 0x9C2F, 0xBFDE, 0x9F83, 0xABBF,
    0x1FF7, 0xFFD5, 0xB7DF, 0xDFFE, 0xFDAE, 0xFFEF, 0xFB7E, 0xEFFD,
    0xAAFF, 0x6EBF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xB620,
    0x7FCD, 0xBE9E, 0x62B3, 0x58F1, 0xF10D, 0xFD7B, 0xE9F1, 0xBEFD,
    0xC6C3, 0x5F6D, 0xFF3D, 0x69FF, 0xFFCF, 0xFBF4, 0xDCFB, 0x4FF7,
    0x2000, 0x1137, 0x0015,
};

/* Multibyte indexes for URO (U+4E00-U+9FFF) block */
static const unsigned short big5_uro_mb_ind[1307] = {
      502,   514,   523,   527,   535,   544,   553,   554,
      557,   566,   575,   585,   589,   601,   612,   618,
      629,   641,   650,   654,   665,   675,   691,   703,
      717,   730,   743,   745,   754,   767,   781,   786,
      795,   805,   819,   833,   839,   853,   863,   876,
      885,   894,   906,   912,   926,   938,   947,   960,
      971,   983,   994,  1004,  1018,  1030,  1041,  1052,
     1058,  1064,  1072,  1078,  1086,  1095,  1102,  1104,
     1113,  1123,  1132,  1139,  1149,  1160,  1170,  1179,
     1189,  1201,  1209,  1218,  1221,  1228,  1239,  1246,
     1258,  1267,  1278,  1285,  1294,  1305,  1313,  1320,
     1331,  1336,  1347,  1352,  1356,  1362,  1367,  1381,
     1389,  1402,  1412,  1424,  1436,  1447,  1448,  1460,
     1475,  1486,  1493,  1507,  1519,  1531,  1533,  1546,
     1556,  1569,  1575,  1582,  1595,  1607,  1616,  1623,
     1631,  1645,  1656,  1669,  1675,  1690,  1703,  1713,
     1722,  1733,  1744,  1750,  1763,  1773,  1779,  1793,
     1804,  1816,  1825,  1834,  1843,  1855,  1864,  1872,
     1877,  1888,  1898,  1908,  1913,  1924,  1927,  1937,
     1948,  1954,  1965,  1971,  1979,  1988,  1994,  2005,
     2019,  2033,  2040,  2053,  2066,  2074,  2086,  2094,
     2105,  2118,  2127,  2138,  2145,  2154,  2167,  2176,
     2183,  2189,  2197,  2209,  2214,  2223,  2232,  2241,
     2255,  2265,  2274,  2285,  2297,  2310,  2322,  2334,
     2347,  2354,  2365,  2371,  2379,  2391,  2405,  2415,
     2423,  2430,  2442,  2450,  2466,  2478,  2489,  2502,
     2512,  2522,  2532,  2545,  2553,  2562,  2575,  2583,
     2594,  2605,  2614,  2624,  2632,  2644,  2654,  2669,
     2676,  2688,  2695,  2701,  2712,  2724,  2733,  2746,
     2754,  2762,  2770,  2786,  2793,  2802,  2814,  2819,
     2829,  2838,  2849,  2859,  2873,  2884,  2890,  2899,
     2908,  2918,  2929,  2940,  2950,  2959,  2968,  2977,
     2987,  2994,  3005,  3015,  3022,  3033,  3043,  3057,
     3069,  3080,  3086,  3099,  3110,  3122,  3137,  3149,
     3157,  3166,  3176,  3185,  3193,  3204,  3210,  3220,
     3232,  3243,  3254,  3266,  3276,  3284,  3295,  3306,
     3316,  3324,  3338,  3353,  3359,  3370,  3381,  3395,
     3398,  3411,  3422,  3426,  3441,  3456,  3467,  3472,
     3487,  3500,  3512,  3520,  3527,  3541,  3552,  3563,
     3575,  3584,  3594,  3606,  3618,  3630,  3634,  3646,
     3660,  3671,  3681,  3693,  3702,  3714,  3725,  3735,
     3749,  3761,  3769,  3777,  3790,  3802,  3814,  3819,
     3835,  3847,  3853,  3860,  3871,  3887,  3896,  3904,
     3915,  3929,  3942,  3957,  3961,  3976,  3989,  4002,
     4010,  4018,  4031,  4046,  4056,  4062,  4074,  4086,
     4099,  4108,  4121,  4132,  4141,  4153,  4162,  4173,
     4186,  4197,  4208,  4222,  4232,  4240,  4251,  4261,
     4273,  4280,  4293,  4305,  4316,  4327,  4337,  4347,
     4357,  4372,  4381,  4393,  4401,  4410,  4419,  4429,
     4441,  4451,  4461,  4470,  4482,  4492,  4501,  4511,
     4522,  4533,  4543,  4555,  4567,  4577,  4589,  4594,
     4610,  4621,  4634,  4636,  4647,  4662,  4675,  4688,
     4700,  4700,  4710,  4721,  4732,  4746,  4750,  4754,
     4767,  4779,  4790,  4804,  4810,  4819,  4833,  4846,
     4860,  4871,  4878,  4881,  4893,  4905,  4919,  4932,
     4942,  4947,  4959,  4974,  4987,  4999,  5003,  5013,
     5025,  5037,  5049,  5056,  5067,  5078,  5090,  5102,
     5105,  5115,  5128,  5140,  5149,  5158,  5168,  5178,
     5186,  5195,  5205,  5213,  5227,  5240,  5250,  5260,
     5268,  5280,  5290,  5302,  5312,  5325,  5335,  5345,
     5356,  5369,  5381,  5394,  5402,  5413,  5424,  5435,
     5446,  5462,  5474,  5478,  5492,  5505,  5519,  5532,
     5538,  5551,  5563,  5575,  5591,  5594,  5599,  5614,
     5627,  5641,  5649,  5654,  5666,  5679,  5695,  5710,
     5723,  5726,  5732,  5746,  5761,  5773,  5786,  5799,
     5806,  5811,  5824,  5836,  5849,  5865,  5874,  5879,
     5892,  5905,  5915,  5929,  5943,  5948,  5961,  5975,
     5987,  5999,  6007,  6023,  6035,  6050,  6058,  6072,
     6082,  6095,  6107,  6119,  6133,  6144,  6155,  6166,
     6174,  6181,  6191,  6199,  6208,  6217,  6228,  6233,
     6245,  6255,  6264,  6273,  6278,  6289,  6301,  6314,
     6319,  6329,  6340,  6350,  6361,  6375,  6386,  6397,
     6408,  6417,  6426,  6435,  6445,  6456,  6466,  6476,
     6489,  6500,  6512,  6525,  6531,  6543,  6554,  6563,
     6575,  6583,  6594,  6601,  6614,  6624,  6635,  6648,
     6661,  6674,  6682,  6693,  6705,  6716,  6728,  6738,
     6747,  6760,  6764,  6779,  6788,  6798,  6810,  6819,
     6829,  6839,  6849,  6861,  6873,  6881,  6893,  6904,
     6912,  6922,  6935,  6947,  6958,  6965,  6972,  6981,
     6989,  6997,  7005,  7012,  7025,  7037,  7050,  7059,
     7075,  7085,  7098,  7110,  7120,  7127,  7137,  7147,
     7158,  7169,  7179,  7186,  7195,  7205,  7214,  7226,
     7239,  7248,  7258,  7267,  7281,  7291,  7301,  7316,
     7321,  7335,  7345,  7356,  7369,  7378,  7389,  7400,
     7411,  7420,  7427,  7442,  7450,  7458,  7463,  7475,
     7482,  7492,  7503,  7516,  7524,  7536,  7545,  7557,
     7568,  7575,  7586,  7599,  7607,  7620,  7634,  7645,
     7654,  7662,  7673,  7685,  7699,  7708,  7717,  7728,
     7733,  7743,  7757,  7764,  7772,  7782,  7790,  7800,
     7811,  7823,  7833,  7843,  7854,  7861,  7865,  7874,
     7881,  7891,  7901,  7914,  7922,  7935,  7941,  7951,
     7960,  7971,  7982,  7988,  7995,  8005,  8015,  8027,
     8039,  8053,  8060,  8073,  8083,  8092,  8101,  8113,
     8121,  8130,  8139,  8145,  8157,  8163,  8175,  8183,
     8193,  8209,  8225,  8234,  8248,  8259,  8271,  8283,
     8293,  8304,  8313,  8325,  8339,  8351,  8360,  8371,
     8381,  8390,  8404,  8416,  8432,  8443,  8457,  8467,
     8481,  8492,  8503,  8503,  8503,  8503,  8503,  8503,
     8503,  8503,  8503,  8503,  8510,  8519,  8529,  8542,
     8555,  8566,  8576,  8588,  8603,  8616,  8626,  8640,
     8654,  8666,  8679,  8686,  8696,  8702,  8711,  8715,
     8727,  8737,  8748,  8758,  8764,  8776,  8789,  8797,
     8810,  8817,  8825,  8836,  8841,  8851,  8860,  8871,
     8882,  8894,  8904,  8914,  8928,  8940,  8952,  8965,
     8976,  8988,  8999,  9008,  9020,  9029,  9043,  9054,
     9064,  9073,  9085,  9099,  9113,  9116,  9128,  9141,
     9152,  9164,  9170,  9183,  9196,  9211,  9217,  9217,
     9229,  9241,  9254,  9267,  9270,  9285,  9297,  9311,
     9326,  9338,  9343,  9349,  9364,  9376,  9388,  9401,
     9412,  9417,  9429,  9441,  9452,  9466,  9474,  9482,
     9496,  9508,  9522,  9537,  9542,  9554,  9565,  9580,
     9590,  9606,  9619,  9630,  9643,  9656,  9668,  9681,
     9693,  9703,  9712,  9725,  9738,  9747,  9758,  9771,
     9780,  9788,  9801,  9811,  9826,  9838,  9852,  9862,
     9870,  9885,  9894,  9908,  9921,  9930,  9946,  9962,
     9971,  9981,  9995, 10004, 10019, 10030, 10042, 10056,
    10067, 10079, 10091, 10105, 10119, 10129, 10138, 10148,
    10160, 10170, 10182, 10190, 10200, 10209, 10223, 10230,
    10244, 10254, 10267, 10280, 10292, 10300, 10314, 10327,
    10338, 10346, 10356, 10366, 10374, 10375, 10386, 10398,
    10411, 10421, 10433, 10440, 10450, 10461, 10472, 10483,
    10496, 10507, 10516, 10526, 10537, 10549, 10563, 10574,
    10588, 10601, 10616, 10629, 10641, 10653, 10667, 10678,
    10688, 10698, 10709, 10709, 10709, 10709, 10709, 10709,
    10709, 10709, 10709, 10709, 10716, 10730, 10739, 10751,
    10763, 10774, 10787, 10800, 10815, 10826, 10837, 10850,
    10862, 10873, 10881, 10881, 10881, 10881, 10881, 10891,
    10901, 10911, 10922, 10934, 10945, 10956, 10969, 10983,
    10993, 11004, 11020, 11031, 11043, 11056, 11069, 11082,
    11090, 11103, 11116, 11127, 11130, 11138, 11149, 11160,
    11172, 11185, 11200, 11210, 11221, 11234, 11249, 11254,
    11254, 11254, 11257, 11263, 11268, 11276, 11283, 11295,
    11307, 11318, 11331, 11339, 11349, 11359, 11371, 11381,
    11396, 11409, 11419, 11428, 11439, 11447, 11458, 11471,
    11484, 11498, 11512, 11527, 11540, 11555, 11564, 11576,
    11584, 11597, 11608, 11621, 11633, 11646, 11657, 11669,
    11678, 11691, 11702, 11709, 11722, 11733, 11743, 11753,
    11764, 11776, 11788, 11801, 11809, 11825, 11836, 11846,
    11856, 11868, 11881, 11896, 11903, 11912, 11925, 11934,
    11944, 11954, 11967, 11980, 11987, 11998, 12012, 12021,
    12032, 12043, 12052, 12059, 12073, 12084, 12091, 12102,
    12115, 12119, 12119, 12119, 12119, 12119, 12119, 12119,
    12119, 12119, 12119, 12119, 12119, 12119, 12119, 12119,
    12124, 12135, 12145, 12155, 12167, 12178, 12190, 12196,
    12196, 12196, 12198, 12209, 12218, 12228, 12238, 12247,
    12259, 12271, 12282, 12291, 12300, 12315, 12329, 12337,
    12349, 12361, 12372, 12386, 12395, 12403, 12410, 12419,
    12432, 12444, 12452, 12465, 12471, 12483, 12495, 12499,
    12510, 12524, 12535, 12545, 12552, 12564, 12576, 12586,
    12591, 12591, 12591, 12597, 12608, 12616, 12618, 12627,
    12635, 12644, 12657, 12669, 12679, 12688, 12702, 12703,
    12703, 12703, 12710, 12721, 12731, 12741, 12755, 12765,
    12778, 12791, 12801, 12813, 12826, 12840, 12852, 12862,
    12862, 12862, 12862, 12866, 12877, 12885, 12895, 12904,
    12915, 12926, 12937, 12948, 12958, 12971, 12981, 12989,
    13000, 13006, 13014, 13026, 13032, 13041, 13051, 13062,
    13066, 13074, 13080, 13089, 13101, 13112, 13122, 13130,
    13138, 13138, 13138, 13138, 13138, 13138, 13138, 13144,
    13157, 13165, 13176, 13186, 13196, 13205, 13218, 13227,
    13239, 13251, 13264, 13277, 13291, 13303, 13318, 13331,
    13345, 13357, 13369, 13369, 13369, 13369, 13369, 13369,
    13375, 13387, 13398, 13406, 13414, 13422, 13435, 13445,
    13458, 13466, 13477, 13490, 13502, 13516, 13528, 13540,
    13552, 13553, 13560,
};

/* Unicode codepoints sorted */
static const unsigned short big5_u[642] = {
    0x00A2, 0x00A3, 0x00A5, 0x00A7, 0x00B0, 0x00B1, 0x00B7, 0x00D7,
    0x00F7, 0x02C7, 0x02C9, 0x02CA, 0x02CB, 0x02D9, 0x0391, 0x0392,
    0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A,
    0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3,
    0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x03B1, 0x03B2,
    0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA,
    0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3,
    0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x0401, 0x0414,
    0x0415, 0x0416, 0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C,
    0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A,
    0x042B, 0x042C, 0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432,
    0x0433, 0x0434, 0x0435, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A,
    0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441, 0x0442,
    0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A,
    0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 0x0451, 0x2013, 0x2014,
    0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2025, 0x2026, 0x2032,
    0x2035, 0x203B, 0x203E, 0x2103, 0x2105, 0x2109, 0x2160, 0x2161,
    0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169,
    0x2190, 0x2191, 0x2192, 0x2193, 0x2196, 0x2197, 0x2198, 0x2199,
    0x221A, 0x221E, 0x221F, 0x2220, 0x2223, 0x2225, 0x2229, 0x222A,
    0x222B, 0x222E, 0x2234, 0x2235, 0x223C, 0x2252, 0x2260, 0x2261,
    0x2266, 0x2267, 0x22A5, 0x22BF, 0x2460, 0x2461, 0x2462, 0x2463,
    0x2464, 0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 0x2474, 0x2475,
    0x2476, 0x2477, 0x2478, 0x2479, 0x247A, 0x247B, 0x247C, 0x247D,
    0x2500, 0x2502, 0x250C, 0x2510, 0x2514, 0x2518, 0x251C, 0x2524,
    0x252C, 0x2534, 0x253C, 0x2550, 0x255E, 0x2561, 0x256A, 0x256D,
    0x256E, 0x256F, 0x2570, 0x2571, 0x2572, 0x2573, 0x2581, 0x2582,
    0x2583, 0x2584, 0x2585, 0x2586, 0x2587, 0x2588, 0x2589, 0x258A,
    0x258B, 0x258C, 0x258D, 0x258E, 0x258F, 0x2594, 0x2595, 0x25A0,
    0x25A1, 0x25B2, 0x25B3, 0x25BC, 0x25BD, 0x25C6, 0x25C7, 0x25CB,
    0x25CE, 0x25CF, 0x25E2, 0x25E3, 0x25E4, 0x25E5, 0x2605, 0x2606,
    0x2609, 0x2640, 0x2641, 0x2642, 0x3000, 0x3001, 0x3002, 0x3003,
    0x3005, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E,
    0x300F, 0x3010, 0x3011, 0x3012, 0x3014, 0x3015, 0x301D, 0x301E,
    0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 0x3026, 0x3027, 0x3028,
    0x3029, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047,
    0x3048, 0x3049, 0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F,
    0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057,
    0x3058, 0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F,
    0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067,
    0x3068, 0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F,
    0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077,
    0x3078, 0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F,
    0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087,
    0x3088, 0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F,
    0x3090, 0x3091, 0x3092, 0x3093, 0x309D, 0x309E, 0x30A1, 0x30A2,
    0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8, 0x30A9, 0x30AA,
    0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0, 0x30B1, 0x30B2,
    0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8, 0x30B9, 0x30BA,
    0x30BB, 0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0, 0x30C1, 0x30C2,
    0x30C3, 0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8, 0x30C9, 0x30CA,
    0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0, 0x30D1, 0x30D2,
    0x30D3, 0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8, 0x30D9, 0x30DA,
    0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 0x30E0, 0x30E1, 0x30E2,
    0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8, 0x30E9, 0x30EA,
    0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0, 0x30F1, 0x30F2,
    0x30F3, 0x30F4, 0x30F5, 0x30F6, 0x30FE, 0x3105, 0x3106, 0x3107,
    0x3108, 0x3109, 0x310A, 0x310B, 0x310C, 0x310D, 0x310E, 0x310F,
    0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115, 0x3116, 0x3117,
    0x3118, 0x3119, 0x311A, 0x311B, 0x311C, 0x311D, 0x311E, 0x311F,
    0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125, 0x3126, 0x3127,
    0x3128, 0x3129, 0x32A3, 0x338E, 0x338F, 0x339C, 0x339D, 0x339E,
    0x33A1, 0x33C4, 0x33CE, 0x33D1, 0x33D2, 0x33D5, 0xFA0C, 0xFA0D,
    0xFE30, 0xFE31, 0xFE33, 0xFE34, 0xFE35, 0xFE36, 0xFE37, 0xFE38,
    0xFE39, 0xFE3A, 0xFE3B, 0xFE3C, 0xFE3D, 0xFE3E, 0xFE3F, 0xFE40,
    0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE49, 0xFE4A, 0xFE4B, 0xFE4C,
    0xFE4D, 0xFE4E, 0xFE4F, 0xFE50, 0xFE52, 0xFE54, 0xFE55, 0xFE56,
    0xFE57, 0xFE59, 0xFE5A, 0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F,
    0xFE60, 0xFE61, 0xFE62, 0xFE63, 0xFE64, 0xFE65, 0xFE66, 0xFE69,
    0xFE6A, 0xFE6B, 0xFF01, 0xFF03, 0xFF04, 0xFF05, 0xFF06, 0xFF08,
    0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 0xFF10,
    0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18,
    0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F, 0xFF20,
    0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28,
    0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30,
    0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38,
    0xFF39, 0xFF3A, 0xFF3C, 0xFF3F, 0xFF41, 0xFF42, 0xFF43, 0xFF44,
    0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C,
    0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54,
    0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0xFF5B, 0xFF5C,
    0xFF5D, 0xFF64,
};

/* Multibyte values sorted in Unicode order */
static const unsigned short big5_mb[13703] = {
    0xA246, 0xA247, 0xA244, 0xA1B1, 0xA258, 0xA1D3, 0xA150, 0xA1D1,
    0xA1D2, 0xA3BE, 0xA3BC, 0xA3BD, 0xA3BF, 0xA3BB, 0xA344, 0xA345,
    0xA346, 0xA347, 0xA348, 0xA349, 0xA34A, 0xA34B, 0xA34C, 0xA34D,
    0xA34E, 0xA34F, 0xA350, 0xA351, 0xA352, 0xA353, 0xA354, 0xA355,
    0xA356, 0xA357, 0xA358, 0xA359, 0xA35A, 0xA35B, 0xA35C, 0xA35D,
    0xA35E, 0xA35F, 0xA360, 0xA361, 0xA362, 0xA363, 0xA364, 0xA365,
    0xA366, 0xA367, 0xA368, 0xA369, 0xA36A, 0xA36B, 0xA36C, 0xA36D,
    0xA36E, 0xA36F, 0xA370, 0xA371, 0xA372, 0xA373, 0xC7B3, 0xC7B1,
    0xC7B2, 0xC7B4, 0xC7B5, 0xC7B6, 0xC7B7, 0xC7B8, 0xC7B9, 0xC7BA,
    0xC7BB, 0xC7BC, 0xC7BD, 0xC7BE, 0xC7BF, 0xC7C0, 0xC7C1, 0xC7C2,
    0xC7C3, 0xC7C4, 0xC7C5, 0xC7C6, 0xC7C7, 0xC7C8, 0xC7C9, 0xC7CA,
    0xC7CB, 0xC7CC, 0xC7CD, 0xC7CF, 0xC7D0, 0xC7D1, 0xC7D2, 0xC7D3,
    0xC7D4, 0xC7D5, 0xC7D6, 0xC7D7, 0xC7D8, 0xC7D9, 0xC7DA, 0xC7DB,
    0xC7DC, 0xC7DD, 0xC7DE, 0xC7DF, 0xC7E0, 0xC7E1, 0xC7E2, 0xC7E3,
    0xC7E4, 0xC7E5, 0xC7E6, 0xC7E7, 0xC7E8, 0xC7CE, 0xA156, 0xA158,
    0xA1A5, 0xA1A6, 0xA1A7, 0xA1A8, 0xA145, 0xA14C, 0xA14B, 0xA1AC,
    0xA1AB, 0xA1B0, 0xA1C2, 0xA24A, 0xA1C1, 0xA24B, 0xA2B9, 0xA2BA,
    0xA2BB, 0xA2BC, 0xA2BD, 0xA2BE, 0xA2BF, 0xA2C0, 0xA2C1, 0xA2C2,
    0xA1F6, 0xA1F4, 0xA1F7, 0xA1F5, 0xA1F8, 0xA1F9, 0xA1FB, 0xA1FA,
    0xA1D4, 0xA1DB, 0xA1E8, 0xA1E7, 0xA1FD, 0xA1FC, 0xA1E4, 0xA1E5,
    0xA1EC, 0xA1ED, 0xA1EF, 0xA1EE, 0xA1E3, 0xA1DC, 0xA1DA, 0xA1DD,
    0xA1D8, 0xA1D9, 0xA1E6, 0xA1E9, 0xC7E9, 0xC7EA, 0xC7EB, 0xC7EC,
    0xC7ED, 0xC7EE, 0xC7EF, 0xC7F0, 0xC7F1, 0xC7F2, 0xC7F3, 0xC7F4,
    0xC7F5, 0xC7F6, 0xC7F7, 0xC7F8, 0xC7F9, 0xC7FA, 0xC7FB, 0xC7FC,
    0xA277, 0xA278, 0xA27A, 0xA27B, 0xA27C, 0xA27D, 0xA275, 0xA274,
    0xA273, 0xA272, 0xA271, 0xA2A4, 0xA2A5, 0xA2A7, 0xA2A6, 0xA27E,
    0xA2A1, 0xA2A3, 0xA2A2, 0xA2AC, 0xA2AD, 0xA2AE, 0xA262, 0xA263,
    0xA264, 0xA265, 0xA266, 0xA267, 0xA268, 0xA269, 0xA270, 0xA26F,
    0xA26E, 0xA26D, 0xA26C, 0xA26B, 0xA26A, 0xA276, 0xA279, 0xA1BD,
    0xA1BC, 0xA1B6, 0xA1B5, 0xA1BF, 0xA1BE, 0xA1BB, 0xA1BA, 0xA1B3,
    0xA1B7, 0xA1B4, 0xA2A8, 0xA2A9, 0xA2AB, 0xA2AA, 0xA1B9, 0xA1B8,
    0xA1F3, 0xA1F0, 0xA1F2, 0xA1F1, 0xA140, 0xA142, 0xA143, 0xA1B2,
    0xC6A4, 0xA171, 0xA172, 0xA16D, 0xA16E, 0xA175, 0xA176, 0xA179,
    0xA17A, 0xA169, 0xA16A, 0xA245, 0xA165, 0xA166, 0xA1A9, 0xA1AA,
    0xA2C3, 0xA2C4, 0xA2C5, 0xA2C6, 0xA2C7, 0xA2C8, 0xA2C9, 0xA2CA,
    0xA2CB, 0xC6A5, 0xC6A6, 0xC6A7, 0xC6A8, 0xC6A9, 0xC6AA, 0xC6AB,
    0xC6AC, 0xC6AD, 0xC6AE, 0xC6AF, 0xC6B0, 0xC6B1, 0xC6B2, 0xC6B3,
    0xC6B4, 0xC6B5, 0xC6B6, 0xC6B7, 0xC6B8, 0xC6B9, 0xC6BA, 0xC6BB,
    0xC6BC, 0xC6BD, 0xC6BE, 0xC6BF, 0xC6C0, 0xC6C1, 0xC6C2, 0xC6C3,
    0xC6C4, 0xC6C5, 0xC6C6, 0xC6C7, 0xC6C8, 0xC6C9, 0xC6CA, 0xC6CB,
    0xC6CC, 0xC6CD, 0xC6CE, 0xC6CF, 0xC6D0, 0xC6D1, 0xC6D2, 0xC6D3,
    0xC6D4, 0xC6D5, 0xC6D6, 0xC6D7, 0xC6D8, 0xC6D9, 0xC6DA, 0xC6DB,
    0xC6DC, 0xC6DD, 0xC6DE, 0xC6DF, 0xC6E0, 0xC6E1, 0xC6E2, 0xC6E3,
    0xC6E4, 0xC6E5, 0xC6E6, 0xC6E7, 0xC6E8, 0xC6E9, 0xC6EA, 0xC6EB,
    0xC6EC, 0xC6ED, 0xC6EE, 0xC6EF, 0xC6F0, 0xC6F1, 0xC6F2, 0xC6F3,
    0xC6F4, 0xC6F5, 0xC6F6, 0xC6F7, 0xC6A2, 0xC6A3, 0xC6F8, 0xC6F9,
    0xC6FA, 0xC6FB, 0xC6FC, 0xC6FD, 0xC6FE, 0xC740, 0xC741, 0xC742,
    0xC743, 0xC744, 0xC745, 0xC746, 0xC747, 0xC748, 0xC749, 0xC74A,
    0xC74B, 0xC74C, 0xC74D, 0xC74E, 0xC74F, 0xC750, 0xC751, 0xC752,
    0xC753, 0xC754, 0xC755, 0xC756, 0xC757, 0xC758, 0xC759, 0xC75A,
    0xC75B, 0xC75C, 0xC75D, 0xC75E, 0xC75F, 0xC760, 0xC761, 0xC762,
    0xC763, 0xC764, 0xC765, 0xC766, 0xC767, 0xC768, 0xC769, 0xC76A,
    0xC76B, 0xC76C, 0xC76D, 0xC76E, 0xC76F, 0xC770, 0xC771, 0xC772,
    0xC773, 0xC774, 0xC775, 0xC776, 0xC777, 0xC778, 0xC779, 0xC77A,
    0xC77B, 0xC77C, 0xC77D, 0xC77E, 0xC7A1, 0xC7A2, 0xC7A3, 0xC7A4,
    0xC7A5, 0xC7A6, 0xC7A7, 0xC7A8, 0xC7A9, 0xC7AA, 0xC7AB, 0xC7AC,
    0xC7AD, 0xC7AE, 0xC7AF, 0xC7B0, 0xC6A1, 0xA374, 0xA375, 0xA376,
    0xA377, 0xA378, 0xA379, 0xA37A, 0xA37B, 0xA37C, 0xA37D, 0xA37E,
    0xA3A1, 0xA3A2, 0xA3A3, 0xA3A4, 0xA3A5, 0xA3A6, 0xA3A7, 0xA3A8,
    0xA3A9, 0xA3AA, 0xA3AB, 0xA3AC, 0xA3AD, 0xA3AE, 0xA3AF, 0xA3B0,
    0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7, 0xA3B8,
    0xA3B9, 0xA3BA, 0xA1C0, 0xA255, 0xA256, 0xA250, 0xA251, 0xA252,
    0xA254, 0xA257, 0xA253, 0xA1EB, 0xA1EA, 0xA24F, 0xA440, 0xA442,
    0xA443, 0xC945, 0xA456, 0xA454, 0xA457, 0xA455, 0xC946, 0xA4A3,
    0xC94F, 0xC94D, 0xA4A2, 0xA4A1, 0xA542, 0xA541, 0xA540, 0xA543,
    0xA4FE, 0xA5E0, 0xA5E1, 0xA8C3, 0xA458, 0xA4A4, 0xC950, 0xA4A5,
    0xC963, 0xA6EA, 0xCBB1, 0xA459, 0xA4A6, 0xA544, 0xC964, 0xC940,
    0xA444, 0xA45B, 0xC947, 0xA45C, 0xA4A7, 0xA545, 0xA547, 0xA546,
    0xA5E2, 0xA5E3, 0xA8C4, 0xADBC, 0xA441, 0xC941, 0xA445, 0xA45E,
    0xA45D, 0xA5E4, 0xA8C5, 0xB0AE, 0xD44B, 0xB6C3, 0xDCB1, 0xDCB2,
    0xA446, 0xA4A9, 0xA8C6, 0xA447, 0xC948, 0xA45F, 0xA4AA, 0xA4AC,
    0xC951, 0xA4AD, 0xA4AB, 0xA5E5, 0xA8C7, 0xA8C8, 0xAB45, 0xA460,
    0xA4AE, 0xA5E6, 0xA5E8, 0xA5E7, 0xA6EB, 0xA8C9, 0xA8CA, 0xAB46,
    0xAB47, 0xADBD, 0xDCB3, 0xF6D6, 0xA448, 0xA4B0, 0xA4AF, 0xC952,
    0xA4B1, 0xA4B7, 0xA4B2, 0xA4B3, 0xC954, 0xC953, 0xA4B5, 0xA4B6,
    0xA4B4, 0xA54A, 0xA54B, 0xA54C, 0xA54D, 0xA549, 0xA550, 0xC96A,
    0xC966, 0xC969, 0xA551, 0xA561, 0xC968, 0xA54E, 0xA54F, 0xA548,
    0xC965, 0xC967, 0xA5F5, 0xC9B0, 0xA5F2, 0xA5F6, 0xC9BA, 0xC9AE,
    0xA5F3, 0xC9B2, 0xA5F4, 0xA5F7, 0xA5E9, 0xC9B1, 0xA5F8, 0xC9B5,
    0xC9B9, 0xC9B6, 0xC9B3, 0xA5EA, 0xA5EC, 0xA5F9, 0xA5EE, 0xC9AB,
    0xA5F1, 0xA5EF, 0xA5F0, 0xC9BB, 0xC9B8, 0xC9AF, 0xA5ED, 0xC9AC,
    0xA5EB, 0xC9B4, 0xC9B7, 0xC9AD, 0xCA66, 0xA742, 0xA6F4, 0xCA67,
    0xA6F1, 0xA744, 0xA6F9, 0xA6F8, 0xCA5B, 0xA6FC, 0xA6F7, 0xCA60,
    0xCA68, 0xCA64, 0xA6FA, 0xA6FD, 0xA6EE, 0xA747, 0xCA5D, 0xCBBD,
    0xA6EC, 0xA743, 0xA6ED, 0xA6F5, 0xA6F6, 0xCA62, 0xCA5E, 0xA6FB,
    0xA6F3, 0xCA5A, 0xA6EF, 0xCA65, 0xA745, 0xA748, 0xA6F2, 0xA740,
    0xA746, 0xA6F0, 0xCA63, 0xA741, 0xCA69, 0xCA5C, 0xA6FE, 0xCA5F,
    0xCA61, 0xA8D8, 0xCBBF, 0xCBCB, 0xA8D0, 0xCBCC, 0xA8CB, 0xA8D5,
    0xA8CE, 0xCBB9, 0xA8D6, 0xCBB8, 0xCBBC, 0xCBC3, 0xCBC1, 0xA8DE,
    0xA8D9, 0xCBB3, 0xCBB5, 0xA8DB, 0xA8CF, 0xCBB6, 0xCBC2, 0xCBC9,
    0xA8D4, 0xCBBB, 0xCBB4, 0xA8D3, 0xCBB7, 0xA8D7, 0xCBBA, 0xA8D2,
    0xA8CD, 0xA8DC, 0xCBC4, 0xA8DD, 0xCBC8, 0xCBC6, 0xCBCA, 0xA8DA,
    0xCBBE, 0xCBB2, 0xCBC0, 0xA8D1, 0xCBC5, 0xA8CC, 0xCBC7, 0xAB56,
    0xAB4A, 0xCDE0, 0xCDE8, 0xAB49, 0xAB51, 0xAB5D, 0xCDEE, 0xCDEC,
    0xCDE7, 0xAB4B, 0xCDED, 0xCDE3, 0xAB59, 0xAB50, 0xAB58, 0xCDDE,
    0xCDEA, 0xCDE1, 0xAB54, 0xCDE2, 0xCDDD, 0xAB5B, 0xAB4E, 0xAB57,
    0xAB4D, 0xCDDF, 0xCDE4, 0xCDEB, 0xAB55, 0xAB52, 0xCDE6, 0xAB5A,
    0xCDE9, 0xCDE5, 0xAB4F, 0xAB5C, 0xAB53, 0xAB4C, 0xAB48, 0xCDEF,
    0xADD7, 0xADC1, 0xADD1, 0xADD6, 0xD0D0, 0xD0CF, 0xD0D4, 0xD0D5,
    0xADC4, 0xADCD, 0xADDA, 0xADCE, 0xD0C9, 0xADC7, 0xD0CA, 0xADDC,
    0xADD3, 0xADBE, 0xADBF, 0xD0DD, 0xB0BF, 0xADCC, 0xADCB, 0xD0CB,
    0xADCF, 0xD45B, 0xADC6, 0xD0D6, 0xADD5, 0xADD4, 0xADCA, 0xD0CE,
    0xD0D7, 0xD0C8, 0xADC9, 0xD0D8, 0xADD2, 0xD0CC, 0xADC0, 0xADC3,
    0xADC2, 0xD0D9, 0xADD0, 0xADC5, 0xADD9, 0xADDB, 0xD0D3, 0xADD8,
    0xD0DB, 0xD0CD, 0xD0DC, 0xD0D1, 0xD0DA, 0xD0D2, 0xADC8, 0xD463,
    0xD457, 0xB0B3, 0xD45C, 0xD462, 0xB0B2, 0xD455, 0xB0B6, 0xD459,
    0xD452, 0xB0B4, 0xD456, 0xB0B9, 0xB0BE, 0xD467, 0xD451, 0xB0BA,
    0xD466, 0xB0B5, 0xD458, 0xB0B1, 0xD453, 0xD44F, 0xD45D, 0xD450,
    0xD44E, 0xD45A, 0xD460, 0xD461, 0xB0B7, 0xD85B, 0xD45E, 0xD44D,
    0xD45F, 0xB0C1, 0xD464, 0xB0C0, 0xD44C, 0xD454, 0xD465, 0xB0BC,
    0xB0BB, 0xB0B8, 0xB0BD, 0xB0AF, 0xB0B0, 0xB3C8, 0xD85E, 0xD857,
    0xB3C5, 0xD85F, 0xD855, 0xD858, 0xB3C4, 0xD859, 0xB3C7, 0xD85D,
    0xD853, 0xD852, 0xB3C9, 0xB3CA, 0xB3C6, 0xB3CB, 0xD851, 0xD85C,
    0xD85A, 0xD854, 0xB3C3, 0xD856, 0xB6CA, 0xB6C4, 0xDCB7, 0xB6CD,
    0xDCBD, 0xDCC0, 0xB6C6, 0xB6C7, 0xDCBA, 0xB6C5, 0xDCC3, 0xB6CB,
    0xDCC4, 0xDCBF, 0xB6CC, 0xDCB4, 0xB6C9, 0xDCB5, 0xDCBE, 0xDCBC,
    0xDCB8, 0xB6C8, 0xDCB6, 0xB6CE, 0xDCBB, 0xDCC2, 0xDCB9, 0xDCC1,
    0xB9B6, 0xB9B3, 0xB9B4, 0xE0F9, 0xE0F1, 0xB9B2, 0xB9AF, 0xE0F2,
    0xB9B1, 0xE0F5, 0xE0F7, 0xE0FE, 0xE0FD, 0xE0F8, 0xB9AE, 0xE0F0,
    0xB9AC, 0xE0F3, 0xB9B7, 0xE0F6, 0xE0FA, 0xB9B0, 0xB9AD, 0xE0FC,
    0xE0FB, 0xB9B5, 0xE0F4, 0xBBF8, 0xE4EC, 0xE4E9, 0xBBF9, 0xBBF7,
    0xE4F0, 0xE4ED, 0xE4E6, 0xBBF6, 0xBBFA, 0xE4E7, 0xBBF5, 0xBBFD,
    0xE4EA, 0xE4EB, 0xBBFB, 0xBBFC, 0xE4F1, 0xE4EE, 0xE4EF, 0xBEAA,
    0xE8F8, 0xBEA7, 0xE8F5, 0xBEA9, 0xBEAB, 0xE8F6, 0xBEA8, 0xE8F7,
    0xE8F4, 0xC076, 0xECBD, 0xC077, 0xECBB, 0xECBC, 0xECBA, 0xECB9,
    0xECBE, 0xC075, 0xEFB8, 0xEFB9, 0xE4E8, 0xEFB7, 0xC078, 0xC35F,
    0xF1EB, 0xF1EC, 0xC4D7, 0xC4D8, 0xF5C1, 0xF5C0, 0xC56C, 0xC56B,
    0xF7D0, 0xA449, 0xA461, 0xA4B9, 0xA4B8, 0xA553, 0xA552, 0xA5FC,
    0xA5FB, 0xA5FD, 0xA5FA, 0xA74A, 0xA749, 0xA74B, 0xA8E0, 0xA8DF,
    0xA8E1, 0xAB5E, 0xA259, 0xD0DE, 0xA25A, 0xB0C2, 0xA25C, 0xA25B,
    0xD860, 0xA25D, 0xB9B8, 0xA25E, 0xA44A, 0xA4BA, 0xA5FE, 0xA8E2,
    0xA44B, 0xA4BD, 0xA4BB, 0xA4BC, 0xA640, 0xA74C, 0xA8E4, 0xA8E3,
    0xA8E5, 0xADDD, 0xBEAC, 0xC94E, 0xA554, 0xA555, 0xA641, 0xCA6A,
    0xAB60, 0xAB5F, 0xD0E0, 0xD0DF, 0xB0C3, 0xA4BE, 0xC955, 0xCBCD,
    0xAB61, 0xADE0, 0xADDE, 0xADDF, 0xBEAD, 0xA556, 0xA642, 0xC9BC,
    0xA74D, 0xA74E, 0xCA6B, 0xCBCE, 0xA8E6, 0xCBCF, 0xD0E2, 0xD0E3,
    0xADE3, 0xD0E4, 0xD0E1, 0xADE4, 0xADE2, 0xADE1, 0xD0E5, 0xD468,
    0xD861, 0xDCC5, 0xE140, 0xBBFE, 0xBEAE, 0xE8F9, 0xA44C, 0xA45A,
    0xB0C4, 0xB3CD, 0xB9B9, 0xC942, 0xA4BF, 0xA559, 0xA557, 0xA558,
    0xA8E7, 0xA44D, 0xA44E, 0xA462, 0xA4C0, 0xA4C1, 0xA4C2, 0xC9BE,
    0xA55A, 0xC96B, 0xA646, 0xC9BF, 0xA644, 0xA645, 0xC9BD, 0xA647,
    0xA643, 0xCA6C, 0xAAEC, 0xCA6D, 0xCA6E, 0xA750, 0xA74F, 0xA753,
    0xA751, 0xA752, 0xA8ED, 0xA8EC, 0xCBD4, 0xCBD1, 0xCBD2, 0xCBD0,
    0xA8EE, 0xA8EA, 0xA8E9, 0xA8EB, 0xA8E8, 0xA8EF, 0xAB63, 0xCDF0,
    0xCBD3, 0xAB68, 0xCDF1, 0xAB64, 0xAB67, 0xAB66, 0xAB65, 0xAB62,
    0xD0E8, 0xADE7, 0xD0EB, 0xADE5, 0xD0E7, 0xADE8, 0xADE6, 0xADE9,
    0xD0E9, 0xD0EA, 0xD0E6, 0xD0EC, 0xB3D1, 0xB0C5, 0xD469, 0xD46B,
    0xD46A, 0xD46C, 0xB0C6, 0xB3CE, 0xB3CF, 0xB3D0, 0xB6D0, 0xDCC7,
    0xDCC6, 0xDCC8, 0xDCC9, 0xB6D1, 0xB6CF, 0xE141, 0xE142, 0xB9BB,
    0xB9BA, 0xE35A, 0xBC40, 0xBC41, 0xBC42, 0xBC44, 0xE4F2, 0xE4F3,
    0xBC43, 0xBEAF, 0xBEB0, 0xF1ED, 0xF5C3, 0xF5C2, 0xF7D1, 0xA44F,
    0xA55C, 0xA55B, 0xA648, 0xC9C0, 0xA755, 0xA756, 0xA754, 0xA757,
    0xCA6F, 0xCA70, 0xA8F1, 0xCBD5, 0xA8F0, 0xCDF2, 0xAB6C, 0xCDF3,
    0xAB6B, 0xAB69, 0xAB6A, 0xD0ED, 0xB0C7, 0xD46E, 0xB0CA, 0xD46D,
    0xB1E5, 0xB0C9, 0xB0C8, 0xB3D4, 0xB3D3, 0xB3D2, 0xB6D2, 0xB6D5,
    0xB6D6, 0xB6D4, 0xB6D3, 0xE143, 0xE144, 0xE4F5, 0xBC45, 0xE4F4,
    0xBEB1, 0xECBF, 0xC079, 0xF1EE, 0xC455, 0xA463, 0xA4C3, 0xC956,
    0xA4C4, 0xA4C5, 0xA55D, 0xA55E, 0xA649, 0xCA71, 0xCBD6, 0xCBD7,
    0xAB6D, 0xD0EE, 0xB0CC, 0xB0CB, 0xD863, 0xD862, 0xA450, 0xA4C6,
    0xA55F, 0xB0CD, 0xC943, 0xC96C, 0xA560, 0xC9C2, 0xA64B, 0xA64A,
    0xC9C1, 0xA758, 0xADEA, 0xD46F, 0xB6D7, 0xE145, 0xB9BC, 0xE8FA,
    0xF3FD, 0xA4C7, 0xCBD8, 0xCDF4, 0xB0D0, 0xB0CE, 0xB0CF, 0xA451,
    0xA464, 0xA2CD, 0xA4CA, 0xA4C9, 0xA4C8, 0xA563, 0xA562, 0xC96D,
    0xC9C3, 0xA8F5, 0xA8F2, 0xA8F4, 0xA8F3, 0xAB6E, 0xB3D5, 0xA452,
    0xA4CB, 0xA565, 0xA564, 0xCA72, 0xA8F6, 0xC957, 0xA567, 0xA566,
    0xA64C, 0xA64D, 0xCA73, 0xA759, 0xA75A, 0xA8F7, 0xA8F8, 0xA8F9,
    0xAB6F, 0xCDF5, 0xADEB, 0xC944, 0xA4CC, 0xC9C4, 0xCA74, 0xCA75,
    0xCBD9, 0xCBDA, 0xCDF7, 0xCDF6, 0xCDF9, 0xCDF8, 0xAB70, 0xD470,
    0xADED, 0xD0EF, 0xADEC, 0xD864, 0xB3D6, 0xD865, 0xE146, 0xB9BD,
    0xBC46, 0xF1EF, 0xC958, 0xA568, 0xB0D1, 0xA453, 0xA465, 0xA4CE,
    0xA4CD, 0xA4CF, 0xA8FB, 0xA8FA, 0xA8FC, 0xAB71, 0xADEE, 0xE8FB,
    0xC24F, 0xA466, 0xA56A, 0xA579, 0xA574, 0xA56F, 0xA56E, 0xA575,
    0xA573, 0xA56C, 0xA57A, 0xA56D, 0xA569, 0xA578, 0xA577, 0xA576,
    0xA56B, 0xA572, 0xA571, 0xA57B, 0xA570, 0xA653, 0xA659, 0xA655,
    0xA65B, 0xC9C5, 0xA658, 0xA64E, 0xA651, 0xA654, 0xA650, 0xA657,
    0xA65A, 0xA64F, 0xA652, 0xA656, 0xA65C, 0xCA7E, 0xCA7B, 0xA767,
    0xCA7C, 0xA75B, 0xA75D, 0xA775, 0xA770, 0xCAA5, 0xCA7D, 0xA75F,
    0xA761, 0xCAA4, 0xA768, 0xCA78, 0xA774, 0xA776, 0xA75C, 0xA76D,
    0xCA76, 0xA773, 0xA764, 0xA76E, 0xA76F, 0xCA77, 0xA76C, 0xA76A,
    0xA76B, 0xA771, 0xCAA1, 0xA75E, 0xA772, 0xCAA3, 0xA766, 0xA763,
    0xCA7A, 0xA762, 0xCAA6, 0xA765, 0xA769, 0xA760, 0xCAA2, 0xCA79,
    0xCBEB, 0xCBEA, 0xA94F, 0xCBED, 0xCBEF, 0xCBE4, 0xCBE7, 0xCBEE,
    0xA950, 0xCBE1, 0xCBE5, 0xCBE9, 0xCE49, 0xA94B, 0xCE4D, 0xA8FD,
    0xCBE6, 0xA8FE, 0xA94C, 0xA945, 0xA941, 0xCBE2, 0xA944, 0xA949,
    0xA952, 0xCBE3, 0xCBDC, 0xA943, 0xCBDD, 0xCBDF, 0xA946, 0xA948,
    0xCBDB, 0xCBE0, 0xA951, 0xA94D, 0xCBE8, 0xA953, 0xA94A, 0xCBDE,
    0xA947, 0xA942, 0xA940, 0xCBEC, 0xA94E, 0xCE48, 0xCDFB, 0xCE4B,
    0xCDFD, 0xAB78, 0xABA8, 0xAB74, 0xABA7, 0xAB7D, 0xABA4, 0xAB72,
    0xCDFC, 0xCE43, 0xABA3, 0xCE4F, 0xABA5, 0xAB79, 0xCE45, 0xCE42,
    0xAB77, 0xCDFA, 0xABA6, 0xCE4A, 0xAB7C, 0xCE4C, 0xABA9, 0xAB73,
    0xAB7E, 0xAB7B, 0xCE40, 0xABA1, 0xCE46, 0xCE47, 0xAB7A, 0xABA2,
    0xAB76, 0xAB75, 0xCDFE, 0xCE44, 0xCE4E, 0xD144, 0xADFB, 0xD0F1,
    0xD0F6, 0xADF4, 0xAE40, 0xD0F4, 0xADEF, 0xADF9, 0xADFE, 0xD0FB,
    0xADFA, 0xADFD, 0xD0FE, 0xADF5, 0xD0F5, 0xD142, 0xD143, 0xADF7,
    0xD141, 0xADF3, 0xAE43, 0xD0F8, 0xADF1, 0xD146, 0xD0F9, 0xD0FD,
    0xADF6, 0xAE42, 0xD0FA, 0xADFC, 0xD140, 0xD147, 0xD4A1, 0xD145,
    0xAE44, 0xADF0, 0xD0FC, 0xD0F3, 0xADF8, 0xD0F2, 0xD0F7, 0xD0F0,
    0xAE41, 0xD477, 0xB0E4, 0xD4A7, 0xB0E2, 0xB0DF, 0xD47C, 0xB0DB,
    0xD4A2, 0xB0E6, 0xD476, 0xD47B, 0xD47A, 0xADF2, 0xB0E1, 0xD4A5,
    0xD4A8, 0xD473, 0xB3E8, 0xD4A9, 0xB0E7, 0xB0D9, 0xB0D6, 0xD47E,
    0xB0D3, 0xD4A6, 0xB0DA, 0xD4AA, 0xD474, 0xD4A4, 0xB0DD, 0xD475,
    0xD478, 0xD47D, 0xB0DE, 0xB0DC, 0xB0E8, 0xB0E3, 0xB0D7, 0xB1D2,
    0xB0D8, 0xD479, 0xB0E5, 0xB0E0, 0xD4A3, 0xB0D5, 0xB0D4, 0xD471,
    0xD472, 0xD86A, 0xB3D7, 0xB3DA, 0xD875, 0xB3EE, 0xD878, 0xB3D8,
    0xD871, 0xB3DE, 0xB3E4, 0xB5BD, 0xB3E2, 0xD86E, 0xB3EF, 0xB3DB,
    0xB3E3, 0xD876, 0xDCD7, 0xD87B, 0xD86F, 0xD866, 0xD873, 0xD86D,
    0xB3E1, 0xD879, 0xB3DD, 0xB3F1, 0xB3EA, 0xB3DF, 0xB3DC, 0xB3E7,
    0xD87A, 0xD86C, 0xD872, 0xD874, 0xD868, 0xD877, 0xB3D9, 0xD867,
    0xB3E0, 0xB3F0, 0xB3EC, 0xD869, 0xB3E6, 0xB3ED, 0xB3E9, 0xB3E5,
    0xD870, 0xB3EB, 0xDCD5, 0xDCD1, 0xDCE0, 0xDCCA, 0xDCD3, 0xB6E5,
    0xB6E6, 0xB6DE, 0xDCDC, 0xB6E8, 0xDCCF, 0xDCCE, 0xDCCC, 0xDCDE,
    0xB6DC, 0xDCD8, 0xDCCD, 0xB6DF, 0xDCD6, 0xB6DA, 0xDCD2, 0xDCD9,
    0xDCDB, 0xDCDF, 0xB6E3, 0xDCCB, 0xB6DD, 0xDCD0, 0xB6D8, 0xB6E4,
    0xDCDA, 0xB6E0, 0xB6E1, 0xB6E7, 0xB6DB, 0xA25F, 0xB6D9, 0xDCD4,
    0xB6E2, 0xDCDD, 0xB9CD, 0xB9C8, 0xE155, 0xE151, 0xE14B, 0xB9C2,
    0xB9BE, 0xE154, 0xB9BF, 0xE14E, 0xE150, 0xE153, 0xB9C4, 0xB9CB,
    0xB9C5, 0xE149, 0xB9C6, 0xB9C7, 0xE14C, 0xB9CC, 0xE14A, 0xE14F,
    0xB9C3, 0xE148, 0xB9C9, 0xB9C1, 0xB9C0, 0xE14D, 0xE152, 0xB9CA,
    0xE147, 0xBC4D, 0xE547, 0xE544, 0xBC47, 0xBC53, 0xBC54, 0xBC4A,
    0xE542, 0xBC4C, 0xE4F9, 0xBC52, 0xE546, 0xBC49, 0xE548, 0xBC48,
    0xE543, 0xE545, 0xBC4B, 0xE541, 0xE4FA, 0xE4F7, 0xD86B, 0xE4FD,
    0xE4F6, 0xE4FC, 0xE4FB, 0xE4F8, 0xBC4F, 0xBC4E, 0xBC50, 0xE4FE,
    0xBEB2, 0xE540, 0xE945, 0xE8FD, 0xBEBE, 0xE942, 0xBEB6, 0xBEBA,
    0xE941, 0xBEB9, 0xBEB5, 0xBEB8, 0xBEB3, 0xBEBD, 0xE943, 0xE8FE,
    0xBEBC, 0xE8FC, 0xBEBB, 0xE944, 0xE940, 0xBC51, 0xBEBF, 0xE946,
    0xBEB7, 0xBEB4, 0xECC6, 0xECC8, 0xC07B, 0xECC9, 0xECC7, 0xECC5,
    0xECC4, 0xC07D, 0xECC3, 0xC07E, 0xECC1, 0xECC2, 0xC07A, 0xC0A1,
    0xC07C, 0xECC0, 0xC250, 0xEFBC, 0xEFBA, 0xEFBF, 0xEFBD, 0xEFBB,
    0xEFBE, 0xC360, 0xF1F2, 0xF1F3, 0xC456, 0xF1F4, 0xF1F0, 0xF1F5,
    0xF1F1, 0xC251, 0xF3FE, 0xF441, 0xC459, 0xF440, 0xC458, 0xC457,
    0xC45A, 0xF5C5, 0xF5C6, 0xC4DA, 0xC4D9, 0xC4DB, 0xF5C4, 0xF6D8,
    0xF6D7, 0xC56D, 0xC56F, 0xC56E, 0xF6D9, 0xC5C8, 0xF8A6, 0xC5F1,
    0xF8A5, 0xF8EE, 0xC949, 0xA57D, 0xA57C, 0xA65F, 0xA65E, 0xC9C7,
    0xA65D, 0xC9C6, 0xA779, 0xCAA9, 0xCAA8, 0xA777, 0xA77A, 0xCAA7,
    0xA778, 0xCBF0, 0xCBF1, 0xA954, 0xABAA, 0xD148, 0xD149, 0xAE45,
    0xAE46, 0xD4AC, 0xB0E9, 0xB0EB, 0xD4AB, 0xB0EA, 0xD87C, 0xB3F2,
    0xB6E9, 0xB6EA, 0xDCE1, 0xB9CF, 0xB9CE, 0xE549, 0xE948, 0xE947,
    0xF96B, 0xA467, 0xC959, 0xC96E, 0xC96F, 0xA662, 0xA666, 0xC9C9,
    0xA664, 0xA663, 0xC9C8, 0xA665, 0xA661, 0xA660, 0xC9CA, 0xA7A6,
    0xA7A3, 0xA77D, 0xCAAA, 0xCAAB, 0xA7A1, 0xCAAD, 0xA77B, 0xCAAE,
    0xCAAC, 0xA77E, 0xA7A2, 0xA7A5, 0xA7A4, 0xA77C, 0xCAAF, 0xA959,
    0xCBFE, 0xA95B, 0xA95A, 0xCC40, 0xA958, 0xA957, 0xCBF5, 0xCBF4,
    0xCBF2, 0xCBF7, 0xCBF6, 0xCBF3, 0xCBFC, 0xCBFD, 0xCBFA, 0xCBF8,
    0xA956, 0xCBFB, 0xA95C, 0xCC41, 0xCBF9, 0xABAB, 0xA955, 0xABAC,
    0xCE54, 0xCE5A, 0xABB2, 0xCE58, 0xCE5E, 0xCE55, 0xCE59, 0xCE5B,
    0xCE5D, 0xCE57, 0xCE56, 0xCE51, 0xCE52, 0xABAD, 0xABAF, 0xABAE,
    0xCE53, 0xCE5C, 0xABB1, 0xCE50, 0xD153, 0xD152, 0xD157, 0xD14E,
    0xD151, 0xD150, 0xD154, 0xD158, 0xAE47, 0xAE4A, 0xD14F, 0xD155,
    0xAE49, 0xD14A, 0xABB0, 0xD4BA, 0xD156, 0xD14D, 0xAE48, 0xD14C,
    0xD4B1, 0xB0EC, 0xB0F0, 0xD4C1, 0xD4AF, 0xD4BD, 0xB0F1, 0xD4BF,
    0xD4C5, 0xD4C9, 0xD4C0, 0xD4B4, 0xD4BC, 0xD4CA, 0xD4C8, 0xD4BE,
    0xD4B9, 0xD4B2, 0xD8A6, 0xD4B0, 0xB0F5, 0xD4B7, 0xB0F6, 0xB0F2,
    0xD4AD, 0xD4C3, 0xD4B5, 0xD4B3, 0xD4C6, 0xB0F3, 0xD4CC, 0xB0ED,
    0xB0EF, 0xD4BB, 0xD4B6, 0xAE4B, 0xB0EE, 0xD4B8, 0xD4C7, 0xD4CB,
    0xD4C2, 0xD4C4, 0xD4AE, 0xD8A1, 0xD8AA, 0xD8A9, 0xB3FA, 0xD8A2,
    0xB3FB, 0xB3F9, 0xD8A4, 0xB3F6, 0xD8A8, 0xD8A3, 0xD8A5, 0xD87D,
    0xB3F4, 0xD8B2, 0xD8B1, 0xD8AE, 0xB3F3, 0xB3F7, 0xB3F8, 0xD14B,
    0xD8AB, 0xB3F5, 0xB0F4, 0xD8AD, 0xD87E, 0xD8B0, 0xD8AF, 0xD8B3,
    0xDCEF, 0xD8AC, 0xD8A7, 0xDCE7, 0xB6F4, 0xB6F7, 0xB6F2, 0xDCE6,
    0xDCEA, 0xDCE5, 0xB6EC, 0xB6F6, 0xDCE2, 0xB6F0, 0xDCE9, 0xB6EE,
    0xB6ED, 0xDCEC, 0xB6EF, 0xDCEE, 0xDCEB, 0xB6EB, 0xB6F5, 0xDCF0,
    0xDCE4, 0xDCED, 0xDCE3, 0xB6F1, 0xB6F3, 0xDCE8, 0xDCF1, 0xE15D,
    0xB9D0, 0xE163, 0xB9D5, 0xE15F, 0xE166, 0xE157, 0xB9D7, 0xB9D1,
    0xE15C, 0xBC55, 0xE15B, 0xE164, 0xB9D2, 0xB9D6, 0xE15A, 0xE160,
    0xE165, 0xE156, 0xB9D4, 0xE15E, 0xE162, 0xE168, 0xE158, 0xE161,
    0xB9D3, 0xE167, 0xE159, 0xBC59, 0xE54B, 0xBC57, 0xBC56, 0xE54D,
    0xE552, 0xE54E, 0xE551, 0xBC5C, 0xBEA5, 0xBC5B, 0xE54A, 0xE550,
    0xBC5A, 0xE54F, 0xE54C, 0xBC58, 0xE94D, 0xE94F, 0xE94A, 0xBEC1,
    0xE94C, 0xBEC0, 0xE94E, 0xBEC3, 0xE950, 0xBEC2, 0xE949, 0xE94B,
    0xC0A5, 0xECCC, 0xC0A4, 0xECCD, 0xC0A3, 0xECCB, 0xC0A2, 0xECCA,
    0xC253, 0xC252, 0xF1F6, 0xF1F8, 0xF1F7, 0xC361, 0xC362, 0xC363,
    0xF442, 0xC45B, 0xF7D3, 0xF7D2, 0xC5F2, 0xA468, 0xA4D0, 0xA7A7,
    0xCE5F, 0xB3FC, 0xB3FD, 0xDCF2, 0xB9D8, 0xE169, 0xE553, 0xC95A,
    0xCAB0, 0xCC42, 0xCE60, 0xD159, 0xAE4C, 0xF1F9, 0xC4DC, 0xA469,
    0xA57E, 0xC970, 0xA667, 0xA668, 0xA95D, 0xB0F7, 0xB9DA, 0xB9DB,
    0xB9D9, 0xA46A, 0xA4D1, 0xA4D3, 0xA4D2, 0xC95B, 0xA4D4, 0xA5A1,
    0xC971, 0xA5A2, 0xA669, 0xA66A, 0xC9CB, 0xA7A8, 0xCAB1, 0xA961,
    0xCC43, 0xA95F, 0xA960, 0xA95E, 0xD15A, 0xABB6, 0xABB5, 0xABB7,
    0xABB4, 0xCE61, 0xA962, 0xABB3, 0xAE4D, 0xAE4E, 0xAE4F, 0xD4CD,
    0xB3FE, 0xD8B4, 0xB0F8, 0xB6F8, 0xB9DD, 0xB9DC, 0xE16A, 0xBC5D,
    0xBEC4, 0xEFC0, 0xF6DA, 0xF7D4, 0xA46B, 0xA5A3, 0xA5A4, 0xC9D1,
    0xA66C, 0xA66F, 0xC9CF, 0xC9CD, 0xA66E, 0xC9D0, 0xC9D2, 0xC9CC,
    0xA671, 0xA670, 0xA66D, 0xA66B, 0xC9CE, 0xA7B3, 0xA7B0, 0xCAB6,
    0xCAB9, 0xCAB8, 0xA7AA, 0xA7B2, 0xA7AF, 0xCAB5, 0xCAB3, 0xA7AE,
    0xA7A9, 0xA7AC, 0xCAB4, 0xCABB, 0xCAB7, 0xA7AD, 0xA7B1, 0xA7B4,
    0xCAB2, 0xCABA, 0xA7AB, 0xA967, 0xA96F, 0xCC4F, 0xCC48, 0xA970,
    0xCC53, 0xCC44, 0xCC4B, 0xA966, 0xCC45, 0xA964, 0xCC4C, 0xCC50,
    0xA963, 0xCC51, 0xCC4A, 0xCC4D, 0xA972, 0xA969, 0xCC54, 0xCC52,
    0xA96E, 0xA96C, 0xCC49, 0xA96B, 0xCC47, 0xCC46, 0xA96A, 0xA968,
    0xA971, 0xA96D, 0xA965, 0xCC4E, 0xABB9, 0xABC0, 0xCE6F, 0xABB8,
    0xCE67, 0xCE63, 0xCE73, 0xCE62, 0xABBB, 0xCE6C, 0xABBE, 0xABC1,
    0xABBC, 0xCE70, 0xABBF, 0xAE56, 0xCE76, 0xCE64, 0xCE66, 0xCE6D,
    0xCE71, 0xCE75, 0xCE72, 0xCE6B, 0xCE6E, 0xCE68, 0xABC3, 0xCE6A,
    0xCE69, 0xCE74, 0xABBA, 0xCE65, 0xABC2, 0xABBD, 0xAE5C, 0xD162,
    0xAE5B, 0xD160, 0xAE50, 0xAE55, 0xD15F, 0xD15C, 0xD161, 0xAE51,
    0xD15B, 0xAE54, 0xAE52, 0xD163, 0xAE53, 0xAE57, 0xAE58, 0xAE5A,
    0xAE59, 0xD15D, 0xD15E, 0xD164, 0xD4D4, 0xB0F9, 0xD8C2, 0xD4D3,
    0xD4E6, 0xB140, 0xD4E4, 0xB0FE, 0xB0FA, 0xD4ED, 0xD4DD, 0xD4E0,
    0xB143, 0xD4EA, 0xD4E2, 0xB0FB, 0xB144, 0xD4E7, 0xD4E5, 0xD4D6,
    0xD4EB, 0xD4DF, 0xD4DA, 0xD4D0, 0xD4EC, 0xD4DC, 0xD4CF, 0xB142,
    0xD4E1, 0xD4EE, 0xD4DE, 0xD4D2, 0xD4D7, 0xD4CE, 0xB141, 0xD4DB,
    0xD4D8, 0xB0FC, 0xD4D1, 0xD4E9, 0xB0FD, 0xD4D9, 0xD4D5, 0xD4E8,
    0xB440, 0xD8BB, 0xD8B8, 0xD8C9, 0xD8BD, 0xD8CA, 0xB442, 0xD8C6,
    0xD8C3, 0xD8C4, 0xD8C7, 0xD8CB, 0xD4E3, 0xD8CD, 0xDD47, 0xB443,
    0xD8CE, 0xD8B6, 0xD8C0, 0xD8C5, 0xB441, 0xB444, 0xD8CC, 0xD8CF,
    0xD8BA, 0xD8B7, 0xD8B9, 0xD8BE, 0xD8BC, 0xB445, 0xD8C8, 0xD8BF,
    0xD8C1, 0xD8B5, 0xDCFA, 0xDCF8, 0xB742, 0xB740, 0xDD43, 0xDCF9,
    0xDD44, 0xDD40, 0xDCF7, 0xDD46, 0xDCF6, 0xDCFD, 0xB6FE, 0xB6FD,
    0xB6FC, 0xDCFB, 0xDD41, 0xB6F9, 0xB741, 0xDCF4, 0xDCFE, 0xDCF3,
    0xDCFC, 0xB6FA, 0xDD42, 0xDCF5, 0xB6FB, 0xDD45, 0xE16E, 0xB9E2,
    0xB9E1, 0xB9E3, 0xE17A, 0xE170, 0xE176, 0xE16B, 0xE179, 0xE178,
    0xE17C, 0xE175, 0xB9DE, 0xE174, 0xB9E4, 0xE16D, 0xB9DF, 0xE17B,
    0xB9E0, 0xE16F, 0xE172, 0xE177, 0xE171, 0xE16C, 0xE173, 0xE555,
    0xBC61, 0xE558, 0xE557, 0xE55A, 0xE55C, 0xBC5F, 0xE556, 0xE554,
    0xE55D, 0xE55B, 0xE559, 0xE55F, 0xE55E, 0xBC63, 0xBC5E, 0xBC60,
    0xBC62, 0xE560, 0xE957, 0xE956, 0xE955, 0xE958, 0xE951, 0xE952,
    0xE95A, 0xE953, 0xBEC5, 0xE95C, 0xE95B, 0xE954, 0xECD1, 0xC0A8,
    0xECCF, 0xECD4, 0xECD3, 0xE959, 0xC0A7, 0xECD2, 0xECCE, 0xECD6,
    0xECD5, 0xC0A6, 0xECD0, 0xBEC6, 0xC254, 0xEFC1, 0xF1FA, 0xF1FB,
    0xF1FC, 0xC45C, 0xC45D, 0xF443, 0xF5C8, 0xF5C7, 0xF6DB, 0xF6DC,
    0xF7D5, 0xF8A7, 0xA46C, 0xA46D, 0xA46E, 0xA4D5, 0xA5A5, 0xC9D3,
    0xA672, 0xA673, 0xA7B7, 0xA7B8, 0xA7B6, 0xA7B5, 0xA973, 0xCC55,
    0xA975, 0xA974, 0xCC56, 0xABC4, 0xAE5D, 0xD165, 0xD4F0, 0xB145,
    0xB447, 0xD4EF, 0xB446, 0xB9E5, 0xE17D, 0xBEC7, 0xC0A9, 0xECD7,
    0xC45E, 0xC570, 0xC972, 0xA5A6, 0xC973, 0xA676, 0xA674, 0xA675,
    0xA677, 0xA7BA, 0xA7B9, 0xCABC, 0xA7BB, 0xCABD, 0xCC57, 0xCC58,
    0xA976, 0xA978, 0xA97A, 0xA977, 0xA97B, 0xA979, 0xABC8, 0xABC5,
    0xABC7, 0xABC9, 0xABC6, 0xD166, 0xCE77, 0xD168, 0xD167, 0xAE63,
    0xAE5F, 0xAE60, 0xAE62, 0xAE64, 0xAE61, 0xAE66, 0xAE65, 0xB14A,
    0xD4F2, 0xD4F1, 0xB149, 0xB148, 0xB147, 0xB14B, 0xB146, 0xD8D5,
    0xD8D2, 0xB449, 0xD8D1, 0xD8D6, 0xB44B, 0xD8D4, 0xB448, 0xB44A,
    0xD8D3, 0xDD48, 0xDD49, 0xDD4A, 0xB9E6, 0xB9EE, 0xE17E, 0xB9E8,
    0xB9EC, 0xE1A1, 0xB9ED, 0xB9E9, 0xB9EA, 0xB9E7, 0xB9EB, 0xBC66,
    0xD8D0, 0xBC67, 0xBC65, 0xBC64, 0xE95D, 0xBEC8, 0xECD8, 0xECD9,
    0xC364, 0xC45F, 0xA46F, 0xA678, 0xABCA, 0xD169, 0xAE67, 0xB14E,
    0xB14D, 0xB14C, 0xB44C, 0xB44D, 0xD8D7, 0xB9EF, 0xBEC9, 0xA470,
    0xC95C, 0xA4D6, 0xC974, 0xC9D4, 0xA679, 0xA97C, 0xDD4B, 0xA471,
    0xA4D7, 0xC9D5, 0xCABE, 0xCABF, 0xA7BC, 0xD8D8, 0xB44E, 0xDD4C,
    0xC0AA, 0xA472, 0xA4A8, 0xA4D8, 0xC975, 0xA5A7, 0xA7C0, 0xA7BF,
    0xA7BD, 0xA7BE, 0xCC59, 0xA97E, 0xA9A1, 0xCC5A, 0xA97D, 0xABCE,
    0xCE78, 0xABCD, 0xABCB, 0xABCC, 0xAE6A, 0xAE68, 0xD16B, 0xAE69,
    0xD16A, 0xAE5E, 0xD4F3, 0xB150, 0xB151, 0xB14F, 0xB9F0, 0xE1A2,
    0xBC68, 0xBC69, 0xE561, 0xC0AB, 0xEFC2, 0xEFC3, 0xC4DD, 0xF8A8,
    0xC94B, 0xA4D9, 0xA473, 0xC977, 0xC976, 0xA67A, 0xC9D7, 0xC9D8,
    0xC9D6, 0xC9D9, 0xCAC7, 0xCAC2, 0xCAC4, 0xCAC6, 0xCAC3, 0xA7C4,
    0xCAC0, 0xCAC1, 0xA7C1, 0xA7C2, 0xCAC5, 0xCAC8, 0xA7C3, 0xCAC9,
    0xCC68, 0xCC62, 0xCC5D, 0xA9A3, 0xCC65, 0xCC63, 0xCC5C, 0xCC69,
    0xCC6C, 0xCC67, 0xCC60, 0xA9A5, 0xCC66, 0xA9A6, 0xCC61, 0xCC64,
    0xCC5B, 0xCC5F, 0xCC6B, 0xA9A7, 0xA9A8, 0xCC5E, 0xCC6A, 0xA9A2,
    0xA9A4, 0xCEAB, 0xCEA4, 0xCEAA, 0xCEA3, 0xCEA5, 0xCE7D, 0xCE7B,
    0xCEAC, 0xCEA9, 0xCE79, 0xABD0, 0xCEA7, 0xCEA8, 0xCEA6, 0xCE7C,
    0xCE7A, 0xABCF, 0xCEA2, 0xCE7E, 0xCEA1, 0xCEAD, 0xAE6F, 0xAE6E,
    0xD16C, 0xAE6B, 0xD16E, 0xAE70, 0xD16F, 0xAE73, 0xAE71, 0xD170,
    0xCEAE, 0xD172, 0xAE6D, 0xAE6C, 0xD16D, 0xD171, 0xAE72, 0xB153,
    0xB152, 0xD4F5, 0xD4F9, 0xD4FB, 0xB154, 0xD4FE, 0xB158, 0xD541,
    0xB15A, 0xB156, 0xB15E, 0xB15B, 0xD4F7, 0xB155, 0xD4F6, 0xD4F4,
    0xD543, 0xD4F8, 0xB157, 0xD542, 0xB15C, 0xD4FD, 0xD4FC, 0xB15D,
    0xD4FA, 0xB159, 0xD544, 0xD540, 0xD8E7, 0xD8EE, 0xD8E3, 0xB451,
    0xD8DF, 0xD8EF, 0xD8D9, 0xD8EC, 0xD8EA, 0xD8E4, 0xD8ED, 0xD8E6,
    0xD8DE, 0xD8F0, 0xD8DC, 0xD8E9, 0xD8DA, 0xD8F1, 0xB452, 0xD8EB,
    0xDD4F, 0xD8DD, 0xB44F, 0xD8E1, 0xB450, 0xD8E0, 0xD8E5, 0xD8E2,
    0xD8E8, 0xDD53, 0xDD56, 0xDD4E, 0xDD50, 0xDD55, 0xDD54, 0xB743,
    0xD8DB, 0xDD52, 0xB744, 0xDD4D, 0xDD51, 0xE1A9, 0xE1B0, 0xE1A7,
    0xE1AE, 0xE1A5, 0xE1AD, 0xE1B1, 0xE1A4, 0xE1A8, 0xE1A3, 0xB9F1,
    0xE1A6, 0xB9F2, 0xE1AC, 0xE1AB, 0xE1AA, 0xE1AF, 0xE565, 0xE567,
    0xBC6B, 0xE568, 0xE563, 0xE562, 0xE56C, 0xE56A, 0xBC6A, 0xE56D,
    0xE564, 0xE569, 0xE56B, 0xE566, 0xE961, 0xE966, 0xE960, 0xE965,
    0xE95E, 0xE968, 0xE964, 0xE969, 0xE963, 0xE95F, 0xE967, 0xE96A,
    0xE962, 0xECDA, 0xC0AF, 0xC0AD, 0xC0AC, 0xC0AE, 0xEFC4, 0xF172,
    0xF1FD, 0xF444, 0xF445, 0xC460, 0xF5C9, 0xC4DE, 0xF5CA, 0xF6DE,
    0xC572, 0xC571, 0xF6DD, 0xC5C9, 0xF7D6, 0xA474, 0xA67B, 0xC9DA,
    0xCACA, 0xA8B5, 0xB15F, 0xA475, 0xA5AA, 0xA5A9, 0xA5A8, 0xA7C5,
    0xAE74, 0xDD57, 0xA476, 0xA477, 0xA478, 0xA4DA, 0xABD1, 0xCEAF,
    0xB453, 0xA479, 0xC95D, 0xA5AB, 0xA5AC, 0xC978, 0xA67C, 0xCACB,
    0xA7C6, 0xCACC, 0xA9AE, 0xCC6E, 0xA9AC, 0xA9AB, 0xCC6D, 0xA9A9,
    0xCC6F, 0xA9AA, 0xA9AD, 0xABD2, 0xABD4, 0xCEB3, 0xCEB0, 0xCEB1,
    0xCEB2, 0xCEB4, 0xABD3, 0xD174, 0xD173, 0xAE76, 0xAE75, 0xB162,
    0xD546, 0xB161, 0xB163, 0xB160, 0xB455, 0xD545, 0xB456, 0xD8F3,
    0xB457, 0xD8F2, 0xB454, 0xDD5A, 0xDD5C, 0xB745, 0xDD5B, 0xDD59,
    0xDD58, 0xE1B4, 0xB9F7, 0xB9F5, 0xB9F6, 0xE1B2, 0xE1B3, 0xB9F3,
    0xE571, 0xE56F, 0xBC6D, 0xE570, 0xBC6E, 0xBC6C, 0xB9F4, 0xE96D,
    0xE96B, 0xE96C, 0xE56E, 0xECDC, 0xC0B0, 0xECDB, 0xEFC5, 0xEFC6,
    0xE96E, 0xF1FE, 0xA47A, 0xA5AD, 0xA67E, 0xC9DB, 0xA67D, 0xA9AF,
    0xB746, 0xA4DB, 0xA5AE, 0xABD5, 0xB458, 0xC979, 0xC97A, 0xC9DC,
    0xA7C8, 0xCAD0, 0xCACE, 0xA7C9, 0xCACD, 0xCACF, 0xCAD1, 0xA7C7,
    0xA9B3, 0xA9B4, 0xA9B1, 0xA9B0, 0xCEB8, 0xA9B2, 0xABD6, 0xCEB7,
    0xCEB9, 0xCEB6, 0xCEBA, 0xABD7, 0xAE79, 0xD175, 0xD177, 0xAE77,
    0xD178, 0xAE78, 0xD176, 0xCEB5, 0xD547, 0xD54A, 0xD54B, 0xD548,
    0xB167, 0xB166, 0xB164, 0xB165, 0xD549, 0xB168, 0xB45A, 0xB45B,
    0xB45C, 0xDD5D, 0xDD5F, 0xDD61, 0xB748, 0xB747, 0xB459, 0xDD60,
    0xDD5E, 0xE1B8, 0xE1B6, 0xE1BC, 0xB9F8, 0xE1BD, 0xE1BA, 0xB9F9,
    0xE1B7, 0xE1B5, 0xE1BB, 0xBC70, 0xE573, 0xE1B9, 0xBC72, 0xE574,
    0xBC71, 0xBC74, 0xE575, 0xBC6F, 0xBC73, 0xE973, 0xE971, 0xE970,
    0xE972, 0xE96F, 0xC366, 0xF446, 0xF447, 0xF5CB, 0xF6DF, 0xC655,
    0xA9B5, 0xA7CA, 0xABD8, 0xA47B, 0xA4DC, 0xA5AF, 0xC9DD, 0xA7CB,
    0xCAD2, 0xCEBB, 0xABD9, 0xB9FA, 0xA47C, 0xA6A1, 0xB749, 0xA47D,
    0xA4DD, 0xA4DE, 0xA5B1, 0xA5B0, 0xC9DE, 0xA6A2, 0xCAD3, 0xA7CC,
    0xCC71, 0xCC72, 0xCC73, 0xA9B6, 0xA9B7, 0xCC70, 0xA9B8, 0xABDA,
    0xCEBC, 0xD17A, 0xAE7A, 0xD179, 0xB169, 0xD54C, 0xB16A, 0xD54D,
    0xB45D, 0xDD62, 0xE1BF, 0xE1BE, 0xB9FB, 0xBC75, 0xE576, 0xBECA,
    0xE974, 0xC0B1, 0xC573, 0xF7D8, 0xCC74, 0xCEBD, 0xB16B, 0xD8F4,
    0xB74A, 0xC255, 0xA7CE, 0xA7CD, 0xABDB, 0xD17B, 0xB16D, 0xB343,
    0xB16E, 0xB16C, 0xB45E, 0xE1C0, 0xB9FC, 0xBC76, 0xC94C, 0xC9DF,
    0xCAD5, 0xA7CF, 0xCAD4, 0xA7D0, 0xA9BC, 0xCC77, 0xCC76, 0xA9BB,
    0xA9B9, 0xA9BA, 0xCC75, 0xABDD, 0xCEBE, 0xABE0, 0xABDC, 0xABE2,
    0xABDE, 0xABDF, 0xABE1, 0xAE7D, 0xAE7C, 0xAE7B, 0xD54F, 0xB16F,
    0xB172, 0xB170, 0xD54E, 0xB175, 0xB171, 0xD550, 0xB174, 0xB173,
    0xD8F6, 0xD8F5, 0xB461, 0xB45F, 0xB460, 0xD8F7, 0xB74B, 0xDD64,
    0xB74C, 0xDD63, 0xE577, 0xBC78, 0xE1C1, 0xBC77, 0xB9FD, 0xECDE,
    0xE975, 0xC0B2, 0xECDD, 0xF240, 0xF448, 0xF449, 0xA4DF, 0xA5B2,
    0xC97B, 0xA7D2, 0xA7D4, 0xC9E2, 0xCAD8, 0xCAD7, 0xCAD6, 0xC9E1,
    0xC9E0, 0xA6A4, 0xA7D3, 0xA7D1, 0xA6A3, 0xA9BD, 0xCC78, 0xA9BE,
    0xCADD, 0xCADF, 0xCADE, 0xCC79, 0xCADA, 0xA7D8, 0xA7D6, 0xCAD9,
    0xCADB, 0xCAE1, 0xA7D5, 0xCADC, 0xCAE5, 0xA9C0, 0xCAE2, 0xA7D7,
    0xCAE0, 0xCAE3, 0xA9BF, 0xA9C1, 0xCAE4, 0xCCAF, 0xCCA2, 0xCC7E,
    0xCCAE, 0xCCA9, 0xABE7, 0xA9C2, 0xCCAA, 0xCCAD, 0xABE3, 0xCCAC,
    0xA9C3, 0xA9C8, 0xA9C6, 0xCCA3, 0xCC7C, 0xCCA5, 0xA9CD, 0xCCB0,
    0xABE4, 0xCCA6, 0xABE5, 0xA9C9, 0xCCA8, 0xCECD, 0xABE6, 0xCC7B,
    0xA9CA, 0xABE8, 0xA9CB, 0xA9C7, 0xA9CC, 0xCCA7, 0xCC7A, 0xCCAB,
    0xA9C4, 0xCC7D, 0xCCA4, 0xCCA1, 0xA9C5, 0xCEBF, 0xCEC0, 0xCECA,
    0xD1A1, 0xCECB, 0xABEE, 0xCECE, 0xCEC4, 0xABED, 0xCEC6, 0xCEC7,
    0xCEC9, 0xABE9, 0xAEA3, 0xCEC5, 0xCEC1, 0xAEA4, 0xCECF, 0xAE7E,
    0xD17D, 0xCEC8, 0xD17C, 0xCEC3, 0xCECC, 0xABEC, 0xAEA1, 0xABF2,
    0xAEA2, 0xCED0, 0xD17E, 0xABEB, 0xAEA6, 0xABF1, 0xABF0, 0xABEF,
    0xAEA5, 0xCED1, 0xAEA7, 0xABEA, 0xCEC2, 0xB176, 0xD1A4, 0xD1A6,
    0xD1A8, 0xAEA8, 0xAEAE, 0xD553, 0xD1AC, 0xD1A3, 0xB178, 0xD551,
    0xAEAD, 0xAEAB, 0xD1AE, 0xD552, 0xD1A5, 0xAEAC, 0xD1A9, 0xAEAF,
    0xD1AB, 0xAEAA, 0xD1AA, 0xD1AD, 0xD1A7, 0xAEA9, 0xB179, 0xD1A2,
    0xB177, 0xB17A, 0xD555, 0xD55E, 0xB464, 0xB17C, 0xB1A3, 0xB465,
    0xD560, 0xB1AA, 0xD8F9, 0xD556, 0xB1A2, 0xB1A5, 0xB17E, 0xD554,
    0xD562, 0xD565, 0xD949, 0xD563, 0xD8FD, 0xB1A1, 0xB1A8, 0xB1AC,
    0xD55D, 0xD8F8, 0xD561, 0xB17B, 0xD8FA, 0xD564, 0xD8FC, 0xD559,
    0xB462, 0xD557, 0xD558, 0xB1A7, 0xB1A6, 0xD55B, 0xB1AB, 0xD55F,
    0xB1A4, 0xD55C, 0xB1A9, 0xB466, 0xB463, 0xD8FB, 0xD55A, 0xB17D,
    0xB46B, 0xB46F, 0xD940, 0xB751, 0xB46D, 0xD944, 0xB471, 0xDD65,
    0xD946, 0xB753, 0xB469, 0xB46C, 0xD947, 0xD948, 0xD94E, 0xB473,
    0xB754, 0xD94A, 0xD94F, 0xD943, 0xB75E, 0xB755, 0xB472, 0xD941,
    0xD950, 0xB75D, 0xB470, 0xB74E, 0xD94D, 0xB474, 0xD945, 0xD8FE,
    0xB46A, 0xD942, 0xD94B, 0xB74D, 0xB752, 0xB467, 0xD94C, 0xB750,
    0xB468, 0xB75C, 0xE1C3, 0xDD70, 0xDD68, 0xE1C2, 0xDD6C, 0xDD6E,
    0xDD6B, 0xB75B, 0xDD6A, 0xB75F, 0xE1D2, 0xB75A, 0xBA40, 0xDD71,
    0xE1C4, 0xB758, 0xDD69, 0xDD6D, 0xB9FE, 0xB74F, 0xDD66, 0xDD67,
    0xBA41, 0xB757, 0xB759, 0xB756, 0xDD6F, 0xE1C8, 0xE1C9, 0xE1CE,
    0xBC7D, 0xE1D5, 0xBA47, 0xBA46, 0xE1D0, 0xBC7C, 0xE1C5, 0xBA45,
    0xE1D4, 0xBA43, 0xBA44, 0xE1D1, 0xE5AA, 0xBC7A, 0xB46E, 0xE1D3,
    0xBCA3, 0xE1CB, 0xBC7B, 0xBCA2, 0xE1C6, 0xE1CA, 0xE1C7, 0xE1CD,
    0xBA48, 0xBC79, 0xBA42, 0xE57A, 0xE1CF, 0xBCA1, 0xBCA4, 0xE1CC,
    0xBC7E, 0xE579, 0xE57E, 0xBECE, 0xE578, 0xE9A3, 0xE5A9, 0xBCA8,
    0xBCA6, 0xBECC, 0xE5A6, 0xE5A2, 0xBCAC, 0xE978, 0xBCAA, 0xE5A1,
    0xE976, 0xE5A5, 0xE5A8, 0xE57D, 0xBCAB, 0xBCA5, 0xE977, 0xBECD,
    0xE5A7, 0xBCA7, 0xBCA9, 0xE5A4, 0xBCAD, 0xE5A3, 0xE57C, 0xE57B,
    0xBECB, 0xE5AB, 0xE97A, 0xECE0, 0xBED0, 0xE9A2, 0xE97E, 0xECE1,
    0xBED1, 0xE9A1, 0xE97C, 0xC0B4, 0xECDF, 0xE979, 0xE97B, 0xC0B5,
    0xBED3, 0xC0B3, 0xBED2, 0xC0B7, 0xE97D, 0xBECF, 0xEFCF, 0xEFC7,
    0xECE7, 0xEFC8, 0xECE3, 0xC256, 0xECE5, 0xECE4, 0xC0B6, 0xECE2,
    0xECE6, 0xEFD0, 0xEFCC, 0xEFCE, 0xEFC9, 0xEFCA, 0xEFCD, 0xEFCB,
    0xC367, 0xC36A, 0xC369, 0xC368, 0xC461, 0xF44A, 0xC462, 0xF241,
    0xC4DF, 0xF5CC, 0xC4E0, 0xC574, 0xC5CA, 0xF7D9, 0xF7DA, 0xF7DB,
    0xF9BA, 0xA4E0, 0xC97C, 0xA5B3, 0xA6A6, 0xA6A7, 0xA6A5, 0xA6A8,
    0xA7DA, 0xA7D9, 0xCCB1, 0xA9CF, 0xA9CE, 0xD1AF, 0xB1AD, 0xB1AE,
    0xB475, 0xDD72, 0xB760, 0xB761, 0xDD74, 0xDD76, 0xDD75, 0xE1D7,
    0xE1D6, 0xBA49, 0xE1D8, 0xE5AC, 0xBCAE, 0xBED4, 0xC0B8, 0xC257,
    0xC0B9, 0xA4E1, 0xCAE6, 0xCCB2, 0xA9D1, 0xA9D0, 0xA9D2, 0xABF3,
    0xCED2, 0xCED3, 0xD1B0, 0xAEB0, 0xB1AF, 0xB476, 0xD951, 0xA4E2,
    0xA47E, 0xA4E3, 0xC97D, 0xA5B7, 0xA5B6, 0xA5B4, 0xA5B5, 0xA6AB,
    0xC9E9, 0xC9EB, 0xA6AA, 0xC9E3, 0xC9E4, 0xC9EA, 0xC9E6, 0xC9E8,
    0xA6A9, 0xC9E5, 0xC9EC, 0xC9E7, 0xA7E1, 0xA7EA, 0xA7E8, 0xCAF0,
    0xCAED, 0xCAF5, 0xA7E6, 0xCAF6, 0xA7DF, 0xCAF3, 0xA7E5, 0xCAEF,
    0xCAEE, 0xA7E3, 0xCAF4, 0xA7E4, 0xA9D3, 0xA7DE, 0xCAF1, 0xCAE7,
    0xA7DB, 0xA7EE, 0xCAEC, 0xCAF2, 0xA7E0, 0xA7E2, 0xCAE8, 0xCAE9,
    0xCAEA, 0xA7ED, 0xA7E7, 0xA7EC, 0xCAEB, 0xA7EB, 0xA7DD, 0xA7DC,
    0xA7E9, 0xA9E1, 0xCCBE, 0xCCB7, 0xA9DC, 0xA9EF, 0xCCB3, 0xCCBA,
    0xCCBC, 0xCCBF, 0xA9EA, 0xCCBB, 0xCCB4, 0xA9E8, 0xCCB8, 0xCCC0,
    0xA9D9, 0xCCBD, 0xA9E3, 0xA9E2, 0xCCB6, 0xA9D7, 0xA9D8, 0xA9D6,
    0xA9EE, 0xA9E6, 0xA9E0, 0xA9D4, 0xCCB9, 0xA9DF, 0xA9D5, 0xA9E7,
    0xA9F0, 0xCED4, 0xA9E4, 0xCCB5, 0xA9DA, 0xA9DD, 0xA9DE, 0xA9EC,
    0xA9ED, 0xA9EB, 0xA9E5, 0xA9E9, 0xA9DB, 0xABF4, 0xCEDA, 0xAC41,
    0xABF8, 0xABFA, 0xAC40, 0xCEE6, 0xABFD, 0xD1B1, 0xAEB1, 0xAC43,
    0xCED7, 0xCEDF, 0xABFE, 0xCEDE, 0xCEDB, 0xCEE3, 0xCEE5, 0xABF7,
    0xABFB, 0xAC42, 0xAEB3, 0xCEE0, 0xABF9, 0xAC45, 0xCED9, 0xABFC,
    0xAEB2, 0xABF6, 0xCED6, 0xCEDD, 0xCED5, 0xCED8, 0xCEDC, 0xD1B2,
    0xAC44, 0xCEE1, 0xCEE2, 0xCEE4, 0xABF5, 0xAEC1, 0xD1BE, 0xAEBF,
    0xAEC0, 0xD1B4, 0xD1C4, 0xAEB6, 0xD566, 0xD1C6, 0xD1C0, 0xD1B7,
    0xD1C9, 0xD1BA, 0xAEBC, 0xD57D, 0xD1BD, 0xAEBE, 0xAEB5, 0xD1CB,
    0xD1BF, 0xAEB8, 0xD1B8, 0xD1B5, 0xD1B6, 0xAEB9, 0xD1C5, 0xD1CC,
    0xAEBB, 0xD1BC, 0xD1BB, 0xAEC3, 0xAEC2, 0xAEB4, 0xAEBA, 0xAEBD,
    0xD1C8, 0xD1C2, 0xAEB7, 0xD1B3, 0xD1CA, 0xD1C1, 0xD1C3, 0xD1C7,
    0xD567, 0xB1B7, 0xB1CB, 0xB1CA, 0xB1BF, 0xD579, 0xD575, 0xD572,
    0xD5A6, 0xB1BA, 0xB1B2, 0xD577, 0xB4A8, 0xB1B6, 0xD5A1, 0xB1CC,
    0xB1C9, 0xD57B, 0xD56A, 0xB1C8, 0xD5A3, 0xD569, 0xB1BD, 0xB1C1,
    0xD5A2, 0xD573, 0xB1C2, 0xB1BC, 0xD568, 0xB478, 0xD5A5, 0xD571,
    0xB1C7, 0xD574, 0xD5A4, 0xB1C6, 0xD952, 0xB1B3, 0xD56F, 0xB1B8,
    0xB1C3, 0xB1BE, 0xD578, 0xD56E, 0xD56C, 0xD57E, 0xB1B0, 0xB1C4,
    0xB1B4, 0xB477, 0xD57C, 0xB1B5, 0xB1B1, 0xB1C0, 0xB1BB, 0xB1B9,
    0xD570, 0xB1C5, 0xD56D, 0xD57A, 0xD576, 0xD954, 0xD953, 0xD56B,
    0xD964, 0xB47A, 0xD96A, 0xD959, 0xD967, 0xDD77, 0xB47D, 0xD96B,
    0xD96E, 0xB47C, 0xD95C, 0xD96D, 0xD96C, 0xB47E, 0xD955, 0xB479,
    0xB4A3, 0xB4A1, 0xD969, 0xD95F, 0xB4A5, 0xD970, 0xD968, 0xD971,
    0xB4AD, 0xB4AB, 0xD966, 0xD965, 0xD963, 0xD95D, 0xB4A4, 0xB4A2,
    0xD1B9, 0xD956, 0xDDB7, 0xD957, 0xB47B, 0xB4AA, 0xDD79, 0xB4A6,
    0xB4A7, 0xD958, 0xD96F, 0xDD78, 0xD960, 0xD95B, 0xB4A9, 0xD961,
    0xD95E, 0xB4AE, 0xB770, 0xDD7C, 0xDDB1, 0xDDB6, 0xDDAA, 0xB76C,
    0xDDBB, 0xB769, 0xDD7A, 0xDD7B, 0xB762, 0xB76B, 0xDDA4, 0xB76E,
    0xB76F, 0xDDA5, 0xDDB2, 0xDDB8, 0xB76A, 0xB764, 0xDDA3, 0xDD7D,
    0xDDBA, 0xDDA8, 0xDDA9, 0xDD7E, 0xDDB4, 0xDDAB, 0xDDB5, 0xDDAD,
    0xB765, 0xE1D9, 0xB768, 0xB766, 0xDDB9, 0xDDB0, 0xDDAC, 0xDDA1,
    0xBA53, 0xDDAF, 0xB76D, 0xDDA7, 0xDDA6, 0xB767, 0xB763, 0xE1EE,
    0xDDB3, 0xDDAE, 0xDDA2, 0xE1E9, 0xE1DA, 0xE1E5, 0xE1EC, 0xBA51,
    0xB4AC, 0xE1EA, 0xBA4C, 0xBA4B, 0xE1F1, 0xE1DB, 0xE1E8, 0xE1DC,
    0xE1E7, 0xBA4F, 0xE1EB, 0xD962, 0xE1F2, 0xE1E3, 0xBA52, 0xE5BA,
    0xBCAF, 0xE1F0, 0xE1EF, 0xBA54, 0xE5AD, 0xBCB0, 0xE5AE, 0xE1DF,
    0xE1E0, 0xE1DD, 0xE1E2, 0xE1DE, 0xE1F3, 0xBA4E, 0xBCB1, 0xBA50,
    0xBA55, 0xE1E1, 0xE1ED, 0xE1E6, 0xE5B1, 0xBA4A, 0xBCB4, 0xE9AA,
    0xE5B6, 0xE5B5, 0xE5B7, 0xE5B4, 0xBCB5, 0xBCBB, 0xBCB8, 0xBCB9,
    0xE5AF, 0xE5B2, 0xE5BC, 0xBCC1, 0xBCBF, 0xE5B3, 0xD95A, 0xBCB2,
    0xE5B9, 0xE5B0, 0xBCC2, 0xE5B8, 0xBA4D, 0xBCB7, 0xE1E4, 0xBCBA,
    0xBCBE, 0xBCC0, 0xBCBD, 0xBCBC, 0xBCB6, 0xE5BB, 0xBCB3, 0xBCC3,
    0xBED8, 0xBED9, 0xE9A9, 0xBEE2, 0xBEDF, 0xBED6, 0xBEDD, 0xE9AB,
    0xBEDB, 0xBED5, 0xBEDC, 0xE9A8, 0xC0BB, 0xBED7, 0xBEDE, 0xC0BA,
    0xE9A7, 0xE9A6, 0xBEE0, 0xBEE1, 0xE9A5, 0xE9A4, 0xC0BC, 0xE9AE,
    0xBEDA, 0xE9AC, 0xC0BD, 0xC0C2, 0xECEA, 0xECEC, 0xC0BF, 0xECED,
    0xECE9, 0xECEB, 0xC0C0, 0xC0C3, 0xECE8, 0xC0BE, 0xC0C1, 0xC259,
    0xE9AD, 0xC258, 0xC25E, 0xEFD4, 0xC25C, 0xC25D, 0xEFD7, 0xEFD3,
    0xC25A, 0xEFD1, 0xC36B, 0xEFD5, 0xEFD6, 0xEFD2, 0xC25B, 0xF242,
    0xF245, 0xF246, 0xF244, 0xF247, 0xC36C, 0xF243, 0xF44E, 0xC464,
    0xF44D, 0xF44C, 0xF44B, 0xC463, 0xC465, 0xF5CD, 0xC4E2, 0xC4E1,
    0xF6E1, 0xF6E0, 0xF6E3, 0xC5CB, 0xC575, 0xF7DD, 0xF6E2, 0xF7DC,
    0xC5CD, 0xC5CC, 0xC5F3, 0xF8A9, 0xF8EF, 0xA4E4, 0xD972, 0xE9AF,
    0xA6AC, 0xCAF7, 0xA7F1, 0xA7EF, 0xA7F0, 0xCCC1, 0xA9F1, 0xAC46,
    0xCEE7, 0xCEE8, 0xAC47, 0xD1CE, 0xAEC4, 0xAEC5, 0xD1CD, 0xB1D3,
    0xB1CF, 0xD5A7, 0xB1D6, 0xB1D5, 0xB1CE, 0xB1D1, 0xB1D4, 0xB1D0,
    0xD976, 0xB1CD, 0xB4AF, 0xB4B1, 0xB4B2, 0xD975, 0xD978, 0xB4B0,
    0xD973, 0xD977, 0xD974, 0xB771, 0xDDBC, 0xBA56, 0xE1F4, 0xBEE3,
    0xBCC4, 0xE5BD, 0xBCC5, 0xBCC6, 0xE5BF, 0xE5BE, 0xE5C0, 0xE9B1,
    0xE9B0, 0xECEF, 0xECEE, 0xC0C4, 0xC0C5, 0xF248, 0xA4E5, 0xD979,
    0xB4B4, 0xB4B3, 0xDDBD, 0xEFD8, 0xC4E3, 0xF7DE, 0xA4E6, 0xAEC6,
    0xB1D8, 0xB1D7, 0xD97A, 0xD97B, 0xB772, 0xE1F5, 0xBA57, 0xE9B2,
    0xA4E7, 0xA5B8, 0xA9F2, 0xCCC2, 0xCEE9, 0xAC48, 0xB1D9, 0xD97C,
    0xB4B5, 0xB773, 0xE5C1, 0xE5C2, 0xECF0, 0xC25F, 0xF8F0, 0xA4E8,
    0xCCC3, 0xA9F3, 0xAC49, 0xCEEA, 0xAEC7, 0xD1D2, 0xD1D0, 0xD1D1,
    0xAEC8, 0xD1CF, 0xB1DB, 0xB1DC, 0xD5A8, 0xB1DD, 0xB1DA, 0xD97D,
    0xD97E, 0xDDBE, 0xBA59, 0xBA58, 0xECF1, 0xEFD9, 0xF24A, 0xF249,
    0xF44F, 0xC95E, 0xAC4A, 0xA4E9, 0xA5B9, 0xA6AE, 0xA6AD, 0xA6AF,
    0xA6B0, 0xC9EE, 0xC9ED, 0xCAF8, 0xA7F2, 0xCAFB, 0xCAFA, 0xCAF9,
    0xCAFC, 0xA9F4, 0xCCC9, 0xCCC5, 0xCCCE, 0xA9FB, 0xA9F9, 0xCCCA,
    0xCCC6, 0xCCCD, 0xA9F8, 0xAA40, 0xCCC8, 0xCCC4, 0xA9FE, 0xCCCB,
    0xA9F7, 0xCCCC, 0xA9FA, 0xA9FC, 0xCCD0, 0xCCCF, 0xCCC7, 0xA9F6,
    0xA9F5, 0xA9FD, 0xCEEF, 0xCEF5, 0xAC50, 0xAC4D, 0xCEEC, 0xCEF1,
    0xAC53, 0xAC4B, 0xCEF0, 0xAC4E, 0xAC51, 0xCEF3, 0xAC4C, 0xCEF8,
    0xAC4F, 0xAC52, 0xCEED, 0xCEF2, 0xCEF6, 0xCEEE, 0xCEEB, 0xCEF7,
    0xCEF4, 0xAED0, 0xAEC9, 0xAECC, 0xAECF, 0xD1D5, 0xAECA, 0xD1D3,
    0xAECE, 0xAECB, 0xD1D6, 0xAECD, 0xD5AC, 0xB1DF, 0xD5AB, 0xD5AD,
    0xB1DE, 0xB1E3, 0xD1D4, 0xD5AA, 0xD5AE, 0xB1E0, 0xD5A9, 0xB1E2,
    0xB1E1, 0xD9A7, 0xD9A2, 0xB4B6, 0xB4BA, 0xB4B7, 0xD9A5, 0xD9A8,
    0xB4B8, 0xB4B9, 0xB4BE, 0xDDC7, 0xD9A6, 0xB4BC, 0xD9A3, 0xD9A1,
    0xB4BD, 0xD9A4, 0xB779, 0xDDBF, 0xB776, 0xB777, 0xB775, 0xDDC4,
    0xDDC3, 0xDDC0, 0xB77B, 0xDDC2, 0xB4BB, 0xDDC6, 0xDDC1, 0xB778,
    0xB774, 0xB77A, 0xDDC5, 0xBA5C, 0xE1F8, 0xE1F7, 0xE1F6, 0xBA5A,
    0xBA5B, 0xE5C5, 0xE5C8, 0xBCC8, 0xBCC7, 0xE5C9, 0xE5C4, 0xBCCA,
    0xE5C6, 0xBCC9, 0xE5C3, 0xE5C7, 0xBEE9, 0xBEE6, 0xE9BB, 0xE9BA,
    0xE9B9, 0xE9B4, 0xE9B5, 0xBEE7, 0xBEE4, 0xBEE8, 0xE9B3, 0xBEE5,
    0xE9B6, 0xE9B7, 0xE9BC, 0xE9B8, 0xECF2, 0xC0C7, 0xEFDC, 0xC0C6,
    0xEFDA, 0xEFDB, 0xC260, 0xC36E, 0xF24B, 0xC36D, 0xF451, 0xF452,
    0xC466, 0xF450, 0xC4E4, 0xF7DF, 0xC5CE, 0xF8AA, 0xF8AB, 0xA4EA,
    0xA6B1, 0xA6B2, 0xA7F3, 0xCCD1, 0xAC54, 0xAED1, 0xB1E4, 0xB0D2,
    0xB4BF, 0xB4C0, 0xB3CC, 0xD9A9, 0xB77C, 0xE1FA, 0xE1F9, 0xA4EB,
    0xA6B3, 0xCCD2, 0xAA42, 0xAA41, 0xCEF9, 0xCEFA, 0xD1D7, 0xD1D8,
    0xAED2, 0xAED3, 0xAED4, 0xD5AF, 0xB1E6, 0xB4C2, 0xB4C1, 0xDDC8,
    0xDF7A, 0xE1FB, 0xE9BD, 0xC261, 0xC467, 0xA4EC, 0xA5BC, 0xA5BD,
    0xA5BB, 0xA5BE, 0xA5BA, 0xA6B6, 0xC9F6, 0xA6B5, 0xA6B7, 0xC9F1,
    0xC9F0, 0xC9F3, 0xC9F2, 0xC9F5, 0xA6B4, 0xC9EF, 0xC9F4, 0xCAFD,
    0xA7FD, 0xCAFE, 0xCB43, 0xA7FC, 0xCB47, 0xCB42, 0xCB45, 0xA7F5,
    0xA7F6, 0xA7F7, 0xA7F8, 0xA840, 0xCB41, 0xA7FA, 0xA841, 0xCB40,
    0xCB46, 0xA7F9, 0xCB44, 0xA7FB, 0xA7F4, 0xA7FE, 0xAA57, 0xCCD4,
    0xAA43, 0xAA4D, 0xAA4E, 0xAA46, 0xAA58, 0xAA48, 0xCCDC, 0xAA53,
    0xCCD7, 0xAA49, 0xCCE6, 0xCCE7, 0xCCDF, 0xCCD8, 0xAA56, 0xCCE4,
    0xAA51, 0xAA4F, 0xCCE5, 0xCCE3, 0xCCDB, 0xCCD3, 0xCCDA, 0xAA4A,
    0xAA50, 0xAA44, 0xCCDE, 0xCCDD, 0xCCD5, 0xAA52, 0xCCE1, 0xCCD6,
    0xAA55, 0xCCE8, 0xAA45, 0xAA4C, 0xCCD9, 0xCCE2, 0xAA54, 0xAA47,
    0xAA4B, 0xCCE0, 0xCF5B, 0xAC5C, 0xAC69, 0xCF56, 0xCF4C, 0xAC62,
    0xCF4A, 0xAC5B, 0xCF45, 0xAC65, 0xCF52, 0xCEFE, 0xCF41, 0xCF44,
    0xCEFB, 0xCF51, 0xCF61, 0xAC60, 0xCF46, 0xCF58, 0xCEFD, 0xCF5F,
    0xCF60, 0xCF63, 0xCF5A, 0xCF4B, 0xCF53, 0xAC66, 0xAC59, 0xAC61,
    0xAC6D, 0xAC56, 0xAC58, 0xCF43, 0xAC6A, 0xAC63, 0xCF5D, 0xCF40,
    0xAC6C, 0xAC67, 0xCF49, 0xAC6B, 0xCF50, 0xCF48, 0xAC64, 0xCF5C,
    0xCF54, 0xAC5E, 0xCF62, 0xCF47, 0xAC5A, 0xCF59, 0xCF4F, 0xAC5F,
    0xCF55, 0xAC57, 0xCEFC, 0xAC68, 0xAEE3, 0xAC5D, 0xCF4E, 0xCF4D,
    0xCF42, 0xCF5E, 0xCF57, 0xAC55, 0xD1EC, 0xAEEA, 0xD1ED, 0xD1E1,
    0xAEDF, 0xAEEB, 0xD1DA, 0xD1E3, 0xD1EB, 0xD1D9, 0xD1F4, 0xAED5,
    0xD1F3, 0xD1EE, 0xD1EF, 0xAEDD, 0xAEE8, 0xD1E5, 0xD1E6, 0xD1F0,
    0xD1E7, 0xD1E2, 0xD1DC, 0xD1DD, 0xD1EA, 0xD1E4, 0xAED6, 0xAEDA,
    0xD1F2, 0xD1DE, 0xAEE6, 0xAEE2, 0xAEE5, 0xAEEC, 0xAEDB, 0xAEE7,
    0xD1E9, 0xAEE9, 0xAED8, 0xAED7, 0xD1DB, 0xD1DF, 0xAEE0, 0xD1F1,
    0xD1E8, 0xD1E0, 0xAEE4, 0xAEE1, 0xAED9, 0xAEDC, 0xD5C4, 0xD5B4,
    0xD5B5, 0xD5B9, 0xD5C8, 0xD5C5, 0xD5BE, 0xD5BD, 0xB1ED, 0xD5C1,
    0xD5D0, 0xD5B0, 0xD5D1, 0xD5C3, 0xD5D5, 0xD5C9, 0xB1EC, 0xD5C7,
    0xB1E7, 0xB1FC, 0xB1F2, 0xB1F6, 0xB1F5, 0xD5B1, 0xD5CE, 0xD5D4,
    0xD5CC, 0xD5D3, 0xD5C0, 0xD5B2, 0xD5D2, 0xD5C2, 0xB1EA, 0xB1F7,
    0xD5CB, 0xB1F0, 0xD5CA, 0xD5B3, 0xB1F8, 0xB1FA, 0xD5CD, 0xB1FB,
    0xB1E9, 0xD5BA, 0xD5CF, 0xB1EF, 0xB1F9, 0xD5BC, 0xD5C6, 0xD5B7,
    0xD5BB, 0xB1F4, 0xD5B6, 0xB1E8, 0xB1F1, 0xB1EE, 0xD5BF, 0xAEDE,
    0xD9C0, 0xB1EB, 0xB1F3, 0xD9C3, 0xD9D9, 0xD9CE, 0xB4D6, 0xB4D1,
    0xD9BD, 0xB4D2, 0xD9CD, 0xD9C6, 0xD9D3, 0xB4CE, 0xD9AB, 0xD9D5,
    0xB4C4, 0xD9B3, 0xB4C7, 0xB4C6, 0xB4D7, 0xD9AD, 0xD9CF, 0xD9D0,
    0xB4C9, 0xB4C5, 0xD9BB, 0xB4D0, 0xD9B6, 0xD9D1, 0xB4CC, 0xD9C9,
    0xD9D6, 0xD9B0, 0xD9B5, 0xD9AF, 0xB4CB, 0xD9C2, 0xDDDE, 0xD9B1,
    0xB4CF, 0xD9BA, 0xD9D2, 0xB4CA, 0xD9B7, 0xD9B4, 0xD9C5, 0xB4CD,
    0xB4C3, 0xB4D9, 0xD9C8, 0xD9C7, 0xD9AC, 0xB4C8, 0xD9D4, 0xD9BC,
    0xD9BE, 0xD9CB, 0xD9CA, 0xD9AA, 0xB4D3, 0xB4D5, 0xD9B2, 0xD9B9,
    0xD9C1, 0xB4D4, 0xD9B8, 0xD9C4, 0xD9D7, 0xD9CC, 0xD9D8, 0xD9AE,
    0xDDF2, 0xB7A6, 0xDDF0, 0xDDDB, 0xDDE0, 0xDDD9, 0xDDEC, 0xDDCB,
    0xDDD2, 0xDDEA, 0xDDF4, 0xDDDC, 0xDDCF, 0xDDE2, 0xDDE7, 0xDDD3,
    0xDDE4, 0xDDD0, 0xDDD7, 0xDDD8, 0xB7A8, 0xDDEB, 0xDDE9, 0xDDCC,
    0xDDEE, 0xDDEF, 0xDDF1, 0xB7AC, 0xB7A4, 0xD5B8, 0xDDD4, 0xDDE6,
    0xDDD5, 0xB7A1, 0xB7B1, 0xDDED, 0xB7AF, 0xB7AB, 0xDDCA, 0xB7A3,
    0xDDCD, 0xB7B0, 0xDDDD, 0xDDC9, 0xB7A9, 0xDDE1, 0xDDD1, 0xB7AA,
    0xDDDA, 0xB77E, 0xB4D8, 0xDDE3, 0xD9BF, 0xDDCE, 0xDDE8, 0xB7A5,
    0xDDE5, 0xB7A2, 0xDDDF, 0xB7AD, 0xDDD6, 0xDDF3, 0xB7A7, 0xDEC6,
    0xB7AE, 0xE24A, 0xE248, 0xE25E, 0xE246, 0xE258, 0xB77D, 0xBA5F,
    0xE242, 0xE25D, 0xE247, 0xE255, 0xBA64, 0xBA5D, 0xE25B, 0xE240,
    0xE25A, 0xBA6F, 0xE251, 0xE261, 0xBA6D, 0xE249, 0xBA5E, 0xE24B,
    0xE259, 0xBA67, 0xE244, 0xBA6B, 0xBA61, 0xE24D, 0xE243, 0xE1FC,
    0xE257, 0xBA68, 0xE260, 0xE1FD, 0xBA65, 0xE253, 0xBA66, 0xE245,
    0xE250, 0xE24C, 0xE24E, 0xBA60, 0xE25F, 0xBA6E, 0xE24F, 0xE262,
    0xE1FE, 0xE254, 0xBA63, 0xBA6C, 0xBA6A, 0xE241, 0xE256, 0xBA69,
    0xBA62, 0xE252, 0xE25C, 0xE5D5, 0xE5D1, 0xE5CD, 0xE5E1, 0xE5DE,
    0xBCCD, 0xE5E5, 0xE5D4, 0xBCD8, 0xE5DB, 0xE5D0, 0xE5DA, 0xBCD5,
    0xE5EE, 0xE5EB, 0xE5DD, 0xE5CE, 0xE5E2, 0xE5E4, 0xBCD1, 0xE5D8,
    0xE5D3, 0xE5CA, 0xBCCE, 0xBCD6, 0xE5E7, 0xBCD7, 0xE5CB, 0xE5ED,
    0xE5E0, 0xE5E6, 0xBCD4, 0xE5E3, 0xE5EA, 0xBCD9, 0xBCD3, 0xE5DC,
    0xE5CF, 0xE5EF, 0xE5CC, 0xE5E8, 0xBCD0, 0xE5D6, 0xE5D7, 0xBCCF,
    0xBCCC, 0xE5D2, 0xBCD2, 0xBCCB, 0xE5E9, 0xE5EC, 0xE5D9, 0xE9CA,
    0xE9C2, 0xE9BE, 0xBEF6, 0xBEEB, 0xBEF0, 0xBEEC, 0xE9CC, 0xE9D7,
    0xBEEA, 0xE9C4, 0xE9CD, 0xE5DF, 0xE9CE, 0xBEF1, 0xE9DD, 0xBEF5,
    0xBEF8, 0xE9C0, 0xBEF4, 0xE9DB, 0xE9DC, 0xE9D2, 0xE9D1, 0xE9C9,
    0xE9D3, 0xE9DA, 0xE9D9, 0xBEEF, 0xBEED, 0xE9CB, 0xE9C8, 0xE9C5,
    0xE9D8, 0xBEF7, 0xE9D6, 0xBEF3, 0xBEF2, 0xE9D0, 0xE9BF, 0xE9C1,
    0xE9C3, 0xE9D5, 0xE9CF, 0xBEEE, 0xE9C6, 0xE9D4, 0xE9C7, 0xC0CF,
    0xED45, 0xC0C8, 0xECF5, 0xED41, 0xC0CA, 0xED48, 0xECFC, 0xECF7,
    0xED49, 0xECF3, 0xECFE, 0xC0D1, 0xED44, 0xED4A, 0xECFD, 0xC0C9,
    0xED40, 0xECF4, 0xC0D0, 0xED47, 0xECF9, 0xC0CC, 0xECFB, 0xECF8,
    0xC0D2, 0xECFA, 0xC0CB, 0xC0CE, 0xED43, 0xECF6, 0xED46, 0xED42,
    0xC263, 0xEFE7, 0xC268, 0xC269, 0xC262, 0xEFE6, 0xEFE3, 0xEFE4,
    0xC266, 0xEFDE, 0xEFE2, 0xC265, 0xEFDF, 0xC267, 0xC264, 0xEFDD,
    0xEFE1, 0xEFE5, 0xF251, 0xF24E, 0xF257, 0xF256, 0xF254, 0xF24F,
    0xC372, 0xF250, 0xC371, 0xC0CD, 0xF253, 0xC370, 0xF258, 0xF252,
    0xF24D, 0xEFE0, 0xC36F, 0xF24C, 0xF456, 0xF455, 0xF255, 0xC468,
    0xF459, 0xF45A, 0xF454, 0xF458, 0xF453, 0xF5D1, 0xF457, 0xC4E7,
    0xC4E5, 0xF5CF, 0xF5D2, 0xF5CE, 0xF5D0, 0xC4E6, 0xF6E5, 0xF6E6,
    0xC576, 0xF6E4, 0xF7E2, 0xC5CF, 0xF7E0, 0xF7E1, 0xF8AC, 0xC656,
    0xF8F3, 0xF8F1, 0xF8F2, 0xF8F4, 0xF9BB, 0xA4ED, 0xA6B8, 0xAA59,
    0xCCE9, 0xCF64, 0xD1F5, 0xD1F7, 0xD1F6, 0xD1F8, 0xB1FD, 0xD5D7,
    0xD1F9, 0xD5D6, 0xD5D8, 0xD5D9, 0xD9DA, 0xB4DB, 0xD9DB, 0xD9DD,
    0xB4DC, 0xB4DA, 0xD9DC, 0xDDFA, 0xDDF8, 0xDDF7, 0xDDF6, 0xDDF5,
    0xB7B2, 0xDDF9, 0xBA70, 0xE263, 0xE265, 0xBA71, 0xE264, 0xBCDB,
    0xBCDA, 0xE5F0, 0xE9DF, 0xE9DE, 0xE9E0, 0xBEF9, 0xED4B, 0xC0D3,
    0xEFE8, 0xC26A, 0xF259, 0xC577, 0xA4EE, 0xA5BF, 0xA6B9, 0xA842,
    0xAA5A, 0xAA5B, 0xAC6E, 0xD1FA, 0xB7B3, 0xE6D1, 0xBEFA, 0xC26B,
    0xA4EF, 0xA6BA, 0xCCEB, 0xAA5C, 0xCCEA, 0xCF65, 0xAC6F, 0xCF66,
    0xAC70, 0xD1FC, 0xAEEE, 0xAEED, 0xD5DE, 0xD5DC, 0xD5DD, 0xD5DB,
    0xD5DA, 0xD9DE, 0xD9E1, 0xB4DE, 0xD9DF, 0xB4DD, 0xD9E0, 0xDDFB,
    0xE266, 0xE267, 0xE268, 0xE5F3, 0xE5F2, 0xBCDC, 0xE5F1, 0xE5F4,
    0xE9E1, 0xE9E2, 0xE9E3, 0xED4C, 0xC0D4, 0xC26C, 0xF25A, 0xC4E8,
    0xC95F, 0xAC71, 0xCF67, 0xAEEF, 0xB1FE, 0xB4DF, 0xD9E2, 0xB7B5,
    0xB7B4, 0xE269, 0xE26A, 0xBCDD, 0xBCDE, 0xE9E5, 0xE9E4, 0xEFE9,
    0xF7E3, 0xA4F0, 0xC960, 0xA5C0, 0xA843, 0xCB48, 0xAC72, 0xB7B6,
    0xA4F1, 0xCF68, 0xAC73, 0xCF69, 0xC0D5, 0xA4F2, 0xCCEC, 0xCF6A,
    0xD242, 0xD241, 0xD1FE, 0xD1FD, 0xD243, 0xD240, 0xB240, 0xB241,
    0xB4E0, 0xD9E3, 0xD9E4, 0xD9E5, 0xDE41, 0xDE42, 0xDE40, 0xDDFD,
    0xDDFE, 0xB7B7, 0xE26B, 0xE5F7, 0xE5F6, 0xE5F5, 0xE5F8, 0xE9E7,
    0xE9E6, 0xBEFB, 0xE9E8, 0xC0D6, 0xED4D, 0xEFEA, 0xF25B, 0xF6E7,
    0xA4F3, 0xA5C2, 0xA5C1, 0xAA5D, 0xC961, 0xC97E, 0xA6BB, 0xC9F7,
    0xCB49, 0xCB4A, 0xAA5E, 0xCCED, 0xAC74, 0xCF6B, 0xCF6C, 0xAEF0,
    0xAEF4, 0xD244, 0xAEF3, 0xAEF1, 0xAEF2, 0xD5DF, 0xB242, 0xB4E3,
    0xB4E1, 0xB4E2, 0xD9E6, 0xBA72, 0xA4F4, 0xC9A1, 0xA5C3, 0xC9A4,
    0xA5C6, 0xC9A3, 0xA5C5, 0xA5C4, 0xA844, 0xC9A2, 0xC9F8, 0xC9FC,
    0xC9FE, 0xCA40, 0xA6C5, 0xA6C6, 0xC9FB, 0xA6C1, 0xC9F9, 0xC9FD,
    0xA6C2, 0xA6BD, 0xA6BE, 0xA6C4, 0xC9FA, 0xA6BC, 0xA845, 0xA6BF,
    0xA6C0, 0xA6C3, 0xCB5B, 0xCB59, 0xCB4C, 0xA851, 0xCB53, 0xA84C,
    0xCB4D, 0xCB55, 0xCB52, 0xA84F, 0xCB51, 0xA856, 0xCB5A, 0xA858,
    0xA85A, 0xCB4B, 0xA84D, 0xCB5C, 0xA854, 0xA857, 0xCD45, 0xA847,
    0xA85E, 0xA855, 0xCB4E, 0xA84A, 0xA859, 0xCB56, 0xA848, 0xA849,
    0xCD43, 0xCB4F, 0xA850, 0xA85B, 0xCB5D, 0xCB50, 0xA84E, 0xA853,
    0xCCEE, 0xA85C, 0xCB57, 0xA852, 0xA85D, 0xA846, 0xCB54, 0xA84B,
    0xCB58, 0xCD44, 0xAA6A, 0xAA7A, 0xCCF5, 0xAA71, 0xCD4B, 0xAA62,
    0xAA65, 0xCD42, 0xCCF3, 0xCCF7, 0xAA6D, 0xAA6F, 0xCCFA, 0xAA76,
    0xAA68, 0xAA66, 0xAA67, 0xAA75, 0xCD47, 0xAA70, 0xCCF9, 0xCCFB,
    0xAA6E, 0xAA73, 0xCCFC, 0xCD4A, 0xAC75, 0xAA79, 0xAA63, 0xCD49,
    0xCD4D, 0xCCF8, 0xCD4F, 0xCD40, 0xAA6C, 0xCCF4, 0xAA6B, 0xAA7D,
    0xAA72, 0xCCF2, 0xCF75, 0xAA78, 0xAA7C, 0xCD41, 0xCD46, 0xAA7E,
    0xAA77, 0xAA69, 0xAA5F, 0xAA64, 0xCCF6, 0xAA60, 0xCD4E, 0xCCF0,
    0xCCEF, 0xCCFD, 0xCCF1, 0xAA7B, 0xAEF5, 0xAA74, 0xCCFE, 0xAA61,
    0xACA6, 0xCD4C, 0xCF7C, 0xCFA1, 0xCFA4, 0xCF77, 0xCFA7, 0xCFAA,
    0xCFAC, 0xCF74, 0xAC76, 0xAC7B, 0xD249, 0xACAD, 0xCFA5, 0xCFAD,
    0xCF7B, 0xCF73, 0xD264, 0xAC7E, 0xCFA2, 0xCF78, 0xCF7A, 0xACA5,
    0xCF7D, 0xAC7D, 0xCF70, 0xCFA8, 0xCFAB, 0xAC7A, 0xACA8, 0xCF6D,
    0xACAA, 0xAC78, 0xACAE, 0xCFA9, 0xCF6F, 0xACAB, 0xD25E, 0xCD48,
    0xAC7C, 0xAC77, 0xCF76, 0xCF6E, 0xACAC, 0xACA4, 0xCFA3, 0xACA9,
    0xACA7, 0xCF79, 0xACA1, 0xCF71, 0xACA2, 0xACA3, 0xCF72, 0xCFA6,
    0xAC79, 0xCF7E, 0xD24C, 0xAEFD, 0xAF43, 0xD255, 0xD25B, 0xD257,
    0xD24A, 0xD24D, 0xD246, 0xD247, 0xAF4A, 0xAEFA, 0xD256, 0xD25F,
    0xAF45, 0xAEF6, 0xAF40, 0xD24E, 0xAF42, 0xD24F, 0xD259, 0xAF44,
    0xD268, 0xD248, 0xAEFC, 0xAEFB, 0xAF48, 0xD245, 0xD266, 0xD25A,
    0xD267, 0xD261, 0xD253, 0xD262, 0xD25C, 0xD265, 0xD263, 0xAF49,
    0xD254, 0xAEF9, 0xAEF8, 0xAF41, 0xAF47, 0xD260, 0xAF46, 0xD251,
    0xB243, 0xD269, 0xD250, 0xD24B, 0xAEFE, 0xAF4B, 0xAEF7, 0xD258,
    0xD25D, 0xB265, 0xD5E1, 0xD5E5, 0xB252, 0xB250, 0xB247, 0xD5E3,
    0xD5E2, 0xB25B, 0xD5E8, 0xB255, 0xD5FA, 0xD647, 0xB244, 0xD5F7,
    0xD5F0, 0xB267, 0xD5E0, 0xD5FC, 0xB264, 0xB258, 0xB263, 0xB24E,
    0xD5EC, 0xD5FE, 0xD5F6, 0xB24F, 0xB249, 0xD645, 0xD5FD, 0xD640,
    0xB251, 0xB259, 0xD642, 0xD5EA, 0xD5FB, 0xD5EF, 0xD644, 0xB25E,
    0xB246, 0xB25C, 0xD5F4, 0xD5F2, 0xD5F3, 0xB253, 0xD5EE, 0xD5ED,
    0xB248, 0xD5E7, 0xD646, 0xB24A, 0xD5F1, 0xB268, 0xB262, 0xD5E6,
    0xB25F, 0xB25D, 0xB266, 0xD5F8, 0xB261, 0xD252, 0xD5F9, 0xB260,
    0xD641, 0xB245, 0xD5F5, 0xB257, 0xD5E9, 0xB256, 0xB254, 0xB24C,
    0xB24B, 0xD9E7, 0xD643, 0xD5EB, 0xD9FC, 0xB24D, 0xB541, 0xB25A,
    0xB4EE, 0xD9F6, 0xB4FC, 0xD9EA, 0xB4EB, 0xB4E7, 0xDA49, 0xB4ED,
    0xB4F1, 0xB4EC, 0xB4F5, 0xDA4D, 0xDA44, 0xD9F1, 0xB4FA, 0xB4F4,
    0xD9FD, 0xB4E4, 0xDA4A, 0xDA43, 0xB4E8, 0xD9F7, 0xB4F7, 0xDA55,
    0xDA56, 0xB4E5, 0xDA48, 0xB4F9, 0xD9FB, 0xD9ED, 0xD9EE, 0xB4FD,
    0xD9F2, 0xD9F9, 0xD9F3, 0xB4FB, 0xB544, 0xD9EF, 0xD9E8, 0xD9E9,
    0xD9EB, 0xB4EA, 0xD9F8, 0xB4F8, 0xB542, 0xD9FA, 0xDA53, 0xDA4B,
    0xB4E6, 0xDA51, 0xB4F2, 0xB4F0, 0xDA57, 0xB4EF, 0xDA41, 0xD9F4,
    0xD9FE, 0xB547, 0xDA45, 0xDA42, 0xD9F0, 0xB543, 0xDA4F, 0xDA4C,
    0xDA54, 0xB4E9, 0xDA40, 0xB546, 0xDA47, 0xB4F3, 0xB4F6, 0xDA46,
    0xB545, 0xD9F5, 0xD5E4, 0xDA50, 0xDA4E, 0xDA52, 0xD9EC, 0xB540,
    0xDE61, 0xDE60, 0xDE46, 0xB7BD, 0xDE5F, 0xDE49, 0xDE4A, 0xB7C7,
    0xDE68, 0xB7C2, 0xDE5E, 0xDE43, 0xB7C8, 0xB7BE, 0xDE52, 0xDE48,
    0xDE4B, 0xDE63, 0xB7B8, 0xDE6A, 0xDE62, 0xB7C1, 0xDE57, 0xB7CC,
    0xB7CB, 0xB7C5, 0xDE69, 0xB7B9, 0xDE55, 0xDE4C, 0xDE59, 0xDE65,
    0xB7CD, 0xB7BB, 0xDE54, 0xDE4D, 0xB7C4, 0xB7C3, 0xDE50, 0xDE5A,
    0xDE64, 0xDE47, 0xDE51, 0xB7BC, 0xDE5B, 0xB7C9, 0xB7C0, 0xDE4E,
    0xB7BF, 0xDE45, 0xDE53, 0xDE67, 0xB4FE, 0xBAB0, 0xDE56, 0xE26C,
    0xDE58, 0xDE66, 0xB7C6, 0xDE4F, 0xB7BA, 0xB7CA, 0xBCF0, 0xDE44,
    0xDE5D, 0xDE5C, 0xE2AA, 0xBAAD, 0xE27D, 0xE2A4, 0xBAA2, 0xE26E,
    0xBAAF, 0xBA77, 0xE26D, 0xE2B0, 0xBAB1, 0xE271, 0xE2A3, 0xE273,
    0xE2B3, 0xE2AF, 0xBA75, 0xBAA1, 0xE653, 0xBAAE, 0xBA7D, 0xE26F,
    0xE2AE, 0xBAA3, 0xE2AB, 0xE2B8, 0xE275, 0xE27E, 0xE2B6, 0xE2AC,
    0xBA7C, 0xE27C, 0xBA76, 0xBA74, 0xBAA8, 0xE27A, 0xE277, 0xE278,
    0xE2B2, 0xE2B7, 0xE2B5, 0xBA7A, 0xE2B9, 0xBA7E, 0xBAA7, 0xE270,
    0xE5FA, 0xE279, 0xBA78, 0xBAAC, 0xBAA9, 0xBA7B, 0xE2A5, 0xE274,
    0xBAAA, 0xE2A7, 0xBAA4, 0xBAA6, 0xBA73, 0xE2A9, 0xE2A1, 0xE272,
    0xBAA5, 0xE2B1, 0xE2B4, 0xE27B, 0xE2A8, 0xBA79, 0xBCDF, 0xE2A6,
    0xE5F9, 0xE2AD, 0xE276, 0xE644, 0xE64E, 0xBCE2, 0xE64D, 0xE659,
    0xBCE4, 0xE64B, 0xE64F, 0xBCEF, 0xE646, 0xBCE7, 0xE652, 0xE9F0,
    0xBCF3, 0xBCF2, 0xE654, 0xE643, 0xE65E, 0xBCED, 0xBCE3, 0xE657,
    0xE65B, 0xE660, 0xE655, 0xE649, 0xBCE6, 0xBCE9, 0xBCF1, 0xBCEC,
    0xE64C, 0xE2A2, 0xE648, 0xE65F, 0xBCE8, 0xBCEB, 0xE661, 0xBCE0,
    0xE656, 0xE5FB, 0xE65C, 0xC0DF, 0xE64A, 0xBCE1, 0xE645, 0xBCE5,
    0xE5FC, 0xBAAB, 0xE641, 0xE65A, 0xE642, 0xE640, 0xBCEA, 0xE658,
    0xE5FE, 0xE651, 0xE650, 0xE65D, 0xE647, 0xBCEE, 0xE9F3, 0xBF49,
    0xBEFE, 0xEA40, 0xE9EB, 0xBF41, 0xE9F7, 0xBF48, 0xBF43, 0xE9F5,
    0xED4F, 0xE9FB, 0xEA42, 0xE9FA, 0xE9E9, 0xE9F8, 0xEA44, 0xEA46,
    0xBEFD, 0xEA45, 0xBF44, 0xBF4A, 0xBF47, 0xE9FE, 0xBF46, 0xE9F9,
    0xE9ED, 0xE9F2, 0xE9FD, 0xBF45, 0xBF42, 0xBEFC, 0xBF40, 0xE9F1,
    0xE5FD, 0xE9EC, 0xE9EF, 0xEA41, 0xE9F4, 0xE9EA, 0xED4E, 0xEA43,
    0xE9EE, 0xE9FC, 0xED51, 0xC0E3, 0xC0D7, 0xC0DB, 0xED53, 0xED59,
    0xED57, 0xC0D9, 0xC0DA, 0xC0E1, 0xED5A, 0xED52, 0xC0DC, 0xED56,
    0xED55, 0xED5B, 0xC0E2, 0xC0DD, 0xC0E0, 0xED54, 0xC0E4, 0xC0DE,
    0xC0E5, 0xC0D8, 0xED58, 0xED50, 0xEFF7, 0xC271, 0xEFF4, 0xEFF6,
    0xC26F, 0xEFF2, 0xEFF3, 0xEFEE, 0xE9F6, 0xEFEF, 0xC270, 0xEFEB,
    0xC26D, 0xEFF8, 0xC26E, 0xEFEC, 0xEFED, 0xEFF1, 0xC273, 0xC272,
    0xEFF0, 0xC378, 0xF25F, 0xF265, 0xC379, 0xF25C, 0xC376, 0xC373,
    0xF267, 0xC377, 0xC374, 0xF25E, 0xF261, 0xF262, 0xF263, 0xF266,
    0xEFF5, 0xF25D, 0xC375, 0xF264, 0xF268, 0xF260, 0xF45D, 0xC46A,
    0xF460, 0xC46B, 0xF468, 0xF45F, 0xF45C, 0xF45E, 0xF462, 0xF465,
    0xF464, 0xF467, 0xF45B, 0xC469, 0xF463, 0xF466, 0xF469, 0xF461,
    0xF5D3, 0xF5D4, 0xF5D8, 0xF5D9, 0xF5D6, 0xF5D7, 0xF5D5, 0xC4E9,
    0xC578, 0xF6EB, 0xF6E8, 0xF6E9, 0xF6EA, 0xC579, 0xF7E5, 0xF7E4,
    0xF8AF, 0xC5F4, 0xF8AD, 0xF8B0, 0xF8AE, 0xF8F5, 0xC657, 0xC665,
    0xF9A3, 0xF96C, 0xF9A2, 0xF9D0, 0xF9D1, 0xA4F5, 0xA6C7, 0xCA41,
    0xCB5E, 0xA85F, 0xA862, 0xCB5F, 0xA860, 0xA861, 0xCD58, 0xCD5A,
    0xCD55, 0xCD52, 0xCD54, 0xAAA4, 0xAAA2, 0xCD56, 0xAAA3, 0xCD53,
    0xCD50, 0xAAA1, 0xCD57, 0xCD51, 0xAAA5, 0xCD59, 0xCFAF, 0xCFB3,
    0xACB7, 0xCFB6, 0xACAF, 0xACB2, 0xACB4, 0xACB6, 0xACB3, 0xCFB2,
    0xCFB1, 0xACB1, 0xCFB4, 0xCFB5, 0xCFAE, 0xACB5, 0xACB0, 0xCFB0,
    0xD277, 0xD278, 0xD279, 0xAF50, 0xAF4C, 0xD26E, 0xD276, 0xD27B,
    0xAF51, 0xD26C, 0xD272, 0xD26B, 0xD275, 0xD271, 0xAF4D, 0xAF4F,
    0xD27A, 0xD26A, 0xD26D, 0xD273, 0xD274, 0xD27C, 0xD270, 0xAF4E,
    0xB26D, 0xD64E, 0xD650, 0xD64C, 0xD658, 0xD64A, 0xD657, 0xB269,
    0xD648, 0xDA5B, 0xD652, 0xB26C, 0xD653, 0xD656, 0xD65A, 0xD64F,
    0xD654, 0xB26A, 0xB26B, 0xD659, 0xD64D, 0xD649, 0xD65B, 0xD651,
    0xD655, 0xD64B, 0xB548, 0xB549, 0xDA65, 0xB54F, 0xDA59, 0xDA62,
    0xDA58, 0xB54C, 0xDA60, 0xDA5E, 0xDA5F, 0xB54A, 0xDA63, 0xDA5C,
    0xDA5A, 0xB54B, 0xDA5D, 0xDA61, 0xB54D, 0xDA64, 0xDE70, 0xDE77,
    0xDE79, 0xDEA1, 0xB7DA, 0xDE6B, 0xB7D2, 0xDE7A, 0xB7D7, 0xDEA2,
    0xB7CE, 0xDE7D, 0xDE6D, 0xDE7E, 0xDE6C, 0xB7DC, 0xDE78, 0xB7CF,
    0xDEA3, 0xB7D4, 0xDE71, 0xB7D9, 0xDE7C, 0xDE6F, 0xDE76, 0xDE72,
    0xDE6E, 0xB7D1, 0xB7D8, 0xB7D6, 0xB7D3, 0xB7DB, 0xB7D0, 0xDE75,
    0xB7D5, 0xB54E, 0xDE7B, 0xDE73, 0xDE74, 0xE2C1, 0xBAB4, 0xE2BD,
    0xE2C3, 0xE2BF, 0xBAB6, 0xE2BE, 0xE2C2, 0xE2BA, 0xE2BC, 0xBAB5,
    0xE2C0, 0xE2BB, 0xBAB7, 0xBAB2, 0xE2C4, 0xBAB3, 0xE667, 0xE664,
    0xE670, 0xE66A, 0xE66C, 0xBCF4, 0xE666, 0xE66E, 0xE66D, 0xE66B,
    0xE671, 0xBCF7, 0xE668, 0xE66F, 0xBCF5, 0xE663, 0xE665, 0xBCF6,
    0xE662, 0xE672, 0xE669, 0xEA4A, 0xBF51, 0xEA55, 0xEA53, 0xBF4B,
    0xEA49, 0xEA4C, 0xEA4D, 0xEA48, 0xBF55, 0xBF56, 0xEA47, 0xEA56,
    0xEA51, 0xBF4F, 0xBF4C, 0xEA50, 0xEA4E, 0xBF52, 0xEA52, 0xBF4D,
    0xBF4E, 0xEA4F, 0xBF50, 0xEA4B, 0xEA54, 0xBF53, 0xEA57, 0xEA58,
    0xBF54, 0xC0E7, 0xC0EE, 0xED5C, 0xED62, 0xED60, 0xC0EA, 0xC0E9,
    0xC0E6, 0xED5E, 0xC0EC, 0xC0EB, 0xC0E8, 0xED61, 0xED5D, 0xED5F,
    0xC0ED, 0xC277, 0xEFFB, 0xC274, 0xC275, 0xEFFD, 0xC276, 0xEFFA,
    0xEFF9, 0xF26C, 0xEFFC, 0xF26D, 0xC37A, 0xF26B, 0xF26A, 0xF269,
    0xC37B, 0xC46C, 0xF46A, 0xF46B, 0xF5DC, 0xF5DB, 0xC4EA, 0xF5DA,
    0xF6EC, 0xF6ED, 0xF7E6, 0xF8B1, 0xF8F6, 0xF9BC, 0xC679, 0xF9C6,
    0xA4F6, 0xAAA6, 0xAAA7, 0xACB8, 0xC0EF, 0xA4F7, 0xAAA8, 0xAF52,
    0xB7DD, 0xA4F8, 0xB26E, 0xBAB8, 0xC962, 0xCFB7, 0xD27D, 0xE2C5,
    0xC0F0, 0xA4F9, 0xAAA9, 0xCFB8, 0xCFB9, 0xDA66, 0xB550, 0xDEA4,
    0xB7DE, 0xE2C6, 0xBCF8, 0xC37C, 0xA4FA, 0xDA67, 0xA4FB, 0xA6C9,
    0xCA42, 0xA6C8, 0xA865, 0xA864, 0xA863, 0xCB60, 0xAAAA, 0xAAAB,
    0xCD5B, 0xCFBA, 0xCFBD, 0xACBA, 0xCFBB, 0xACB9, 0xCFBC, 0xACBB,
    0xD2A2, 0xD2A1, 0xD27E, 0xAF53, 0xD65D, 0xD65E, 0xB26F, 0xD65C,
    0xD65F, 0xB552, 0xB270, 0xB551, 0xDA6B, 0xDA6A, 0xDA68, 0xDA69,
    0xDA6C, 0xDEA6, 0xDEA5, 0xDEA9, 0xDEA8, 0xDEA7, 0xBAB9, 0xE2C9,
    0xE2C8, 0xBABA, 0xE2C7, 0xE673, 0xE674, 0xBCF9, 0xEA59, 0xEA5A,
    0xF272, 0xC37D, 0xF271, 0xF270, 0xF26E, 0xF26F, 0xC4EB, 0xF46C,
    0xF6EE, 0xF8F7, 0xA4FC, 0xC9A5, 0xA5C7, 0xC9A6, 0xCA43, 0xCA44,
    0xCB66, 0xCB62, 0xCB61, 0xAAAC, 0xCB65, 0xA867, 0xCB63, 0xA866,
    0xCB67, 0xCB64, 0xCD5F, 0xCFBE, 0xCD5D, 0xCD64, 0xAAAD, 0xAAB0,
    0xCD65, 0xCD61, 0xCD62, 0xCD5C, 0xAAAF, 0xCD5E, 0xAAAE, 0xCD63,
    0xCD60, 0xCFC2, 0xACBD, 0xACBE, 0xCFC5, 0xCFBF, 0xCFC4, 0xCFC0,
    0xACBC, 0xCFC3, 0xCFC1, 0xD2A8, 0xD2A5, 0xD2A7, 0xAF58, 0xAF57,
    0xAF55, 0xD2A4, 0xD2A9, 0xAF54, 0xAF56, 0xD2A6, 0xD667, 0xD2A3,
    0xD2AA, 0xD662, 0xD666, 0xD665, 0xDA6E, 0xDA79, 0xD668, 0xD663,
    0xDA6D, 0xB274, 0xB273, 0xD661, 0xD664, 0xB275, 0xB272, 0xB271,
    0xD660, 0xD669, 0xDA70, 0xDA77, 0xB554, 0xDA76, 0xDA73, 0xB556,
    0xDA75, 0xDA6F, 0xDA71, 0xDA74, 0xDA72, 0xB555, 0xDA78, 0xB553,
    0xB7DF, 0xDEAD, 0xDEAC, 0xDEAA, 0xB7E2, 0xB7E1, 0xDEAE, 0xDEAB,
    0xE2CA, 0xBABB, 0xB7E0, 0xDEB0, 0xDEAF, 0xE2CD, 0xE2CB, 0xBCFA,
    0xBABC, 0xE2CC, 0xE676, 0xBCFB, 0xE675, 0xE67E, 0xE67D, 0xE67B,
    0xE67A, 0xE677, 0xE678, 0xE679, 0xE67C, 0xE6A1, 0xEA5F, 0xEA5C,
    0xEA5D, 0xBF57, 0xEA5B, 0xEA61, 0xEA60, 0xEA5E, 0xED64, 0xED65,
    0xC0F1, 0xC0F2, 0xED63, 0xC279, 0xEFFE, 0xC278, 0xC37E, 0xC3A1,
    0xC46D, 0xF46E, 0xF46D, 0xF5DD, 0xF6EF, 0xC57A, 0xF7E8, 0xF7E7,
    0xF7E9, 0xA5C8, 0xCFC6, 0xAF59, 0xB276, 0xD66A, 0xA5C9, 0xC9A7,
    0xA4FD, 0xCA45, 0xCB6C, 0xCB6A, 0xCB6B, 0xCB68, 0xA868, 0xCB69,
    0xCD6D, 0xAAB3, 0xCD6B, 0xCD67, 0xCD6A, 0xCD66, 0xAAB5, 0xCD69,
    0xAAB2, 0xAAB1, 0xAAB4, 0xCD6C, 0xCD68, 0xACC2, 0xACC5, 0xCFCE,
    0xCFCD, 0xCFCC, 0xACBF, 0xCFD5, 0xCFCB, 0xACC1, 0xD2AF, 0xCFD2,
    0xCFD0, 0xACC4, 0xCFC8, 0xCFD3, 0xCFCA, 0xCFD4, 0xCFD1, 0xCFC9,
    0xACC0, 0xCFD6, 0xCFC7, 0xACC3, 0xD2B4, 0xD2AB, 0xD2B6, 0xD2AE,
    0xD2B9, 0xD2BA, 0xD2AC, 0xD2B8, 0xD2B5, 0xD2B3, 0xD2B7, 0xAF5F,
    0xAF5D, 0xD2B1, 0xD2AD, 0xD2B0, 0xD2BB, 0xD2B2, 0xAF5E, 0xCFCF,
    0xAF5A, 0xAF5C, 0xD678, 0xD66D, 0xD66B, 0xD66C, 0xD673, 0xD674,
    0xD670, 0xB27B, 0xD675, 0xD672, 0xD66F, 0xB279, 0xD66E, 0xB277,
    0xB27A, 0xD671, 0xD679, 0xAF5B, 0xB278, 0xD677, 0xD676, 0xB27C,
    0xDA7E, 0xDAA1, 0xB560, 0xDAA7, 0xDAA9, 0xDAA2, 0xB55A, 0xDAA6,
    0xDAA5, 0xB55B, 0xB561, 0xB562, 0xDAA8, 0xB558, 0xDA7D, 0xDA7B,
    0xDAA3, 0xDA7A, 0xB55F, 0xDA7C, 0xDAA4, 0xDAAA, 0xB559, 0xB55E,
    0xB55C, 0xB55D, 0xB557, 0xB7E9, 0xDEB7, 0xB7E8, 0xDEBB, 0xDEB1,
    0xDEBC, 0xDEB2, 0xDEB3, 0xDEBD, 0xDEBA, 0xDEB8, 0xDEB9, 0xDEB5,
    0xDEB4, 0xDEBE, 0xB7E5, 0xDEB6, 0xB7EA, 0xB7E4, 0xB7EB, 0xB7EC,
    0xB7E7, 0xB7E6, 0xE2CE, 0xBABE, 0xBABD, 0xE2D3, 0xBCFC, 0xBABF,
    0xBAC1, 0xE2D4, 0xB7E3, 0xBAC0, 0xE2D0, 0xE2D2, 0xE2CF, 0xE2D1,
    0xE6AB, 0xE6AA, 0xE6A7, 0xBD40, 0xEA62, 0xBD41, 0xE6A6, 0xBCFE,
    0xE6A8, 0xE6A5, 0xE6A2, 0xE6A9, 0xE6A3, 0xE6A4, 0xBCFD, 0xED69,
    0xEA66, 0xEA65, 0xEA67, 0xED66, 0xBF5A, 0xEA63, 0xBF58, 0xBF5C,
    0xBF5B, 0xEA64, 0xEA68, 0xBF59, 0xED6D, 0xC0F5, 0xC27A, 0xC0F6,
    0xC0F3, 0xED6A, 0xED68, 0xED6B, 0xED6E, 0xC0F4, 0xED6C, 0xED67,
    0xF042, 0xF045, 0xF275, 0xF040, 0xF46F, 0xF046, 0xC3A2, 0xF044,
    0xC27B, 0xF041, 0xF043, 0xF047, 0xF276, 0xF274, 0xC3A3, 0xF273,
    0xC46E, 0xC4ED, 0xF6F1, 0xC4EC, 0xF6F3, 0xF6F0, 0xF6F2, 0xC5D0,
    0xF8B2, 0xA5CA, 0xCD6E, 0xD2BC, 0xD2BD, 0xB27D, 0xDEBF, 0xBF5D,
    0xC3A4, 0xC57B, 0xF8B3, 0xA5CB, 0xCD6F, 0xA260, 0xCFD7, 0xCFD8,
    0xD2BE, 0xD2BF, 0xB27E, 0xB2A1, 0xDAAB, 0xDEC2, 0xDEC1, 0xDEC0,
    0xE2D5, 0xE2D6, 0xE2D7, 0xBAC2, 0xE6AD, 0xE6AC, 0xEA69, 0xBF5E,
    0xBF5F, 0xED72, 0xED6F, 0xED70, 0xED71, 0xF049, 0xF048, 0xC27C,
    0xF277, 0xF5DE, 0xA5CC, 0xACC6, 0xB2A2, 0xDEC3, 0xA5CD, 0xD2C0,
    0xB2A3, 0xB563, 0xB564, 0xA5CE, 0xA5CF, 0xCA46, 0xA86A, 0xA869,
    0xACC7, 0xCFD9, 0xDAAC, 0xA5D0, 0xA5D1, 0xA5D2, 0xA5D3, 0xA86B,
    0xA86C, 0xCB6E, 0xCB6D, 0xAAB6, 0xCD72, 0xCD70, 0xCD71, 0xCFDA,
    0xCFDB, 0xACCB, 0xACC9, 0xACCA, 0xACC8, 0xAF60, 0xAF64, 0xAF63,
    0xD2C1, 0xAF62, 0xAF61, 0xD2C2, 0xB2A6, 0xD67B, 0xD67A, 0xB2A4,
    0xB2A5, 0xB566, 0xB565, 0xDAAE, 0xDAAD, 0xB2A7, 0xB7ED, 0xDEC5,
    0xB7EE, 0xDEC4, 0xE2D8, 0xE6AE, 0xBD42, 0xEA6A, 0xED73, 0xC3A6,
    0xC3A5, 0xC57C, 0xA5D4, 0xCD73, 0xB2A8, 0xE2D9, 0xBAC3, 0xCB6F,
    0xCB70, 0xCD74, 0xAAB8, 0xAAB9, 0xAAB7, 0xACCF, 0xACD0, 0xACCD,
    0xACCE, 0xCFDC, 0xCFDD, 0xACCC, 0xD2C3, 0xAF68, 0xAF69, 0xB2AB,
    0xD2C9, 0xAF6E, 0xAF6C, 0xD2CA, 0xD2C5, 0xAF6B, 0xAF6A, 0xAF65,
    0xD2C8, 0xD2C7, 0xD2C4, 0xAF6D, 0xD2C6, 0xAF66, 0xAF67, 0xB2AC,
    0xD6A1, 0xD6A2, 0xB2AD, 0xD67C, 0xD67E, 0xD6A4, 0xD6A3, 0xD67D,
    0xB2A9, 0xB2AA, 0xDAB6, 0xB56B, 0xB56A, 0xDAB0, 0xB568, 0xDAB3,
    0xB56C, 0xDAB4, 0xB56D, 0xDAB1, 0xB567, 0xB569, 0xDAB5, 0xDAB2,
    0xDAAF, 0xDED2, 0xDEC7, 0xB7F0, 0xB7F3, 0xB7F2, 0xB7F7, 0xB7F6,
    0xDED3, 0xDED1, 0xDECA, 0xDECE, 0xDECD, 0xB7F4, 0xDED0, 0xDECC,
    0xDED4, 0xDECB, 0xB7F5, 0xB7EF, 0xB7F1, 0xDEC9, 0xE2DB, 0xBAC7,
    0xE2DF, 0xBAC6, 0xE2DC, 0xBAC5, 0xDEC8, 0xDECF, 0xE2DE, 0xBAC8,
    0xE2E0, 0xE2DD, 0xE2DA, 0xE6B1, 0xE6B5, 0xE6B7, 0xE6B3, 0xE6B2,
    0xE6B0, 0xBD45, 0xBD43, 0xBD48, 0xBD49, 0xE6B4, 0xBD46, 0xE6AF,
    0xBD47, 0xBAC4, 0xE6B6, 0xBD44, 0xEA6C, 0xEA6B, 0xEA73, 0xEA6D,
    0xEA72, 0xEA6F, 0xBF60, 0xEA71, 0xBF61, 0xBF62, 0xEA70, 0xEA6E,
    0xC0F8, 0xED74, 0xC0F7, 0xED77, 0xED75, 0xED76, 0xC0F9, 0xF04D,
    0xC2A1, 0xF04E, 0xC27D, 0xF04F, 0xC27E, 0xF04C, 0xF050, 0xF04A,
    0xC3A7, 0xF278, 0xC3A8, 0xC46F, 0xF04B, 0xC470, 0xC4EE, 0xF5DF,
    0xC57E, 0xF6F4, 0xC57D, 0xF7EA, 0xC5F5, 0xC5F6, 0xF9CC, 0xACD1,
    0xCFDE, 0xB56E, 0xB56F, 0xA5D5, 0xA6CA, 0xCA47, 0xCB71, 0xA86D,
    0xAABA, 0xACD2, 0xACD3, 0xACD4, 0xD6A6, 0xD2CB, 0xAF6F, 0xB2AE,
    0xD6A5, 0xDAB8, 0xB571, 0xDAB7, 0xB570, 0xDED5, 0xBD4A, 0xE6BB,
    0xE6B8, 0xE6B9, 0xE6BA, 0xED78, 0xF051, 0xF471, 0xF470, 0xF6F5,
    0xA5D6, 0xCD75, 0xAF70, 0xB572, 0xDED6, 0xE2E1, 0xBD4B, 0xEA74,
    0xF052, 0xF472, 0xA5D7, 0xAABB, 0xACD7, 0xCFDF, 0xACD8, 0xACD6,
    0xACD5, 0xD2CC, 0xAF71, 0xAF72, 0xAF73, 0xB2B0, 0xD6A7, 0xB2AF,
    0xDAB9, 0xB2B1, 0xB573, 0xDED7, 0xB7F8, 0xB7F9, 0xBAC9, 0xBACA,
    0xBD4C, 0xBF64, 0xEA75, 0xBF63, 0xED79, 0xC0FA, 0xF053, 0xF473,
    0xA5D8, 0xA86E, 0xCD78, 0xCD77, 0xAABC, 0xCD76, 0xAABD, 0xCD79,
    0xCFE5, 0xACDB, 0xACDA, 0xCFE7, 0xCFE6, 0xACDF, 0xACDE, 0xACD9,
    0xCFE1, 0xCFE2, 0xCFE3, 0xACE0, 0xCFE0, 0xACDC, 0xCFE4, 0xACDD,
    0xD2CF, 0xD2D3, 0xD2D1, 0xD2D0, 0xD2D4, 0xD2D5, 0xD2D6, 0xD2CE,
    0xD2CD, 0xAF75, 0xAF76, 0xD2D7, 0xD2D2, 0xD6B0, 0xD2D8, 0xAF77,
    0xAF74, 0xD6AA, 0xD6A9, 0xD6AB, 0xD6AC, 0xD6AE, 0xD6AD, 0xD6B2,
    0xB2B5, 0xB2B2, 0xB2B6, 0xD6A8, 0xB2B7, 0xD6B1, 0xB2B4, 0xD6AF,
    0xB2B3, 0xDABC, 0xDABE, 0xDABA, 0xDABB, 0xDABF, 0xDAC1, 0xDAC2,
    0xDABD, 0xDAC0, 0xB574, 0xDEDB, 0xDEE0, 0xDED8, 0xDEDC, 0xDEE1,
    0xDEDD, 0xB7FA, 0xB843, 0xB7FD, 0xDED9, 0xDEDA, 0xBACE, 0xB846,
    0xB7FE, 0xB844, 0xB7FC, 0xDEDF, 0xB845, 0xDEDE, 0xB841, 0xB7FB,
    0xB842, 0xDEE2, 0xE2E6, 0xE2E8, 0xB840, 0xE2E3, 0xBACC, 0xE2E9,
    0xBACD, 0xE2E7, 0xE2E2, 0xE2E5, 0xE2EA, 0xBACB, 0xE2E4, 0xBD4E,
    0xE6BF, 0xE6BE, 0xBD51, 0xBD4F, 0xE6BC, 0xBD4D, 0xE6BD, 0xBD50,
    0xEA7D, 0xEAA1, 0xEA7E, 0xEA76, 0xEA7A, 0xEA79, 0xEA77, 0xBF66,
    0xBF67, 0xBF65, 0xEA78, 0xEA7B, 0xEA7C, 0xBF68, 0xC140, 0xEDA3,
    0xC0FC, 0xED7B, 0xC0FE, 0xC141, 0xC0FD, 0xEDA2, 0xED7C, 0xC0FB,
    0xEDA1, 0xED7A, 0xED7E, 0xED7D, 0xF055, 0xC2A4, 0xC2A5, 0xC2A2,
    0xC2A3, 0xF054, 0xF27B, 0xC3A9, 0xF279, 0xF27A, 0xF474, 0xF477,
    0xF475, 0xF476, 0xF5E0, 0xC4EF, 0xF7EB, 0xF8B4, 0xC5F7, 0xF8F8,
    0xF8F9, 0xC666, 0xA5D9, 0xACE1, 0xDAC3, 0xDEE3, 0xA5DA, 0xA86F,
    0xAABE, 0xCFE8, 0xCFE9, 0xAF78, 0xDAC4, 0xB575, 0xB847, 0xC142,
    0xEDA4, 0xF27C, 0xF478, 0xA5DB, 0xCDA1, 0xCD7A, 0xCD7C, 0xCD7E,
    0xCD7D, 0xCD7B, 0xAABF, 0xACE2, 0xCFF2, 0xCFED, 0xCFEA, 0xCFF1,
    0xACE4, 0xACE5, 0xCFF0, 0xCFEF, 0xCFEE, 0xCFEB, 0xCFEC, 0xCFF3,
    0xACE3, 0xAF7C, 0xAFA4, 0xAFA3, 0xD2E1, 0xD2DB, 0xD2D9, 0xAFA1,
    0xD6B9, 0xAF7A, 0xD2DE, 0xD2E2, 0xD2E4, 0xD2E0, 0xD2DA, 0xAFA2,
    0xD2DF, 0xD2DD, 0xAF79, 0xD2E5, 0xAFA5, 0xD2E3, 0xAF7D, 0xD2DC,
    0xAF7E, 0xAF7B, 0xB2B9, 0xD6BA, 0xD6B3, 0xD6B5, 0xD6B7, 0xD6B8,
    0xD6B6, 0xB2BA, 0xD6BB, 0xD6B4, 0xDAC8, 0xB576, 0xDAD0, 0xDAC5,
    0xDAD1, 0xDAC6, 0xDAC7, 0xDACF, 0xDACE, 0xDACB, 0xB2B8, 0xB577,
    0xDAC9, 0xDACC, 0xB578, 0xDACD, 0xDACA, 0xDEEE, 0xDEF2, 0xB84E,
    0xE2F0, 0xB851, 0xDEF0, 0xDEED, 0xDEE8, 0xDEEA, 0xDEEB, 0xDEE4,
    0xB84D, 0xB84C, 0xB848, 0xDEE7, 0xB84F, 0xB850, 0xDEE6, 0xDEE9,
    0xDEF1, 0xB84A, 0xB84B, 0xDEEF, 0xDEE5, 0xE2F2, 0xBAD0, 0xE2F4,
    0xDEEC, 0xE2F6, 0xBAD4, 0xE2F7, 0xE2F3, 0xBAD1, 0xE2EF, 0xBAD3,
    0xE2EC, 0xE2F1, 0xE2F5, 0xE2EE, 0xB849, 0xE2EB, 0xBAD2, 0xE2ED,
    0xBD54, 0xE6C1, 0xBD58, 0xBD56, 0xBACF, 0xE6C8, 0xE6C9, 0xBD53,
    0xE6C7, 0xE6CA, 0xBD55, 0xBD52, 0xE6C3, 0xE6C0, 0xE6C5, 0xE6C2,
    0xBD59, 0xE6C4, 0xE6C6, 0xBD57, 0xBF6A, 0xEAA8, 0xEAA2, 0xEAA6,
    0xEAAC, 0xEAAD, 0xEAA9, 0xEAAA, 0xEAA7, 0xEAA4, 0xBF6C, 0xBF69,
    0xEAA3, 0xEAA5, 0xBF6B, 0xEAAB, 0xC146, 0xEDAA, 0xEDA5, 0xC145,
    0xC143, 0xEDAC, 0xC144, 0xEDA8, 0xEDA9, 0xEDA6, 0xEDAD, 0xF056,
    0xC147, 0xEDA7, 0xEDAE, 0xEDAB, 0xF05A, 0xF057, 0xC2A6, 0xF05B,
    0xF05D, 0xF05C, 0xF058, 0xF059, 0xF2A3, 0xC3AA, 0xF27E, 0xF2A2,
    0xF27D, 0xF2A4, 0xF2A1, 0xF47A, 0xF47D, 0xF479, 0xC471, 0xF47B,
    0xF47C, 0xF47E, 0xC472, 0xC474, 0xC473, 0xF5E1, 0xF5E3, 0xF5E2,
    0xF6F6, 0xF8B5, 0xF8FA, 0xA5DC, 0xCB72, 0xAAC0, 0xCDA3, 0xAAC1,
    0xAAC2, 0xCDA2, 0xCFF8, 0xCFF7, 0xACE6, 0xACE9, 0xACE8, 0xACE7,
    0xCFF4, 0xCFF6, 0xCFF5, 0xD2E8, 0xAFA7, 0xD2EC, 0xD2EB, 0xD2EA,
    0xD2E6, 0xAFA6, 0xAFAA, 0xAFAD, 0xAFAE, 0xD2E7, 0xD2E9, 0xAFAC,
    0xAFAB, 0xAFA9, 0xAFA8, 0xD6C2, 0xD6C0, 0xD6BC, 0xB2BB, 0xD6BD,
    0xB2BC, 0xD6BE, 0xD6BF, 0xD6C1, 0xB2BD, 0xDAD5, 0xDAD4, 0xDAD3,
    0xDAD2, 0xDEF6, 0xB852, 0xDEF3, 0xDEF5, 0xB853, 0xB854, 0xDEF4,
    0xE341, 0xE2F9, 0xE2FA, 0xBAD7, 0xBAD5, 0xBAD6, 0xE343, 0xE342,
    0xE2FE, 0xE2FD, 0xE2FC, 0xE2FB, 0xE340, 0xE2F8, 0xE6CB, 0xE6D0,
    0xE6CE, 0xE6CD, 0xE6CC, 0xE6CF, 0xEAAE, 0xBF6D, 0xC148, 0xEDB0,
    0xC149, 0xEDAF, 0xF05F, 0xF05E, 0xC2A7, 0xF2A5, 0xC3AB, 0xF4A1,
    0xC5A1, 0xF6F7, 0xF8B7, 0xF8B6, 0xC9A8, 0xACEA, 0xACEB, 0xD6C3,
    0xB856, 0xA5DD, 0xA872, 0xA871, 0xA870, 0xCDA4, 0xAAC4, 0xAAC3,
    0xACEE, 0xCFFA, 0xCFFD, 0xCFFB, 0xACEC, 0xACED, 0xCFF9, 0xCFFC,
    0xAFB5, 0xD2F3, 0xD2F5, 0xD2F4, 0xAFB2, 0xD2EF, 0xAFB0, 0xAFAF,
    0xAFB3, 0xAFB1, 0xAFB4, 0xD2F2, 0xD2ED, 0xD2EE, 0xD2F1, 0xD2F0,
    0xD6C6, 0xD6C7, 0xD6C5, 0xD6C4, 0xB2BE, 0xB57D, 0xDAD6, 0xDAD8,
    0xDADA, 0xB57C, 0xB57A, 0xDAD7, 0xB57B, 0xDAD9, 0xB579, 0xDF41,
    0xDEF7, 0xDEFA, 0xDEFE, 0xB85A, 0xDEFC, 0xDEFB, 0xDEF8, 0xDEF9,
    0xB858, 0xDF40, 0xB857, 0xB85C, 0xB85B, 0xB859, 0xDEFD, 0xE349,
    0xE348, 0xE344, 0xBAD8, 0xE347, 0xE346, 0xBAD9, 0xBD5E, 0xE6D2,
    0xBD5F, 0xBD5B, 0xBD5D, 0xBD5A, 0xBD5C, 0xEAAF, 0xBF70, 0xEAB1,
    0xEAB0, 0xE345, 0xBF72, 0xBF71, 0xBF6E, 0xBF6F, 0xEDB5, 0xEDB3,
    0xC14A, 0xEDB4, 0xEDB6, 0xEDB2, 0xEDB1, 0xF060, 0xC2AA, 0xC2A8,
    0xC2A9, 0xF2A6, 0xF2A7, 0xC3AD, 0xC3AC, 0xF4A3, 0xF4A4, 0xF4A2,
    0xF6F8, 0xF6F9, 0xA5DE, 0xCA48, 0xA873, 0xCDA5, 0xAAC6, 0xAAC5,
    0xCDA6, 0xD040, 0xACEF, 0xCFFE, 0xACF0, 0xAFB6, 0xD2F8, 0xD2F6,
    0xD2FC, 0xAFB7, 0xD2F7, 0xD2FB, 0xD2F9, 0xD2FA, 0xD6C8, 0xD6CA,
    0xB2BF, 0xD6C9, 0xB2C0, 0xB5A2, 0xB5A1, 0xB57E, 0xDADB, 0xDF44,
    0xB85D, 0xB85E, 0xDF43, 0xDF42, 0xE34A, 0xBADB, 0xBADA, 0xE34B,
    0xE34C, 0xBD61, 0xBD60, 0xEAB5, 0xE6D3, 0xE6D5, 0xE6D4, 0xEAB4,
    0xEAB2, 0xEAB6, 0xEAB3, 0xBF73, 0xEDB7, 0xC14B, 0xEDB8, 0xEDB9,
    0xC2AB, 0xC2AC, 0xC475, 0xC5D1, 0xA5DF, 0xD041, 0xD2FD, 0xAFB8,
    0xB3BA, 0xB3B9, 0xB5A4, 0xDADD, 0xB5A3, 0xDADC, 0xDF45, 0xBADC,
    0xE34D, 0xBADD, 0xC476, 0xF4A5, 0xA6CB, 0xAAC7, 0xCDA7, 0xACF2,
    0xACF1, 0xD042, 0xD043, 0xD340, 0xD342, 0xAFB9, 0xD344, 0xD347,
    0xD345, 0xD346, 0xD343, 0xD2FE, 0xAFBA, 0xD348, 0xD341, 0xD6D3,
    0xB2C6, 0xD6DC, 0xB2C3, 0xD6D5, 0xB2C7, 0xB2C1, 0xD6D0, 0xD6DD,
    0xD6D1, 0xD6CE, 0xB2C5, 0xB2C2, 0xD6D4, 0xD6D7, 0xB2C4, 0xD6D8,
    0xB2C8, 0xD6D9, 0xD6CF, 0xD6D6, 0xD6DA, 0xD6D2, 0xD6CD, 0xD6CB,
    0xD6DB, 0xDADF, 0xDAE4, 0xDAE0, 0xDAE6, 0xB5A7, 0xD6CC, 0xDAE1,
    0xB5A5, 0xDADE, 0xB5AC, 0xDAE2, 0xB5AB, 0xDAE3, 0xB5AD, 0xB5A8,
    0xB5AE, 0xB5A9, 0xB5AA, 0xB5A6, 0xDAE5, 0xB861, 0xDF50, 0xDF53,
    0xDF47, 0xDF4C, 0xDF46, 0xB863, 0xDF4A, 0xDF48, 0xB862, 0xDF4F,
    0xDF4E, 0xDF4B, 0xDF4D, 0xDF49, 0xBAE1, 0xDF52, 0xB85F, 0xDF51,
    0xE35D, 0xBAE8, 0xE358, 0xBAE7, 0xE34E, 0xE350, 0xBAE0, 0xE355,
    0xE354, 0xE357, 0xBAE5, 0xE352, 0xE351, 0xBAE4, 0xBADF, 0xE353,
    0xBAE2, 0xE359, 0xE35B, 0xE356, 0xE34F, 0xBAE3, 0xBD69, 0xBADE,
    0xE35C, 0xE6D9, 0xBD62, 0xE6DB, 0xBD63, 0xBD65, 0xE6DE, 0xE6D6,
    0xBAE6, 0xE6DC, 0xE6D8, 0xB860, 0xBD68, 0xBD64, 0xBD66, 0xBD67,
    0xBF76, 0xE6DD, 0xE6D7, 0xBD6A, 0xE6DA, 0xEAC0, 0xEABB, 0xEAC5,
    0xBF74, 0xEABD, 0xBF78, 0xEAC3, 0xEABA, 0xEAB7, 0xEAC6, 0xC151,
    0xBF79, 0xEAC2, 0xEAB8, 0xBF77, 0xEABC, 0xBF7B, 0xEAB9, 0xEABE,
    0xBF7A, 0xEAC1, 0xEAC4, 0xEDCB, 0xEDCC, 0xEDBC, 0xEDC3, 0xEDC1,
    0xC14F, 0xEDC8, 0xEABF, 0xEDBF, 0xEDC9, 0xC14E, 0xEDBE, 0xEDBD,
    0xEDC7, 0xEDC4, 0xEDC6, 0xEDBA, 0xEDCA, 0xC14C, 0xEDC5, 0xEDCE,
    0xEDC2, 0xC150, 0xC14D, 0xEDC0, 0xEDBB, 0xEDCD, 0xBF75, 0xF063,
    0xF061, 0xF067, 0xC2B0, 0xF065, 0xF064, 0xC2B2, 0xF06A, 0xC2B1,
    0xF06B, 0xF068, 0xC2AE, 0xF069, 0xF062, 0xC2AF, 0xC2AD, 0xF2AB,
    0xF066, 0xF06C, 0xF2A8, 0xC3B2, 0xC3B0, 0xF2AA, 0xF2AC, 0xF2A9,
    0xC3B1, 0xC3AE, 0xC3AF, 0xC3B3, 0xC478, 0xF4AA, 0xF4A9, 0xF4A7,
    0xF4A6, 0xF4A8, 0xC477, 0xC479, 0xC4F0, 0xF5E5, 0xF5E4, 0xF6FA,
    0xF6FC, 0xF6FE, 0xF6FD, 0xF6FB, 0xC5A3, 0xC5A2, 0xC5D3, 0xC5D2,
    0xC5D4, 0xF7ED, 0xF7EC, 0xF8FB, 0xF8B8, 0xF8FC, 0xC658, 0xC659,
    0xF96D, 0xC67E, 0xA6CC, 0xCDA8, 0xD045, 0xD046, 0xD044, 0xACF3,
    0xD047, 0xD048, 0xD049, 0xD349, 0xD34F, 0xD34D, 0xAFBB, 0xD34B,
    0xD34C, 0xD34E, 0xD34A, 0xB2C9, 0xD6DE, 0xB2CB, 0xD6E0, 0xB2CA,
    0xD6DF, 0xDAE8, 0xB5AF, 0xDAEA, 0xDAE7, 0xD6E1, 0xB5B0, 0xDAE9,
    0xDF56, 0xB864, 0xDF54, 0xB865, 0xDF55, 0xB866, 0xBAE9, 0xE361,
    0xE35E, 0xE360, 0xBAEA, 0xBAEB, 0xE35F, 0xE6DF, 0xE6E0, 0xBD6B,
    0xE6E2, 0xE6E1, 0xA261, 0xEACA, 0xEACB, 0xEAC7, 0xEAC8, 0xBF7C,
    0xBF7D, 0xEAC9, 0xC157, 0xC153, 0xC158, 0xC154, 0xC156, 0xC152,
    0xC155, 0xC2B3, 0xEDCF, 0xF2AE, 0xF2AD, 0xF4AB, 0xC47A, 0xC47B,
    0xF741, 0xF5E6, 0xF740, 0xF8FD, 0xF9A4, 0xA6CD, 0xA874, 0xCDA9,
    0xAAC8, 0xACF6, 0xD04C, 0xACF4, 0xD04A, 0xACF9, 0xACF5, 0xACFA,
    0xACF8, 0xD04B, 0xACF7, 0xAFBF, 0xAFBE, 0xD35A, 0xAFC7, 0xD353,
    0xD359, 0xAFC3, 0xD352, 0xD358, 0xD356, 0xAFC2, 0xAFC4, 0xD355,
    0xAFBD, 0xD354, 0xAFC8, 0xAFC5, 0xAFC9, 0xAFC6, 0xD351, 0xD350,
    0xD357, 0xAFC0, 0xAFBC, 0xAFC1, 0xD6F0, 0xD6E9, 0xB5B5, 0xD6E8,
    0xB2CF, 0xB2D6, 0xB2D3, 0xB2D9, 0xB2D8, 0xB2D4, 0xD6E2, 0xD6E5,
    0xD6E4, 0xB2D0, 0xD6E6, 0xD6EF, 0xB2D1, 0xD6E3, 0xD6EC, 0xD6ED,
    0xB2D2, 0xD6EA, 0xB2D7, 0xB2CD, 0xB2D5, 0xD6E7, 0xB2CC, 0xD6EB,
    0xD6EE, 0xDAFB, 0xDAF2, 0xB5B2, 0xDAF9, 0xDAF6, 0xDAEE, 0xDAF7,
    0xB5B4, 0xDAEF, 0xDAEB, 0xB86C, 0xDAF4, 0xB5B1, 0xDAFA, 0xB5B8,
    0xB5BA, 0xDAED, 0xB5B9, 0xDAF0, 0xB5B3, 0xDAF8, 0xDAF1, 0xDAF5,
    0xDAF3, 0xB5B6, 0xDAEC, 0xB5BB, 0xB2CE, 0xB5B7, 0xB5BC, 0xB868,
    0xDF5D, 0xDF5F, 0xDF61, 0xDF65, 0xDF5B, 0xDF59, 0xB86A, 0xDF60,
    0xDF64, 0xDF5C, 0xDF58, 0xDF57, 0xDF62, 0xDF5A, 0xDF5E, 0xB86B,
    0xB869, 0xDF66, 0xB867, 0xDF63, 0xE372, 0xBAEE, 0xE36A, 0xBD78,
    0xE374, 0xBAF1, 0xE378, 0xBAF7, 0xE365, 0xE375, 0xE362, 0xE377,
    0xE366, 0xBAFE, 0xBAFB, 0xE376, 0xE370, 0xBAED, 0xBAF5, 0xBAF4,
    0xBAF3, 0xBAF9, 0xE363, 0xBAFA, 0xE371, 0xBAF6, 0xBAEC, 0xE373,
    0xBAEF, 0xBAF0, 0xBAF8, 0xE368, 0xE367, 0xE364, 0xE36C, 0xE369,
    0xE36D, 0xBAFD, 0xE379, 0xBAF2, 0xE36E, 0xE36F, 0xE36B, 0xBAFC,
    0xE6E7, 0xBD70, 0xBD79, 0xBD75, 0xE6E4, 0xBD72, 0xBD76, 0xE6F0,
    0xBD6C, 0xE6E8, 0xBD74, 0xE6EB, 0xE6E6, 0xBD73, 0xBD77, 0xE6E5,
    0xBD71, 0xE6EF, 0xBD6E, 0xE6EE, 0xE6ED, 0xBD7A, 0xE572, 0xBD6D,
    0xE6EC, 0xE6E3, 0xBD7B, 0xE6EA, 0xBD6F, 0xE6E9, 0xBFA2, 0xBFA7,
    0xBF7E, 0xEAD8, 0xEACF, 0xEADB, 0xEAD3, 0xEAD9, 0xBFA8, 0xBFA1,
    0xEACC, 0xEAD2, 0xEADC, 0xEAD5, 0xEADA, 0xEACE, 0xEAD6, 0xBFA3,
    0xEAD4, 0xBFA6, 0xBFA5, 0xEAD0, 0xEAD1, 0xEACD, 0xEAD7, 0xBFA4,
    0xEADE, 0xEADD, 0xEDDA, 0xEDD6, 0xC15F, 0xEDD0, 0xC159, 0xC169,
    0xEDDC, 0xC161, 0xC15D, 0xEDD3, 0xC164, 0xC167, 0xEDDE, 0xC15C,
    0xEDD5, 0xC165, 0xEDE0, 0xEDDD, 0xEDD1, 0xC160, 0xC15A, 0xC168,
    0xEDD8, 0xC163, 0xEDD2, 0xC15E, 0xEDDF, 0xC162, 0xC15B, 0xEDD9,
    0xC166, 0xEDD7, 0xEDDB, 0xF06E, 0xF074, 0xC2B9, 0xF077, 0xC2B4,
    0xC2B5, 0xF06F, 0xF076, 0xF071, 0xC2BA, 0xC2B7, 0xF06D, 0xC2B6,
    0xF073, 0xF075, 0xC2B8, 0xF072, 0xF070, 0xF2B8, 0xC3B7, 0xC3B8,
    0xC3B4, 0xC3B5, 0xF2B4, 0xF2B2, 0xF2B6, 0xC3BA, 0xF2B7, 0xF2B0,
    0xF2AF, 0xF2B3, 0xF2B1, 0xC3B6, 0xF2B5, 0xF4AC, 0xC47E, 0xC47D,
    0xF4AD, 0xF4AF, 0xF4AE, 0xC4A1, 0xF5EB, 0xF5E8, 0xF5E9, 0xF5E7,
    0xF5EA, 0xC4F2, 0xF5EC, 0xC4F1, 0xF742, 0xC5D5, 0xC5D7, 0xF7EE,
    0xC5D6, 0xF8B9, 0xF940, 0xF942, 0xF8FE, 0xF941, 0xC66C, 0xA6CE,
    0xACFB, 0xD26F, 0xAFCA, 0xB2DA, 0xDAFC, 0xDAFD, 0xEADF, 0xC16A,
    0xEDE1, 0xC2BB, 0xF2BA, 0xF2B9, 0xC4A2, 0xF5ED, 0xF743, 0xC5F8,
    0xCA49, 0xAAC9, 0xA875, 0xD04D, 0xD360, 0xD35B, 0xD35F, 0xD35D,
    0xAFCB, 0xD35E, 0xD35C, 0xD6F1, 0xDAFE, 0xDB40, 0xDF69, 0xDF6A,
    0xB86E, 0xB86F, 0xDF68, 0xDF6B, 0xDF67, 0xB86D, 0xBB40, 0xB870,
    0xE37A, 0xBD7C, 0xE6F1, 0xBD7D, 0xBFA9, 0xEAE2, 0xEAE0, 0xEAE1,
    0xEDE4, 0xEDE3, 0xEDE2, 0xF2BB, 0xC3B9, 0xF2BC, 0xF744, 0xC5F9,
    0xF8BA, 0xA6CF, 0xAACB, 0xAACA, 0xD04F, 0xACFC, 0xD04E, 0xD362,
    0xAFCC, 0xD6F2, 0xD361, 0xB2DC, 0xD6F5, 0xD6F3, 0xD6F4, 0xB2DB,
    0xDB42, 0xDB43, 0xDB41, 0xB873, 0xDF6D, 0xDF6C, 0xDF6E, 0xB872,
    0xB871, 0xE6F2, 0xE6F4, 0xBD7E, 0xE6F3, 0xEAE3, 0xBFAA, 0xF079,
    0xF078, 0xC3BB, 0xF2BD, 0xC3BD, 0xC3BC, 0xF4B0, 0xF5EE, 0xC4F3,
    0xA6D0, 0xD050, 0xACFD, 0xD365, 0xAFCE, 0xD364, 0xD363, 0xAFCD,
    0xD6FB, 0xD6FD, 0xD6F6, 0xD6F7, 0xB2DD, 0xD6F8, 0xB2DE, 0xD6FC,
    0xD6F9, 0xD6FA, 0xB2DF, 0xB5BE, 0xB5BF, 0xDB44, 0xDF6F, 0xDF70,
    0xE37E, 0xBB43, 0xBB41, 0xBB42, 0xE37B, 0xE37C, 0xE37D, 0xE6F9,
    0xE6FA, 0xBDA1, 0xE6F7, 0xE6F6, 0xE6F8, 0xE6F5, 0xBFAD, 0xEAE4,
    0xBFAB, 0xBFAC, 0xEDE6, 0xC16B, 0xEDE5, 0xEFA8, 0xF07A, 0xF07B,
    0xC2BC, 0xC2BD, 0xC16C, 0xF2BE, 0xF2BF, 0xF4B1, 0xC4A3, 0xA6D1,
    0xA6D2, 0xACFE, 0xAACC, 0xAFCF, 0xD051, 0xB5C0, 0xA6D3, 0xAD41,
    0xD052, 0xD053, 0xAD40, 0xAD42, 0xA6D4, 0xD054, 0xAFD1, 0xD366,
    0xAFD3, 0xAFD0, 0xAFD2, 0xD741, 0xB2E0, 0xD740, 0xD6FE, 0xDF71,
    0xE3A1, 0xBDA2, 0xBFAE, 0xEAE6, 0xEAE5, 0xEDE7, 0xF5EF, 0xA6D5,
    0xCB73, 0xCDAA, 0xAD43, 0xD055, 0xD368, 0xAFD4, 0xD367, 0xAFD5,
    0xD743, 0xB2E2, 0xD742, 0xD744, 0xB2E1, 0xDB46, 0xDB47, 0xDB45,
    0xB5C1, 0xB874, 0xB875, 0xBB45, 0xE3A3, 0xE3A2, 0xBB44, 0xE6FB,
    0xE6FC, 0xEAE7, 0xC170, 0xC16F, 0xC16D, 0xC16E, 0xC171, 0xF07C,
    0xC2BF, 0xC2BE, 0xF2C0, 0xF4B2, 0xC5A5, 0xC5A4, 0xA6D6, 0xD1FB,
    0xB877, 0xB5C2, 0xB876, 0xBB46, 0xA6D7, 0xC9A9, 0xA6D8, 0xA6D9,
    0xCDAB, 0xCB76, 0xCB77, 0xA877, 0xCB74, 0xA876, 0xA879, 0xCB75,
    0xA87B, 0xA87A, 0xCB78, 0xA878, 0xAAD1, 0xAACF, 0xCDAD, 0xAACE,
    0xAAD3, 0xAAD5, 0xAAD2, 0xCDB0, 0xCDAC, 0xAAD6, 0xAAD0, 0xA87C,
    0xAAD4, 0xCDAF, 0xCDAE, 0xAACD, 0xD05B, 0xAD47, 0xAD48, 0xD05D,
    0xD057, 0xD05A, 0xD063, 0xD061, 0xAD49, 0xD067, 0xAD4C, 0xD064,
    0xD05C, 0xD059, 0xDB49, 0xD062, 0xAD44, 0xD065, 0xD056, 0xD05F,
    0xAD46, 0xAD4B, 0xD060, 0xAD4F, 0xAD4D, 0xD058, 0xAD4A, 0xD05E,
    0xAD4E, 0xAD45, 0xD066, 0xAFDA, 0xAFE3, 0xAFD8, 0xAFD6, 0xD36A,
    0xAFDE, 0xAFDB, 0xD36C, 0xAFDD, 0xD36B, 0xD369, 0xD36E, 0xAFE2,
    0xAFE0, 0xDB48, 0xD36F, 0xD36D, 0xAFD7, 0xAFD9, 0xAFDC, 0xAFDF,
    0xAFE1, 0xD74E, 0xB2E4, 0xD745, 0xD747, 0xD748, 0xD750, 0xD74C,
    0xD74A, 0xD74D, 0xD751, 0xB2E5, 0xB2E9, 0xD746, 0xD74F, 0xB2E7,
    0xB2E6, 0xD74B, 0xD749, 0xB2E3, 0xB2E8, 0xB5C8, 0xDB51, 0xDB4F,
    0xB5CA, 0xDB4A, 0xDFA1, 0xB5C9, 0xDB4E, 0xDB4B, 0xB5C5, 0xB5CB,
    0xDB50, 0xB5C7, 0xDB4D, 0xBB47, 0xB5C6, 0xDB4C, 0xB5CC, 0xB5C4,
    0xB5C3, 0xDF77, 0xDF75, 0xDF7B, 0xDF73, 0xDFA2, 0xDF78, 0xDF72,
    0xB87B, 0xB8A3, 0xDF7D, 0xDF76, 0xB87E, 0xB87C, 0xDF7E, 0xB879,
    0xB878, 0xDF79, 0xB87D, 0xB5CD, 0xDF7C, 0xDF74, 0xB87A, 0xB8A1,
    0xB8A2, 0xBB4C, 0xBB48, 0xBB4D, 0xE3A6, 0xE3A5, 0xE3A7, 0xBB4A,
    0xE3A4, 0xBB4B, 0xE3AA, 0xE3A9, 0xE3A8, 0xBB49, 0xE741, 0xE744,
    0xBDA8, 0xE743, 0xBDA7, 0xBDA3, 0xBDA4, 0xBDA5, 0xE740, 0xE6FE,
    0xBDA6, 0xE742, 0xE6FD, 0xEAE9, 0xEAF3, 0xBFB1, 0xBFB0, 0xEAED,
    0xEAEF, 0xEAEA, 0xEAEE, 0xEAE8, 0xEAF1, 0xBFAF, 0xEAF0, 0xEAEC,
    0xEAF2, 0xEAEB, 0xC174, 0xEDE8, 0xEDEE, 0xC178, 0xC17A, 0xC177,
    0xC176, 0xC175, 0xC173, 0xEDE9, 0xEDEC, 0xC172, 0xEDED, 0xC179,
    0xEDEB, 0xEDEA, 0xC2C0, 0xC2C1, 0xF0A1, 0xF07D, 0xF07E, 0xF2C2,
    0xF2C1, 0xC3BE, 0xF4B4, 0xC4A4, 0xF4B3, 0xF5F0, 0xF745, 0xC5A6,
    0xF943, 0xF944, 0xC5D8, 0xA6DA, 0xAAD7, 0xDB52, 0xBB4E, 0xC17B,
    0xEDEF, 0xA6DB, 0xAFE5, 0xAFE4, 0xDB53, 0xEAF4, 0xA6DC, 0xAD50,
    0xDB54, 0xDB55, 0xDB56, 0xBB4F, 0xBFB2, 0xA6DD, 0xAAD8, 0xD068,
    0xAFE6, 0xD370, 0xB2EA, 0xDB57, 0xB8A4, 0xBB50, 0xBFB3, 0xC17C,
    0xC2C2, 0xF4B5, 0xA6DE, 0xAAD9, 0xAFE7, 0xD752, 0xB5CE, 0xBB51,
    0xE3AB, 0xE745, 0xA6DF, 0xB5CF, 0xDFA3, 0xBB52, 0xA6E0, 0xCDB1,
    0xD069, 0xAD51, 0xD372, 0xAFEA, 0xAFE8, 0xAFE9, 0xAFEB, 0xD371,
    0xD757, 0xD754, 0xD756, 0xB2EB, 0xB2ED, 0xB2EC, 0xD753, 0xB2EE,
    0xD755, 0xDB58, 0xDB59, 0xDB5A, 0xDFA6, 0xDFA7, 0xDFA5, 0xDFA8,
    0xB8A5, 0xDFA4, 0xBB53, 0xE74A, 0xE746, 0xE749, 0xE74B, 0xE748,
    0xE747, 0xEAF5, 0xEAF6, 0xEAF7, 0xBFB4, 0xBFB5, 0xEDF1, 0xEDF0,
    0xEDF2, 0xF0A3, 0xF0A2, 0xF2C4, 0xF2C5, 0xF2C3, 0xC4A5, 0xF4B6,
    0xF4B7, 0xF746, 0xF7EF, 0xF8BB, 0xA6E1, 0xA87D, 0xC17D, 0xA6E2,
    0xD758, 0xDB5B, 0xC641, 0xCA4A, 0xCA4B, 0xCA4D, 0xA6E3, 0xCA4E,
    0xCA4C, 0xCBA2, 0xCBA3, 0xCB7B, 0xCBA1, 0xA8A1, 0xA8A2, 0xCB7C,
    0xCB7A, 0xCB79, 0xCB7D, 0xA87E, 0xCB7E, 0xD06A, 0xCDB6, 0xAADC,
    0xCDB5, 0xCDB7, 0xAADB, 0xCDBC, 0xAADF, 0xCDB2, 0xCDC0, 0xCDC6,
    0xAAE6, 0xCDC3, 0xAAE3, 0xCDB9, 0xCDBF, 0xCDC1, 0xCDB4, 0xAAE2,
    0xAADD, 0xCDBA, 0xAAE4, 0xAAE7, 0xAAE1, 0xAADA, 0xCDBE, 0xCDB8,
    0xCDC5, 0xAAE9, 0xAAE5, 0xAAE0, 0xCDBD, 0xAFEC, 0xCDBB, 0xAADE,
    0xAAE8, 0xCDB3, 0xCDC2, 0xCDC4, 0xAD62, 0xAD5C, 0xAD64, 0xAD61,
    0xD071, 0xD074, 0xAD5D, 0xD06B, 0xAD56, 0xAD60, 0xAD63, 0xAD65,
    0xD0A2, 0xD077, 0xAD55, 0xD0A1, 0xAD59, 0xAD57, 0xAD52, 0xD06F,
    0xD07E, 0xD073, 0xD076, 0xD0A5, 0xAD66, 0xD07D, 0xAD5E, 0xD078,
    0xD0A4, 0xD075, 0xD079, 0xD07C, 0xD06D, 0xD0A3, 0xD07B, 0xD06C,
    0xD070, 0xAD5F, 0xAD5A, 0xAD53, 0xAD58, 0xAD54, 0xAD67, 0xD06E,
    0xD3A5, 0xAD5B, 0xD07A, 0xCE41, 0xD3A8, 0xAFFA, 0xD376, 0xD3A3,
    0xD37D, 0xD3B2, 0xD3AA, 0xD37E, 0xD3A9, 0xD378, 0xD37C, 0xD3B5,
    0xAFFD, 0xD3AD, 0xD3A4, 0xAFED, 0xD3B3, 0xD374, 0xD3AC, 0xAFFC,
    0xAFF7, 0xD373, 0xAFF5, 0xAFF4, 0xAFF9, 0xD3AB, 0xAFF1, 0xAFF8,
    0xD072, 0xDB5C, 0xD3A6, 0xD37A, 0xAFFB, 0xD37B, 0xD3A1, 0xAFFE,
    0xD375, 0xD3AF, 0xD3AE, 0xD3B6, 0xAFF3, 0xAFF0, 0xD3B4, 0xD3B0,
    0xD3A7, 0xD3A2, 0xAFF6, 0xAFF2, 0xD377, 0xAFEE, 0xD3B1, 0xAFEF,
    0xD379, 0xD75E, 0xD760, 0xD765, 0xD779, 0xB2FC, 0xB2F2, 0xD75D,
    0xB2FD, 0xB2FE, 0xD768, 0xD76F, 0xD775, 0xD762, 0xD769, 0xB340,
    0xD777, 0xD772, 0xB2FA, 0xB2F8, 0xD76E, 0xD76A, 0xD75C, 0xB2EF,
    0xD761, 0xD759, 0xB2F7, 0xB2F9, 0xD766, 0xD763, 0xB2F4, 0xD773,
    0xB2F1, 0xD764, 0xD77A, 0xD76C, 0xD76B, 0xB2F0, 0xB2FB, 0xB2F3,
    0xD75A, 0xD75F, 0xD770, 0xD776, 0xB341, 0xD75B, 0xD767, 0xD76D,
    0xB2F6, 0xD778, 0xD771, 0xD774, 0xB2F5, 0xDB6C, 0xDB60, 0xB5D7,
    0xDB7D, 0xDBA7, 0xDBAA, 0xB5D5, 0xDB68, 0xDBA3, 0xDB69, 0xDB77,
    0xB5E2, 0xDB73, 0xB5DF, 0xDB74, 0xDB5D, 0xDBA4, 0xB5E8, 0xDBA1,
    0xDB75, 0xDBAC, 0xDB70, 0xDFC8, 0xDBAF, 0xB5E6, 0xDB6E, 0xDB7A,
    0xB5E9, 0xB5D4, 0xDB72, 0xDBAD, 0xDB6B, 0xDB64, 0xDB6F, 0xDB63,
    0xDB61, 0xB5D0, 0xDBA5, 0xDB6A, 0xDBA8, 0xDBA9, 0xB5D8, 0xB5DD,
    0xB5D9, 0xB5E1, 0xDB7E, 0xB5DA, 0xDB76, 0xDB66, 0xB5D2, 0xDB5E,
    0xDBA2, 0xDBAB, 0xDB65, 0xB5E0, 0xDBB0, 0xDB71, 0xDB6D, 0xB5D1,
    0xB5E5, 0xDB7C, 0xB5E7, 0xDB78, 0xB5DC, 0xB5D6, 0xB5DE, 0xB5D3,
    0xB5E4, 0xDB79, 0xDB67, 0xDB7B, 0xDB62, 0xDBA6, 0xDBAE, 0xDB5F,
    0xDFC7, 0xDFDD, 0xB855, 0xDFCC, 0xDFCA, 0xDFB5, 0xB8A9, 0xDFC5,
    0xDFD9, 0xDFC1, 0xB8B1, 0xDFD8, 0xDFBF, 0xB5E3, 0xDFCF, 0xDFC0,
    0xDFD6, 0xB8B0, 0xB8A8, 0xDFAA, 0xDFB2, 0xDFCB, 0xDFC3, 0xDFDC,
    0xDFC6, 0xB8B6, 0xDFD7, 0xB8AD, 0xDFC9, 0xDFD1, 0xDFB6, 0xDFD0,
    0xDFE1, 0xDFB1, 0xDFD2, 0xDFDF, 0xDFAB, 0xB5DB, 0xDFB9, 0xDFB8,
    0xB8AF, 0xDFBC, 0xDFBE, 0xDFCD, 0xDFDE, 0xB8B2, 0xB8B3, 0xDFB0,
    0xB8AB, 0xDFB4, 0xDFDA, 0xB8B4, 0xB8AC, 0xB8AE, 0xB8B5, 0xDFE0,
    0xDFD3, 0xDFCE, 0xDFBB, 0xDFBA, 0xB8AA, 0xDFAC, 0xB8A7, 0xDFC4,
    0xDFAD, 0xDFC2, 0xDFB7, 0xDFDB, 0xB8A6, 0xDFB3, 0xDFAF, 0xDFD5,
    0xDFAE, 0xBB60, 0xE3D3, 0xE3C2, 0xE3AC, 0xE3CA, 0xBB58, 0xE3BB,
    0xE3C5, 0xBB5B, 0xE3BE, 0xBB59, 0xE3AF, 0xE3CD, 0xE3AE, 0xE3C1,
    0xE3AD, 0xE3BF, 0xE3C8, 0xE3C6, 0xE3BA, 0xE3B5, 0xE3B3, 0xE3B4,
    0xE3C7, 0xE3D2, 0xE3BC, 0xBB5A, 0xE3B7, 0xE3CB, 0xBB5D, 0xE3B6,
    0xE3B0, 0xE3C0, 0xBB61, 0xBB55, 0xBB5E, 0xE3B8, 0xE3B2, 0xBB57,
    0xDFD4, 0xBB56, 0xE3C3, 0xBB54, 0xBB63, 0xBB5C, 0xE3C4, 0xE3B9,
    0xE3B1, 0xE3CC, 0xE3BD, 0xBB62, 0xE3D0, 0xBB5F, 0xE3CF, 0xE3C9,
    0xE3CE, 0xE3D1, 0xE773, 0xE774, 0xE767, 0xE766, 0xE762, 0xBDB4,
    0xBDAC, 0xE776, 0xE775, 0xDFA9, 0xE75F, 0xE763, 0xE75D, 0xE770,
    0xE761, 0xE777, 0xE75A, 0xE758, 0xE764, 0xE76E, 0xE769, 0xBDB6,
    0xE74F, 0xE76D, 0xBDB7, 0xDFBD, 0xE75B, 0xE752, 0xE755, 0xE77B,
    0xE75C, 0xE753, 0xE751, 0xE74E, 0xBDB0, 0xE765, 0xBDAF, 0xBDB3,
    0xE760, 0xE768, 0xBDA9, 0xE778, 0xE77C, 0xBDAB, 0xE757, 0xE76B,
    0xE76F, 0xE754, 0xE779, 0xBDB2, 0xBDB1, 0xE74C, 0xBDB5, 0xE772,
    0xE756, 0xE76A, 0xE750, 0xE75E, 0xE759, 0xBDAD, 0xBDAE, 0xE76C,
    0xE77D, 0xE77A, 0xE771, 0xE74D, 0xBDAA, 0xEB49, 0xEB40, 0xEB43,
    0xBFBB, 0xEB45, 0xEAF9, 0xEB41, 0xEB47, 0xBFB8, 0xBFBC, 0xBFB6,
    0xEAFB, 0xEB4C, 0xEB46, 0xEAFC, 0xEB55, 0xEB4F, 0xEAF8, 0xEE46,
    0xEAFE, 0xBFB7, 0xEB4A, 0xEB54, 0xBFBF, 0xEB51, 0xEAFD, 0xEB44,
    0xEB48, 0xEB42, 0xEB56, 0xEB53, 0xEB50, 0xBFB9, 0xBFBA, 0xBFBE,
    0xEAFA, 0xEB57, 0xBFBD, 0xEB4D, 0xEB4B, 0xEB4E, 0xEE53, 0xEE40,
    0xEE45, 0xEE52, 0xEE44, 0xEDFB, 0xEE41, 0xC1A2, 0xEDF4, 0xEE4D,
    0xEE4F, 0xEDF3, 0xC1A1, 0xEE51, 0xEE49, 0xC1A8, 0xEE50, 0xEE42,
    0xC1AA, 0xEDF9, 0xEB52, 0xEE4A, 0xEE47, 0xEDF5, 0xEE55, 0xC1A4,
    0xC1A5, 0xEDF7, 0xEE48, 0xEE54, 0xEE4B, 0xEDFD, 0xC1A7, 0xC1A3,
    0xEE4C, 0xEDFE, 0xEE56, 0xEDF8, 0xEE43, 0xEE4E, 0xEDFA, 0xEDFC,
    0xC2CB, 0xEDF6, 0xC1A9, 0xC2C4, 0xC17E, 0xC1A6, 0xC2C8, 0xF0B3,
    0xF0A9, 0xF0A4, 0xF0AA, 0xF0B4, 0xF0B8, 0xF0B7, 0xC2CA, 0xC2C9,
    0xF0AB, 0xF0B9, 0xF0AE, 0xF0A6, 0xF0A8, 0xF0A7, 0xF0AD, 0xF0B2,
    0xF0A5, 0xF0AC, 0xF0B1, 0xC2C7, 0xF0AF, 0xC2C5, 0xF0B0, 0xC2C3,
    0xC2C6, 0xF2D5, 0xF0B5, 0xC3C2, 0xF2CD, 0xF2D1, 0xF2C9, 0xF2CC,
    0xF2D4, 0xC3C0, 0xF2D9, 0xF2D2, 0xF2CA, 0xF2DA, 0xF2D3, 0xC3C3,
    0xC3C4, 0xF2D7, 0xF2CB, 0xC3BF, 0xC3C1, 0xF2C6, 0xF2CE, 0xF2C8,
    0xF2D8, 0xF2D6, 0xF2C7, 0xF2CF, 0xF4BE, 0xC3C5, 0xF2D0, 0xC4A7,
    0xC4A9, 0xC4A6, 0xF4C3, 0xF4BB, 0xF4B9, 0xF4BD, 0xF4BA, 0xF4BF,
    0xF4C1, 0xC4AA, 0xC4AC, 0xF4C0, 0xC4AD, 0xC4AB, 0xF4C2, 0xC4A8,
    0xC4F4, 0xF5F1, 0xF5F7, 0xC4F6, 0xF4BC, 0xF5F6, 0xF5FD, 0xF5F4,
    0xF5FB, 0xF5FA, 0xF4B8, 0xF5F5, 0xF0B6, 0xF5FE, 0xF5F3, 0xF5F8,
    0xF5FC, 0xF5F2, 0xF74A, 0xC4F5, 0xF5F9, 0xF7F4, 0xF74B, 0xF749,
    0xF747, 0xF748, 0xF74C, 0xC5D9, 0xF7F2, 0xF7F0, 0xF7F5, 0xF7F3,
    0xF7F6, 0xC5DA, 0xF7F1, 0xF8BC, 0xF945, 0xF946, 0xF947, 0xF9C7,
    0xF9BD, 0xCA4F, 0xAAEA, 0xAD68, 0xD3B8, 0xD3B7, 0xB040, 0xB342,
    0xD77C, 0xD77B, 0xB5EA, 0xB8B8, 0xB8B7, 0xB8B9, 0xE3D4, 0xE77E,
    0xEB58, 0xEB5A, 0xEB59, 0xC1AB, 0xEE57, 0xF0BA, 0xF9A5, 0xA6E4,
    0xCDC9, 0xCDCA, 0xCDC8, 0xCDC7, 0xAAEB, 0xD0A9, 0xD0A7, 0xD0A6,
    0xAD69, 0xAD6B, 0xAD6A, 0xD0A8, 0xD3C4, 0xD3C1, 0xD3BF, 0xB041,
    0xD3C2, 0xB046, 0xD3BC, 0xD3CB, 0xD3CD, 0xD3BD, 0xB043, 0xD3CE,
    0xD3C9, 0xD3BB, 0xD3C0, 0xD3CA, 0xD3C6, 0xD3C3, 0xB048, 0xD3CC,
    0xD3BE, 0xD3C7, 0xD3B9, 0xB047, 0xB044, 0xD3C5, 0xD3C8, 0xD3BA,
    0xB045, 0xB042, 0xB34C, 0xD7A5, 0xB34B, 0xD7A8, 0xD7AB, 0xB348,
    0xB346, 0xD77E, 0xD7A9, 0xD7A7, 0xD7A4, 0xD7AC, 0xD7AD, 0xD7AF,
    0xD7B0, 0xD77D, 0xB345, 0xD7A2, 0xD7A1, 0xD7AE, 0xB347, 0xD7A3,
    0xB349, 0xB344, 0xD7A6, 0xB34D, 0xB34A, 0xD7AA, 0xB5F1, 0xDBBF,
    0xDBB4, 0xB5EE, 0xDFE7, 0xDBBD, 0xDBB1, 0xB5EC, 0xDBB6, 0xB5EF,
    0xDBBA, 0xDBB8, 0xB5F2, 0xB5EB, 0xDBB2, 0xDBB5, 0xB5F0, 0xDBB3,
    0xDBBE, 0xDBBC, 0xDBB7, 0xDBB9, 0xDBBB, 0xB5ED, 0xDFE8, 0xDFEE,
    0xDFE4, 0xDFEA, 0xB8BA, 0xDFE6, 0xB8C0, 0xB8BF, 0xB8BE, 0xDFED,
    0xB8C1, 0xB8C2, 0xDFE3, 0xDFF0, 0xB8C3, 0xB8BD, 0xB8BC, 0xDFEC,
    0xB8C4, 0xDFE2, 0xDFE5, 0xDFEF, 0xDFEB, 0xE3F4, 0xE3E9, 0xB8BB,
    0xBB6A, 0xE3DD, 0xE3F2, 0xE3DE, 0xBB65, 0xE3DB, 0xE3E4, 0xE3DC,
    0xBB67, 0xE3D6, 0xE3F1, 0xBB68, 0xE3EE, 0xE3EF, 0xE3D7, 0xBB6D,
    0xE3E6, 0xE3E0, 0xE3E7, 0xE3DA, 0xE3F3, 0xE3EB, 0xE3E5, 0xE3D5,
    0xBB69, 0xE3EC, 0xBB6C, 0xE3F0, 0xE3EA, 0xBB66, 0xE3E8, 0xE3E2,
    0xBB64, 0xE3D9, 0xE3E1, 0xE3ED, 0xE3DF, 0xE3E3, 0xBDC1, 0xDFE9,
    0xE7B2, 0xE7BB, 0xE7B1, 0xE7AD, 0xE7AA, 0xBDC2, 0xE7A8, 0xBB6B,
    0xE7A1, 0xBDC0, 0xE7A7, 0xBDBF, 0xE7AC, 0xE7A9, 0xE7B9, 0xE7B4,
    0xE7AE, 0xE7B3, 0xBDBB, 0xE7AB, 0xE7BE, 0xE7A2, 0xE7A3, 0xE7BA,
    0xBDBC, 0xE7BF, 0xBDBE, 0xE7C0, 0xE7B0, 0xE3D8, 0xE7B6, 0xE7AF,
    0xE7B8, 0xE7B5, 0xE7A6, 0xBDB9, 0xE7BD, 0xBDBA, 0xE7A4, 0xBDBD,
    0xEB64, 0xE7B7, 0xE7BC, 0xEB61, 0xBDB8, 0xBFC0, 0xEB6B, 0xEB67,
    0xEB65, 0xEB60, 0xEB6F, 0xBFC4, 0xEB5C, 0xEB68, 0xEB69, 0xEB5F,
    0xEB5E, 0xEB6C, 0xEB62, 0xEB5D, 0xEB63, 0xEB6E, 0xEB5B, 0xEB6D,
    0xEB6A, 0xBFC2, 0xBFC1, 0xBFC3, 0xEB66, 0xF0CB, 0xEE59, 0xC1B1,
    0xEE5D, 0xEE5A, 0xEE61, 0xEE67, 0xEE5C, 0xEE70, 0xC1AE, 0xEE6A,
    0xEE5F, 0xEE6B, 0xEE66, 0xEE6D, 0xEE5E, 0xC1B3, 0xC1B2, 0xEE60,
    0xEE6E, 0xEE58, 0xEE6C, 0xC1AC, 0xEE64, 0xEE63, 0xEE68, 0xEE5B,
    0xC1B0, 0xC1B4, 0xEE62, 0xEE69, 0xC1B5, 0xEE65, 0xC1AD, 0xC1AF,
    0xF0C7, 0xF0C5, 0xF0CC, 0xF0C9, 0xF0CD, 0xF0BE, 0xF0C6, 0xF0D1,
    0xEE6F, 0xF0C2, 0xC2CF, 0xE7A5, 0xF0BD, 0xF0CA, 0xF0C4, 0xF0C1,
    0xF0BC, 0xF0BB, 0xF0D0, 0xF0C0, 0xF0BF, 0xC2CD, 0xF0C8, 0xC2CC,
    0xC2CE, 0xF0C3, 0xF0CF, 0xF2DE, 0xF2DF, 0xC3C9, 0xF2DC, 0xC3C6,
    0xF2E4, 0xC3CA, 0xF2E6, 0xF2DB, 0xF0CE, 0xF2E8, 0xF2DD, 0xC3C7,
    0xF2E3, 0xF2E5, 0xF2E0, 0xF2E7, 0xF2E2, 0xF2E1, 0xC3C8, 0xF4C5,
    0xF4C6, 0xF4C8, 0xC4AE, 0xC4AF, 0xF4C9, 0xF4C7, 0xF4C4, 0xF642,
    0xF645, 0xF641, 0xC4FA, 0xF643, 0xC4F9, 0xC4F8, 0xC4F7, 0xF644,
    0xF751, 0xF74F, 0xF74E, 0xF640, 0xF750, 0xF646, 0xF74D, 0xF7F9,
    0xF7D7, 0xF7F7, 0xC5DB, 0xF7F8, 0xF7FA, 0xF8BF, 0xC5FA, 0xF8BE,
    0xF8BD, 0xC5FB, 0xC65A, 0xF96E, 0xF9A7, 0xF9A6, 0xF9A8, 0xA6E5,
    0xD0AA, 0xD3CF, 0xD3D0, 0xDBC0, 0xF647, 0xF8C0, 0xA6E6, 0xAD6C,
    0xD0AB, 0xD7B1, 0xB34E, 0xDBC2, 0xDBC1, 0xB5F3, 0xB8C5, 0xE7C1,
    0xBDC3, 0xBDC4, 0xBFC5, 0xC5FC, 0xA6E7, 0xD0AC, 0xAAED, 0xD0AE,
    0xD0AD, 0xAD6D, 0xD3D1, 0xD3D8, 0xB049, 0xD3D6, 0xD3D4, 0xD3DB,
    0xD3D2, 0xD3D3, 0xB04A, 0xB04E, 0xD3DC, 0xB04D, 0xD3DA, 0xD3D7,
    0xD3D5, 0xB04B, 0xB04C, 0xD3D9, 0xB350, 0xD7B2, 0xB355, 0xD7C2,
    0xB354, 0xD7C4, 0xD7B8, 0xB352, 0xD7C3, 0xD7B3, 0xB353, 0xD7BF,
    0xD7BB, 0xD7BD, 0xD7B7, 0xD7BE, 0xB34F, 0xD7BA, 0xD7B9, 0xD7B5,
    0xD7C0, 0xD7BC, 0xD7B4, 0xD7B6, 0xB351, 0xD7C1, 0xB5F6, 0xDBCD,
    0xDBC9, 0xDBCB, 0xDBC6, 0xDBC5, 0xDBC3, 0xDBCA, 0xDBCC, 0xDBC8,
    0xDBC7, 0xB5F4, 0xB5F5, 0xDBCF, 0xB8CD, 0xDFF2, 0xDFF8, 0xDFF3,
    0xDFF4, 0xDFF9, 0xB8CF, 0xB8C7, 0xB8CE, 0xDFF1, 0xDBC4, 0xB8CA,
    0xB8C8, 0xDFF7, 0xDFF6, 0xB8C9, 0xB8CB, 0xDFF5, 0xB8C6, 0xB8CC,
    0xE3F6, 0xBB74, 0xE442, 0xE441, 0xE3FB, 0xBB76, 0xE440, 0xE3F7,
    0xE3F8, 0xBB6E, 0xBB70, 0xE3FD, 0xE3F5, 0xBB72, 0xBB71, 0xE3F9,
    0xE3FE, 0xE3FC, 0xBB73, 0xE3FA, 0xDBCE, 0xBB6F, 0xE7C2, 0xE7C9,
    0xBDC6, 0xE7CD, 0xBDCA, 0xE7C5, 0xE7C3, 0xE7CC, 0xBDC5, 0xE7CB,
    0xBDC7, 0xBDC8, 0xE7C4, 0xBDC9, 0xE7CA, 0xE7C6, 0xE7C7, 0xE7C8,
    0xBB75, 0xEB70, 0xEB7C, 0xBFCA, 0xEB77, 0xEB79, 0xBFC8, 0xEB71,
    0xEB75, 0xEB78, 0xBFC6, 0xBFC9, 0xEB7B, 0xEB73, 0xEB74, 0xEB7A,
    0xEB72, 0xEB76, 0xBFC7, 0xEE72, 0xEE71, 0xC1B7, 0xEE77, 0xC1B9,
    0xC1B6, 0xEE73, 0xC1BA, 0xEE74, 0xEE75, 0xEE78, 0xC1B8, 0xF0D6,
    0xF0D9, 0xF0D3, 0xF0D5, 0xF0D4, 0xF0D7, 0xF0D8, 0xEE76, 0xF0D2,
    0xC3CD, 0xF2EC, 0xF2EF, 0xF2F1, 0xF2EA, 0xF2EB, 0xF2EE, 0xF2F0,
    0xC3CE, 0xC3CC, 0xC3CB, 0xF2ED, 0xF2E9, 0xF4CA, 0xC4B0, 0xF4CB,
    0xF649, 0xC4FB, 0xF64B, 0xC4FC, 0xF648, 0xF64A, 0xC5A8, 0xF752,
    0xC5A7, 0xF7FD, 0xF7FC, 0xF7FB, 0xF948, 0xF949, 0xF94B, 0xF94A,
    0xCA50, 0xA6E8, 0xAD6E, 0xD7C5, 0xB5F7, 0xDFFA, 0xC2D0, 0xF2F2,
    0xA8A3, 0xB357, 0xB356, 0xDBD0, 0xB5F8, 0xDBD2, 0xDBD1, 0xDFFB,
    0xB8D0, 0xE443, 0xE446, 0xE445, 0xE444, 0xE7CE, 0xE7D0, 0xE7CF,
    0xBFCC, 0xBFCB, 0xC1BB, 0xEE79, 0xEE7B, 0xEE7A, 0xC2D1, 0xF2F4,
    0xF2F3, 0xF4CC, 0xC4B1, 0xC4FD, 0xF754, 0xF753, 0xC65B, 0xA8A4,
    0xD0AF, 0xAD6F, 0xD7C8, 0xD7C6, 0xD7C7, 0xDBD4, 0xDBD5, 0xE043,
    0xDBD3, 0xDFFC, 0xE041, 0xE040, 0xE042, 0xB8D1, 0xDFFE, 0xDFFD,
    0xE044, 0xE449, 0xE447, 0xE448, 0xE7D3, 0xE7D1, 0xE7D2, 0xEB7D,
    0xEE7C, 0xEE7D, 0xC2D2, 0xF2F5, 0xF4CD, 0xC4B2, 0xF64C, 0xF755,
    0xC5A9, 0xF7FE, 0xF94C, 0xA8A5, 0xAD71, 0xAD72, 0xD0B0, 0xD0B1,
    0xAD70, 0xB054, 0xB052, 0xB051, 0xB058, 0xB050, 0xB059, 0xD3DD,
    0xB056, 0xB053, 0xB057, 0xB055, 0xB04F, 0xB35F, 0xB359, 0xD7CC,
    0xB35E, 0xB360, 0xB35A, 0xB35B, 0xD7CA, 0xB358, 0xD7CB, 0xB35D,
    0xD7C9, 0xB35C, 0xB644, 0xB646, 0xDBD8, 0xB645, 0xB5F9, 0xB5FD,
    0xB8E4, 0xE049, 0xDBDA, 0xB5FE, 0xDBDD, 0xDBDE, 0xB643, 0xDBE0,
    0xDBE2, 0xDBE3, 0xDBD7, 0xDBD6, 0xDBE4, 0xB642, 0xDBE1, 0xDBDF,
    0xB640, 0xB5FB, 0xB647, 0xDBDB, 0xDBDC, 0xDBD9, 0xB641, 0xB5FC,
    0xB5FA, 0xE048, 0xB8DF, 0xB8DA, 0xB8D5, 0xB8E5, 0xB8D6, 0xB8D2,
    0xB8E1, 0xB8DE, 0xB8E0, 0xB8D7, 0xB8DC, 0xB8D3, 0xB8D4, 0xE050,
    0xE04D, 0xE045, 0xE04A, 0xB8E2, 0xE051, 0xB8E3, 0xB8D9, 0xE047,
    0xE04F, 0xE04B, 0xE04E, 0xE04C, 0xB8DD, 0xE046, 0xB8D8, 0xE44C,
    0xBB78, 0xBB7B, 0xE44E, 0xBBA5, 0xE44D, 0xBB7D, 0xBDCF, 0xE44F,
    0xBBA4, 0xE44B, 0xBBA6, 0xBB79, 0xB8DB, 0xBB7C, 0xBB7A, 0xBB7E,
    0xBBA2, 0xBB77, 0xBBA7, 0xBBA3, 0xBBA1, 0xE44A, 0xBDD6, 0xBDD2,
    0xBDD9, 0xE7D6, 0xBDDA, 0xE7E2, 0xE7DB, 0xBDCB, 0xE7E3, 0xE7DD,
    0xBDD5, 0xE7DE, 0xBDD4, 0xE7E1, 0xBDCE, 0xE7DF, 0xE7D5, 0xBDCD,
    0xEBAA, 0xBDD3, 0xBDD0, 0xBDD8, 0xE7D4, 0xE7D8, 0xBDCC, 0xE7D7,
    0xE7D9, 0xE7DA, 0xBDD7, 0xE7DC, 0xE7E0, 0xE7E4, 0xBDDB, 0xBFD2,
    0xEBA5, 0xEBAB, 0xEBA8, 0xEB7E, 0xEBAC, 0xEBA1, 0xEBA7, 0xBFCD,
    0xBFD3, 0xEBAD, 0xBFCF, 0xBFD9, 0xBFD4, 0xEBAF, 0xEBA9, 0xBFD0,
    0xEBA2, 0xBFDA, 0xEBA3, 0xEBA4, 0xBFDB, 0xBFD8, 0xBDD1, 0xBFCE,
    0xEBB0, 0xBFDC, 0xBFD5, 0xEBAE, 0xBFD1, 0xBFD6, 0xBFD7, 0xC1C3,
    0xEEA4, 0xEEAD, 0xEEAA, 0xEEAC, 0xC1C0, 0xEEA5, 0xEEAB, 0xC1BC,
    0xEEA7, 0xC1C4, 0xEEA3, 0xEEA8, 0xEEAF, 0xEBA6, 0xEEA9, 0xEEA2,
    0xC1BD, 0xEEA1, 0xC1BE, 0xEEB0, 0xC1BF, 0xEEAE, 0xC1C2, 0xEE7E,
    0xC1C1, 0xEEA6, 0xF0DC, 0xF0EA, 0xF0E5, 0xF0E7, 0xF0DB, 0xC2D3,
    0xF0DA, 0xC2D6, 0xC2D5, 0xF0E9, 0xF0E1, 0xF0DE, 0xF0E4, 0xF0DD,
    0xF0DF, 0xF0E8, 0xF0E6, 0xC2D4, 0xF0ED, 0xF0EB, 0xF0E2, 0xF0EC,
    0xF0E3, 0xF2F9, 0xC3CF, 0xF341, 0xF64F, 0xC3D6, 0xF0E0, 0xF2F7,
    0xC3D2, 0xF2F8, 0xF2FD, 0xC3D4, 0xC3D5, 0xF2F6, 0xF340, 0xF342,
    0xF2FA, 0xF2FC, 0xF2FE, 0xF2FB, 0xF343, 0xC3D1, 0xC3D7, 0xC3D3,
    0xC3D0, 0xF4D0, 0xC4B7, 0xF4CE, 0xF4D2, 0xF4D3, 0xC4B5, 0xF4D4,
    0xF4D1, 0xF4CF, 0xC4B8, 0xC4B4, 0xF4D5, 0xC4B6, 0xC4B3, 0xC4FE,
    0xC540, 0xF64E, 0xF64D, 0xF650, 0xF651, 0xC541, 0xF756, 0xF75B,
    0xC5AA, 0xF758, 0xF757, 0xF75A, 0xF759, 0xF843, 0xC5DC, 0xF842,
    0xF840, 0xF841, 0xC5FE, 0xC5FD, 0xF8C1, 0xF8C2, 0xC640, 0xF94D,
    0xF94E, 0xC667, 0xC66D, 0xF9A9, 0xF9C8, 0xA8A6, 0xD7CD, 0xD7CE,
    0xE052, 0xE450, 0xE7E5, 0xC1C6, 0xC1C5, 0xF0EE, 0xF344, 0xF844,
    0xA8A7, 0xD3DE, 0xB05A, 0xB361, 0xE054, 0xE053, 0xBDDC, 0xE7E6,
    0xBDDD, 0xEEB1, 0xC2D7, 0xC676, 0xA8A8, 0xCDCB, 0xD3DF, 0xB362,
    0xD7CF, 0xD7D0, 0xDBE5, 0xB648, 0xB8E6, 0xE056, 0xE055, 0xE057,
    0xE451, 0xE452, 0xBBA8, 0xBFDD, 0xBDDE, 0xBFDE, 0xEEB5, 0xEEB2,
    0xEEB4, 0xEEB3, 0xC1C7, 0xF0EF, 0xF346, 0xF345, 0xCBA4, 0xB05C,
    0xB05B, 0xD3E0, 0xD7D1, 0xDBE7, 0xDBE6, 0xB649, 0xE059, 0xE05A,
    0xE058, 0xB8E8, 0xB8E7, 0xBBAA, 0xBBA9, 0xE7E7, 0xEBB3, 0xEBB1,
    0xEBB2, 0xBFDF, 0xEEB7, 0xEEB6, 0xF0F2, 0xF0F1, 0xF0F0, 0xF347,
    0xF9AA, 0xA8A9, 0xAD73, 0xAD74, 0xB05D, 0xB05E, 0xD3E2, 0xD3E1,
    0xD7D2, 0xB368, 0xB366, 0xB363, 0xB367, 0xB365, 0xB364, 0xB64A,
    0xDBEA, 0xB8ED, 0xB64C, 0xB651, 0xDBEC, 0xB653, 0xB652, 0xB655,
    0xDBEB, 0xDBE8, 0xB64F, 0xB64B, 0xB64D, 0xDBE9, 0xB654, 0xB650,
    0xB64E, 0xB8EF, 0xB8EE, 0xB8EC, 0xB8F0, 0xB8EA, 0xB8EB, 0xB8E9,
    0xE05B, 0xE454, 0xBBAC, 0xBBAD, 0xBBAB, 0xE453, 0xE455, 0xE7EA,
    0xE7EC, 0xBDE7, 0xE7ED, 0xBDE0, 0xE7E9, 0xBDDF, 0xBDE9, 0xBDE5,
    0xBDE6, 0xBDE2, 0xE7E8, 0xBDE1, 0xE7EE, 0xE7EB, 0xBDE8, 0xBDE3,
    0xBDE4, 0xEBB5, 0xEBB7, 0xEBB6, 0xEBB8, 0xBFE0, 0xEBB4, 0xC1CB,
    0xEEB8, 0xC1C8, 0xC1CC, 0xC1CA, 0xC1C9, 0xF0F3, 0xF0F6, 0xF0F5,
    0xF0F4, 0xC2D8, 0xF348, 0xF349, 0xC3D8, 0xF34A, 0xC3D9, 0xC4BA,
    0xC4B9, 0xF652, 0xC542, 0xF653, 0xF75C, 0xC5AB, 0xC5AC, 0xF845,
    0xC642, 0xA8AA, 0xB36A, 0xB369, 0xE05C, 0xE05D, 0xBBAE, 0xEBB9,
    0xBDEA, 0xEBBA, 0xEEB9, 0xA8AB, 0xD0B2, 0xAD76, 0xAD75, 0xD3E3,
    0xB05F, 0xD3E4, 0xD7D5, 0xD7D4, 0xD7D3, 0xDBEE, 0xB658, 0xDBED,
    0xB657, 0xDBEF, 0xB656, 0xE05F, 0xE062, 0xE060, 0xE061, 0xE065,
    0xE05E, 0xE066, 0xE063, 0xE064, 0xBBB0, 0xE456, 0xBBAF, 0xE7F2,
    0xE7F0, 0xBDEB, 0xE7EF, 0xE7F1, 0xBDEC, 0xEBBB, 0xEBBC, 0xC1CD,
    0xF34C, 0xF34E, 0xF34B, 0xF34D, 0xF4D6, 0xF654, 0xF96F, 0xA8AC,
    0xAD77, 0xD3E5, 0xD3E7, 0xD3E6, 0xD7D8, 0xB36C, 0xD7D6, 0xB36B,
    0xD7D9, 0xD7DA, 0xD7D7, 0xDBFB, 0xB660, 0xDBF3, 0xDBF9, 0xB65B,
    0xB65E, 0xDBF2, 0xB659, 0xDBF6, 0xE06C, 0xB65D, 0xDBF1, 0xDBF7,
    0xDBF4, 0xDBFA, 0xDBF0, 0xDBF8, 0xB65C, 0xB65F, 0xDBF5, 0xB65A,
    0xB8F2, 0xE068, 0xB8F1, 0xE06F, 0xE06E, 0xB8F8, 0xB8F9, 0xE070,
    0xB8F3, 0xE06D, 0xB8F7, 0xE072, 0xE069, 0xE06B, 0xB8F4, 0xE067,
    0xE06A, 0xE071, 0xB8F5, 0xE073, 0xB8F6, 0xBBB1, 0xE45B, 0xE461,
    0xE459, 0xE462, 0xE458, 0xE45D, 0xE463, 0xE460, 0xE45F, 0xE45E,
    0xE457, 0xE45C, 0xE45A, 0xBDF1, 0xBDEE, 0xE7FB, 0xE841, 0xE843,
    0xE840, 0xE7F8, 0xE7FA, 0xE845, 0xE842, 0xE7FC, 0xE846, 0xE7F9,
    0xE844, 0xBDEF, 0xBDF5, 0xBDF3, 0xE7F3, 0xBDF4, 0xBDF0, 0xE7F4,
    0xE7F6, 0xE7F5, 0xE7FD, 0xE7FE, 0xBDF2, 0xBDED, 0xE7F7, 0xEBC6,
    0xBFE2, 0xEBBD, 0xBFE3, 0xBFE6, 0xEBC2, 0xEBBF, 0xBFE5, 0xEBC3,
    0xEBC4, 0xEBBE, 0xEBC7, 0xEBC0, 0xEBC5, 0xBFE4, 0xBFE1, 0xEBC1,
    0xEEBF, 0xC1D0, 0xC1CE, 0xC1D1, 0xC1CF, 0xEEBE, 0xEEBB, 0xEEBA,
    0xEEBD, 0xEEBC, 0xF145, 0xC2DE, 0xF0FB, 0xF0FA, 0xC2D9, 0xF141,
    0xF140, 0xF0F7, 0xF143, 0xF0FC, 0xC2DD, 0xF0F9, 0xF142, 0xF0F8,
    0xC2DA, 0xC2DC, 0xF0FD, 0xC2DB, 0xF0FE, 0xF144, 0xF352, 0xC3DE,
    0xF34F, 0xF353, 0xC3DB, 0xF351, 0xC3E0, 0xC3DD, 0xF350, 0xC3DF,
    0xF354, 0xC3DA, 0xC4BC, 0xC4BE, 0xF4D9, 0xC4BD, 0xF4D7, 0xC3DC,
    0xF4D8, 0xC4BB, 0xC543, 0xC545, 0xF656, 0xC544, 0xF655, 0xF761,
    0xC5AD, 0xF760, 0xC5AE, 0xF75E, 0xF75D, 0xF762, 0xF763, 0xF846,
    0xF75F, 0xF8C6, 0xF8C3, 0xF8C4, 0xF8C5, 0xC65C, 0xF951, 0xF950,
    0xF94F, 0xF970, 0xF9BE, 0xF9AB, 0xC66E, 0xA8AD, 0xB060, 0xB8FA,
    0xBDF6, 0xEBC8, 0xC2DF, 0xF355, 0xF9AC, 0xA8AE, 0xAAEE, 0xAD79,
    0xAD78, 0xB063, 0xD3E8, 0xB061, 0xD3E9, 0xB062, 0xD7DF, 0xD7DB,
    0xB36D, 0xD7DE, 0xD7DD, 0xD7DC, 0xB36E, 0xD7E0, 0xD7E1, 0xDC43,
    0xDC41, 0xDC45, 0xDC46, 0xDC4C, 0xDC48, 0xDC4A, 0xDC42, 0xDBFC,
    0xDC49, 0xDC4B, 0xDC44, 0xDC47, 0xDBFD, 0xB662, 0xDC40, 0xDBFE,
    0xB661, 0xB663, 0xB8FD, 0xE075, 0xE077, 0xE076, 0xE07B, 0xB8FB,
    0xE078, 0xE074, 0xE079, 0xE07A, 0xB8FC, 0xB8FE, 0xE07C, 0xE467,
    0xE466, 0xE464, 0xE465, 0xBBB3, 0xBBB5, 0xBBB2, 0xBBB4, 0xE84D,
    0xE84E, 0xE849, 0xE84A, 0xBDF8, 0xBDFD, 0xBDF7, 0xBDFE, 0xBDF9,
    0xE84B, 0xE84C, 0xE848, 0xBE40, 0xBDFB, 0xBDFA, 0xBDFC, 0xE847,
    0xEBCA, 0xBFE8, 0xEBCC, 0xBFEA, 0xEBCF, 0xEBCB, 0xEBC9, 0xEBCE,
    0xBFE9, 0xEBCD, 0xBFE7, 0xC1D3, 0xC1D6, 0xEEC1, 0xC1D4, 0xEEC0,
    0xC1D2, 0xC1D5, 0xF146, 0xF147, 0xF148, 0xC2E0, 0xF149, 0xC2E1,
    0xC3E2, 0xF358, 0xF359, 0xF357, 0xF356, 0xF35A, 0xC3E1, 0xF4DD,
    0xF4DB, 0xF4DC, 0xF4DE, 0xF4DA, 0xF4DF, 0xF658, 0xF659, 0xF657,
    0xC546, 0xF764, 0xC5AF, 0xF765, 0xF848, 0xF847, 0xA8AF, 0xB664,
    0xB940, 0xBBB6, 0xBFEC, 0xBFEB, 0xC3E3, 0xC47C, 0xC547, 0xA8B0,
    0xB064, 0xB941, 0xF35B, 0xCBA6, 0xA8B1, 0xA8B4, 0xA8B3, 0xA8B2,
    0xCBA5, 0xCDCD, 0xCDCF, 0xAAEF, 0xAAF1, 0xCDCC, 0xCDCE, 0xAAF0,
    0xCDD1, 0xCDD0, 0xCDD2, 0xD0B6, 0xD0B4, 0xAD7C, 0xD0B3, 0xADA3,
    0xAD7E, 0xAD7B, 0xADA4, 0xAD7D, 0xADA2, 0xADA1, 0xD0B5, 0xAD7A,
    0xB06A, 0xD3EB, 0xD3F1, 0xB067, 0xB06E, 0xB069, 0xD3EE, 0xD3F0,
    0xB06C, 0xD3EA, 0xD3ED, 0xB068, 0xB065, 0xD3EC, 0xB06B, 0xD3EF,
    0xB06D, 0xB066, 0xD7E3, 0xD7E6, 0xB370, 0xB37A, 0xB376, 0xD7E4,
    0xB37E, 0xB377, 0xB37C, 0xB372, 0xB36F, 0xB371, 0xB37D, 0xD7E5,
    0xB375, 0xB378, 0xB374, 0xB379, 0xD7E7, 0xB37B, 0xB373, 0xD7E2,
    0xDC4D, 0xB665, 0xDC4F, 0xB667, 0xB669, 0xDC4E, 0xB666, 0xB66A,
    0xB668, 0xB947, 0xE0A3, 0xB94F, 0xE07E, 0xB950, 0xB945, 0xE0A1,
    0xB94A, 0xE0A2, 0xB943, 0xB942, 0xB94D, 0xB94C, 0xB94B, 0xB949,
    0xB94E, 0xE07D, 0xB944, 0xB946, 0xB948, 0xBBB8, 0xBBBB, 0xBBBF,
    0xBBB9, 0xBBBE, 0xBBBC, 0xBBB7, 0xBBBD, 0xBBBA, 0xE852, 0xBE43,
    0xBE41, 0xE853, 0xBE44, 0xBE42, 0xE851, 0xE850, 0xBFF0, 0xE84F,
    0xBFEE, 0xBFED, 0xEBD0, 0xBE45, 0xBFEF, 0xEBD1, 0xBFF2, 0xEBD2,
    0xBFF1, 0xC1D8, 0xEEC3, 0xC1D7, 0xC1DC, 0xC1DA, 0xC1DB, 0xC2E3,
    0xC1D9, 0xEEC2, 0xEBD3, 0xC2E2, 0xC2E4, 0xC3E4, 0xC3E5, 0xF4E0,
    0xC5DE, 0xC5DD, 0xA8B6, 0xCA55, 0xB06F, 0xCA52, 0xCA53, 0xCA51,
    0xCA54, 0xCBAA, 0xCBA7, 0xCBAC, 0xCBA8, 0xA8B7, 0xA8BA, 0xCBA9,
    0xA8B9, 0xCBAB, 0xA8B8, 0xCDD5, 0xCDD7, 0xAAF4, 0xCDD3, 0xCDD6,
    0xCDD4, 0xAAF2, 0xAAF5, 0xAAF3, 0xD0B8, 0xD0BC, 0xD0B9, 0xADA7,
    0xADA8, 0xD0BB, 0xD0BD, 0xD0BF, 0xADA5, 0xD0BE, 0xADA6, 0xD7EE,
    0xD0BA, 0xD3F2, 0xD3FB, 0xD3F9, 0xD3F4, 0xD3F5, 0xD3FA, 0xD3FC,
    0xB071, 0xD3F7, 0xD3F3, 0xB070, 0xB072, 0xD3F6, 0xD3FD, 0xD3F8,
    0xB3A1, 0xD7F1, 0xD7E9, 0xD7EF, 0xD7F0, 0xB3A2, 0xD7E8, 0xD7EA,
    0xD0B7, 0xD7EC, 0xD7ED, 0xD7EB, 0xB66C, 0xDC56, 0xEBD4, 0xDC57,
    0xDC54, 0xB3A3, 0xB66E, 0xDC53, 0xDC59, 0xDC58, 0xB66B, 0xDC5C,
    0xDC52, 0xDC5B, 0xDC50, 0xDC5A, 0xDC55, 0xB66D, 0xE0AA, 0xE0A5,
    0xE0AB, 0xE0A6, 0xE0A4, 0xE0A7, 0xB951, 0xE0A9, 0xE0A8, 0xB952,
    0xBBC1, 0xBBC0, 0xE46E, 0xE471, 0xE469, 0xE46D, 0xBBC2, 0xE46C,
    0xE46A, 0xE470, 0xE46B, 0xE468, 0xE46F, 0xE859, 0xBE48, 0xF14A,
    0xE856, 0xE857, 0xE855, 0xDC51, 0xBE47, 0xE85A, 0xE854, 0xBE46,
    0xBE49, 0xE858, 0xEBD5, 0xBFF3, 0xEBD6, 0xEBD7, 0xEEC4, 0xC1DD,
    0xF14B, 0xF14C, 0xF14D, 0xF35D, 0xF35C, 0xF4E2, 0xF4E1, 0xF65B,
    0xF65C, 0xF65A, 0xF766, 0xC5B0, 0xA8BB, 0xADAA, 0xADA9, 0xB075,
    0xB074, 0xD440, 0xD441, 0xD3FE, 0xB073, 0xD7F5, 0xD7F6, 0xD7F2,
    0xB3A4, 0xD7F3, 0xD7F4, 0xDC5F, 0xDC61, 0xDC5D, 0xDC60, 0xB66F,
    0xDC5E, 0xB670, 0xDD73, 0xB955, 0xB954, 0xB953, 0xE0AC, 0xE0AD,
    0xE473, 0xE475, 0xBBC6, 0xBBC3, 0xBBC5, 0xBBC4, 0xE474, 0xE472,
    0xE861, 0xE85E, 0xE85F, 0xBE4D, 0xE860, 0xE85B, 0xE85C, 0xBE4A,
    0xBE4B, 0xE85D, 0xBE4C, 0xEBDB, 0xEBDC, 0xEBD9, 0xEBDA, 0xBFF4,
    0xEBD8, 0xEEC8, 0xEEC5, 0xEEC7, 0xC1E0, 0xEECB, 0xC1DF, 0xEEC9,
    0xEECC, 0xEECA, 0xEEC6, 0xC1DE, 0xF14F, 0xF150, 0xF14E, 0xF152,
    0xC2E5, 0xC2E6, 0xF35F, 0xC3E7, 0xF151, 0xF35E, 0xC3E6, 0xF4E5,
    0xF4E6, 0xC4BF, 0xF4E4, 0xF4E3, 0xF65D, 0xC548, 0xF849, 0xF8C8,
    0xF8C7, 0xC643, 0xC65D, 0xF8C9, 0xF971, 0xC66F, 0xA8BC, 0xAAF6,
    0xB956, 0xC4C0, 0xA8BD, 0xADAB, 0xB3A5, 0xB671, 0xC2E7, 0xAAF7,
    0xD0C1, 0xD0C0, 0xD442, 0xB078, 0xB076, 0xB07A, 0xD444, 0xB079,
    0xB077, 0xD443, 0xB3A8, 0xD7FC, 0xB3A7, 0xB3A9, 0xD842, 0xB3AB,
    0xD7FE, 0xD840, 0xD7F7, 0xB3AA, 0xD843, 0xD7F9, 0xD7FA, 0xD7F8,
    0xB3A6, 0xD841, 0xD7FB, 0xD7FD, 0xDC6D, 0xDC6C, 0xDC6A, 0xDC62,
    0xDC71, 0xDC65, 0xDC6F, 0xDC76, 0xDC6E, 0xB679, 0xB675, 0xDC63,
    0xDC69, 0xB677, 0xDC68, 0xB678, 0xB67A, 0xDC6B, 0xB672, 0xB673,
    0xDC77, 0xDC75, 0xDC74, 0xDC66, 0xDC72, 0xB676, 0xB674, 0xDC73,
    0xDC64, 0xDC67, 0xDC70, 0xE4BA, 0xE0B7, 0xE0B0, 0xE0C3, 0xE0CC,
    0xE0B3, 0xB961, 0xE0C0, 0xB957, 0xB959, 0xB965, 0xE0B1, 0xB95A,
    0xB95C, 0xB966, 0xB95B, 0xB964, 0xE0B9, 0xE0AE, 0xB962, 0xE0B8,
    0xB95E, 0xE0CA, 0xB963, 0xE0C8, 0xE0BC, 0xE0C6, 0xB960, 0xE0AF,
    0xE0C9, 0xE0C4, 0xE0CB, 0xB958, 0xB967, 0xB95D, 0xE0B5, 0xE0BD,
    0xE0C1, 0xE0C5, 0xB95F, 0xE0B4, 0xE0B2, 0xE0BE, 0xE0BB, 0xE0BA,
    0xE0BF, 0xE0C2, 0xE0C7, 0xE478, 0xBBC7, 0xE4A4, 0xE47A, 0xBBCC,
    0xBBD0, 0xE4AD, 0xE4B5, 0xE4A6, 0xBBC8, 0xE4AA, 0xE0B6, 0xBBC9,
    0xE4B1, 0xE4B6, 0xE4AE, 0xE4B0, 0xE4B9, 0xE4B2, 0xE47E, 0xE4A9,
    0xBBD1, 0xBBCD, 0xE47C, 0xE4AB, 0xBBCB, 0xE4A5, 0xBBCA, 0xE4B3,
    0xE4A2, 0xE479, 0xBBCE, 0xE4B8, 0xE47B, 0xE4AF, 0xE4AC, 0xE4A7,
    0xE477, 0xE476, 0xE4A1, 0xE4B4, 0xBBCF, 0xE4B7, 0xE47D, 0xE4A3,
    0xBE52, 0xBE5A, 0xBE55, 0xE8A4, 0xE8A1, 0xE867, 0xBE50, 0xBE4F,
    0xBE56, 0xE865, 0xBE54, 0xE871, 0xE863, 0xE864, 0xBE4E, 0xE8A3,
    0xBE58, 0xE874, 0xE879, 0xE873, 0xEBEE, 0xE86F, 0xE877, 0xE875,
    0xE868, 0xE862, 0xE87D, 0xBE57, 0xE87E, 0xE878, 0xE86D, 0xE86B,
    0xE866, 0xE86E, 0xE87B, 0xE86A, 0xE87A, 0xE8A2, 0xBE53, 0xE876,
    0xE87C, 0xE872, 0xE86C, 0xBE51, 0xE4A8, 0xE870, 0xBE59, 0xE869,
    0xEBF4, 0xBFF7, 0xEBF3, 0xEBF0, 0xEC44, 0xBFFB, 0xEC41, 0xEBF8,
    0xEC43, 0xEBE9, 0xEBF6, 0xBFFD, 0xEBE1, 0xEBDF, 0xEC42, 0xEC40,
    0xEBFE, 0xEBED, 0xEBEC, 0xEBE2, 0xC040, 0xEBE8, 0xEBF2, 0xEBFD,
    0xC043, 0xEC45, 0xC1E8, 0xC045, 0xBFFE, 0xEBE6, 0xEBEF, 0xEBDE,
    0xEBE0, 0xBFF5, 0xC042, 0xBFFA, 0xEBE7, 0xEBF7, 0xEBF1, 0xC041,
    0xEBDD, 0xC1E3, 0xEBF9, 0xEBFC, 0xBFFC, 0xEBEB, 0xC044, 0xBFF9,
    0xBFF8, 0xEBF5, 0xEBFB, 0xBFF6, 0xEBE4, 0xEBFA, 0xEBE5, 0xEBEA,
    0xEED2, 0xEED7, 0xC1E5, 0xC1E7, 0xEEDD, 0xC1E1, 0xEEEC, 0xEEE3,
    0xEED8, 0xEED9, 0xEEE2, 0xC1EE, 0xEEE1, 0xEED1, 0xEEE0, 0xEED4,
    0xEEED, 0xC1ED, 0xC1EB, 0xEED5, 0xEEE8, 0xEEDA, 0xEEE7, 0xEEE9,
    0xEED0, 0xC1E6, 0xEEEA, 0xEEDE, 0xC1EA, 0xEEDB, 0xC1EC, 0xEEE4,
    0xC1E4, 0xEED6, 0xEEE5, 0xEEDF, 0xEBE3, 0xEEE6, 0xEED3, 0xC1E9,
    0xEEEB, 0xC1E2, 0xEECE, 0xF160, 0xF159, 0xC2E9, 0xF154, 0xF163,
    0xF15B, 0xEEDC, 0xF165, 0xF155, 0xC2E8, 0xF15F, 0xC2EA, 0xC2F2,
    0xC2F0, 0xF161, 0xC2F1, 0xF157, 0xF158, 0xF15D, 0xF162, 0xEECD,
    0xC2EB, 0xF16A, 0xF167, 0xF16B, 0xF15E, 0xF15A, 0xF168, 0xF36A,
    0xF15C, 0xC2EE, 0xC2ED, 0xEECF, 0xC2EF, 0xF164, 0xF166, 0xC2EC,
    0xF169, 0xF153, 0xF156, 0xF373, 0xF363, 0xC3EB, 0xF371, 0xF361,
    0xC3EC, 0xF36C, 0xF368, 0xC3F1, 0xF372, 0xF362, 0xF365, 0xC3E9,
    0xF374, 0xF36D, 0xF370, 0xC3EF, 0xC3F4, 0xC3F2, 0xF369, 0xF364,
    0xC3ED, 0xC3EE, 0xF360, 0xC3EA, 0xC3E8, 0xC3F0, 0xF36F, 0xC3F3,
    0xF36B, 0xF375, 0xC3F5, 0xF367, 0xF36E, 0xF4F3, 0xF542, 0xF4F5,
    0xF4FC, 0xF366, 0xF4FA, 0xF4E9, 0xF540, 0xC4C3, 0xF4ED, 0xF4FE,
    0xF4F4, 0xC4C2, 0xF544, 0xF4F6, 0xF4FB, 0xF4FD, 0xF4E7, 0xF541,
    0xF4F2, 0xF4F7, 0xF4EB, 0xF4EF, 0xF543, 0xF4F9, 0xF4E8, 0xF4EC,
    0xF4EE, 0xF4F8, 0xC4C1, 0xF4F1, 0xF4EA, 0xF4F0, 0xF661, 0xF666,
    0xC54F, 0xF668, 0xC549, 0xF664, 0xF66A, 0xC54E, 0xC54A, 0xC54B,
    0xF660, 0xF667, 0xC54D, 0xF665, 0xC54C, 0xF65F, 0xF663, 0xF662,
    0xF65E, 0xF669, 0xC5B1, 0xF76D, 0xF770, 0xF76C, 0xF76E, 0xF76F,
    0xF769, 0xF76A, 0xF767, 0xF76B, 0xF768, 0xC5B2, 0xC5B3, 0xF84B,
    0xF84D, 0xF84C, 0xF84E, 0xC5E0, 0xF84A, 0xC5DF, 0xC5E1, 0xF8CB,
    0xF8CC, 0xC644, 0xF8CA, 0xF953, 0xF952, 0xF954, 0xC65F, 0xF955,
    0xC65E, 0xF956, 0xF972, 0xF975, 0xF974, 0xC668, 0xF973, 0xC672,
    0xC670, 0xC671, 0xC677, 0xF9C0, 0xF9C1, 0xF9BF, 0xF9C9, 0xAAF8,
    0xD844, 0xDC78, 0xE8A5, 0xF376, 0xAAF9, 0xADAC, 0xB07B, 0xD845,
    0xD846, 0xB3AC, 0xB67D, 0xDC7A, 0xDC79, 0xB6A3, 0xB67C, 0xDC7B,
    0xB67E, 0xB6A2, 0xB6A1, 0xB67B, 0xB968, 0xE0D0, 0xE0CE, 0xE0CF,
    0xE0CD, 0xBBD2, 0xBBD5, 0xBBD7, 0xBBD6, 0xBBD3, 0xBBD4, 0xE8A7,
    0xE8A6, 0xBE5B, 0xE8A8, 0xE8A9, 0xBE5C, 0xEC4D, 0xEC4B, 0xEEF3,
    0xEC49, 0xEC4A, 0xC046, 0xEC46, 0xEC4E, 0xEC48, 0xEC4C, 0xEEEF,
    0xEEF1, 0xEEF2, 0xC1F3, 0xEEEE, 0xC1F2, 0xEEF0, 0xC1EF, 0xC1F0,
    0xC1F1, 0xEC47, 0xC2F5, 0xF16E, 0xF16C, 0xF16D, 0xC2F3, 0xC2F6,
    0xC2F4, 0xF377, 0xF378, 0xC3F6, 0xF545, 0xF547, 0xF546, 0xC4C4,
    0xC550, 0xF66D, 0xF66C, 0xF66B, 0xAAFA, 0xC9AA, 0xCA58, 0xA6E9,
    0xCA56, 0xCA59, 0xCA57, 0xCBAE, 0xA8C1, 0xA8C2, 0xCBB0, 0xA8BF,
    0xCBAF, 0xCBAD, 0xA8C0, 0xA8BE, 0xCDD8, 0xCDDB, 0xAAFD, 0xCDDA,
    0xCDD9, 0xAAFC, 0xAAFB, 0xAB40, 0xCDDC, 0xAAFE, 0xD0C6, 0xADAE,
    0xADAF, 0xADB0, 0xD0C7, 0xD0C3, 0xADAD, 0xD0C4, 0xD0C5, 0xD0C2,
    0xB0A4, 0xB0A1, 0xD445, 0xB0A2, 0xB0A5, 0xD446, 0xB07E, 0xB07C,
    0xB07D, 0xB0A3, 0xB3AD, 0xD849, 0xB3B5, 0xD848, 0xD84B, 0xB3B1,
    0xD84A, 0xB6AB, 0xB3AF, 0xB3B2, 0xB3AE, 0xB3B3, 0xB3B4, 0xB3B0,
    0xD847, 0xB6A7, 0xDC7D, 0xDCA3, 0xDCA2, 0xB6AC, 0xB6A8, 0xB6A9,
    0xDC7C, 0xDC7E, 0xDCA1, 0xB6A4, 0xB6A6, 0xB6AA, 0xB6A5, 0xE0D3,
    0xE0D1, 0xE0D2, 0xB96A, 0xB96B, 0xE0D4, 0xB969, 0xBBD8, 0xBBDA,
    0xBBD9, 0xE4BB, 0xE4BC, 0xE8AB, 0xE8AA, 0xC047, 0xC048, 0xEC4F,
    0xC049, 0xEEF6, 0xEEF4, 0xEEF5, 0xC1F4, 0xF16F, 0xC3F7, 0xC1F5,
    0xAB41, 0xB0A6, 0xD447, 0xD84C, 0xB3B6, 0xB6AD, 0xDCA4, 0xDCA6,
    0xB6AF, 0xB6AE, 0xB6B0, 0xB6B1, 0xDCA5, 0xB96E, 0xB96F, 0xB96D,
    0xBBDB, 0xB96C, 0xE0D5, 0xBBDC, 0xE8AC, 0xEC50, 0xC04A, 0xC1F6,
    0xF170, 0xF174, 0xC2F9, 0xF171, 0xC2FA, 0xC2F8, 0xF175, 0xC2FB,
    0xF173, 0xF379, 0xC2F7, 0xC3F8, 0xF8CD, 0xAB42, 0xB3B8, 0xB3B7,
    0xB6B2, 0xDCA8, 0xDCA7, 0xB6B3, 0xE0D9, 0xB973, 0xB970, 0xE0D8,
    0xB972, 0xE0D6, 0xB971, 0xE0D7, 0xE4BD, 0xBBDD, 0xE8AF, 0xBE5D,
    0xE8AD, 0xBE5E, 0xBE5F, 0xE8AE, 0xBE60, 0xEC51, 0xC04E, 0xC04B,
    0xC050, 0xEC53, 0xC04C, 0xEC52, 0xC04F, 0xC04D, 0xEEF9, 0xEEFB,
    0xC1F7, 0xEEFA, 0xC1F8, 0xEEF8, 0xEEF7, 0xF177, 0xF176, 0xC2FC,
    0xF178, 0xF37E, 0xC3FA, 0xF37D, 0xF37A, 0xC3F9, 0xF37B, 0xF37C,
    0xF548, 0xF549, 0xC4C5, 0xC553, 0xF66E, 0xC551, 0xC552, 0xF66F,
    0xC5B4, 0xC5B5, 0xF771, 0xC645, 0xF8CF, 0xC647, 0xF8CE, 0xF8D0,
    0xC646, 0xF957, 0xF9AD, 0xAB43, 0xB974, 0xE4BE, 0xE8B0, 0xC051,
    0xC052, 0xAB44, 0xBE61, 0xC3FB, 0xADB1, 0xC053, 0xC5E2, 0xADB2,
    0xD84D, 0xDCA9, 0xDCAB, 0xDCAA, 0xE0DD, 0xE0DA, 0xB975, 0xB976,
    0xE0DB, 0xE0DC, 0xE4C0, 0xE4C5, 0xBBDE, 0xE4BF, 0xE4C1, 0xE4C8,
    0xE4C3, 0xE4C7, 0xE4C4, 0xE4C2, 0xE4C6, 0xBBDF, 0xE8B3, 0xE8B1,
    0xBE63, 0xBE62, 0xE8B2, 0xBE64, 0xEC56, 0xEC55, 0xC054, 0xEC54,
    0xEEFC, 0xEEFE, 0xEF41, 0xEF40, 0xC1F9, 0xEEFD, 0xF1A1, 0xC2FD,
    0xF17D, 0xF1A2, 0xC2FE, 0xF17B, 0xF17E, 0xF17C, 0xF179, 0xC340,
    0xF17A, 0xF3A1, 0xF3A3, 0xF3A2, 0xF54A, 0xF54B, 0xF670, 0xC5B7,
    0xC5B6, 0xF84F, 0xF850, 0xC648, 0xF8D1, 0xC669, 0xADB3, 0xB6B4,
    0xE4CA, 0xE4C9, 0xE8B5, 0xE8B4, 0xC1FA, 0xEF43, 0xEF42, 0xF1A5,
    0xF1A3, 0xF1A6, 0xF1A4, 0xC3FC, 0xF3A4, 0xF3A5, 0xF3A6, 0xF671,
    0xF772, 0xF8D2, 0xADB4, 0xEC57, 0xEF44, 0xADB5, 0xBBE0, 0xEC58,
    0xC341, 0xF1A7, 0xC3FD, 0xF54C, 0xF54D, 0xC554, 0xF851, 0xADB6,
    0xB3BB, 0xB3BC, 0xD84E, 0xB6B5, 0xB6B6, 0xDCAC, 0xB6B7, 0xB97A,
    0xB97C, 0xE0DF, 0xE0E0, 0xE0DE, 0xB977, 0xB978, 0xB97B, 0xB979,
    0xE4CB, 0xBBE1, 0xBBE2, 0xE8BC, 0xBE67, 0xE8B7, 0xE8B6, 0xE8BB,
    0xBE65, 0xC05B, 0xE8B8, 0xE8BD, 0xE8BA, 0xE8B9, 0xBE66, 0xC059,
    0xEC5A, 0xC055, 0xEC5B, 0xEC59, 0xC058, 0xC056, 0xC05A, 0xC057,
    0xEF45, 0xEF4A, 0xEF46, 0xEF49, 0xC1FB, 0xEDD4, 0xEF48, 0xEF47,
    0xC344, 0xC342, 0xC345, 0xC343, 0xF1A8, 0xF1A9, 0xF1AA, 0xC346,
    0xF3AA, 0xC440, 0xF3A8, 0xC441, 0xF3A7, 0xF3A9, 0xC3FE, 0xF551,
    0xF54E, 0xF54F, 0xF550, 0xF672, 0xC556, 0xC555, 0xF774, 0xF773,
    0xC5B8, 0xC5E3, 0xC649, 0xC660, 0xF958, 0xF9AE, 0xF9AF, 0xADB7,
    0xDCAD, 0xE0E1, 0xE4CC, 0xE4CD, 0xBBE3, 0xBBE4, 0xE8BE, 0xBE68,
    0xC1FC, 0xF1AB, 0xC347, 0xF3AD, 0xC442, 0xF3AC, 0xF3AE, 0xF3AB,
    0xF675, 0xF552, 0xF553, 0xC4C6, 0xF674, 0xF673, 0xF775, 0xF9B0,
    0xADB8, 0xADB9, 0xB0A7, 0xD448, 0xD84F, 0xB6B8, 0xB6BB, 0xB6B9,
    0xDCAE, 0xB6BD, 0xB6BA, 0xB6BC, 0xB97E, 0xE0E2, 0xE0E3, 0xE8C0,
    0xB97D, 0xB9A1, 0xB9A2, 0xE4CF, 0xE4CE, 0xBBE5, 0xBBE6, 0xE4D0,
    0xE8BF, 0xBBE8, 0xBE69, 0xBBE7, 0xC05C, 0xE8C1, 0xBE6B, 0xBE6A,
    0xE8C2, 0xE8C5, 0xE8C3, 0xE8C4, 0xBE6C, 0xC061, 0xC05F, 0xC05E,
    0xEC5D, 0xC060, 0xEC5C, 0xEF4B, 0xEC5E, 0xC05D, 0xEC5F, 0xEF4E,
    0xEF4C, 0xEF4D, 0xEF52, 0xC34B, 0xEF51, 0xEF54, 0xEF53, 0xEF50,
    0xEF4F, 0xC1FD, 0xF1AE, 0xF1AD, 0xC34A, 0xC348, 0xC349, 0xF1AC,
    0xF3B1, 0xC443, 0xF3B0, 0xF3AF, 0xC444, 0xF558, 0xF557, 0xF555,
    0xF554, 0xC4C8, 0xC4C7, 0xF559, 0xF776, 0xC5B9, 0xF677, 0xC557,
    0xF676, 0xF556, 0xF777, 0xC5E4, 0xC661, 0xF959, 0xF9B1, 0xADBA,
    0xD850, 0xEF55, 0xADBB, 0xE4D2, 0xE4D1, 0xEC60, 0xEF57, 0xEF56,
    0xC34C, 0xF3B2, 0xF3B3, 0xC4C9, 0xF9B2, 0xB0A8, 0xB6BF, 0xB6BE,
    0xE0E4, 0xE0E6, 0xB9A4, 0xE0E5, 0xB9A3, 0xB9A5, 0xE0E7, 0xE4D4,
    0xE4D6, 0xE4D5, 0xE4D8, 0xBBE9, 0xE4D7, 0xE4D3, 0xE4D9, 0xE8CC,
    0xE8CF, 0xE8D1, 0xE8C7, 0xE8CB, 0xE8C8, 0xBE6E, 0xBE71, 0xBE73,
    0xE8C9, 0xE8CA, 0xBE72, 0xE8CD, 0xE8D0, 0xE8CE, 0xBE74, 0xBE70,
    0xE8C6, 0xBE6D, 0xBE6F, 0xC063, 0xEC66, 0xEC64, 0xEC63, 0xEC69,
    0xEC68, 0xEC67, 0xEC62, 0xC062, 0xEC61, 0xEC65, 0xC064, 0xEF5A,
    0xEF5E, 0xEF5B, 0xEF5D, 0xEF5C, 0xEF59, 0xEF5F, 0xEF62, 0xEF60,
    0xEF61, 0xC240, 0xC1FE, 0xEF58, 0xEF63, 0xF1B3, 0xF1B6, 0xF1B8,
    0xF1B7, 0xF1B1, 0xF1B5, 0xF1B0, 0xF1B2, 0xC34D, 0xF1AF, 0xF1B4,
    0xF3C0, 0xF3B5, 0xC445, 0xC446, 0xF3B4, 0xF3B9, 0xF3BF, 0xF3B7,
    0xF3BE, 0xF3BB, 0xF3BA, 0xF3BD, 0xF3B8, 0xF3B6, 0xF3BC, 0xF560,
    0xF55E, 0xC4CA, 0xF55D, 0xF563, 0xF561, 0xC4CB, 0xF55C, 0xF55A,
    0xF55B, 0xC4CD, 0xF55F, 0xC4CC, 0xF562, 0xF678, 0xF67E, 0xF679,
    0xC55B, 0xF6A1, 0xC55A, 0xF67D, 0xF67C, 0xC559, 0xF67B, 0xC558,
    0xF67A, 0xF77D, 0xF7A1, 0xF77E, 0xF77B, 0xC5BB, 0xF778, 0xF77C,
    0xF7A3, 0xF7A2, 0xF779, 0xF77A, 0xC5BA, 0xF852, 0xC5E7, 0xF853,
    0xC5E5, 0xC5E6, 0xF8D3, 0xC64A, 0xF976, 0xC66A, 0xF9B3, 0xC66B,
    0xF9B4, 0xF9B5, 0xF9C3, 0xF9C2, 0xC67A, 0xF9CD, 0xB0A9, 0xE0E9,
    0xE0E8, 0xBBEA, 0xBBEB, 0xE4DA, 0xE8D2, 0xEC6C, 0xBE75, 0xC065,
    0xEC6A, 0xEC6D, 0xC066, 0xEF64, 0xEC6B, 0xF1B9, 0xC34E, 0xF3C1,
    0xF566, 0xF564, 0xF565, 0xF6A2, 0xC55C, 0xF7A4, 0xC5EA, 0xC5BC,
    0xC5E8, 0xC5E9, 0xF8D4, 0xC662, 0xB0AA, 0xF1BA, 0xD449, 0xB9A6,
    0xE4DB, 0xBBEC, 0xE4DC, 0xE8D4, 0xE8D3, 0xC068, 0xBE76, 0xBE77,
    0xE8D7, 0xE8D6, 0xE8D5, 0xEC6E, 0xEC71, 0xEC70, 0xEC6F, 0xC067,
    0xEF68, 0xEF66, 0xEF65, 0xEF67, 0xC34F, 0xF1BC, 0xF1BD, 0xC350,
    0xF1BB, 0xF3C3, 0xF3C2, 0xF3C5, 0xC447, 0xF3C4, 0xF567, 0xF569,
    0xF568, 0xF6A3, 0xF6A6, 0xF6A4, 0xF6A5, 0xF7A5, 0xC5BD, 0xF854,
    0xF855, 0xF856, 0xC64B, 0xC663, 0xF9B6, 0xB0AB, 0xBE78, 0xC069,
    0xF1BE, 0xF7A6, 0xF9C4, 0xD44A, 0xC67B, 0xB0AC, 0xEC72, 0xF1BF,
    0xF3C6, 0xF6A7, 0xF7A7, 0xB0AD, 0xE4DD, 0xE4DE, 0xBBED, 0xBBEE,
    0xE8D9, 0xBE7A, 0xBE79, 0xE8D8, 0xEF69, 0xF1C0, 0xF1C2, 0xF1C1,
    0xC353, 0xC352, 0xC351, 0xC55E, 0xF6A8, 0xC55D, 0xF7A9, 0xF7A8,
    0xC64C, 0xF8D5, 0xB3BD, 0xE0EA, 0xE4E1, 0xE4DF, 0xE4E0, 0xE8E2,
    0xE8DD, 0xE8DA, 0xE8E1, 0xE8E3, 0xBE7C, 0xE8E0, 0xE8DC, 0xE8DB,
    0xE8DF, 0xE8DE, 0xBE7B, 0xEC7D, 0xEC78, 0xEC76, 0xECA1, 0xEC77,
    0xEC73, 0xEC79, 0xEC74, 0xEF72, 0xEC75, 0xECA2, 0xEC7C, 0xC06A,
    0xEC7B, 0xEC7A, 0xEC7E, 0xEF6A, 0xEF6D, 0xEF6C, 0xEF74, 0xEF6F,
    0xEF73, 0xEF71, 0xEF70, 0xEF6E, 0xEF6B, 0xC243, 0xC242, 0xC244,
    0xC241, 0xEF75, 0xF1C8, 0xF1CB, 0xF1C9, 0xF1CD, 0xF1CE, 0xF1C6,
    0xC358, 0xF1C7, 0xF1C5, 0xF1CC, 0xF1C4, 0xF1C3, 0xC357, 0xC355,
    0xC354, 0xF1CA, 0xF3CF, 0xF3D5, 0xC44A, 0xF3D0, 0xF3D3, 0xF3D7,
    0xC44B, 0xF3D2, 0xF3CA, 0xF3C9, 0xF3D6, 0xF3CD, 0xF3CB, 0xF3D4,
    0xF3CC, 0xC449, 0xC448, 0xF3C7, 0xF3C8, 0xF3D1, 0xF3CE, 0xF56C,
    0xF56F, 0xC356, 0xF56D, 0xF573, 0xF571, 0xF56B, 0xF576, 0xF56A,
    0xC4CF, 0xF572, 0xF56E, 0xC4CE, 0xF575, 0xF574, 0xF6AB, 0xF6AA,
    0xF6B1, 0xF6AD, 0xF6B0, 0xC560, 0xF6AE, 0xF6AF, 0xF6A9, 0xF6AC,
    0xC55F, 0xC5BF, 0xF7B4, 0xF7AF, 0xF7B3, 0xF7B6, 0xF7B2, 0xF7AE,
    0xC5C1, 0xF7B1, 0xF7B5, 0xC5C0, 0xF7AC, 0xF570, 0xF7B0, 0xF7AD,
    0xF7AA, 0xF7AB, 0xC5BE, 0xF85A, 0xF85C, 0xF85F, 0xF85B, 0xF860,
    0xF859, 0xF857, 0xC5EB, 0xF85D, 0xC5ED, 0xC5EC, 0xF858, 0xF85E,
    0xF8DA, 0xC64D, 0xF8DB, 0xF8D9, 0xF8D6, 0xF8D8, 0xF8D7, 0xF95A,
    0xF95C, 0xF95B, 0xF979, 0xF978, 0xF977, 0xF97A, 0xC673, 0xC674,
    0xF9CA, 0xF9CE, 0xB3BE, 0xDCAF, 0xE0ED, 0xB9A7, 0xE0EB, 0xE0EC,
    0xE4E2, 0xE4E3, 0xBBF1, 0xBBEF, 0xE4E4, 0xBBF0, 0xE8E8, 0xE8EB,
    0xE8E5, 0xE8EC, 0xE8E4, 0xE8E6, 0xE8E7, 0xE8EA, 0xBEA1, 0xE8EF,
    0xE8EE, 0xBE7D, 0xE8E9, 0xE8ED, 0xBE7E, 0xECAC, 0xC06F, 0xECA7,
    0xC06B, 0xECA4, 0xECAA, 0xECAD, 0xC070, 0xECA9, 0xECA6, 0xECAE,
    0xECA5, 0xECAB, 0xC06C, 0xECA3, 0xC06D, 0xC06E, 0xECA8, 0xEFA9,
    0xEF7A, 0xEF7B, 0xEF7E, 0xEF7C, 0xEF76, 0xEF79, 0xEFA5, 0xEF7D,
    0xC245, 0xEFA7, 0xEFA4, 0xC246, 0xEFA6, 0xEF77, 0xEFA2, 0xEFA3,
    0xEFA1, 0xF1D2, 0xF1D4, 0xF1D7, 0xF1D1, 0xC359, 0xF1D9, 0xF1D0,
    0xF1DA, 0xF1D6, 0xF1D8, 0xF1DC, 0xF1D5, 0xF1DD, 0xF1D3, 0xF1CF,
    0xC35A, 0xF1DB, 0xC35B, 0xC44D, 0xEF78, 0xF3F1, 0xF3E8, 0xC44F,
    0xF3E4, 0xC450, 0xF3ED, 0xF3E7, 0xF3DD, 0xC44E, 0xF3EA, 0xF3E5,
    0xF3E6, 0xF3D8, 0xF3DF, 0xF3EE, 0xF3EB, 0xF3E3, 0xF3EF, 0xF3DE,
    0xF3D9, 0xF3EC, 0xF3DB, 0xF3E9, 0xF3E0, 0xF3F0, 0xF3DC, 0xC44C,
    0xF3DA, 0xF3E1, 0xF3E2, 0xF57D, 0xF57B, 0xF5A2, 0xF5AE, 0xF5A5,
    0xF57C, 0xF578, 0xF5A7, 0xF57E, 0xF5A3, 0xF57A, 0xF5AA, 0xF577,
    0xF5A1, 0xF5A6, 0xF5A8, 0xF5AB, 0xF579, 0xF5AF, 0xF5B0, 0xF5A9,
    0xF5AD, 0xF5A4, 0xF6C1, 0xF6C4, 0xC561, 0xF6C3, 0xF6C8, 0xF6C6,
    0xC562, 0xF6BD, 0xF6B3, 0xF6B2, 0xC564, 0xF6BF, 0xF6C0, 0xF6BC,
    0xF6B4, 0xF6B9, 0xF5AC, 0xF6B5, 0xC563, 0xF6BB, 0xF6BA, 0xF6B6,
    0xF6C2, 0xF6B7, 0xF7BB, 0xF6C5, 0xF6C7, 0xF6BE, 0xF6B8, 0xF7BC,
    0xF7BE, 0xF7B8, 0xC5C2, 0xF7C5, 0xF7C3, 0xC5C3, 0xF7C2, 0xF7C1,
    0xF7BA, 0xF7B7, 0xF7BD, 0xF7C6, 0xF7B9, 0xF7BF, 0xF869, 0xF86E,
    0xF864, 0xF867, 0xC5EE, 0xF86B, 0xF872, 0xF7C0, 0xF865, 0xF86F,
    0xF873, 0xF86A, 0xF863, 0xF86D, 0xF86C, 0xF871, 0xF870, 0xF7C4,
    0xF868, 0xF862, 0xF866, 0xC64E, 0xC64F, 0xF861, 0xF8E6, 0xF8DD,
    0xF8E5, 0xF8E2, 0xF8E3, 0xF8DC, 0xF8DF, 0xF8E7, 0xF8E1, 0xF8E0,
    0xF8DE, 0xF8E4, 0xF95D, 0xF95E, 0xF960, 0xF95F, 0xF962, 0xF961,
    0xF97C, 0xF97B, 0xF9B7, 0xF9B8, 0xF9C5, 0xC678, 0xC67C, 0xF9CF,
    0xC67D, 0xB3BF, 0xC4D0, 0xF6C9, 0xC650, 0xC651, 0xB3C0, 0xE0EE,
    0xB9A8, 0xE8F0, 0xECB0, 0xECB1, 0xECAF, 0xEFAB, 0xEFAA, 0xC247,
    0xF1DF, 0xEFAC, 0xF1DE, 0xF3F3, 0xC451, 0xC453, 0xF3F2, 0xC452,
    0xF5B1, 0xF5B3, 0xF5B2, 0xF6CA, 0xC565, 0xC5EF, 0xF8E8, 0xF963,
    0xF9D2, 0xB3C1, 0xE4E5, 0xBEA2, 0xECB3, 0xECB2, 0xEFAD, 0xC454,
    0xC4D1, 0xF7C7, 0xF9CB, 0xB3C2, 0xBBF2, 0xBEA3, 0xF3F4, 0xF874,
    0xB6C0, 0xEFAE, 0xC664, 0xB6C1, 0xBEA4, 0xC248, 0xF875, 0xB6C2,
    0xE8F1, 0xC072, 0xECB4, 0xECB5, 0xC071, 0xEFAF, 0xC24C, 0xC24A,
    0xC24B, 0xC249, 0xF1E0, 0xC35C, 0xF5B5, 0xF5B4, 0xF5B7, 0xF5B6,
    0xC4D2, 0xF6CB, 0xF6CD, 0xF6CC, 0xC566, 0xF7C8, 0xF876, 0xF877,
    0xC5F0, 0xF964, 0xF97D, 0xC675, 0xDCB0, 0xECB6, 0xEFB0, 0xF3F5,
    0xE0EF, 0xEFB1, 0xF1E2, 0xF1E1, 0xF878, 0xC652, 0xF965, 0xF97E,
    0xB9A9, 0xE8F2, 0xE8F3, 0xECB7, 0xB9AA, 0xC35D, 0xF1E3, 0xF6CF,
    0xC567, 0xF6D0, 0xF6CE, 0xF879, 0xF8E9, 0xB9AB, 0xEFB4, 0xEFB3,
    0xEFB2, 0xF1E4, 0xF1E8, 0xF1E7, 0xF1E6, 0xF1E5, 0xC35E, 0xF3F6,
    0xF5B9, 0xC4D3, 0xF5B8, 0xF6D1, 0xF7CB, 0xF7CA, 0xC5C4, 0xF7C9,
    0xF87C, 0xF87B, 0xF87A, 0xBBF3, 0xECB8, 0xC24D, 0xF3F7, 0xF3F8,
    0xF7CC, 0xF87D, 0xF8EA, 0xF966, 0xF9B9, 0xF9D4, 0xBBF4, 0xC24E,
    0xF1E9, 0xF3F9, 0xF6D2, 0xF87E, 0xBEA6, 0xEFB5, 0xF1EA, 0xF3FA,
    0xF3FB, 0xF3FC, 0xF5BE, 0xF5BA, 0xC568, 0xF5BD, 0xF5BC, 0xC4D4,
    0xF5BB, 0xC4D6, 0xC4D5, 0xF6D4, 0xF6D3, 0xC569, 0xC56A, 0xC5C6,
    0xF7CD, 0xC5C5, 0xF8A3, 0xF8A4, 0xF8A2, 0xF8A1, 0xC654, 0xF8EB,
    0xF8EC, 0xF8ED, 0xC653, 0xF967, 0xF96A, 0xF969, 0xF968, 0xF9D3,
    0xC073, 0xC365, 0xF5BF, 0xF6D5, 0xC5C7, 0xF7CE, 0xF9D5, 0xC074,
    0xEFB6, 0xF7CF, 0xF9A1, 0xC94A, 0xDDFC, 0xA14A, 0xA157, 0xA159,
    0xA15B, 0xA15F, 0xA160, 0xA163, 0xA164, 0xA167, 0xA168, 0xA16B,
    0xA16C, 0xA16F, 0xA170, 0xA173, 0xA174, 0xA177, 0xA178, 0xA17B,
    0xA17C, 0xA1C6, 0xA1C7, 0xA1CA, 0xA1CB, 0xA1C8, 0xA1C9, 0xA15C,
    0xA14D, 0xA14F, 0xA151, 0xA152, 0xA153, 0xA154, 0xA17D, 0xA17E,
    0xA1A1, 0xA1A2, 0xA1A3, 0xA1A4, 0xA1CC, 0xA1CD, 0xA1CE, 0xA1DE,
    0xA1DF, 0xA1E0, 0xA1E1, 0xA1E2, 0xA24C, 0xA24D, 0xA24E, 0xA149,
    0xA1AD, 0xA243, 0xA248, 0xA1AE, 0xA15D, 0xA15E, 0xA1AF, 0xA1CF,
    0xA141, 0xA1D0, 0xA144, 0xA241, 0xA2AF, 0xA2B0, 0xA2B1, 0xA2B2,
    0xA2B3, 0xA2B4, 0xA2B5, 0xA2B6, 0xA2B7, 0xA2B8, 0xA147, 0xA146,
    0xA1D5, 0xA1D7, 0xA1D6, 0xA148, 0xA249, 0xA2CF, 0xA2D0, 0xA2D1,
    0xA2D2, 0xA2D3, 0xA2D4, 0xA2D5, 0xA2D6, 0xA2D7, 0xA2D8, 0xA2D9,
    0xA2DA, 0xA2DB, 0xA2DC, 0xA2DD, 0xA2DE, 0xA2DF, 0xA2E0, 0xA2E1,
    0xA2E2, 0xA2E3, 0xA2E4, 0xA2E5, 0xA2E6, 0xA2E7, 0xA2E8, 0xA242,
    0xA1C4, 0xA2E9, 0xA2EA, 0xA2EB, 0xA2EC, 0xA2ED, 0xA2EE, 0xA2EF,
    0xA2F0, 0xA2F1, 0xA2F2, 0xA2F3, 0xA2F4, 0xA2F5, 0xA2F6, 0xA2F7,
    0xA2F8, 0xA2F9, 0xA2FA, 0xA2FB, 0xA2FC, 0xA2FD, 0xA2FE, 0xA340,
    0xA341, 0xA342, 0xA343, 0xA161, 0xA155, 0xA162, 0xA14E,
};

#endif /* Z_BIG5_H */
