/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class DefaultFileLookup
implements FileLookup {
    private final FileSystem fileSystem;
    private final IdentityFileResolver fileResolver;

    public DefaultFileLookup(FileSystem fileSystem, Factory<PatternSet> patternSetFactory) {
        this.fileSystem = fileSystem;
        this.fileResolver = new IdentityFileResolver(this.fileSystem, patternSetFactory);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public FileResolver getFileResolver() {
        return this.fileResolver;
    }

    @Override
    public PathToFileResolver getPathToFileResolver() {
        return this.getFileResolver();
    }

    @Override
    public FileResolver getFileResolver(File baseDirectory) {
        return this.fileResolver.withBaseDir(baseDirectory);
    }

    @Override
    public PathToFileResolver getPathToFileResolver(File baseDirectory) {
        return this.getFileResolver(baseDirectory);
    }
}

