/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.annotations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\f*\u00020\u0010\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\f*\u00020\u0010\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0013*\u00020\u0010\u001a\n\u0010\u0016\u001a\u00020\u0013*\u00020\u0010\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"JVM_DEFAULT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_DEFAULT_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_FIELD_ANNOTATION_FQ_NAME", "getJVM_FIELD_ANNOTATION_FQ_NAME", "JVM_STATIC_ANNOTATION_FQ_NAME", "getJVM_STATIC_ANNOTATION_FQ_NAME", "JVM_SYNTHETIC_ANNOTATION_FQ_NAME", "STRICTFP_ANNOTATION_FQ_NAME", "argumentValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "parameterName", "", "findJvmSyntheticAnnotation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findStrictfpAnnotation", "hasJvmDefaultAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "hasJvmStaticAnnotation", "hasJvmSyntheticAnnotation", "frontend"})
public final class AnnotationUtilKt {
    @NotNull
    private static final FqName JVM_STATIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmStatic");
    @NotNull
    private static final FqName JVM_FIELD_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmField");
    @NotNull
    private static final FqName JVM_DEFAULT_FQ_NAME = new FqName("kotlin.jvm.JvmDefault");
    private static final FqName JVM_SYNTHETIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSynthetic");
    private static final FqName STRICTFP_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Strictfp");

    @NotNull
    public static final FqName getJVM_STATIC_ANNOTATION_FQ_NAME() {
        return JVM_STATIC_ANNOTATION_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_FIELD_ANNOTATION_FQ_NAME() {
        return JVM_FIELD_ANNOTATION_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_DEFAULT_FQ_NAME() {
        return JVM_DEFAULT_FQ_NAME;
    }

    public static final boolean hasJvmDefaultAnnotation(@NotNull CallableMemberDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtils.getDirectMember($receiver).getAnnotations().hasAnnotation(JVM_DEFAULT_FQ_NAME);
    }

    public static final boolean hasJvmStaticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getAnnotations().findAnnotation(JVM_STATIC_ANNOTATION_FQ_NAME) != null;
    }

    public static final boolean hasJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return AnnotationUtilKt.findJvmSyntheticAnnotation($receiver) != null;
    }

    @Nullable
    public static final AnnotationDescriptor findJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtils.getAnnotationByFqName($receiver.getAnnotations(), JVM_SYNTHETIC_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findStrictfpAnnotation(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return DescriptorUtils.getAnnotationByFqName($receiver.getAnnotations(), STRICTFP_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final ConstantValue<?> argumentValue(@NotNull AnnotationDescriptor $receiver, @NotNull String parameterName) {
        ConstantValue<?> constantValue;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)parameterName, (String)"parameterName");
        ConstantValue<?> it = constantValue = $receiver.getAllValueArguments().get(Name.identifier(parameterName));
        return !(it instanceof ErrorValue) ? constantValue : null;
    }
}

