/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.maven.Maven2Gradle;
import org.gradle.buildinit.plugins.internal.maven.MavenConversionException;
import org.gradle.buildinit.plugins.internal.maven.MavenProjectsCreator;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.SingleMessageLogger;

public class PomProjectInitDescriptor
implements ProjectInitDescriptor {
    private final MavenSettingsProvider settingsProvider;
    private final PathToFileResolver fileResolver;

    public PomProjectInitDescriptor(PathToFileResolver fileResolver, MavenSettingsProvider mavenSettingsProvider) {
        this.fileResolver = fileResolver;
        this.settingsProvider = mavenSettingsProvider;
    }

    @Override
    public void generate(BuildInitDsl dsl, BuildInitTestFramework testFramework) {
        SingleMessageLogger.incubatingFeatureUsed((String)"Maven to Gradle conversion");
        File pom = this.fileResolver.resolve((Object)"pom.xml");
        try {
            Settings settings = this.settingsProvider.buildSettings();
            Set<MavenProject> mavenProjects = new MavenProjectsCreator().create(settings, pom);
            new Maven2Gradle(mavenProjects, this.fileResolver.resolve((Object)".")).convert();
        }
        catch (Exception exception) {
            throw new MavenConversionException(String.format("Could not convert Maven POM %s to a Gradle build.", pom), exception);
        }
    }

    @Override
    public boolean supports(BuildInitDsl dsl) {
        return BuildInitDsl.GROOVY == dsl;
    }

    @Override
    public boolean supports(BuildInitTestFramework testFramework) {
        return false;
    }
}

