package cpe

var DefaultArtifactIDToGroupID = map[string]string{
	"ant":                                         "org.apache.ant",
	"ant-antlr":                                   "org.apache.ant",
	"ant-antunit":                                 "org.apache.ant",
	"ant-apache-bcel":                             "org.apache.ant",
	"ant-apache-bsf":                              "org.apache.ant",
	"ant-apache-log4j":                            "org.apache.ant",
	"ant-apache-oro":                              "org.apache.ant",
	"ant-apache-regexp":                           "org.apache.ant",
	"ant-apache-resolver":                         "org.apache.ant",
	"ant-apache-xalan2":                           "org.apache.ant",
	"ant-commons-logging":                         "org.apache.ant",
	"ant-commons-net":                             "org.apache.ant",
	"ant-compress":                                "org.apache.ant",
	"ant-dotnet":                                  "org.apache.ant",
	"ant-imageio":                                 "org.apache.ant",
	"ant-jai":                                     "org.apache.ant",
	"ant-jakartamail":                             "org.apache.ant",
	"ant-javamail":                                "org.apache.ant",
	"ant-jdepend":                                 "org.apache.ant",
	"ant-jmf":                                     "org.apache.ant",
	"ant-jsch":                                    "org.apache.ant",
	"ant-junit":                                   "org.apache.ant",
	"ant-junit4":                                  "org.apache.ant",
	"ant-junitlauncher":                           "org.apache.ant",
	"ant-launcher":                                "org.apache.ant",
	"ant-netrexx":                                 "org.apache.ant",
	"ant-nodeps":                                  "org.apache.ant",
	"ant-parent":                                  "org.apache.ant",
	"ant-starteam":                                "org.apache.ant",
	"ant-stylebook":                               "org.apache.ant",
	"ant-swing":                                   "org.apache.ant",
	"ant-testutil":                                "org.apache.ant",
	"ant-trax":                                    "org.apache.ant",
	"ant-weblogic":                                "org.apache.ant",
	"ant-xz":                                      "org.apache.ant",
	"commons-codec":                               "commons-codec",
	"commons-logging":                             "commons-logging", // see e.g. https://mvnrepository.com/artifact/commons-logging/commons-logging/1.1.1
	"okhttp":                                      "com.squareup.okhttp3",
	"okio":                                        "com.squareup.okio",
	"cassandra-all":                               "org.apache.cassandra",
	"cassandra-clientutil":                        "org.apache.cassandra",
	"cassandra-javautils":                         "org.apache.cassandra",
	"cassandra-parent":                            "org.apache.cassandra",
	"cassandra-thrift":                            "org.apache.cassandra",
	"apache-geode":                                "org.apache.geode",
	"geode-all-bom":                               "org.apache.geode",
	"geode-apis-compatible-with-redis":            "org.apache.geode",
	"geode-client-bom":                            "org.apache.geode",
	"geode-client-protocol":                       "org.apache.geode",
	"geode-common":                                "org.apache.geode",
	"geode-concurrency-test":                      "org.apache.geode",
	"geode-connectors":                            "org.apache.geode",
	"geode-core":                                  "org.apache.geode",
	"geode-cq":                                    "org.apache.geode",
	"geode-deployment-legacy":                     "org.apache.geode",
	"geode-dunit":                                 "org.apache.geode",
	"geode-experimental-driver":                   "org.apache.geode",
	"geode-gfsh":                                  "org.apache.geode",
	"geode-http-service":                          "org.apache.geode",
	"geode-jmh":                                   "org.apache.geode",
	"geode-joptsimple":                            "org.apache.geode",
	"geode-json":                                  "org.apache.geode",
	"geode-junit":                                 "org.apache.geode",
	"geode-log4j":                                 "org.apache.geode",
	"geode-logging":                               "org.apache.geode",
	"geode-lucene":                                "org.apache.geode",
	"geode-management":                            "org.apache.geode",
	"geode-membership":                            "org.apache.geode",
	"geode-memcached":                             "org.apache.geode",
	"geode-modules":                               "org.apache.geode",
	"geode-modules-hibernate":                     "org.apache.geode",
	"geode-modules-session":                       "org.apache.geode",
	"geode-modules-session-internal":              "org.apache.geode",
	"geode-modules-tomcat7":                       "org.apache.geode",
	"geode-modules-tomcat8":                       "org.apache.geode",
	"geode-modules-tomcat9":                       "org.apache.geode",
	"geode-old-client-support":                    "org.apache.geode",
	"geode-protobuf":                              "org.apache.geode",
	"geode-protobuf-messages":                     "org.apache.geode",
	"geode-pulse":                                 "org.apache.geode",
	"geode-rebalancer":                            "org.apache.geode",
	"geode-redis":                                 "org.apache.geode",
	"geode-serialization":                         "org.apache.geode",
	"geode-server-all":                            "org.apache.geode",
	"geode-tcp-server":                            "org.apache.geode",
	"geode-unsafe":                                "org.apache.geode",
	"geode-wan":                                   "org.apache.geode",
	"geode-web":                                   "org.apache.geode",
	"geode-web-api":                               "org.apache.geode",
	"geode-web-management":                        "org.apache.geode",
	"spring-velocity-support":                     "org.apache.velocity",
	"velocity":                                    "org.apache.velocity",
	"velocity-engine-core":                        "org.apache.velocity",
	"velocity-engine-parent":                      "org.apache.velocity",
	"velocity-engine-scripting":                   "org.apache.velocity",
	"velocity-tools":                              "org.apache.velocity",
	"tapestry-TimeTracker":                        "org.apache.tapestry",
	"tapestry-Vlib":                               "org.apache.tapestry",
	"tapestry-VlibBeans":                          "org.apache.tapestry",
	"tapestry-Workbench":                          "org.apache.tapestry",
	"tapestry-annotations":                        "org.apache.tapestry",
	"tapestry-archetype":                          "org.apache.tapestry",
	"tapestry-beanvalidator":                      "org.apache.tapestry",
	"tapestry-clojure":                            "org.apache.tapestry",
	"tapestry-component-report":                   "org.apache.tapestry",
	"tapestry-contrib":                            "org.apache.tapestry",
	"tapestry-core":                               "org.apache.tapestry",
	"tapestry-examples":                           "org.apache.tapestry",
	"tapestry-framework":                          "org.apache.tapestry",
	"tapestry-func":                               "org.apache.tapestry",
	"tapestry-hibernate":                          "org.apache.tapestry",
	"tapestry-hibernate-core":                     "org.apache.tapestry",
	"tapestry-http":                               "org.apache.tapestry",
	"tapestry-internal-test":                      "org.apache.tapestry",
	"tapestry-ioc":                                "org.apache.tapestry",
	"tapestry-ioc-jcache":                         "org.apache.tapestry",
	"tapestry-ioc-junit":                          "org.apache.tapestry",
	"tapestry-ioc-test":                           "org.apache.tapestry",
	"tapestry-javadoc":                            "org.apache.tapestry",
	"tapestry-jmx":                                "org.apache.tapestry",
	"tapestry-jpa":                                "org.apache.tapestry",
	"tapestry-json":                               "org.apache.tapestry",
	"tapestry-kaptcha":                            "org.apache.tapestry",
	"tapestry-mongodb":                            "org.apache.tapestry",
	"tapestry-openapi-viewer":                     "org.apache.tapestry",
	"tapestry-portlet":                            "org.apache.tapestry",
	"tapestry-project":                            "org.apache.tapestry",
	"tapestry-rest-jackson":                       "org.apache.tapestry",
	"tapestry-runner":                             "org.apache.tapestry",
	"tapestry-simple":                             "org.apache.tapestry",
	"tapestry-site":                               "org.apache.tapestry",
	"tapestry-spock":                              "org.apache.tapestry",
	"tapestry-spring":                             "org.apache.tapestry",
	"tapestry-test":                               "org.apache.tapestry",
	"tapestry-test-constants":                     "org.apache.tapestry",
	"tapestry-test-data":                          "org.apache.tapestry",
	"tapestry-upload":                             "org.apache.tapestry",
	"tapestry-version-migrator":                   "org.apache.tapestry",
	"tapestry-webflow":                            "org.apache.tapestry",
	"tapestry-webresources":                       "org.apache.tapestry",
	"tapestry-yuicompressor":                      "org.apache.tapestry",
	"tapestry5-annotations":                       "org.apache.tapestry",
	"tomcat":                                      "org.apache.tomcat",
	"tomcat-annotations-api":                      "org.apache.tomcat",
	"tomcat-api":                                  "org.apache.tomcat",
	"tomcat-catalina":                             "org.apache.tomcat",
	"tomcat-catalina-ant":                         "org.apache.tomcat",
	"tomcat-catalina-ha":                          "org.apache.tomcat",
	"tomcat-catalina-jmx-remote":                  "org.apache.tomcat",
	"tomcat-catalina-ws":                          "org.apache.tomcat",
	"tomcat-coyote":                               "org.apache.tomcat",
	"tomcat-dbcp":                                 "org.apache.tomcat",
	"tomcat-el-api":                               "org.apache.tomcat",
	"tomcat-i18n-cs":                              "org.apache.tomcat",
	"tomcat-i18n-de":                              "org.apache.tomcat",
	"tomcat-i18n-es":                              "org.apache.tomcat",
	"tomcat-i18n-fr":                              "org.apache.tomcat",
	"tomcat-i18n-ja":                              "org.apache.tomcat",
	"tomcat-i18n-ko":                              "org.apache.tomcat",
	"tomcat-i18n-pt-BR":                           "org.apache.tomcat",
	"tomcat-i18n-ru":                              "org.apache.tomcat",
	"tomcat-i18n-zh-CN":                           "org.apache.tomcat",
	"tomcat-jasper":                               "org.apache.tomcat",
	"tomcat-jasper-el":                            "org.apache.tomcat",
	"tomcat-jaspic-api":                           "org.apache.tomcat",
	"tomcat-jdbc":                                 "org.apache.tomcat",
	"tomcat-jni":                                  "org.apache.tomcat",
	"tomcat-jsp-api":                              "org.apache.tomcat",
	"tomcat-juli":                                 "org.apache.tomcat",
	"tomcat-servlet-api":                          "org.apache.tomcat",
	"tomcat-spdy":                                 "org.apache.tomcat",
	"tomcat-ssi":                                  "org.apache.tomcat",
	"tomcat-storeconfig":                          "org.apache.tomcat",
	"tomcat-tribes":                               "org.apache.tomcat",
	"tomcat-util":                                 "org.apache.tomcat",
	"tomcat-util-scan":                            "org.apache.tomcat",
	"tomcat-websocket":                            "org.apache.tomcat",
	"tomcat-websocket-api":                        "org.apache.tomcat",
	"tomcat-websocket-client-api":                 "org.apache.tomcat",
	"tomcat7-websocket":                           "org.apache.tomcat",
	"tomcat-embed-core":                           "org.apache.tomcat.embed",
	"tomcat-embed-el":                             "org.apache.tomcat.embed",
	"tomcat-embed-jasper":                         "org.apache.tomcat.embed",
	"tomcat-embed-logging-juli":                   "org.apache.tomcat.embed",
	"tomcat-embed-logging-log4j":                  "org.apache.tomcat.embed",
	"tomcat-embed-websocket":                      "org.apache.tomcat.embed",
	"bc-fips":                                     "org.bouncycastle",
	"bc-fips-debug":                               "org.bouncycastle",
	"bcjmail-debug-jdk15to18":                     "org.bouncycastle",
	"bcjmail-debug-jdk18on":                       "org.bouncycastle",
	"bcjmail-jdk15on":                             "org.bouncycastle",
	"bcjmail-jdk15to18":                           "org.bouncycastle",
	"bcjmail-jdk18on":                             "org.bouncycastle",
	"bcjmail-lts8on":                              "org.bouncycastle",
	"bcmail-debug-jdk15to18":                      "org.bouncycastle",
	"bcmail-debug-jdk18on":                        "org.bouncycastle",
	"bcmail-fips":                                 "org.bouncycastle",
	"bcmail-jdk14":                                "org.bouncycastle",
	"bcmail-jdk15":                                "org.bouncycastle",
	"bcmail-jdk15+":                               "org.bouncycastle",
	"bcmail-jdk15on":                              "org.bouncycastle",
	"bcmail-jdk15to18":                            "org.bouncycastle",
	"bcmail-jdk16":                                "org.bouncycastle",
	"bcmail-jdk18on":                              "org.bouncycastle",
	"bcmail-lts8on":                               "org.bouncycastle",
	"bcpg-debug-jdk15to18":                        "org.bouncycastle",
	"bcpg-debug-jdk18on":                          "org.bouncycastle",
	"bcpg-fips":                                   "org.bouncycastle",
	"bcpg-jdk12":                                  "org.bouncycastle",
	"bcpg-jdk14":                                  "org.bouncycastle",
	"bcpg-jdk15":                                  "org.bouncycastle",
	"bcpg-jdk15+":                                 "org.bouncycastle",
	"bcpg-jdk15on":                                "org.bouncycastle",
	"bcpg-jdk15to18":                              "org.bouncycastle",
	"bcpg-jdk16":                                  "org.bouncycastle",
	"bcpg-jdk18on":                                "org.bouncycastle",
	"bcpg-lts8on":                                 "org.bouncycastle",
	"bcpkix-debug-jdk15to18":                      "org.bouncycastle",
	"bcpkix-debug-jdk18on":                        "org.bouncycastle",
	"bcpkix-fips":                                 "org.bouncycastle",
	"bcpkix-jdk14":                                "org.bouncycastle",
	"bcpkix-jdk15on":                              "org.bouncycastle",
	"bcpkix-jdk15to18":                            "org.bouncycastle",
	"bcpkix-jdk18on":                              "org.bouncycastle",
	"bcpkix-lts8on":                               "org.bouncycastle",
	"bcpqc-addon-fips":                            "org.bouncycastle",
	"bcprov-debug-jdk14":                          "org.bouncycastle",
	"bcprov-debug-jdk15on":                        "org.bouncycastle",
	"bcprov-debug-jdk15to18":                      "org.bouncycastle",
	"bcprov-debug-jdk18on":                        "org.bouncycastle",
	"bcprov-ext-debug-jdk14":                      "org.bouncycastle",
	"bcprov-ext-debug-jdk15on":                    "org.bouncycastle",
	"bcprov-ext-debug-jdk15to18":                  "org.bouncycastle",
	"bcprov-ext-debug-jdk18on":                    "org.bouncycastle",
	"bcprov-ext-jdk14":                            "org.bouncycastle",
	"bcprov-ext-jdk15":                            "org.bouncycastle",
	"bcprov-ext-jdk15on":                          "org.bouncycastle",
	"bcprov-ext-jdk15to18":                        "org.bouncycastle",
	"bcprov-ext-jdk16":                            "org.bouncycastle",
	"bcprov-ext-jdk18on":                          "org.bouncycastle",
	"bcprov-jdk12":                                "org.bouncycastle",
	"bcprov-jdk14":                                "org.bouncycastle",
	"bcprov-jdk15":                                "org.bouncycastle",
	"bcprov-jdk15+":                               "org.bouncycastle",
	"bcprov-jdk15on":                              "org.bouncycastle",
	"bcprov-jdk15to18":                            "org.bouncycastle",
	"bcprov-jdk16":                                "org.bouncycastle",
	"bcprov-jdk18on":                              "org.bouncycastle",
	"bcprov-lts8on":                               "org.bouncycastle",
	"bctls-debug-jdk15to18":                       "org.bouncycastle",
	"bctls-debug-jdk18on":                         "org.bouncycastle",
	"bctls-fips":                                  "org.bouncycastle",
	"bctls-jdk14":                                 "org.bouncycastle",
	"bctls-jdk15on":                               "org.bouncycastle",
	"bctls-jdk15to18":                             "org.bouncycastle",
	"bctls-jdk18on":                               "org.bouncycastle",
	"bctls-lts8on":                                "org.bouncycastle",
	"bctsp-jdk14":                                 "org.bouncycastle",
	"bctsp-jdk15":                                 "org.bouncycastle",
	"bctsp-jdk15+":                                "org.bouncycastle",
	"bctsp-jdk15on":                               "org.bouncycastle",
	"bctsp-jdk16":                                 "org.bouncycastle",
	"bcutil-debug-jdk15to18":                      "org.bouncycastle",
	"bcutil-debug-jdk18on":                        "org.bouncycastle",
	"bcutil-jdk14":                                "org.bouncycastle",
	"bcutil-jdk15on":                              "org.bouncycastle",
	"bcutil-jdk15to18":                            "org.bouncycastle",
	"bcutil-jdk18on":                              "org.bouncycastle",
	"bcutil-lts8on":                               "org.bouncycastle",
	"elasticsearch":                               "org.elasticsearch",
	"elasticsearch-analysis-icu":                  "org.elasticsearch",
	"elasticsearch-analysis-ik":                   "org.elasticsearch",
	"elasticsearch-analysis-kuromoji":             "org.elasticsearch",
	"elasticsearch-analysis-mmseg":                "org.elasticsearch",
	"elasticsearch-analysis-phonetic":             "org.elasticsearch",
	"elasticsearch-analysis-pinyin":               "org.elasticsearch",
	"elasticsearch-analysis-smartcn":              "org.elasticsearch",
	"elasticsearch-analysis-stconvert":            "org.elasticsearch",
	"elasticsearch-analysis-stempel":              "org.elasticsearch",
	"elasticsearch-attachments":                   "org.elasticsearch",
	"elasticsearch-benchmarks":                    "org.elasticsearch",
	"elasticsearch-cli":                           "org.elasticsearch",
	"elasticsearch-client-groovy":                 "org.elasticsearch",
	"elasticsearch-cloud":                         "org.elasticsearch",
	"elasticsearch-cloud-aws":                     "org.elasticsearch",
	"elasticsearch-cloud-azure":                   "org.elasticsearch",
	"elasticsearch-cloud-gce":                     "org.elasticsearch",
	"elasticsearch-core":                          "org.elasticsearch",
	"elasticsearch-discovery-jgroups":             "org.elasticsearch",
	"elasticsearch-geo":                           "org.elasticsearch",
	"elasticsearch-grok":                          "org.elasticsearch",
	"elasticsearch-groovy":                        "org.elasticsearch",
	"elasticsearch-h3":                            "org.elasticsearch",
	"elasticsearch-hadoop":                        "org.elasticsearch",
	"elasticsearch-hadoop-cascading":              "org.elasticsearch",
	"elasticsearch-hadoop-hive":                   "org.elasticsearch",
	"elasticsearch-hadoop-mr":                     "org.elasticsearch",
	"elasticsearch-hadoop-pig":                    "org.elasticsearch",
	"elasticsearch-lang-groovy":                   "org.elasticsearch",
	"elasticsearch-lang-javascript":               "org.elasticsearch",
	"elasticsearch-lang-mvel":                     "org.elasticsearch",
	"elasticsearch-lang-python":                   "org.elasticsearch",
	"elasticsearch-logging":                       "org.elasticsearch",
	"elasticsearch-lz4":                           "org.elasticsearch",
	"elasticsearch-mapper-attachments":            "org.elasticsearch",
	"elasticsearch-nio":                           "org.elasticsearch",
	"elasticsearch-parent":                        "org.elasticsearch",
	"elasticsearch-plugin-analysis-api":           "org.elasticsearch",
	"elasticsearch-plugin-api":                    "org.elasticsearch",
	"elasticsearch-plugin-classloader":            "org.elasticsearch",
	"elasticsearch-plugin-scanner":                "org.elasticsearch",
	"elasticsearch-preallocate":                   "org.elasticsearch",
	"elasticsearch-repository-hdfs":               "org.elasticsearch",
	"elasticsearch-river-couchdb":                 "org.elasticsearch",
	"elasticsearch-river-rabbitmq":                "org.elasticsearch",
	"elasticsearch-river-twitter":                 "org.elasticsearch",
	"elasticsearch-river-wikipedia":               "org.elasticsearch",
	"elasticsearch-secure-sm":                     "org.elasticsearch",
	"elasticsearch-spark-1.2":                     "org.elasticsearch",
	"elasticsearch-spark-1.2_2.10":                "org.elasticsearch",
	"elasticsearch-spark-1.2_2.11":                "org.elasticsearch",
	"elasticsearch-spark-13_2.10":                 "org.elasticsearch",
	"elasticsearch-spark-13_2.11":                 "org.elasticsearch",
	"elasticsearch-spark-20_2.10":                 "org.elasticsearch",
	"elasticsearch-spark-20_2.11":                 "org.elasticsearch",
	"elasticsearch-spark-20_2.12":                 "org.elasticsearch",
	"elasticsearch-spark-30_2.12":                 "org.elasticsearch",
	"elasticsearch-spark-30_2.13":                 "org.elasticsearch",
	"elasticsearch-spark_2.10":                    "org.elasticsearch",
	"elasticsearch-spark_2.11":                    "org.elasticsearch",
	"elasticsearch-ssl-config":                    "org.elasticsearch",
	"elasticsearch-storm":                         "org.elasticsearch",
	"elasticsearch-tdigest":                       "org.elasticsearch",
	"elasticsearch-transport-memcached":           "org.elasticsearch",
	"elasticsearch-transport-thrift":              "org.elasticsearch",
	"elasticsearch-transport-wares":               "org.elasticsearch",
	"elasticsearch-x-content":                     "org.elasticsearch",
	"elasticsearch-yarn":                          "org.elasticsearch",
	"elasticsearch-rest-client":                   "org.elasticsearch.client",
	"elasticsearch-rest-client-sniffer":           "org.elasticsearch.client",
	"elasticsearch-rest-high-level-client":        "org.elasticsearch.client",
	"apoc":                                        "org.neo4j.procedure",
	"apoc-common":                                 "org.neo4j.procedure",
	"apoc-core":                                   "org.neo4j.procedure",
	"apoc-extended":                               "org.neo4j.procedure",
	"apoc-processor":                              "org.neo4j.procedure",
	"apoc-test-utils":                             "org.neo4j.procedure",
	"spring":                                      "org.springframework",
	"spring-agent":                                "org.springframework",
	"spring-aop":                                  "org.springframework",
	"spring-asm":                                  "org.springframework",
	"spring-aspects":                              "org.springframework",
	"spring-beandoc":                              "org.springframework",
	"spring-beans":                                "org.springframework",
	"spring-context":                              "org.springframework",
	"spring-context-indexer":                      "org.springframework",
	"spring-context-support":                      "org.springframework",
	"spring-core":                                 "org.springframework",
	"spring-core-test":                            "org.springframework",
	"spring-dao":                                  "org.springframework",
	"spring-expression":                           "org.springframework",
	"spring-framework-bom":                        "org.springframework",
	"spring-full":                                 "org.springframework",
	"spring-hibernate":                            "org.springframework",
	"spring-hibernate2":                           "org.springframework",
	"spring-hibernate3":                           "org.springframework",
	"spring-ibatis":                               "org.springframework",
	"spring-instrument":                           "org.springframework",
	"spring-instrument-tomcat":                    "org.springframework",
	"spring-jca":                                  "org.springframework",
	"spring-jcl":                                  "org.springframework",
	"spring-jdbc":                                 "org.springframework",
	"spring-jdo":                                  "org.springframework",
	"spring-jms":                                  "org.springframework",
	"spring-jmx":                                  "org.springframework",
	"spring-jpa":                                  "org.springframework",
	"spring-ldap":                                 "org.springframework",
	"spring-messaging":                            "org.springframework",
	"spring-mock":                                 "org.springframework",
	"spring-ojb":                                  "org.springframework",
	"spring-orm":                                  "org.springframework",
	"spring-oxm":                                  "org.springframework",
	"spring-parent":                               "org.springframework",
	"spring-portlet":                              "org.springframework",
	"spring-r2dbc":                                "org.springframework",
	"spring-remoting":                             "org.springframework",
	"spring-struts":                               "org.springframework",
	"spring-support":                              "org.springframework",
	"spring-test":                                 "org.springframework",
	"spring-tomcat-weaver":                        "org.springframework",
	"spring-toplink":                              "org.springframework",
	"spring-tuple":                                "org.springframework",
	"spring-tuple-parent":                         "org.springframework",
	"spring-tx":                                   "org.springframework",
	"spring-web":                                  "org.springframework",
	"spring-webflux":                              "org.springframework",
	"spring-webmvc":                               "org.springframework",
	"spring-webmvc-portlet":                       "org.springframework",
	"spring-webmvc-struts":                        "org.springframework",
	"spring-websocket":                            "org.springframework",
	"spring-amqp":                                 "org.springframework.amqp",
	"spring-amqp-bom":                             "org.springframework.amqp",
	"spring-amqp-dist":                            "org.springframework.amqp",
	"spring-amqp-parent":                          "org.springframework.amqp",
	"spring-erlang":                               "org.springframework.amqp",
	"spring-rabbit":                               "org.springframework.amqp",
	"spring-rabbit-junit":                         "org.springframework.amqp",
	"spring-rabbit-stream":                        "org.springframework.amqp",
	"spring-rabbit-test":                          "org.springframework.amqp",
	"spring-analytics":                            "org.springframework.analytics",
	"spring-batch":                                "org.springframework.batch",
	"spring-batch-admin-manager":                  "org.springframework.batch",
	"spring-batch-admin-parent":                   "org.springframework.batch",
	"spring-batch-admin-resources":                "org.springframework.batch",
	"spring-batch-archetypes":                     "org.springframework.batch",
	"spring-batch-bom":                            "org.springframework.batch",
	"spring-batch-core":                           "org.springframework.batch",
	"spring-batch-docs":                           "org.springframework.batch",
	"spring-batch-infrastructure":                 "org.springframework.batch",
	"spring-batch-infrastructure-tests":           "org.springframework.batch",
	"spring-batch-integration":                    "org.springframework.batch",
	"spring-batch-parent":                         "org.springframework.batch",
	"spring-batch-samples":                        "org.springframework.batch",
	"spring-batch-test":                           "org.springframework.batch",
	"spring-batch-tuple":                          "org.springframework.batch",
	"spring-boot":                                 "org.springframework.boot",
	"spring-boot-actuator":                        "org.springframework.boot",
	"spring-boot-actuator-autoconfigure":          "org.springframework.boot",
	"spring-boot-actuator-docs":                   "org.springframework.boot",
	"spring-boot-antlib":                          "org.springframework.boot",
	"spring-boot-archetypes":                      "org.springframework.boot",
	"spring-boot-autoconfigure":                   "org.springframework.boot",
	"spring-boot-autoconfigure-processor":         "org.springframework.boot",
	"spring-boot-build":                           "org.springframework.boot",
	"spring-boot-buildpack-platform":              "org.springframework.boot",
	"spring-boot-cli":                             "org.springframework.boot",
	"spring-boot-configuration-metadata":          "org.springframework.boot",
	"spring-boot-configuration-processor":         "org.springframework.boot",
	"spring-boot-dependencies":                    "org.springframework.boot",
	"spring-boot-dependency-tools":                "org.springframework.boot",
	"spring-boot-deployment-test-glassfish":       "org.springframework.boot",
	"spring-boot-deployment-test-tomcat":          "org.springframework.boot",
	"spring-boot-deployment-test-tomee":           "org.springframework.boot",
	"spring-boot-deployment-test-wildfly":         "org.springframework.boot",
	"spring-boot-deployment-test-wlp":             "org.springframework.boot",
	"spring-boot-deployment-tests":                "org.springframework.boot",
	"spring-boot-devtools":                        "org.springframework.boot",
	"spring-boot-devtools-tests":                  "org.springframework.boot",
	"spring-boot-docker-compose":                  "org.springframework.boot",
	"spring-boot-docs":                            "org.springframework.boot",
	"spring-boot-full-build":                      "org.springframework.boot",
	"spring-boot-gradle-plugin":                   "org.springframework.boot",
	"spring-boot-gradle-tests":                    "org.springframework.boot",
	"spring-boot-jarmode-layertools":              "org.springframework.boot",
	"spring-boot-launch-script-tests":             "org.springframework.boot",
	"spring-boot-legacy":                          "org.springframework.boot",
	"spring-boot-loader":                          "org.springframework.boot",
	"spring-boot-loader-tools":                    "org.springframework.boot",
	"spring-boot-maven-plugin":                    "org.springframework.boot",
	"spring-boot-parent":                          "org.springframework.boot",
	"spring-boot-project":                         "org.springframework.boot",
	"spring-boot-properties-migrator":             "org.springframework.boot",
	"spring-boot-sample-actuator-archetype":       "org.springframework.boot",
	"spring-boot-sample-actuator-log4j-archetype": "org.springframework.boot",
	"spring-boot-sample-actuator-noweb-archetype": "org.springframework.boot",
	"spring-boot-sample-actuator-ui-archetype":    "org.springframework.boot",
	"spring-boot-sample-amqp-archetype":           "org.springframework.boot",
	"spring-boot-sample-aop-archetype":            "org.springframework.boot",
	"spring-boot-sample-batch-archetype":          "org.springframework.boot",
	"spring-boot-sample-data-jpa-archetype":       "org.springframework.boot",
	"spring-boot-sample-data-mongodb-archetype":   "org.springframework.boot",
	"spring-boot-sample-data-redis-archetype":     "org.springframework.boot",
	"spring-boot-sample-data-rest-archetype":      "org.springframework.boot",
	"spring-boot-sample-integration-archetype":    "org.springframework.boot",
	"spring-boot-sample-jetty-archetype":          "org.springframework.boot",
	"spring-boot-sample-profile-archetype":        "org.springframework.boot",
	"spring-boot-sample-secure-archetype":         "org.springframework.boot",
	"spring-boot-sample-servlet-archetype":        "org.springframework.boot",
	"spring-boot-sample-simple-archetype":         "org.springframework.boot",
	"spring-boot-sample-tomcat-archetype":         "org.springframework.boot",
	"spring-boot-sample-traditional-archetype":    "org.springframework.boot",
	"spring-boot-sample-web-jsp-archetype":        "org.springframework.boot",
	"spring-boot-sample-web-method-security-archetype":         "org.springframework.boot",
	"spring-boot-sample-web-secure-archetype":                  "org.springframework.boot",
	"spring-boot-sample-web-static-archetype":                  "org.springframework.boot",
	"spring-boot-sample-web-ui-archetype":                      "org.springframework.boot",
	"spring-boot-sample-websocket-archetype":                   "org.springframework.boot",
	"spring-boot-sample-xml-archetype":                         "org.springframework.boot",
	"spring-boot-security-test-web-helloworld":                 "org.springframework.boot",
	"spring-boot-security-tests":                               "org.springframework.boot",
	"spring-boot-security-tests-web-helloworld":                "org.springframework.boot",
	"spring-boot-starter":                                      "org.springframework.boot",
	"spring-boot-starter-activemq":                             "org.springframework.boot",
	"spring-boot-starter-actuator":                             "org.springframework.boot",
	"spring-boot-starter-amqp":                                 "org.springframework.boot",
	"spring-boot-starter-aop":                                  "org.springframework.boot",
	"spring-boot-starter-artemis":                              "org.springframework.boot",
	"spring-boot-starter-batch":                                "org.springframework.boot",
	"spring-boot-starter-cache":                                "org.springframework.boot",
	"spring-boot-starter-cloud-connectors":                     "org.springframework.boot",
	"spring-boot-starter-data-cassandra":                       "org.springframework.boot",
	"spring-boot-starter-data-cassandra-reactive":              "org.springframework.boot",
	"spring-boot-starter-data-couchbase":                       "org.springframework.boot",
	"spring-boot-starter-data-couchbase-reactive":              "org.springframework.boot",
	"spring-boot-starter-data-elasticsearch":                   "org.springframework.boot",
	"spring-boot-starter-data-gemfire":                         "org.springframework.boot",
	"spring-boot-starter-data-jdbc":                            "org.springframework.boot",
	"spring-boot-starter-data-jpa":                             "org.springframework.boot",
	"spring-boot-starter-data-ldap":                            "org.springframework.boot",
	"spring-boot-starter-data-mongodb":                         "org.springframework.boot",
	"spring-boot-starter-data-mongodb-reactive":                "org.springframework.boot",
	"spring-boot-starter-data-neo4j":                           "org.springframework.boot",
	"spring-boot-starter-data-r2dbc":                           "org.springframework.boot",
	"spring-boot-starter-data-redis":                           "org.springframework.boot",
	"spring-boot-starter-data-redis-reactive":                  "org.springframework.boot",
	"spring-boot-starter-data-rest":                            "org.springframework.boot",
	"spring-boot-starter-data-solr":                            "org.springframework.boot",
	"spring-boot-starter-freemarker":                           "org.springframework.boot",
	"spring-boot-starter-graphql":                              "org.springframework.boot",
	"spring-boot-starter-groovy-templates":                     "org.springframework.boot",
	"spring-boot-starter-hateoas":                              "org.springframework.boot",
	"spring-boot-starter-hornetq":                              "org.springframework.boot",
	"spring-boot-starter-integration":                          "org.springframework.boot",
	"spring-boot-starter-jdbc":                                 "org.springframework.boot",
	"spring-boot-starter-jersey":                               "org.springframework.boot",
	"spring-boot-starter-jetty":                                "org.springframework.boot",
	"spring-boot-starter-jooq":                                 "org.springframework.boot",
	"spring-boot-starter-json":                                 "org.springframework.boot",
	"spring-boot-starter-jta-atomikos":                         "org.springframework.boot",
	"spring-boot-starter-jta-bitronix":                         "org.springframework.boot",
	"spring-boot-starter-jta-narayana":                         "org.springframework.boot",
	"spring-boot-starter-log4j":                                "org.springframework.boot",
	"spring-boot-starter-log4j2":                               "org.springframework.boot",
	"spring-boot-starter-logging":                              "org.springframework.boot",
	"spring-boot-starter-mail":                                 "org.springframework.boot",
	"spring-boot-starter-mobile":                               "org.springframework.boot",
	"spring-boot-starter-mustache":                             "org.springframework.boot",
	"spring-boot-starter-oauth2-authorization-server":          "org.springframework.boot",
	"spring-boot-starter-oauth2-client":                        "org.springframework.boot",
	"spring-boot-starter-oauth2-resource-server":               "org.springframework.boot",
	"spring-boot-starter-parent":                               "org.springframework.boot",
	"spring-boot-starter-quartz":                               "org.springframework.boot",
	"spring-boot-starter-reactor-netty":                        "org.springframework.boot",
	"spring-boot-starter-redis":                                "org.springframework.boot",
	"spring-boot-starter-remote-shell":                         "org.springframework.boot",
	"spring-boot-starter-rsocket":                              "org.springframework.boot",
	"spring-boot-starter-security":                             "org.springframework.boot",
	"spring-boot-starter-social-facebook":                      "org.springframework.boot",
	"spring-boot-starter-social-linkedin":                      "org.springframework.boot",
	"spring-boot-starter-social-twitter":                       "org.springframework.boot",
	"spring-boot-starter-test":                                 "org.springframework.boot",
	"spring-boot-starter-thymeleaf":                            "org.springframework.boot",
	"spring-boot-starter-tomcat":                               "org.springframework.boot",
	"spring-boot-starter-undertow":                             "org.springframework.boot",
	"spring-boot-starter-validation":                           "org.springframework.boot",
	"spring-boot-starter-velocity":                             "org.springframework.boot",
	"spring-boot-starter-web":                                  "org.springframework.boot",
	"spring-boot-starter-web-services":                         "org.springframework.boot",
	"spring-boot-starter-webflux":                              "org.springframework.boot",
	"spring-boot-starter-websocket":                            "org.springframework.boot",
	"spring-boot-starter-ws":                                   "org.springframework.boot",
	"spring-boot-starters":                                     "org.springframework.boot",
	"spring-boot-test":                                         "org.springframework.boot",
	"spring-boot-test-autoconfigure":                           "org.springframework.boot",
	"spring-boot-testcontainers":                               "org.springframework.boot",
	"spring-boot-tools":                                        "org.springframework.boot",
	"spring-boot-versions":                                     "org.springframework.boot",
	"spring-cloud-alibaba":                                     "org.springframework.cloud",
	"spring-cloud-alibaba-dependencies":                        "org.springframework.cloud",
	"spring-cloud-alibaba-docs":                                "org.springframework.cloud",
	"spring-cloud-alibaba-dubbo":                               "org.springframework.cloud",
	"spring-cloud-alibaba-nacos-config":                        "org.springframework.cloud",
	"spring-cloud-alibaba-nacos-config-server":                 "org.springframework.cloud",
	"spring-cloud-alibaba-nacos-discovery":                     "org.springframework.cloud",
	"spring-cloud-alibaba-seata":                               "org.springframework.cloud",
	"spring-cloud-alibaba-sentinel":                            "org.springframework.cloud",
	"spring-cloud-alibaba-sentinel-datasource":                 "org.springframework.cloud",
	"spring-cloud-alibaba-sentinel-zuul":                       "org.springframework.cloud",
	"spring-cloud-alicloud-acm":                                "org.springframework.cloud",
	"spring-cloud-alicloud-ans":                                "org.springframework.cloud",
	"spring-cloud-alicloud-context":                            "org.springframework.cloud",
	"spring-cloud-alicloud-oss":                                "org.springframework.cloud",
	"spring-cloud-alicloud-schedulerx":                         "org.springframework.cloud",
	"spring-cloud-alicloud-sms":                                "org.springframework.cloud",
	"spring-cloud-app-broker":                                  "org.springframework.cloud",
	"spring-cloud-app-broker-autoconfigure":                    "org.springframework.cloud",
	"spring-cloud-app-broker-core":                             "org.springframework.cloud",
	"spring-cloud-app-broker-deployer":                         "org.springframework.cloud",
	"spring-cloud-app-broker-deployer-cloudfoundry":            "org.springframework.cloud",
	"spring-cloud-app-broker-docs":                             "org.springframework.cloud",
	"spring-cloud-app-broker-logging":                          "org.springframework.cloud",
	"spring-cloud-app-broker-security-credhub":                 "org.springframework.cloud",
	"spring-cloud-app-starter-doc-maven-plugin":                "org.springframework.cloud",
	"spring-cloud-app-starter-metadata-maven-plugin":           "org.springframework.cloud",
	"spring-cloud-aws":                                         "org.springframework.cloud",
	"spring-cloud-aws-actuator":                                "org.springframework.cloud",
	"spring-cloud-aws-autoconfigure":                           "org.springframework.cloud",
	"spring-cloud-aws-context":                                 "org.springframework.cloud",
	"spring-cloud-aws-core":                                    "org.springframework.cloud",
	"spring-cloud-aws-depednencies":                            "org.springframework.cloud",
	"spring-cloud-aws-dependencies":                            "org.springframework.cloud",
	"spring-cloud-aws-docs":                                    "org.springframework.cloud",
	"spring-cloud-aws-integration-test":                        "org.springframework.cloud",
	"spring-cloud-aws-jdbc":                                    "org.springframework.cloud",
	"spring-cloud-aws-messaging":                               "org.springframework.cloud",
	"spring-cloud-aws-parameter-store-config":                  "org.springframework.cloud",
	"spring-cloud-aws-secrets-manager-config":                  "org.springframework.cloud",
	"spring-cloud-bindings":                                    "org.springframework.cloud",
	"spring-cloud-bindings-parent":                             "org.springframework.cloud",
	"spring-cloud-build":                                       "org.springframework.cloud",
	"spring-cloud-build-dependencies":                          "org.springframework.cloud",
	"spring-cloud-build-docs":                                  "org.springframework.cloud",
	"spring-cloud-build-tools":                                 "org.springframework.cloud",
	"spring-cloud-bus":                                         "org.springframework.cloud",
	"spring-cloud-bus-dependencies":                            "org.springframework.cloud",
	"spring-cloud-bus-docs":                                    "org.springframework.cloud",
	"spring-cloud-bus-parent":                                  "org.springframework.cloud",
	"spring-cloud-bus-rsocket":                                 "org.springframework.cloud",
	"spring-cloud-bus-tests":                                   "org.springframework.cloud",
	"spring-cloud-circuitbreaker":                              "org.springframework.cloud",
	"spring-cloud-circuitbreaker-dependencies":                 "org.springframework.cloud",
	"spring-cloud-circuitbreaker-docs":                         "org.springframework.cloud",
	"spring-cloud-circuitbreaker-resilience4j":                 "org.springframework.cloud",
	"spring-cloud-circuitbreaker-spring-retry":                 "org.springframework.cloud",
	"spring-cloud-cli":                                         "org.springframework.cloud",
	"spring-cloud-cli-docs":                                    "org.springframework.cloud",
	"spring-cloud-cli-parent":                                  "org.springframework.cloud",
	"spring-cloud-cloudfoundry":                                "org.springframework.cloud",
	"spring-cloud-cloudfoundry-commons":                        "org.springframework.cloud",
	"spring-cloud-cloudfoundry-connector":                      "org.springframework.cloud",
	"spring-cloud-cloudfoundry-dependencies":                   "org.springframework.cloud",
	"spring-cloud-cloudfoundry-discovery":                      "org.springframework.cloud",
	"spring-cloud-cloudfoundry-docs":                           "org.springframework.cloud",
	"spring-cloud-cloudfoundry-service-broker":                 "org.springframework.cloud",
	"spring-cloud-cloudfoundry-web":                            "org.springframework.cloud",
	"spring-cloud-cluster":                                     "org.springframework.cloud",
	"spring-cloud-cluster-autoconfigure":                       "org.springframework.cloud",
	"spring-cloud-cluster-core":                                "org.springframework.cloud",
	"spring-cloud-cluster-dependencies":                        "org.springframework.cloud",
	"spring-cloud-cluster-docs":                                "org.springframework.cloud",
	"spring-cloud-cluster-etcd":                                "org.springframework.cloud",
	"spring-cloud-cluster-hazelcast":                           "org.springframework.cloud",
	"spring-cloud-cluster-redis":                               "org.springframework.cloud",
	"spring-cloud-cluster-zookeeper":                           "org.springframework.cloud",
	"spring-cloud-common-security-config":                      "org.springframework.cloud",
	"spring-cloud-common-security-config-core":                 "org.springframework.cloud",
	"spring-cloud-common-security-config-web":                  "org.springframework.cloud",
	"spring-cloud-commons":                                     "org.springframework.cloud",
	"spring-cloud-commons-dependencies":                        "org.springframework.cloud",
	"spring-cloud-commons-docs":                                "org.springframework.cloud",
	"spring-cloud-commons-parent":                              "org.springframework.cloud",
	"spring-cloud-config":                                      "org.springframework.cloud",
	"spring-cloud-config-client":                               "org.springframework.cloud",
	"spring-cloud-config-client-tls-tests":                     "org.springframework.cloud",
	"spring-cloud-config-dependencies":                         "org.springframework.cloud",
	"spring-cloud-config-docs":                                 "org.springframework.cloud",
	"spring-cloud-config-monitor":                              "org.springframework.cloud",
	"spring-cloud-config-server":                               "org.springframework.cloud",
	"spring-cloud-connectors-core":                             "org.springframework.cloud",
	"spring-cloud-consul":                                      "org.springframework.cloud",
	"spring-cloud-consul-binder":                               "org.springframework.cloud",
	"spring-cloud-consul-config":                               "org.springframework.cloud",
	"spring-cloud-consul-core":                                 "org.springframework.cloud",
	"spring-cloud-consul-dependencies":                         "org.springframework.cloud",
	"spring-cloud-consul-discovery":                            "org.springframework.cloud",
	"spring-cloud-consul-docs":                                 "org.springframework.cloud",
	"spring-cloud-consul-integration-tests":                    "org.springframework.cloud",
	"spring-cloud-context":                                     "org.springframework.cloud",
	"spring-cloud-contract-converters":                         "org.springframework.cloud",
	"spring-cloud-contract-dependencies":                       "org.springframework.cloud",
	"spring-cloud-contract-docs":                               "org.springframework.cloud",
	"spring-cloud-contract-gradle-plugin":                      "org.springframework.cloud",
	"spring-cloud-contract-maven-plugin":                       "org.springframework.cloud",
	"spring-cloud-contract-pact":                               "org.springframework.cloud",
	"spring-cloud-contract-parent":                             "org.springframework.cloud",
	"spring-cloud-contract-shade":                              "org.springframework.cloud",
	"spring-cloud-contract-spec":                               "org.springframework.cloud",
	"spring-cloud-contract-spec-groovy":                        "org.springframework.cloud",
	"spring-cloud-contract-spec-java":                          "org.springframework.cloud",
	"spring-cloud-contract-spec-kotlin":                        "org.springframework.cloud",
	"spring-cloud-contract-spec-pact":                          "org.springframework.cloud",
	"spring-cloud-contract-starters":                           "org.springframework.cloud",
	"spring-cloud-contract-stub-runner":                        "org.springframework.cloud",
	"spring-cloud-contract-stub-runner-boot":                   "org.springframework.cloud",
	"spring-cloud-contract-stub-runner-moco-contract-jar":      "org.springframework.cloud",
	"spring-cloud-contract-tools":                              "org.springframework.cloud",
	"spring-cloud-contract-verifier":                           "org.springframework.cloud",
	"spring-cloud-contract-wiremock":                           "org.springframework.cloud",
	"spring-cloud-core":                                        "org.springframework.cloud",
	"spring-cloud-dataflow":                                    "org.springframework.cloud",
	"spring-cloud-dataflow-aggregate-task":                     "org.springframework.cloud",
	"spring-cloud-dataflow-apps-docs-plugin":                   "org.springframework.cloud",
	"spring-cloud-dataflow-apps-generator-plugin":              "org.springframework.cloud",
	"spring-cloud-dataflow-apps-metadata-plugin":               "org.springframework.cloud",
	"spring-cloud-dataflow-apps-plugin-parent":                 "org.springframework.cloud",
	"spring-cloud-dataflow-audit":                              "org.springframework.cloud",
	"spring-cloud-dataflow-autoconfigure":                      "org.springframework.cloud",
	"spring-cloud-dataflow-build":                              "org.springframework.cloud",
	"spring-cloud-dataflow-build-dependencies":                 "org.springframework.cloud",
	"spring-cloud-dataflow-build-tools":                        "org.springframework.cloud",
	"spring-cloud-dataflow-classic-docs":                       "org.springframework.cloud",
	"spring-cloud-dataflow-collector-metrics-docs":             "org.springframework.cloud",
	"spring-cloud-dataflow-common-dependencies":                "org.springframework.cloud",
	"spring-cloud-dataflow-common-flyway":                      "org.springframework.cloud",
	"spring-cloud-dataflow-common-parent":                      "org.springframework.cloud",
	"spring-cloud-dataflow-common-persistence":                 "org.springframework.cloud",
	"spring-cloud-dataflow-common-test-docker":                 "org.springframework.cloud",
	"spring-cloud-dataflow-common-test-docker-junit5":          "org.springframework.cloud",
	"spring-cloud-dataflow-completion":                         "org.springframework.cloud",
	"spring-cloud-dataflow-composed-task-runner":               "org.springframework.cloud",
	"spring-cloud-dataflow-configuration-metadata":             "org.springframework.cloud",
	"spring-cloud-dataflow-container-registry":                 "org.springframework.cloud",
	"spring-cloud-dataflow-core":                               "org.springframework.cloud",
	"spring-cloud-dataflow-core-dsl":                           "org.springframework.cloud",
	"spring-cloud-dataflow-dependencies":                       "org.springframework.cloud",
	"spring-cloud-dataflow-dependencies-parent":                "org.springframework.cloud",
	"spring-cloud-dataflow-docs":                               "org.springframework.cloud",
	"spring-cloud-dataflow-metrics-collector-build":            "org.springframework.cloud",
	"spring-cloud-dataflow-metrics-collector-dependencies":     "org.springframework.cloud",
	"spring-cloud-dataflow-package":                            "org.springframework.cloud",
	"spring-cloud-dataflow-parent":                             "org.springframework.cloud",
	"spring-cloud-dataflow-platform-cloudfoundry":              "org.springframework.cloud",
	"spring-cloud-dataflow-platform-kubernetes":                "org.springframework.cloud",
	"spring-cloud-dataflow-registry":                           "org.springframework.cloud",
	"spring-cloud-dataflow-rest-client":                        "org.springframework.cloud",
	"spring-cloud-dataflow-rest-resource":                      "org.springframework.cloud",
	"spring-cloud-dataflow-scheduler-task-launcher":            "org.springframework.cloud",
	"spring-cloud-dataflow-schema":                             "org.springframework.cloud",
	"spring-cloud-dataflow-schema-core":                        "org.springframework.cloud",
	"spring-cloud-dataflow-server":                             "org.springframework.cloud",
	"spring-cloud-dataflow-server-cloudfoundry":                "org.springframework.cloud",
	"spring-cloud-dataflow-server-cloudfoundry-autoconfig":     "org.springframework.cloud",
	"spring-cloud-dataflow-server-cloudfoundry-docs":           "org.springframework.cloud",
	"spring-cloud-dataflow-server-cloudfoundry-parent":         "org.springframework.cloud",
	"spring-cloud-dataflow-server-core":                        "org.springframework.cloud",
	"spring-cloud-dataflow-server-kubernetes":                  "org.springframework.cloud",
	"spring-cloud-dataflow-server-kubernetes-autoconfig":       "org.springframework.cloud",
	"spring-cloud-dataflow-server-kubernetes-docs":             "org.springframework.cloud",
	"spring-cloud-dataflow-server-kubernetes-parent":           "org.springframework.cloud",
	"spring-cloud-dataflow-server-local":                       "org.springframework.cloud",
	"spring-cloud-dataflow-server-local-autoconfig":            "org.springframework.cloud",
	"spring-cloud-dataflow-server-mesos":                       "org.springframework.cloud",
	"spring-cloud-dataflow-server-mesos-docs":                  "org.springframework.cloud",
	"spring-cloud-dataflow-server-mesos-parent":                "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn":                        "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn-autoconfig":             "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn-client":                 "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn-docs":                   "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn-h2":                     "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn-parent":                 "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn-shell":                  "org.springframework.cloud",
	"spring-cloud-dataflow-server-yarn-shell-core":             "org.springframework.cloud",
	"spring-cloud-dataflow-shell":                              "org.springframework.cloud",
	"spring-cloud-dataflow-shell-core":                         "org.springframework.cloud",
	"spring-cloud-dataflow-single-step-batch-job":              "org.springframework.cloud",
	"spring-cloud-dataflow-skipper-docs":                       "org.springframework.cloud",
	"spring-cloud-dataflow-tasklauncher":                       "org.springframework.cloud",
	"spring-cloud-dataflow-tasklauncher-function":              "org.springframework.cloud",
	"spring-cloud-dataflow-tasklauncher-sink":                  "org.springframework.cloud",
	"spring-cloud-dataflow-tasklauncher-sink-dependencies":     "org.springframework.cloud",
	"spring-cloud-dataflow-tasklauncher-sink-kafka":            "org.springframework.cloud",
	"spring-cloud-dataflow-tasklauncher-sink-rabbit":           "org.springframework.cloud",
	"spring-cloud-dataflow-test":                               "org.springframework.cloud",
	"spring-cloud-dataflow-ui":                                 "org.springframework.cloud",
	"spring-cloud-dependencies":                                "org.springframework.cloud",
	"spring-cloud-dependencies-parent":                         "org.springframework.cloud",
	"spring-cloud-deployer-autoconfigure":                      "org.springframework.cloud",
	"spring-cloud-deployer-cloudfoundry":                       "org.springframework.cloud",
	"spring-cloud-deployer-dependencies":                       "org.springframework.cloud",
	"spring-cloud-deployer-kubernetes":                         "org.springframework.cloud",
	"spring-cloud-deployer-local":                              "org.springframework.cloud",
	"spring-cloud-deployer-local-parent":                       "org.springframework.cloud",
	"spring-cloud-deployer-mesos":                              "org.springframework.cloud",
	"spring-cloud-deployer-parent":                             "org.springframework.cloud",
	"spring-cloud-deployer-resource-docker":                    "org.springframework.cloud",
	"spring-cloud-deployer-resource-maven":                     "org.springframework.cloud",
	"spring-cloud-deployer-resource-support":                   "org.springframework.cloud",
	"spring-cloud-deployer-sample-stream":                      "org.springframework.cloud",
	"spring-cloud-deployer-sample-task":                        "org.springframework.cloud",
	"spring-cloud-deployer-spi":                                "org.springframework.cloud",
	"spring-cloud-deployer-spi-scheduler-test-app":             "org.springframework.cloud",
	"spring-cloud-deployer-spi-test":                           "org.springframework.cloud",
	"spring-cloud-deployer-spi-test-app":                       "org.springframework.cloud",
	"spring-cloud-deployer-thin":                               "org.springframework.cloud",
	"spring-cloud-deployer-yarn":                               "org.springframework.cloud",
	"spring-cloud-deployer-yarn-appdeployerappmaster":          "org.springframework.cloud",
	"spring-cloud-deployer-yarn-autoconfig":                    "org.springframework.cloud",
	"spring-cloud-deployer-yarn-build-tests":                   "org.springframework.cloud",
	"spring-cloud-deployer-yarn-parent":                        "org.springframework.cloud",
	"spring-cloud-deployer-yarn-tasklauncherappmaster":         "org.springframework.cloud",
	"spring-cloud-docs":                                        "org.springframework.cloud",
	"spring-cloud-function-adapter-aws":                        "org.springframework.cloud",
	"spring-cloud-function-adapter-aws-web":                    "org.springframework.cloud",
	"spring-cloud-function-adapter-azure":                      "org.springframework.cloud",
	"spring-cloud-function-adapter-azure-web":                  "org.springframework.cloud",
	"spring-cloud-function-adapter-gcp":                        "org.springframework.cloud",
	"spring-cloud-function-adapter-openwhisk":                  "org.springframework.cloud",
	"spring-cloud-function-adapter-parent":                     "org.springframework.cloud",
	"spring-cloud-function-compiler":                           "org.springframework.cloud",
	"spring-cloud-function-context":                            "org.springframework.cloud",
	"spring-cloud-function-core":                               "org.springframework.cloud",
	"spring-cloud-function-dependencies":                       "org.springframework.cloud",
	"spring-cloud-function-deployer":                           "org.springframework.cloud",
	"spring-cloud-function-docs":                               "org.springframework.cloud",
	"spring-cloud-function-grpc":                               "org.springframework.cloud",
	"spring-cloud-function-grpc-cloudevent-ext":                "org.springframework.cloud",
	"spring-cloud-function-integration":                        "org.springframework.cloud",
	"spring-cloud-function-kotlin":                             "org.springframework.cloud",
	"spring-cloud-function-parent":                             "org.springframework.cloud",
	"spring-cloud-function-rsocket":                            "org.springframework.cloud",
	"spring-cloud-function-samples":                            "org.springframework.cloud",
	"spring-cloud-function-serverless-web":                     "org.springframework.cloud",
	"spring-cloud-function-stream":                             "org.springframework.cloud",
	"spring-cloud-function-task":                               "org.springframework.cloud",
	"spring-cloud-function-web":                                "org.springframework.cloud",
	"spring-cloud-gateway":                                     "org.springframework.cloud",
	"spring-cloud-gateway-core":                                "org.springframework.cloud",
	"spring-cloud-gateway-dependencies":                        "org.springframework.cloud",
	"spring-cloud-gateway-docs":                                "org.springframework.cloud",
	"spring-cloud-gateway-mvc":                                 "org.springframework.cloud",
	"spring-cloud-gateway-server":                              "org.springframework.cloud",
	"spring-cloud-gateway-webflux":                             "org.springframework.cloud",
	"spring-cloud-gcp":                                         "org.springframework.cloud",
	"spring-cloud-gcp-autoconfigure":                           "org.springframework.cloud",
	"spring-cloud-gcp-bigquery":                                "org.springframework.cloud",
	"spring-cloud-gcp-cloudfoundry":                            "org.springframework.cloud",
	"spring-cloud-gcp-core":                                    "org.springframework.cloud",
	"spring-cloud-gcp-data-datastore":                          "org.springframework.cloud",
	"spring-cloud-gcp-data-firestore":                          "org.springframework.cloud",
	"spring-cloud-gcp-data-spanner":                            "org.springframework.cloud",
	"spring-cloud-gcp-dependencies":                            "org.springframework.cloud",
	"spring-cloud-gcp-docs":                                    "org.springframework.cloud",
	"spring-cloud-gcp-logging":                                 "org.springframework.cloud",
	"spring-cloud-gcp-pubsub":                                  "org.springframework.cloud",
	"spring-cloud-gcp-pubsub-stream-binder":                    "org.springframework.cloud",
	"spring-cloud-gcp-secretmanager":                           "org.springframework.cloud",
	"spring-cloud-gcp-security-firebase":                       "org.springframework.cloud",
	"spring-cloud-gcp-security-iap":                            "org.springframework.cloud",
	"spring-cloud-gcp-starter":                                 "org.springframework.cloud",
	"spring-cloud-gcp-starter-bigquery":                        "org.springframework.cloud",
	"spring-cloud-gcp-starter-bus-pubsub":                      "org.springframework.cloud",
	"spring-cloud-gcp-starter-cloudfoundry":                    "org.springframework.cloud",
	"spring-cloud-gcp-starter-data-datastore":                  "org.springframework.cloud",
	"spring-cloud-gcp-starter-data-firestore":                  "org.springframework.cloud",
	"spring-cloud-gcp-starter-data-spanner":                    "org.springframework.cloud",
	"spring-cloud-gcp-starter-firestore":                       "org.springframework.cloud",
	"spring-cloud-gcp-starter-logging":                         "org.springframework.cloud",
	"spring-cloud-gcp-starter-metrics":                         "org.springframework.cloud",
	"spring-cloud-gcp-starter-pubsub":                          "org.springframework.cloud",
	"spring-cloud-gcp-starter-secretmanager":                   "org.springframework.cloud",
	"spring-cloud-gcp-starter-security-firebase":               "org.springframework.cloud",
	"spring-cloud-gcp-starter-security-iap":                    "org.springframework.cloud",
	"spring-cloud-gcp-starter-sql-mysql":                       "org.springframework.cloud",
	"spring-cloud-gcp-starter-sql-postgresql":                  "org.springframework.cloud",
	"spring-cloud-gcp-starter-storage":                         "org.springframework.cloud",
	"spring-cloud-gcp-starter-trace":                           "org.springframework.cloud",
	"spring-cloud-gcp-starter-vision":                          "org.springframework.cloud",
	"spring-cloud-gcp-starters":                                "org.springframework.cloud",
	"spring-cloud-gcp-storage":                                 "org.springframework.cloud",
	"spring-cloud-gcp-vision":                                  "org.springframework.cloud",
	"spring-cloud-heroku-connector":                            "org.springframework.cloud",
	"spring-cloud-kubernetes":                                  "org.springframework.cloud",
	"spring-cloud-kubernetes-archaius":                         "org.springframework.cloud",
	"spring-cloud-kubernetes-client-autoconfig":                "org.springframework.cloud",
	"spring-cloud-kubernetes-client-config":                    "org.springframework.cloud",
	"spring-cloud-kubernetes-client-discovery":                 "org.springframework.cloud",
	"spring-cloud-kubernetes-client-loadbalancer":              "org.springframework.cloud",
	"spring-cloud-kubernetes-commons":                          "org.springframework.cloud",
	"spring-cloud-kubernetes-config":                           "org.springframework.cloud",
	"spring-cloud-kubernetes-configserver":                     "org.springframework.cloud",
	"spring-cloud-kubernetes-configuration-watcher":            "org.springframework.cloud",
	"spring-cloud-kubernetes-controllers":                      "org.springframework.cloud",
	"spring-cloud-kubernetes-core":                             "org.springframework.cloud",
	"spring-cloud-kubernetes-dependencies":                     "org.springframework.cloud",
	"spring-cloud-kubernetes-discovery":                        "org.springframework.cloud",
	"spring-cloud-kubernetes-discoveryserver":                  "org.springframework.cloud",
	"spring-cloud-kubernetes-docs":                             "org.springframework.cloud",
	"spring-cloud-kubernetes-fabric8-autoconfig":               "org.springframework.cloud",
	"spring-cloud-kubernetes-fabric8-config":                   "org.springframework.cloud",
	"spring-cloud-kubernetes-fabric8-discovery":                "org.springframework.cloud",
	"spring-cloud-kubernetes-fabric8-istio":                    "org.springframework.cloud",
	"spring-cloud-kubernetes-fabric8-leader":                   "org.springframework.cloud",
	"spring-cloud-kubernetes-fabric8-loadbalancer":             "org.springframework.cloud",
	"spring-cloud-kubernetes-hystrix":                          "org.springframework.cloud",
	"spring-cloud-kubernetes-istio":                            "org.springframework.cloud",
	"spring-cloud-kubernetes-leader":                           "org.springframework.cloud",
	"spring-cloud-kubernetes-loadbalancer":                     "org.springframework.cloud",
	"spring-cloud-kubernetes-ribbon":                           "org.springframework.cloud",
	"spring-cloud-kubernetes-test-support":                     "org.springframework.cloud",
	"spring-cloud-kubernetes-zipkin":                           "org.springframework.cloud",
	"spring-cloud-launcher":                                    "org.springframework.cloud",
	"spring-cloud-loadbalancer":                                "org.springframework.cloud",
	"spring-cloud-localconfig-connector":                       "org.springframework.cloud",
	"spring-cloud-netflix":                                     "org.springframework.cloud",
	"spring-cloud-netflix-archaius":                            "org.springframework.cloud",
	"spring-cloud-netflix-concurrency-limits":                  "org.springframework.cloud",
	"spring-cloud-netflix-core":                                "org.springframework.cloud",
	"spring-cloud-netflix-dependencies":                        "org.springframework.cloud",
	"spring-cloud-netflix-docs":                                "org.springframework.cloud",
	"spring-cloud-netflix-eureka-client":                       "org.springframework.cloud",
	"spring-cloud-netflix-eureka-client-tls-tests":             "org.springframework.cloud",
	"spring-cloud-netflix-eureka-server":                       "org.springframework.cloud",
	"spring-cloud-netflix-hystrix":                             "org.springframework.cloud",
	"spring-cloud-netflix-hystrix-amqp":                        "org.springframework.cloud",
	"spring-cloud-netflix-hystrix-dashboard":                   "org.springframework.cloud",
	"spring-cloud-netflix-hystrix-stream":                      "org.springframework.cloud",
	"spring-cloud-netflix-ribbon":                              "org.springframework.cloud",
	"spring-cloud-netflix-sidecar":                             "org.springframework.cloud",
	"spring-cloud-netflix-spectator":                           "org.springframework.cloud",
	"spring-cloud-netflix-turbine":                             "org.springframework.cloud",
	"spring-cloud-netflix-turbine-amqp":                        "org.springframework.cloud",
	"spring-cloud-netflix-turbine-stream":                      "org.springframework.cloud",
	"spring-cloud-netflix-zuul":                                "org.springframework.cloud",
	"spring-cloud-open-service-broker":                         "org.springframework.cloud",
	"spring-cloud-open-service-broker-autoconfigure":           "org.springframework.cloud",
	"spring-cloud-open-service-broker-contract-tests":          "org.springframework.cloud",
	"spring-cloud-open-service-broker-core":                    "org.springframework.cloud",
	"spring-cloud-open-service-broker-docs":                    "org.springframework.cloud",
	"spring-cloud-openfeign":                                   "org.springframework.cloud",
	"spring-cloud-openfeign-core":                              "org.springframework.cloud",
	"spring-cloud-openfeign-dependencies":                      "org.springframework.cloud",
	"spring-cloud-openfeign-docs":                              "org.springframework.cloud",
	"spring-cloud-parent":                                      "org.springframework.cloud",
	"spring-cloud-scheam-registry-parent":                      "org.springframework.cloud",
	"spring-cloud-scheduler-cloudfoundry":                      "org.springframework.cloud",
	"spring-cloud-scheduler-kubernetes":                        "org.springframework.cloud",
	"spring-cloud-scheduler-parent":                            "org.springframework.cloud",
	"spring-cloud-scheduler-spi":                               "org.springframework.cloud",
	"spring-cloud-scheduler-spi-test":                          "org.springframework.cloud",
	"spring-cloud-scheduler-spi-test-app":                      "org.springframework.cloud",
	"spring-cloud-schema-registry-client":                      "org.springframework.cloud",
	"spring-cloud-schema-registry-core":                        "org.springframework.cloud",
	"spring-cloud-schema-registry-parent":                      "org.springframework.cloud",
	"spring-cloud-schema-registry-server":                      "org.springframework.cloud",
	"spring-cloud-security":                                    "org.springframework.cloud",
	"spring-cloud-security-dependencies":                       "org.springframework.cloud",
	"spring-cloud-security-docs":                               "org.springframework.cloud",
	"spring-cloud-security-parent":                             "org.springframework.cloud",
	"spring-cloud-skipper":                                     "org.springframework.cloud",
	"spring-cloud-skipper-autoconfigure":                       "org.springframework.cloud",
	"spring-cloud-skipper-client":                              "org.springframework.cloud",
	"spring-cloud-skipper-dependencies":                        "org.springframework.cloud",
	"spring-cloud-skipper-docs":                                "org.springframework.cloud",
	"spring-cloud-skipper-parent":                              "org.springframework.cloud",
	"spring-cloud-skipper-platform-cloudfoundry":               "org.springframework.cloud",
	"spring-cloud-skipper-platform-kubernetes":                 "org.springframework.cloud",
	"spring-cloud-skipper-server":                              "org.springframework.cloud",
	"spring-cloud-skipper-server-core":                         "org.springframework.cloud",
	"spring-cloud-skipper-shell":                               "org.springframework.cloud",
	"spring-cloud-skipper-shell-commands":                      "org.springframework.cloud",
	"spring-cloud-sleuth":                                      "org.springframework.cloud",
	"spring-cloud-sleuth-api":                                  "org.springframework.cloud",
	"spring-cloud-sleuth-autoconfigure":                        "org.springframework.cloud",
	"spring-cloud-sleuth-brave":                                "org.springframework.cloud",
	"spring-cloud-sleuth-core":                                 "org.springframework.cloud",
	"spring-cloud-sleuth-dependencies":                         "org.springframework.cloud",
	"spring-cloud-sleuth-docs":                                 "org.springframework.cloud",
	"spring-cloud-sleuth-instrumentation":                      "org.springframework.cloud",
	"spring-cloud-sleuth-otel":                                 "org.springframework.cloud",
	"spring-cloud-sleuth-otel-autoconfigure":                   "org.springframework.cloud",
	"spring-cloud-sleuth-otel-dependencies":                    "org.springframework.cloud",
	"spring-cloud-sleuth-otel-docs":                            "org.springframework.cloud",
	"spring-cloud-sleuth-otel-parent":                          "org.springframework.cloud",
	"spring-cloud-sleuth-otel-tests-parent":                    "org.springframework.cloud",
	"spring-cloud-sleuth-reactor":                              "org.springframework.cloud",
	"spring-cloud-sleuth-sample-test-core":                     "org.springframework.cloud",
	"spring-cloud-sleuth-stream":                               "org.springframework.cloud",
	"spring-cloud-sleuth-tests":                                "org.springframework.cloud",
	"spring-cloud-sleuth-tests-common":                         "org.springframework.cloud",
	"spring-cloud-sleuth-tests-otel-common":                    "org.springframework.cloud",
	"spring-cloud-sleuth-zipkin":                               "org.springframework.cloud",
	"spring-cloud-sleuth-zipkin-legacy":                        "org.springframework.cloud",
	"spring-cloud-sleuth-zipkin-stream":                        "org.springframework.cloud",
	"spring-cloud-spinnaker":                                   "org.springframework.cloud",
	"spring-cloud-spring-service-connector":                    "org.springframework.cloud",
	"spring-cloud-square":                                      "org.springframework.cloud",
	"spring-cloud-square-dependencies":                         "org.springframework.cloud",
	"spring-cloud-square-docs":                                 "org.springframework.cloud",
	"spring-cloud-square-okhttp":                               "org.springframework.cloud",
	"spring-cloud-square-retrofit":                             "org.springframework.cloud",
	"spring-cloud-square-retrofit-core":                        "org.springframework.cloud",
	"spring-cloud-square-retrofit-webclient":                   "org.springframework.cloud",
	"spring-cloud-starter":                                     "org.springframework.cloud",
	"spring-cloud-starter-alibaba":                             "org.springframework.cloud",
	"spring-cloud-starter-alibaba-nacos-config":                "org.springframework.cloud",
	"spring-cloud-starter-alibaba-nacos-config-server":         "org.springframework.cloud",
	"spring-cloud-starter-alibaba-nacos-discovery":             "org.springframework.cloud",
	"spring-cloud-starter-alibaba-seata":                       "org.springframework.cloud",
	"spring-cloud-starter-alibaba-sentinel":                    "org.springframework.cloud",
	"spring-cloud-starter-alicloud":                            "org.springframework.cloud",
	"spring-cloud-starter-alicloud-acm":                        "org.springframework.cloud",
	"spring-cloud-starter-alicloud-ans":                        "org.springframework.cloud",
	"spring-cloud-starter-alicloud-oss":                        "org.springframework.cloud",
	"spring-cloud-starter-alicloud-schedulerx":                 "org.springframework.cloud",
	"spring-cloud-starter-alicloud-sms":                        "org.springframework.cloud",
	"spring-cloud-starter-app-broker":                          "org.springframework.cloud",
	"spring-cloud-starter-app-broker-cloudfoundry":             "org.springframework.cloud",
	"spring-cloud-starter-app-broker-logging":                  "org.springframework.cloud",
	"spring-cloud-starter-archaius":                            "org.springframework.cloud",
	"spring-cloud-starter-atlas":                               "org.springframework.cloud",
	"spring-cloud-starter-aws":                                 "org.springframework.cloud",
	"spring-cloud-starter-aws-jdbc":                            "org.springframework.cloud",
	"spring-cloud-starter-aws-messaging":                       "org.springframework.cloud",
	"spring-cloud-starter-aws-parameter-store-config":          "org.springframework.cloud",
	"spring-cloud-starter-aws-secrets-manager-config":          "org.springframework.cloud",
	"spring-cloud-starter-bootstrap":                           "org.springframework.cloud",
	"spring-cloud-starter-build":                               "org.springframework.cloud",
	"spring-cloud-starter-bus-amqp":                            "org.springframework.cloud",
	"spring-cloud-starter-bus-kafka":                           "org.springframework.cloud",
	"spring-cloud-starter-bus-rocketmq":                        "org.springframework.cloud",
	"spring-cloud-starter-bus-stream":                          "org.springframework.cloud",
	"spring-cloud-starter-circuitbreaker":                      "org.springframework.cloud",
	"spring-cloud-starter-circuitbreaker-reactor-resilience4j": "org.springframework.cloud",
	"spring-cloud-starter-circuitbreaker-resilience4j":         "org.springframework.cloud",
	"spring-cloud-starter-circuitbreaker-spring-retry":         "org.springframework.cloud",
	"spring-cloud-starter-cloudfoundry":                        "org.springframework.cloud",
	"spring-cloud-starter-common-security-config-web":          "org.springframework.cloud",
	"spring-cloud-starter-config":                              "org.springframework.cloud",
	"spring-cloud-starter-consul":                              "org.springframework.cloud",
	"spring-cloud-starter-consul-all":                          "org.springframework.cloud",
	"spring-cloud-starter-consul-bus":                          "org.springframework.cloud",
	"spring-cloud-starter-consul-config":                       "org.springframework.cloud",
	"spring-cloud-starter-consul-discovery":                    "org.springframework.cloud",
	"spring-cloud-starter-contract-stub-runner":                "org.springframework.cloud",
	"spring-cloud-starter-contract-stub-runner-jetty":          "org.springframework.cloud",
	"spring-cloud-starter-contract-verifier":                   "org.springframework.cloud",
	"spring-cloud-starter-dataflow-metrics-collector":          "org.springframework.cloud",
	"spring-cloud-starter-dataflow-server":                     "org.springframework.cloud",
	"spring-cloud-starter-dataflow-server-cloudfoundry":        "org.springframework.cloud",
	"spring-cloud-starter-dataflow-server-kubernetes":          "org.springframework.cloud",
	"spring-cloud-starter-dataflow-server-local":               "org.springframework.cloud",
	"spring-cloud-starter-dataflow-server-mesos":               "org.springframework.cloud",
	"spring-cloud-starter-dataflow-server-yarn":                "org.springframework.cloud",
	"spring-cloud-starter-dataflow-ui":                         "org.springframework.cloud",
	"spring-cloud-starter-deployer-yarn":                       "org.springframework.cloud",
	"spring-cloud-starter-docs":                                "org.springframework.cloud",
	"spring-cloud-starter-dubbo":                               "org.springframework.cloud",
	"spring-cloud-starter-eureka":                              "org.springframework.cloud",
	"spring-cloud-starter-eureka-server":                       "org.springframework.cloud",
	"spring-cloud-starter-feign":                               "org.springframework.cloud",
	"spring-cloud-starter-function-web":                        "org.springframework.cloud",
	"spring-cloud-starter-function-webflux":                    "org.springframework.cloud",
	"spring-cloud-starter-gateway":                             "org.springframework.cloud",
	"spring-cloud-starter-hystrix":                             "org.springframework.cloud",
	"spring-cloud-starter-hystrix-dashboard":                   "org.springframework.cloud",
	"spring-cloud-starter-kubernetes":                          "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-all":                      "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-client":                   "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-client-all":               "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-client-config":            "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-client-loadbalancer":      "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-config":                   "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-discoveryclient":          "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-fabric8":                  "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-fabric8-all":              "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-fabric8-config":           "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-fabric8-loadbalancer":     "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-loadbalancer":             "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-netflix":                  "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-ribbon":                   "org.springframework.cloud",
	"spring-cloud-starter-kubernetes-zipkin":                   "org.springframework.cloud",
	"spring-cloud-starter-loadbalancer":                        "org.springframework.cloud",
	"spring-cloud-starter-netflix":                             "org.springframework.cloud",
	"spring-cloud-starter-netflix-archaius":                    "org.springframework.cloud",
	"spring-cloud-starter-netflix-atlas":                       "org.springframework.cloud",
	"spring-cloud-starter-netflix-eureka-client":               "org.springframework.cloud",
	"spring-cloud-starter-netflix-eureka-server":               "org.springframework.cloud",
	"spring-cloud-starter-netflix-hystrix":                     "org.springframework.cloud",
	"spring-cloud-starter-netflix-hystrix-dashboard":           "org.springframework.cloud",
	"spring-cloud-starter-netflix-ribbon":                      "org.springframework.cloud",
	"spring-cloud-starter-netflix-spectator":                   "org.springframework.cloud",
	"spring-cloud-starter-netflix-turbine":                     "org.springframework.cloud",
	"spring-cloud-starter-netflix-turbine-amqp":                "org.springframework.cloud",
	"spring-cloud-starter-netflix-turbine-stream":              "org.springframework.cloud",
	"spring-cloud-starter-netflix-zuul":                        "org.springframework.cloud",
	"spring-cloud-starter-oauth2":                              "org.springframework.cloud",
	"spring-cloud-starter-open-service-broker":                 "org.springframework.cloud",
	"spring-cloud-starter-open-service-broker-webmvc":          "org.springframework.cloud",
	"spring-cloud-starter-openfeign":                           "org.springframework.cloud",
	"spring-cloud-starter-parent":                              "org.springframework.cloud",
	"spring-cloud-starter-ribbon":                              "org.springframework.cloud",
	"spring-cloud-starter-security":                            "org.springframework.cloud",
	"spring-cloud-starter-single-step-batch-job":               "org.springframework.cloud",
	"spring-cloud-starter-skipper-server":                      "org.springframework.cloud",
	"spring-cloud-starter-sleuth":                              "org.springframework.cloud",
	"spring-cloud-starter-spectator":                           "org.springframework.cloud",
	"spring-cloud-starter-stream-kafka":                        "org.springframework.cloud",
	"spring-cloud-starter-stream-kafka11":                      "org.springframework.cloud",
	"spring-cloud-starter-stream-rabbit":                       "org.springframework.cloud",
	"spring-cloud-starter-stream-redis":                        "org.springframework.cloud",
	"spring-cloud-starter-stream-rocketmq":                     "org.springframework.cloud",
	"spring-cloud-starter-task":                                "org.springframework.cloud",
	"spring-cloud-starter-turbine":                             "org.springframework.cloud",
	"spring-cloud-starter-turbine-amqp":                        "org.springframework.cloud",
	"spring-cloud-starter-turbine-stream":                      "org.springframework.cloud",
	"spring-cloud-starter-vault-config":                        "org.springframework.cloud",
	"spring-cloud-starter-zipkin":                              "org.springframework.cloud",
	"spring-cloud-starter-zipkin-legacy":                       "org.springframework.cloud",
	"spring-cloud-starter-zookeeper":                           "org.springframework.cloud",
	"spring-cloud-starter-zookeeper-all":                       "org.springframework.cloud",
	"spring-cloud-starter-zookeeper-config":                    "org.springframework.cloud",
	"spring-cloud-starter-zookeeper-discovery":                 "org.springframework.cloud",
	"spring-cloud-starter-zuul":                                "org.springframework.cloud",
	"spring-cloud-stream":                                      "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka":                         "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-0.10-test":               "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-0.10.0-test":             "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-0.10.1-test":             "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-0.10.2-test":             "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-0.11-test":               "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-0.9":                     "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-core":                    "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-docs":                    "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-parent":                  "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-reactive":                "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-streams":                 "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka-test-support":            "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka11":                       "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka11-core":                  "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka11-docs":                  "org.springframework.cloud",
	"spring-cloud-stream-binder-kafka11-parent":                "org.springframework.cloud",
	"spring-cloud-stream-binder-kinesis":                       "org.springframework.cloud",
	"spring-cloud-stream-binder-kinesis-docs":                  "org.springframework.cloud",
	"spring-cloud-stream-binder-kinesis-parent":                "org.springframework.cloud",
	"spring-cloud-stream-binder-kstream":                       "org.springframework.cloud",
	"spring-cloud-stream-binder-kstream11":                     "org.springframework.cloud",
	"spring-cloud-stream-binder-rabbit":                        "org.springframework.cloud",
	"spring-cloud-stream-binder-rabbit-core":                   "org.springframework.cloud",
	"spring-cloud-stream-binder-rabbit-docs":                   "org.springframework.cloud",
	"spring-cloud-stream-binder-rabbit-parent":                 "org.springframework.cloud",
	"spring-cloud-stream-binder-rabbit-test-support":           "org.springframework.cloud",
	"spring-cloud-stream-binder-redis":                         "org.springframework.cloud",
	"spring-cloud-stream-binder-redis-parent":                  "org.springframework.cloud",
	"spring-cloud-stream-binder-rocketmq":                      "org.springframework.cloud",
	"spring-cloud-stream-binder-servlet":                       "org.springframework.cloud",
	"spring-cloud-stream-binder-test":                          "org.springframework.cloud",
	"spring-cloud-stream-binders":                              "org.springframework.cloud",
	"spring-cloud-stream-binders-parent":                       "org.springframework.cloud",
	"spring-cloud-stream-codec":                                "org.springframework.cloud",
	"spring-cloud-stream-core":                                 "org.springframework.cloud",
	"spring-cloud-stream-core-docs":                            "org.springframework.cloud",
	"spring-cloud-stream-dependencies":                         "org.springframework.cloud",
	"spring-cloud-stream-docs":                                 "org.springframework.cloud",
	"spring-cloud-stream-integration-tests":                    "org.springframework.cloud",
	"spring-cloud-stream-metrics":                              "org.springframework.cloud",
	"spring-cloud-stream-parent":                               "org.springframework.cloud",
	"spring-cloud-stream-reactive":                             "org.springframework.cloud",
	"spring-cloud-stream-rxjava":                               "org.springframework.cloud",
	"spring-cloud-stream-schema":                               "org.springframework.cloud",
	"spring-cloud-stream-schema-registry":                      "org.springframework.cloud",
	"spring-cloud-stream-schema-registry-client":               "org.springframework.cloud",
	"spring-cloud-stream-schema-registry-core":                 "org.springframework.cloud",
	"spring-cloud-stream-schema-registry-server":               "org.springframework.cloud",
	"spring-cloud-stream-schema-server":                        "org.springframework.cloud",
	"spring-cloud-stream-starter-build":                        "org.springframework.cloud",
	"spring-cloud-stream-starter-parent":                       "org.springframework.cloud",
	"spring-cloud-stream-starters":                             "org.springframework.cloud",
	"spring-cloud-stream-test-binder":                          "org.springframework.cloud",
	"spring-cloud-stream-test-support":                         "org.springframework.cloud",
	"spring-cloud-stream-test-support-internal":                "org.springframework.cloud",
	"spring-cloud-stream-tools":                                "org.springframework.cloud",
	"spring-cloud-task-batch":                                  "org.springframework.cloud",
	"spring-cloud-task-core":                                   "org.springframework.cloud",
	"spring-cloud-task-dependencies":                           "org.springframework.cloud",
	"spring-cloud-task-docs":                                   "org.springframework.cloud",
	"spring-cloud-task-integration-tests":                      "org.springframework.cloud",
	"spring-cloud-task-parent":                                 "org.springframework.cloud",
	"spring-cloud-task-samples":                                "org.springframework.cloud",
	"spring-cloud-task-starter":                                "org.springframework.cloud",
	"spring-cloud-task-stream":                                 "org.springframework.cloud",
	"spring-cloud-test-support":                                "org.springframework.cloud",
	"spring-cloud-vault-config":                                "org.springframework.cloud",
	"spring-cloud-vault-config-aws":                            "org.springframework.cloud",
	"spring-cloud-vault-config-consul":                         "org.springframework.cloud",
	"spring-cloud-vault-config-databases":                      "org.springframework.cloud",
	"spring-cloud-vault-config-docs":                           "org.springframework.cloud",
	"spring-cloud-vault-config-rabbitmq":                       "org.springframework.cloud",
	"spring-cloud-vault-dependencies":                          "org.springframework.cloud",
	"spring-cloud-vault-docs":                                  "org.springframework.cloud",
	"spring-cloud-vault-parent":                                "org.springframework.cloud",
	"spring-cloud-versions":                                    "org.springframework.cloud",
	"spring-cloud-zookeeper":                                   "org.springframework.cloud",
	"spring-cloud-zookeeper-config":                            "org.springframework.cloud",
	"spring-cloud-zookeeper-core":                              "org.springframework.cloud",
	"spring-cloud-zookeeper-dependencies":                      "org.springframework.cloud",
	"spring-cloud-zookeeper-discovery":                         "org.springframework.cloud",
	"spring-cloud-zookeeper-docs":                              "org.springframework.cloud",
	"spring-credhub-core":                                      "org.springframework.credhub",
	"spring-cql":                                               "org.springframework.data",
	"spring-data-bom":                                          "org.springframework.data",
	"spring-data-cassandra":                                    "org.springframework.data",
	"spring-data-cassandra-distribution":                       "org.springframework.data",
	"spring-data-cassandra-parent":                             "org.springframework.data",
	"spring-data-commons":                                      "org.springframework.data",
	"spring-data-commons-core":                                 "org.springframework.data",
	"spring-data-commons-dist":                                 "org.springframework.data",
	"spring-data-commons-parent":                               "org.springframework.data",
	"spring-data-couchbase":                                    "org.springframework.data",
	"spring-data-elasticsearch":                                "org.springframework.data",
	"spring-data-envers":                                       "org.springframework.data",
	"spring-data-gemfire":                                      "org.springframework.data",
	"spring-data-gemfire-test":                                 "org.springframework.data",
	"spring-data-geode":                                        "org.springframework.data",
	"spring-data-geode-distribution":                           "org.springframework.data",
	"spring-data-geode-parent":                                 "org.springframework.data",
	"spring-data-geode-test":                                   "org.springframework.data",
	"spring-data-graph-core":                                   "org.springframework.data",
	"spring-data-graph-dist":                                   "org.springframework.data",
	"spring-data-graph-parent":                                 "org.springframework.data",
	"spring-data-hadoop":                                       "org.springframework.data",
	"spring-data-hadoop-batch":                                 "org.springframework.data",
	"spring-data-hadoop-boot":                                  "org.springframework.data",
	"spring-data-hadoop-build-tests":                           "org.springframework.data",
	"spring-data-hadoop-cluster-tests":                         "org.springframework.data",
	"spring-data-hadoop-config":                                "org.springframework.data",
	"spring-data-hadoop-core":                                  "org.springframework.data",
	"spring-data-hadoop-hbase":                                 "org.springframework.data",
	"spring-data-hadoop-hive":                                  "org.springframework.data",
	"spring-data-hadoop-pig":                                   "org.springframework.data",
	"spring-data-hadoop-spark":                                 "org.springframework.data",
	"spring-data-hadoop-sqoop2":                                "org.springframework.data",
	"spring-data-hadoop-store":                                 "org.springframework.data",
	"spring-data-hadoop-test":                                  "org.springframework.data",
	"spring-data-hadoop-util":                                  "org.springframework.data",
	"spring-data-jdbc":                                         "org.springframework.data",
	"spring-data-jdbc-core":                                    "org.springframework.data",
	"spring-data-jdbc-distribution":                            "org.springframework.data",
	"spring-data-jpa":                                          "org.springframework.data",
	"spring-data-jpa-distribution":                             "org.springframework.data",
	"spring-data-jpa-parent":                                   "org.springframework.data",
	"spring-data-keyvalue":                                     "org.springframework.data",
	"spring-data-ldap":                                         "org.springframework.data",
	"spring-data-mongodb":                                      "org.springframework.data",
	"spring-data-mongodb-cross-store":                          "org.springframework.data",
	"spring-data-mongodb-dist":                                 "org.springframework.data",
	"spring-data-mongodb-distribution":                         "org.springframework.data",
	"spring-data-mongodb-log4j":                                "org.springframework.data",
	"spring-data-mongodb-parent":                               "org.springframework.data",
	"spring-data-neo4j":                                        "org.springframework.data",
	"spring-data-neo4j-aspects":                                "org.springframework.data",
	"spring-data-neo4j-cross-store":                            "org.springframework.data",
	"spring-data-neo4j-dist":                                   "org.springframework.data",
	"spring-data-neo4j-distribution":                           "org.springframework.data",
	"spring-data-neo4j-parent":                                 "org.springframework.data",
	"spring-data-neo4j-rest":                                   "org.springframework.data",
	"spring-data-neo4j-tx":                                     "org.springframework.data",
	"spring-data-oracle":                                       "org.springframework.data",
	"spring-data-r2dbc":                                        "org.springframework.data",
	"spring-data-redis":                                        "org.springframework.data",
	"spring-data-relational":                                   "org.springframework.data",
	"spring-data-relational-parent":                            "org.springframework.data",
	"spring-data-releasetrain":                                 "org.springframework.data",
	"spring-data-rest-core":                                    "org.springframework.data",
	"spring-data-rest-distribution":                            "org.springframework.data",
	"spring-data-rest-hal-browser":                             "org.springframework.data",
	"spring-data-rest-hal-explorer":                            "org.springframework.data",
	"spring-data-rest-parent":                                  "org.springframework.data",
	"spring-data-rest-repository":                              "org.springframework.data",
	"spring-data-rest-webmvc":                                  "org.springframework.data",
	"spring-data-solr":                                         "org.springframework.data",
	"spring-yarn":                                              "org.springframework.data",
	"spring-yarn-batch":                                        "org.springframework.data",
	"spring-yarn-boot":                                         "org.springframework.data",
	"spring-yarn-boot-build-tests":                             "org.springframework.data",
	"spring-yarn-boot-cli":                                     "org.springframework.data",
	"spring-yarn-boot-test":                                    "org.springframework.data",
	"spring-yarn-build-tests":                                  "org.springframework.data",
	"spring-yarn-core":                                         "org.springframework.data",
	"spring-yarn-integration":                                  "org.springframework.data",
	"spring-yarn-test":                                         "org.springframework.data",
	"spring-flex":                                              "org.springframework.flex",
	"spring-graphql":                                           "org.springframework.graphql",
	"spring-hateoas":                                           "org.springframework.hateoas",
	"spring-integration":                                       "org.springframework.integration",
	"spring-integration-adapter":                               "org.springframework.integration",
	"spring-integration-amqp":                                  "org.springframework.integration",
	"spring-integration-aws":                                   "org.springframework.integration",
	"spring-integration-bom":                                   "org.springframework.integration",
	"spring-integration-camel":                                 "org.springframework.integration",
	"spring-integration-cassandra":                             "org.springframework.integration",
	"spring-integration-core":                                  "org.springframework.integration",
	"spring-integration-event":                                 "org.springframework.integration",
	"spring-integration-feed":                                  "org.springframework.integration",
	"spring-integration-file":                                  "org.springframework.integration",
	"spring-integration-flow":                                  "org.springframework.integration",
	"spring-integration-ftp":                                   "org.springframework.integration",
	"spring-integration-gemfire":                               "org.springframework.integration",
	"spring-integration-graphql":                               "org.springframework.integration",
	"spring-integration-groovy":                                "org.springframework.integration",
	"spring-integration-groovy-dsl":                            "org.springframework.integration",
	"spring-integration-hazelcast":                             "org.springframework.integration",
	"spring-integration-http":                                  "org.springframework.integration",
	"spring-integration-httpinvoker":                           "org.springframework.integration",
	"spring-integration-ip":                                    "org.springframework.integration",
	"spring-integration-java-dsl":                              "org.springframework.integration",
	"spring-integration-jdbc":                                  "org.springframework.integration",
	"spring-integration-jms":                                   "org.springframework.integration",
	"spring-integration-jmx":                                   "org.springframework.integration",
	"spring-integration-jpa":                                   "org.springframework.integration",
	"spring-integration-kafka":                                 "org.springframework.integration",
	"spring-integration-kotlin-dsl":                            "org.springframework.integration",
	"spring-integration-mail":                                  "org.springframework.integration",
	"spring-integration-mongodb":                               "org.springframework.integration",
	"spring-integration-mqtt":                                  "org.springframework.integration",
	"spring-integration-parent":                                "org.springframework.integration",
	"spring-integration-r2dbc":                                 "org.springframework.integration",
	"spring-integration-redis":                                 "org.springframework.integration",
	"spring-integration-rmi":                                   "org.springframework.integration",
	"spring-integration-rsocket":                               "org.springframework.integration",
	"spring-integration-samples":                               "org.springframework.integration",
	"spring-integration-scripting":                             "org.springframework.integration",
	"spring-integration-security":                              "org.springframework.integration",
	"spring-integration-sftp":                                  "org.springframework.integration",
	"spring-integration-smb":                                   "org.springframework.integration",
	"spring-integration-smpp":                                  "org.springframework.integration",
	"spring-integration-social-twitter":                        "org.springframework.integration",
	"spring-integration-splunk":                                "org.springframework.integration",
	"spring-integration-stomp":                                 "org.springframework.integration",
	"spring-integration-stream":                                "org.springframework.integration",
	"spring-integration-syslog":                                "org.springframework.integration",
	"spring-integration-test":                                  "org.springframework.integration",
	"spring-integration-test-support":                          "org.springframework.integration",
	"spring-integration-tuple":                                 "org.springframework.integration",
	"spring-integration-twitter":                               "org.springframework.integration",
	"spring-integration-webflux":                               "org.springframework.integration",
	"spring-integration-websocket":                             "org.springframework.integration",
	"spring-integration-ws":                                    "org.springframework.integration",
	"spring-integration-xml":                                   "org.springframework.integration",
	"spring-integration-xmpp":                                  "org.springframework.integration",
	"spring-integration-zeromq":                                "org.springframework.integration",
	"spring-integration-zip":                                   "org.springframework.integration",
	"spring-integration-zookeeper":                             "org.springframework.integration",
	"spring-kafka":                                             "org.springframework.kafka",
	"spring-social-core":                                       "org.springframework.social",
	"spring-security":                                          "org.springframework.security",
	"spring-security-acl":                                      "org.springframework.security",
	"spring-security-adapters":                                 "org.springframework.security",
	"spring-security-aspects":                                  "org.springframework.security",
	"spring-security-bom":                                      "org.springframework.security",
	"spring-security-cas":                                      "org.springframework.security",
	"spring-security-cas-client":                               "org.springframework.security",
	"spring-security-catalina":                                 "org.springframework.security",
	"spring-security-config":                                   "org.springframework.security",
	"spring-security-core":                                     "org.springframework.security",
	"spring-security-core-tiger":                               "org.springframework.security",
	"spring-security-crypto":                                   "org.springframework.security",
	"spring-security-data":                                     "org.springframework.security",
	"spring-security-jboss":                                    "org.springframework.security",
	"spring-security-jetty":                                    "org.springframework.security",
	"spring-security-jwt":                                      "org.springframework.security",
	"spring-security-ldap":                                     "org.springframework.security",
	"spring-security-messaging":                                "org.springframework.security",
	"spring-security-ntlm":                                     "org.springframework.security",
	"spring-security-oauth2-authorization-server":              "org.springframework.security",
	"spring-security-oauth2-client":                            "org.springframework.security",
	"spring-security-oauth2-core":                              "org.springframework.security",
	"spring-security-oauth2-jose":                              "org.springframework.security",
	"spring-security-oauth2-resource-server":                   "org.springframework.security",
	"spring-security-openid":                                   "org.springframework.security",
	"spring-security-parent":                                   "org.springframework.security",
	"spring-security-portlet":                                  "org.springframework.security",
	"spring-security-remoting":                                 "org.springframework.security",
	"spring-security-resin":                                    "org.springframework.security",
	"spring-security-rsa":                                      "org.springframework.security",
	"spring-security-rsocket":                                  "org.springframework.security",
	"spring-security-saml2-service-provider":                   "org.springframework.security",
	"spring-security-samples":                                  "org.springframework.security",
	"spring-security-samples-aspectj":                          "org.springframework.security",
	"spring-security-samples-cas":                              "org.springframework.security",
	"spring-security-samples-cas-client":                       "org.springframework.security",
	"spring-security-samples-cas-server":                       "org.springframework.security",
	"spring-security-samples-contacts":                         "org.springframework.security",
	"spring-security-samples-dms":                              "org.springframework.security",
	"spring-security-samples-javaconfig-messages":              "org.springframework.security",
	"spring-security-samples-ldap":                             "org.springframework.security",
	"spring-security-samples-messages-jc":                      "org.springframework.security",
	"spring-security-samples-openid":                           "org.springframework.security",
	"spring-security-samples-portlet":                          "org.springframework.security",
	"spring-security-samples-preauth":                          "org.springframework.security",
	"spring-security-samples-tutorial":                         "org.springframework.security",
	"spring-security-taglibs":                                  "org.springframework.security",
	"spring-security-test":                                     "org.springframework.security",
	"spring-security-web":                                      "org.springframework.security",
	"spring-security-oauth":                                    "org.springframework.security.oauth",
	"spring-security-oauth-parent":                             "org.springframework.security.oauth",
	"spring-security-oauth2":                                   "org.springframework.security.oauth",
	"spring-security-oauth2-autoconfigure":                     "org.springframework.security.oauth.boot",
	"spring-security-kerberos-bom":                             "org.springframework.security.kerberos",
	"spring-security-kerberos-client":                          "org.springframework.security.kerberos",
	"spring-security-kerberos-core":                            "org.springframework.security.kerberos",
	"spring-security-kerberos-test":                            "org.springframework.security.kerberos",
	"spring-security-kerberos-web":                             "org.springframework.security.kerberos",
	"spring-security-saml-dsl-core":                            "org.springframework.security.extensions",
	"spring-security-saml2-core":                               "org.springframework.security.extensions",
	"spring-session":                                           "org.springframework.session",
	"spring-session-bom":                                       "org.springframework.session",
	"spring-session-core":                                      "org.springframework.session",
	"spring-session-data-gemfire":                              "org.springframework.session",
	"spring-session-data-geode":                                "org.springframework.session",
	"spring-session-data-mongo":                                "org.springframework.session",
	"spring-session-data-mongodb":                              "org.springframework.session",
	"spring-session-data-redis":                                "org.springframework.session",
	"spring-session-hazelcast":                                 "org.springframework.session",
	"spring-session-jdbc":                                      "org.springframework.session",
	"spring-vault-core":                                        "org.springframework.vault",
	"org.springframework.binding":                              "org.springframework.webflow",
	"org.springframework.faces":                                "org.springframework.webflow",
	"org.springframework.js":                                   "org.springframework.webflow",
	"org.springframework.webflow":                              "org.springframework.webflow",
	"spring-binding":                                           "org.springframework.webflow",
	"spring-build-src":                                         "org.springframework.webflow",
	"spring-faces":                                             "org.springframework.webflow",
	"spring-js":                                                "org.springframework.webflow",
	"spring-js-resources":                                      "org.springframework.webflow",
	"spring-webflow":                                           "org.springframework.webflow",
	"spring-ws":                                                "org.springframework.ws",
	"spring-xml":                                               "org.springframework.ws",
	"xalan":                                                    "xalan", // see https://mvnrepository.com/artifact/xalan/xalan/2.7.2
	"org.eclipse.ant.core":                                     "org.eclipse.platform",
	"org.eclipse.ant.launching":                                "org.eclipse.platform",
	"org.eclipse.ant.optional.junit":                           "org.eclipse.platform",
	"org.eclipse.ant.ui":                                       "org.eclipse.platform",
	"org.eclipse.compare":                                      "org.eclipse.platform",
	"org.eclipse.compare.core":                                 "org.eclipse.platform",
	"org.eclipse.compare.examples":                             "org.eclipse.platform",
	"org.eclipse.compare.examples.xml":                         "org.eclipse.platform",
	"org.eclipse.compare.win32":                                "org.eclipse.platform",
	"org.eclipse.core.commands":                                "org.eclipse.platform",
	"org.eclipse.core.contenttype":                             "org.eclipse.platform",
	"org.eclipse.core.databinding":                             "org.eclipse.platform",
	"org.eclipse.core.databinding.beans":                       "org.eclipse.platform",
	"org.eclipse.core.databinding.observable":                  "org.eclipse.platform",
	"org.eclipse.core.databinding.property":                    "org.eclipse.platform",
	"org.eclipse.core.expressions":                             "org.eclipse.platform",
	"org.eclipse.core.externaltools":                           "org.eclipse.platform",
	"org.eclipse.core.filebuffers":                             "org.eclipse.platform",
	"org.eclipse.core.filesystem":                              "org.eclipse.platform",
	"org.eclipse.core.filesystem.aix.ppc":                      "org.eclipse.platform",
	"org.eclipse.core.filesystem.aix.ppc64":                    "org.eclipse.platform",
	"org.eclipse.core.filesystem.hpux.ia64":                    "org.eclipse.platform",
	"org.eclipse.core.filesystem.linux.aarch64":                "org.eclipse.platform",
	"org.eclipse.core.filesystem.linux.ppc":                    "org.eclipse.platform",
	"org.eclipse.core.filesystem.linux.ppc64":                  "org.eclipse.platform",
	"org.eclipse.core.filesystem.linux.ppc64le":                "org.eclipse.platform",
	"org.eclipse.core.filesystem.linux.x86":                    "org.eclipse.platform",
	"org.eclipse.core.filesystem.linux.x86_64":                 "org.eclipse.platform",
	"org.eclipse.core.filesystem.macosx":                       "org.eclipse.platform",
	"org.eclipse.core.filesystem.win32.x86":                    "org.eclipse.platform",
	"org.eclipse.core.filesystem.win32.x86_64":                 "org.eclipse.platform",
	"org.eclipse.core.jobs":                                    "org.eclipse.platform",
	"org.eclipse.core.net":                                     "org.eclipse.platform",
	"org.eclipse.core.net.linux":                               "org.eclipse.platform",
	"org.eclipse.core.net.linux.x86":                           "org.eclipse.platform",
	"org.eclipse.core.net.linux.x86_64":                        "org.eclipse.platform",
	"org.eclipse.core.net.win32":                               "org.eclipse.platform",
	"org.eclipse.core.net.win32.x86":                           "org.eclipse.platform",
	"org.eclipse.core.net.win32.x86_64":                        "org.eclipse.platform",
	"org.eclipse.core.resources":                               "org.eclipse.platform",
	"org.eclipse.core.resources.win32.x86":                     "org.eclipse.platform",
	"org.eclipse.core.resources.win32.x86_64":                  "org.eclipse.platform",
	"org.eclipse.core.runtime":                                 "org.eclipse.platform",
	"org.eclipse.core.variables":                               "org.eclipse.platform",
	"org.eclipse.cvs":                                          "org.eclipse.platform",
	"org.eclipse.debug.core":                                   "org.eclipse.platform",
	"org.eclipse.debug.examples.core":                          "org.eclipse.platform",
	"org.eclipse.debug.examples.ui":                            "org.eclipse.platform",
	"org.eclipse.debug.ui":                                     "org.eclipse.platform",
	"org.eclipse.debug.ui.launchview":                          "org.eclipse.platform",
	"org.eclipse.e4.core.commands":                             "org.eclipse.platform",
	"org.eclipse.e4.core.contexts":                             "org.eclipse.platform",
	"org.eclipse.e4.core.di":                                   "org.eclipse.platform",
	"org.eclipse.e4.core.di.annotations":                       "org.eclipse.platform",
	"org.eclipse.e4.core.di.extensions":                        "org.eclipse.platform",
	"org.eclipse.e4.core.di.extensions.supplier":               "org.eclipse.platform",
	"org.eclipse.e4.core.services":                             "org.eclipse.platform",
	"org.eclipse.e4.emf.xpath":                                 "org.eclipse.platform",
	"org.eclipse.e4.tools":                                     "org.eclipse.platform",
	"org.eclipse.e4.tools.compat":                              "org.eclipse.platform",
	"org.eclipse.e4.tools.compatibility.migration":             "org.eclipse.platform",
	"org.eclipse.e4.tools.emf.editor3x":                        "org.eclipse.platform",
	"org.eclipse.e4.tools.emf.ui":                              "org.eclipse.platform",
	"org.eclipse.e4.tools.jdt.templates":                       "org.eclipse.platform",
	"org.eclipse.e4.tools.persistence":                         "org.eclipse.platform",
	"org.eclipse.e4.tools.services":                            "org.eclipse.platform",
	"org.eclipse.e4.ui.bindings":                               "org.eclipse.platform",
	"org.eclipse.e4.ui.css.core":                               "org.eclipse.platform",
	"org.eclipse.e4.ui.css.swt":                                "org.eclipse.platform",
	"org.eclipse.e4.ui.css.swt.theme":                          "org.eclipse.platform",
	"org.eclipse.e4.ui.di":                                     "org.eclipse.platform",
	"org.eclipse.e4.ui.dialogs":                                "org.eclipse.platform",
	"org.eclipse.e4.ui.ide":                                    "org.eclipse.platform",
	"org.eclipse.e4.ui.model.workbench":                        "org.eclipse.platform",
	"org.eclipse.e4.ui.progress":                               "org.eclipse.platform",
	"org.eclipse.e4.ui.services":                               "org.eclipse.platform",
	"org.eclipse.e4.ui.swt.gtk":                                "org.eclipse.platform",
	"org.eclipse.e4.ui.swt.win32":                              "org.eclipse.platform",
	"org.eclipse.e4.ui.widgets":                                "org.eclipse.platform",
	"org.eclipse.e4.ui.workbench":                              "org.eclipse.platform",
	"org.eclipse.e4.ui.workbench.addons.swt":                   "org.eclipse.platform",
	"org.eclipse.e4.ui.workbench.renderers.swt":                "org.eclipse.platform",
	"org.eclipse.e4.ui.workbench.renderers.swt.cocoa":          "org.eclipse.platform",
	"org.eclipse.e4.ui.workbench.swt":                          "org.eclipse.platform",
	"org.eclipse.e4.ui.workbench3":                             "org.eclipse.platform",
	"org.eclipse.equinox.app":                                  "org.eclipse.platform",
	"org.eclipse.equinox.bidi":                                 "org.eclipse.platform",
	"org.eclipse.equinox.cm":                                   "org.eclipse.platform",
	"org.eclipse.equinox.common":                               "org.eclipse.platform",
	"org.eclipse.equinox.concurrent":                           "org.eclipse.platform",
	"org.eclipse.equinox.console":                              "org.eclipse.platform",
	"org.eclipse.equinox.console.jaas.fragment":                "org.eclipse.platform",
	"org.eclipse.equinox.console.ssh":                          "org.eclipse.platform",
	"org.eclipse.equinox.coordinator":                          "org.eclipse.platform",
	"org.eclipse.equinox.device":                               "org.eclipse.platform",
	"org.eclipse.equinox.ds":                                   "org.eclipse.platform",
	"org.eclipse.equinox.event":                                "org.eclipse.platform",
	"org.eclipse.equinox.frameworkadmin":                       "org.eclipse.platform",
	"org.eclipse.equinox.frameworkadmin.equinox":               "org.eclipse.platform",
	"org.eclipse.equinox.http.jetty":                           "org.eclipse.platform",
	"org.eclipse.equinox.http.registry":                        "org.eclipse.platform",
	"org.eclipse.equinox.http.servlet":                         "org.eclipse.platform",
	"org.eclipse.equinox.http.servletbridge":                   "org.eclipse.platform",
	"org.eclipse.equinox.io":                                   "org.eclipse.platform",
	"org.eclipse.equinox.ip":                                   "org.eclipse.platform",
	"org.eclipse.equinox.jsp.jasper":                           "org.eclipse.platform",
	"org.eclipse.equinox.jsp.jasper.registry":                  "org.eclipse.platform",
	"org.eclipse.equinox.launcher":                             "org.eclipse.platform",
	"org.eclipse.equinox.launcher.cocoa.macosx":                "org.eclipse.platform",
	"org.eclipse.equinox.launcher.cocoa.macosx.aarch64":        "org.eclipse.platform",
	"org.eclipse.equinox.launcher.cocoa.macosx.x86_64":         "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.aix.ppc":                 "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.aix.ppc64":               "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.hpux.ia64":               "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.aarch64":           "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.ppc":               "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.ppc64":             "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.ppc64le":           "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.s390":              "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.s390x":             "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.x86":               "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.linux.x86_64":            "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.solaris.sparcv9":         "org.eclipse.platform",
	"org.eclipse.equinox.launcher.gtk.solaris.x86_64":          "org.eclipse.platform",
	"org.eclipse.equinox.launcher.win32.win32.x86":             "org.eclipse.platform",
	"org.eclipse.equinox.launcher.win32.win32.x86_64":          "org.eclipse.platform",
	"org.eclipse.equinox.log.stream":                           "org.eclipse.platform",
	"org.eclipse.equinox.metatype":                             "org.eclipse.platform",
	"org.eclipse.equinox.p2.artifact.repository":               "org.eclipse.platform",
	"org.eclipse.equinox.p2.console":                           "org.eclipse.platform",
	"org.eclipse.equinox.p2.core":                              "org.eclipse.platform",
	"org.eclipse.equinox.p2.director":                          "org.eclipse.platform",
	"org.eclipse.equinox.p2.director.app":                      "org.eclipse.platform",
	"org.eclipse.equinox.p2.directorywatcher":                  "org.eclipse.platform",
	"org.eclipse.equinox.p2.discovery":                         "org.eclipse.platform",
	"org.eclipse.equinox.p2.discovery.compatibility":           "org.eclipse.platform",
	"org.eclipse.equinox.p2.engine":                            "org.eclipse.platform",
	"org.eclipse.equinox.p2.extensionlocation":                 "org.eclipse.platform",
	"org.eclipse.equinox.p2.garbagecollector":                  "org.eclipse.platform",
	"org.eclipse.equinox.p2.installer":                         "org.eclipse.platform",
	"org.eclipse.equinox.p2.jarprocessor":                      "org.eclipse.platform",
	"org.eclipse.equinox.p2.metadata":                          "org.eclipse.platform",
	"org.eclipse.equinox.p2.metadata.repository":               "org.eclipse.platform",
	"org.eclipse.equinox.p2.operations":                        "org.eclipse.platform",
	"org.eclipse.equinox.p2.publisher":                         "org.eclipse.platform",
	"org.eclipse.equinox.p2.publisher.eclipse":                 "org.eclipse.platform",
	"org.eclipse.equinox.p2.reconciler.dropins":                "org.eclipse.platform",
	"org.eclipse.equinox.p2.repository":                        "org.eclipse.platform",
	"org.eclipse.equinox.p2.repository.tools":                  "org.eclipse.platform",
	"org.eclipse.equinox.p2.touchpoint.eclipse":                "org.eclipse.platform",
	"org.eclipse.equinox.p2.touchpoint.natives":                "org.eclipse.platform",
	"org.eclipse.equinox.p2.transport.ecf":                     "org.eclipse.platform",
	"org.eclipse.equinox.p2.ui":                                "org.eclipse.platform",
	"org.eclipse.equinox.p2.ui.admin":                          "org.eclipse.platform",
	"org.eclipse.equinox.p2.ui.admin.rcp":                      "org.eclipse.platform",
	"org.eclipse.equinox.p2.ui.discovery":                      "org.eclipse.platform",
	"org.eclipse.equinox.p2.ui.importexport":                   "org.eclipse.platform",
	"org.eclipse.equinox.p2.ui.sdk":                            "org.eclipse.platform",
	"org.eclipse.equinox.p2.ui.sdk.scheduler":                  "org.eclipse.platform",
	"org.eclipse.equinox.p2.updatechecker":                     "org.eclipse.platform",
	"org.eclipse.equinox.p2.updatesite":                        "org.eclipse.platform",
	"org.eclipse.equinox.preferences":                          "org.eclipse.platform",
	"org.eclipse.equinox.region":                               "org.eclipse.platform",
	"org.eclipse.equinox.registry":                             "org.eclipse.platform",
	"org.eclipse.equinox.security":                             "org.eclipse.platform",
	"org.eclipse.equinox.security.linux":                       "org.eclipse.platform",
	"org.eclipse.equinox.security.linux.x86_64":                "org.eclipse.platform",
	"org.eclipse.equinox.security.macosx":                      "org.eclipse.platform",
	"org.eclipse.equinox.security.ui":                          "org.eclipse.platform",
	"org.eclipse.equinox.security.win32.x86":                   "org.eclipse.platform",
	"org.eclipse.equinox.security.win32.x86_64":                "org.eclipse.platform",
	"org.eclipse.equinox.servletbridge":                        "org.eclipse.platform",
	"org.eclipse.equinox.simpleconfigurator":                   "org.eclipse.platform",
	"org.eclipse.equinox.simpleconfigurator.manipulator":       "org.eclipse.platform",
	"org.eclipse.equinox.supplement":                           "org.eclipse.platform",
	"org.eclipse.equinox.transforms.hook":                      "org.eclipse.platform",
	"org.eclipse.equinox.transforms.xslt":                      "org.eclipse.platform",
	"org.eclipse.equinox.useradmin":                            "org.eclipse.platform",
	"org.eclipse.equinox.util":                                 "org.eclipse.platform",
	"org.eclipse.equinox.weaving.caching":                      "org.eclipse.platform",
	"org.eclipse.equinox.weaving.caching.j9":                   "org.eclipse.platform",
	"org.eclipse.equinox.weaving.hook":                         "org.eclipse.platform",
	"org.eclipse.equinox.wireadmin":                            "org.eclipse.platform",
	"org.eclipse.help":                                         "org.eclipse.platform",
	"org.eclipse.help.base":                                    "org.eclipse.platform",
	"org.eclipse.help.ui":                                      "org.eclipse.platform",
	"org.eclipse.help.webapp":                                  "org.eclipse.platform",
	"org.eclipse.jface":                                        "org.eclipse.platform",
	"org.eclipse.jface.databinding":                            "org.eclipse.platform",
	"org.eclipse.jface.examples.databinding":                   "org.eclipse.platform",
	"org.eclipse.jface.notifications":                          "org.eclipse.platform",
	"org.eclipse.jface.text":                                   "org.eclipse.platform",
	"org.eclipse.jsch.core":                                    "org.eclipse.platform",
	"org.eclipse.jsch.ui":                                      "org.eclipse.platform",
	"org.eclipse.ltk.core.refactoring":                         "org.eclipse.platform",
	"org.eclipse.ltk.ui.refactoring":                           "org.eclipse.platform",
	"org.eclipse.osgi":                                         "org.eclipse.platform",
	"org.eclipse.osgi.compatibility.plugins":                   "org.eclipse.platform",
	"org.eclipse.osgi.compatibility.state":                     "org.eclipse.platform",
	"org.eclipse.osgi.services":                                "org.eclipse.platform",
	"org.eclipse.osgi.util":                                    "org.eclipse.platform",
	"org.eclipse.platform":                                     "org.eclipse.platform",
	"org.eclipse.platform.doc.isv":                             "org.eclipse.platform",
	"org.eclipse.platform.doc.user":                            "org.eclipse.platform",
	"org.eclipse.rcp":                                          "org.eclipse.platform",
	"org.eclipse.releng.tools":                                 "org.eclipse.platform",
	"org.eclipse.sdk":                                          "org.eclipse.platform",
	"org.eclipse.sdk.examples":                                 "org.eclipse.platform",
	"org.eclipse.search":                                       "org.eclipse.platform",
	"org.eclipse.swt":                                          "org.eclipse.platform",
	"org.eclipse.swt.browser.chromium.cocoa.macosx.x86_64":     "org.eclipse.platform",
	"org.eclipse.swt.browser.chromium.gtk.linux.x86_64":        "org.eclipse.platform",
	"org.eclipse.swt.browser.chromium.win32.win32.x86_64":      "org.eclipse.platform",
	"org.eclipse.swt.cocoa.macosx.aarch64":                     "org.eclipse.platform",
	"org.eclipse.swt.cocoa.macosx.x86_64":                      "org.eclipse.platform",
	"org.eclipse.swt.examples":                                 "org.eclipse.platform",
	"org.eclipse.swt.examples.browser.demos":                   "org.eclipse.platform",
	"org.eclipse.swt.examples.launcher":                        "org.eclipse.platform",
	"org.eclipse.swt.examples.ole.win32":                       "org.eclipse.platform",
	"org.eclipse.swt.examples.views":                           "org.eclipse.platform",
	"org.eclipse.swt.gtk.aix.ppc":                              "org.eclipse.platform",
	"org.eclipse.swt.gtk.aix.ppc64":                            "org.eclipse.platform",
	"org.eclipse.swt.gtk.hpux.ia64":                            "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.aarch64":                        "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.ppc":                            "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.ppc64":                          "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.ppc64le":                        "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.s390":                           "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.s390x":                          "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.x86":                            "org.eclipse.platform",
	"org.eclipse.swt.gtk.linux.x86_64":                         "org.eclipse.platform",
	"org.eclipse.swt.gtk.solaris.sparcv9":                      "org.eclipse.platform",
	"org.eclipse.swt.gtk.solaris.x86_64":                       "org.eclipse.platform",
	"org.eclipse.swt.tools":                                    "org.eclipse.platform",
	"org.eclipse.swt.tools.base":                               "org.eclipse.platform",
	"org.eclipse.swt.tools.spies":                              "org.eclipse.platform",
	"org.eclipse.swt.win32.win32.x86":                          "org.eclipse.platform",
	"org.eclipse.swt.win32.win32.x86_64":                       "org.eclipse.platform",
	"org.eclipse.team.core":                                    "org.eclipse.platform",
	"org.eclipse.team.cvs.core":                                "org.eclipse.platform",
	"org.eclipse.team.cvs.ssh2":                                "org.eclipse.platform",
	"org.eclipse.team.cvs.ui":                                  "org.eclipse.platform",
	"org.eclipse.team.examples.filesystem":                     "org.eclipse.platform",
	"org.eclipse.team.genericeditor.diff.extension":            "org.eclipse.platform",
	"org.eclipse.team.ui":                                      "org.eclipse.platform",
	"org.eclipse.text":                                         "org.eclipse.platform",
	"org.eclipse.text.quicksearch":                             "org.eclipse.platform",
	"org.eclipse.tips.core":                                    "org.eclipse.platform",
	"org.eclipse.tips.ide":                                     "org.eclipse.platform",
	"org.eclipse.tips.json":                                    "org.eclipse.platform",
	"org.eclipse.tips.ui":                                      "org.eclipse.platform",
	"org.eclipse.tools.layout.spy":                             "org.eclipse.platform",
	"org.eclipse.ui":                                           "org.eclipse.platform",
	"org.eclipse.ui.browser":                                   "org.eclipse.platform",
	"org.eclipse.ui.cheatsheets":                               "org.eclipse.platform",
	"org.eclipse.ui.cocoa":                                     "org.eclipse.platform",
	"org.eclipse.ui.console":                                   "org.eclipse.platform",
	"org.eclipse.ui.editors":                                   "org.eclipse.platform",
	"org.eclipse.ui.examples.contributions":                    "org.eclipse.platform",
	"org.eclipse.ui.examples.fieldassist":                      "org.eclipse.platform",
	"org.eclipse.ui.examples.filesystem":                       "org.eclipse.platform",
	"org.eclipse.ui.examples.javaeditor":                       "org.eclipse.platform",
	"org.eclipse.ui.examples.multipageeditor":                  "org.eclipse.platform",
	"org.eclipse.ui.examples.propertysheet":                    "org.eclipse.platform",
	"org.eclipse.ui.examples.readmetool":                       "org.eclipse.platform",
	"org.eclipse.ui.examples.undo":                             "org.eclipse.platform",
	"org.eclipse.ui.examples.uriSchemeHandler":                 "org.eclipse.platform",
	"org.eclipse.ui.examples.views.properties.tabbed.article":  "org.eclipse.platform",
	"org.eclipse.ui.externaltools":                             "org.eclipse.platform",
	"org.eclipse.ui.forms":                                     "org.eclipse.platform",
	"org.eclipse.ui.genericeditor":                             "org.eclipse.platform",
	"org.eclipse.ui.genericeditor.examples":                    "org.eclipse.platform",
	"org.eclipse.ui.ide":                                       "org.eclipse.platform",
	"org.eclipse.ui.ide.application":                           "org.eclipse.platform",
	"org.eclipse.ui.intro":                                     "org.eclipse.platform",
	"org.eclipse.ui.intro.quicklinks":                          "org.eclipse.platform",
	"org.eclipse.ui.intro.universal":                           "org.eclipse.platform",
	"org.eclipse.ui.monitoring":                                "org.eclipse.platform",
	"org.eclipse.ui.navigator":                                 "org.eclipse.platform",
	"org.eclipse.ui.navigator.resources":                       "org.eclipse.platform",
	"org.eclipse.ui.net":                                       "org.eclipse.platform",
	"org.eclipse.ui.themes":                                    "org.eclipse.platform",
	"org.eclipse.ui.trace":                                     "org.eclipse.platform",
	"org.eclipse.ui.views":                                     "org.eclipse.platform",
	"org.eclipse.ui.views.log":                                 "org.eclipse.platform",
	"org.eclipse.ui.views.properties.tabbed":                   "org.eclipse.platform",
	"org.eclipse.ui.win32":                                     "org.eclipse.platform",
	"org.eclipse.ui.workbench":                                 "org.eclipse.platform",
	"org.eclipse.ui.workbench.texteditor":                      "org.eclipse.platform",
	"org.eclipse.update.configurator":                          "org.eclipse.platform",
	"org.eclipse.update.core":                                  "org.eclipse.platform",
	"org.eclipse.urischeme":                                    "org.eclipse.platform",
	"reactor-netty":                                            "io.projectreactor.netty",
	"reactor-netty-core":                                       "io.projectreactor.netty",
	"reactor-netty-http":                                       "io.projectreactor.netty",
	"reactor-netty-http-brave":                                 "io.projectreactor.netty",
	"reactor-netty-incubator-quic":                             "io.projectreactor.netty.incubator",
	"ratpack-base":                                             "io.ratpack",
	"ratpack-codahale-metrics":                                 "io.ratpack",
	"ratpack-config":                                           "io.ratpack",
	"ratpack-consul":                                           "io.ratpack",
	"ratpack-core":                                             "io.ratpack",
	"ratpack-dropwizard-metrics":                               "io.ratpack",
	"ratpack-exec":                                             "io.ratpack",
	"ratpack-func":                                             "io.ratpack",
	"ratpack-gradle":                                           "io.ratpack",
	"ratpack-groovy":                                           "io.ratpack",
	"ratpack-groovy-test":                                      "io.ratpack",
	"ratpack-gson":                                             "io.ratpack",
	"ratpack-guice":                                            "io.ratpack",
	"ratpack-h2":                                               "io.ratpack",
	"ratpack-handlebars":                                       "io.ratpack",
	"ratpack-hikari":                                           "io.ratpack",
	"ratpack-hystrix":                                          "io.ratpack",
	"ratpack-jackson":                                          "io.ratpack",
	"ratpack-jackson-guice":                                    "io.ratpack",
	"ratpack-jdbc-tx":                                          "io.ratpack",
	"ratpack-manual":                                           "io.ratpack",
	"ratpack-newrelic":                                         "io.ratpack",
	"ratpack-pac4j":                                            "io.ratpack",
	"ratpack-reactor":                                          "io.ratpack",
	"ratpack-remote":                                           "io.ratpack",
	"ratpack-remote-test":                                      "io.ratpack",
	"ratpack-retrofit2":                                        "io.ratpack",
	"ratpack-rocker":                                           "io.ratpack",
	"ratpack-rx":                                               "io.ratpack",
	"ratpack-rx2":                                              "io.ratpack",
	"ratpack-session":                                          "io.ratpack",
	"ratpack-session-redis":                                    "io.ratpack",
	"ratpack-session-serialization-kryo":                       "io.ratpack",
	"ratpack-spring-boot":                                      "io.ratpack",
	"ratpack-spring-boot-starter":                              "io.ratpack",
	"ratpack-test":                                             "io.ratpack",
	"ratpack-thymeleaf":                                        "io.ratpack",
	"ratpack-thymeleaf3":                                       "io.ratpack",
	"graphiql-spring-boot-autoconfigure":                       "com.graphql-java",
	"graphiql-spring-boot-starter":                             "com.graphql-java",
	"graphql-java":                                             "com.graphql-java",
	"graphql-java-annotations":                                 "com.graphql-java",
	"graphql-java-extended-scalars":                            "com.graphql-java",
	"graphql-java-extended-validation":                         "com.graphql-java",
	"graphql-java-servlet":                                     "com.graphql-java",
	"graphql-java-spring-boot-starter-webflux":                 "com.graphql-java",
	"graphql-java-spring-boot-starter-webmvc":                  "com.graphql-java",
	"graphql-java-spring-webflux":                              "com.graphql-java",
	"graphql-java-spring-webmvc":                               "com.graphql-java",
	"graphql-java-tools":                                       "com.graphql-java",
	"graphql-rxjava":                                           "com.graphql-java",
	"graphql-spring-boot-autoconfigure":                        "com.graphql-java",
	"graphql-spring-boot-starter":                              "com.graphql-java",
	"graphql-spring-boot-starter-test":                         "com.graphql-java",
	"graphql-spring-boot-test":                                 "com.graphql-java",
	"graphql-spring-boot-test-autoconfigure":                   "com.graphql-java",
	"java-dataloader":                                          "com.graphql-java",
	"voyager-spring-boot-autoconfigure":                        "com.graphql-java",
	"voyager-spring-boot-starter":                              "com.graphql-java",
	"minio":                                                    "io.minio",
	"minio-admin":                                              "io.minio",
	"minio-java":                                               "io.minio",
	"commons-jelly":                                            "commons-jelly",
	"commons-jelly-avalon":                                     "commons-jelly",
	"commons-jelly-tags-ant":                                   "commons-jelly",
	"commons-jelly-tags-antlr":                                 "commons-jelly",
	"commons-jelly-tags-avalon":                                "commons-jelly",
	"commons-jelly-tags-bean":                                  "commons-jelly",
	"commons-jelly-tags-beanshell":                             "commons-jelly",
	"commons-jelly-tags-betwixt":                               "commons-jelly",
	"commons-jelly-tags-bsf":                                   "commons-jelly",
	"commons-jelly-tags-define":                                "commons-jelly",
	"commons-jelly-tags-dynabean":                              "commons-jelly",
	"commons-jelly-tags-email":                                 "commons-jelly",
	"commons-jelly-tags-fmt":                                   "commons-jelly",
	"commons-jelly-tags-html":                                  "commons-jelly",
	"commons-jelly-tags-http":                                  "commons-jelly",
	"commons-jelly-tags-interaction":                           "commons-jelly",
	"commons-jelly-tags-jaxme":                                 "commons-jelly",
	"commons-jelly-tags-jetty":                                 "commons-jelly",
	"commons-jelly-tags-jface":                                 "commons-jelly",
	"commons-jelly-tags-jms":                                   "commons-jelly",
	"commons-jelly-tags-jmx":                                   "commons-jelly",
	"commons-jelly-tags-jsl":                                   "commons-jelly",
	"commons-jelly-tags-junit":                                 "commons-jelly",
	"commons-jelly-tags-log":                                   "commons-jelly",
	"commons-jelly-tags-ojb":                                   "commons-jelly",
	"commons-jelly-tags-quartz":                                "commons-jelly",
	"commons-jelly-tags-regexp":                                "commons-jelly",
	"commons-jelly-tags-soap":                                  "commons-jelly",
	"commons-jelly-tags-sql":                                   "commons-jelly",
	"commons-jelly-tags-swing":                                 "commons-jelly",
	"commons-jelly-tags-swt":                                   "commons-jelly",
	"commons-jelly-tags-threads":                               "commons-jelly",
	"commons-jelly-tags-util":                                  "commons-jelly",
	"commons-jelly-tags-validate":                              "commons-jelly",
	"commons-jelly-tags-velocity":                              "commons-jelly",
	"commons-jelly-tags-xml":                                   "commons-jelly",
	"commons-jelly-tags-xmlunit":                               "commons-jelly",
	"groovy":                                                   "org.codehaus.groovy",
	"groovy-all":                                               "org.codehaus.groovy",
	"groovy-all-jdk14":                                         "org.codehaus.groovy",
	"groovy-all-minimal":                                       "org.codehaus.groovy",
	"groovy-all-tests":                                         "org.codehaus.groovy",
	"groovy-ant":                                               "org.codehaus.groovy",
	"groovy-astbuilder":                                        "org.codehaus.groovy",
	"groovy-backports-compat23":                                "org.codehaus.groovy",
	"groovy-binary":                                            "org.codehaus.groovy",
	"groovy-bom":                                               "org.codehaus.groovy",
	"groovy-bsf":                                               "org.codehaus.groovy",
	"groovy-cli-commons":                                       "org.codehaus.groovy",
	"groovy-cli-picocli":                                       "org.codehaus.groovy",
	"groovy-console":                                           "org.codehaus.groovy",
	"groovy-datetime":                                          "org.codehaus.groovy",
	"groovy-dateutil":                                          "org.codehaus.groovy",
	"groovy-docgenerator":                                      "org.codehaus.groovy",
	"groovy-eclipse-batch":                                     "org.codehaus.groovy",
	"groovy-eclipse-compiler":                                  "org.codehaus.groovy",
	"groovy-groovydoc":                                         "org.codehaus.groovy",
	"groovy-groovysh":                                          "org.codehaus.groovy",
	"groovy-jaxb":                                              "org.codehaus.groovy",
	"groovy-jdk14":                                             "org.codehaus.groovy",
	"groovy-jmx":                                               "org.codehaus.groovy",
	"groovy-json":                                              "org.codehaus.groovy",
	"groovy-json-direct":                                       "org.codehaus.groovy",
	"groovy-jsr223":                                            "org.codehaus.groovy",
	"groovy-macro":                                             "org.codehaus.groovy",
	"groovy-nio":                                               "org.codehaus.groovy",
	"groovy-servlet":                                           "org.codehaus.groovy",
	"groovy-sql":                                               "org.codehaus.groovy",
	"groovy-swing":                                             "org.codehaus.groovy",
	"groovy-templates":                                         "org.codehaus.groovy",
	"groovy-test":                                              "org.codehaus.groovy",
	"groovy-test-junit5":                                       "org.codehaus.groovy",
	"groovy-testng":                                            "org.codehaus.groovy",
	"groovy-tests-vm8":                                         "org.codehaus.groovy",
	"groovy-xml":                                               "org.codehaus.groovy",
	"groovy-xmlrpc":                                            "org.codehaus.groovy",
	"groovy-yaml":                                              "org.codehaus.groovy",
}
