//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//                 Logging.cpp - Logging/output facility                    //
//                                                                          //
//   Copyright (C) 1999-2002 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "Logging.h"

extern ProgressIndicator pi;
extern Distributed *Agent;

char *
Logging::getlogfilename(char *file, char *host)
{
 static char buf[512];

 if(!pi.dlog)
 {
   return file;
 }
  else
 {
  memset(buf,0,512);
  snprintf(buf,510,"%s/%s",host,file);
  if(0!=strcmp(host,lasthname))
  {
   mkdir(host, 0770);
   strncpy(lasthname,host,510);
  }
  return buf;
 }
}

void
Logging::msg(char *file, char *out, char *hn, char *fmt, ...)
{
 va_list va;
 FILE *fp = NULL;

 if(pi.dist == 1)
  {
   char buf[4096];
   memset(buf,0,4096);
   snprintf(buf, 4096, "%s %s ", out, hn);
   va_start(va, fmt);
   vsnprintf(buf+strlen(buf), 4096-strlen(buf), fmt, va);
   va_end(va);
   strcat(buf, "\n");
   Agent->WriteToMaster(buf, strlen(buf));
   return;
  }

 if(file != NULL)
  {
   if(strcmp(file,lastfname)!=0)
    {
     fp = fopen(getlogfilename(file,hn), "a");
     if(logp != NULL)
      fclose(logp);
     logp = fp;
     strncpy(lastfname, getlogfilename(file,hn), 512);
    }
   else
   {
    fp = logp;
   }
  }

 if(fp!=NULL)
  fprintf(fp, "%s ", hn);

 if((pi.Foreground) && (out!=NULL))
  fprintf(stdout, "%s %s ", out, hn);

 va_start(va, fmt);

 if(fp!=NULL)
  vfprintf(fp, fmt, va);

 if((pi.Foreground) && (out!=NULL))
  vfprintf(stdout, fmt, va);

 va_end(va);

 if(fp!=NULL)
  fprintf(fp, "\n");

 if((pi.Foreground) && (out!=NULL))
  fprintf(stdout, "\n");

}

void
Logging::fin(void)
{
 if(logp!=NULL)
  fclose(logp);

 logp = NULL;
}

Logging::Logging()
{
 memset(lastfname, 0, 512);
 logp = NULL;
}

Logging::~Logging()
{
 if(logp!=NULL)
  fclose(logp);
}
