//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//        snmp.h - simple network management protocol scanner               //
//                                                                          //
//   Copyright (C) 1999-2001 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

//   modified version of
// ADMsnmp (c) The ADM Crew
#ifndef SNMP_H
#define SNMP_H
#include "../nsat.h"

#define SNMP_TIMEOUT 20
#define SNMP_REPEAT 2
#define SNMP_NAMES 24

const char *namelist[] =
{
  "router",
  "cisco",
  "public",
  "private",
  "local",
  "admin",
  "proxy",
  "write",
  "access",
  "root",
  "enable"
  "all private",
  "all public",
  " private",
  "test",
  "guest",
  "mygroup",
  "default",
  "secret",
  "community",
  "ascend",
  "bay",
  "read",
  ""
};

struct snmpchex
  {
    char name[16];		/* community name  */
    int id;			/* request id      */
    int ret;			/* return code     */
    u_char rw;			/* writable or not */
  };

#endif
