//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//             nsat.h - includes, definitions, prototypes                   //
//                                                                          //
//   Copyright (C) 1999-2002 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#ifndef NSAT_H
#define NSAT_H
#define VERSION "1.43"
#define PARANOID_CHECK

#define DISTRIBUTED_DEFAULT_PORT        10235
#define MAX_AGENTS                      512

#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif

using namespace std;

#include <iostream>
#include <fstream>
#include "libmix++/mix/mix.h"
#include "libmix++/mix/lmconfig.h"
#include <setjmp.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include "progress.h"
#include "Distributed.h"
#include "Logging.h"
#include "lang.h"

#ifdef DARWIN
#include <unistd.h>
#include <fcntl.h>
#include <sys/ttycom.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>
#define socklen_t int
#endif


#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN 1234
#endif
#ifndef BIG_ENDIAN
#define BIG_ENDIAN 4321
#endif

#ifndef BYTE_ORDER
#ifdef WORDS_BIGENDIAN
#define BYTE_ORDER BIG_ENDIAN
#else
#define BYTE_ORDER LITTLE_ENDIAN
#endif
#endif

#if !defined(u_char) && !defined(u_short) && !defined(u_int)
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned int u_int;
#endif

#if !defined(u_int8_t) 
typedef unsigned char u_int8_t;
#endif
#if !defined(u_int16_t) 
typedef unsigned short u_int16_t;
#endif
#if !defined(u_int32_t)
typedef unsigned int u_int32_t;
#endif

#ifdef HAVE_SYS_SIGNAL_H
#include <sys/signal.h>
#endif
#ifdef HAVE_SOLARIS
#ifdef HAVE_SYS_STREAM_H
#include <sys/stream.h>
#endif
#ifdef HAVE_SYS_DLPI_H
#include <sys/dlpi.h>
#endif
#ifdef HAVE_SYS_BUFMOD_H
#include <sys/bufmod.h>
#endif
#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>
#endif
#ifdef HAVE_SYS_STROPTS_H
#include <sys/stropts.h>
#endif
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_SYS_TERMIOS_H
#include <sys/termios.h>
#endif
#ifdef HAVE_SYS_FILIO_H
#include <sys/filio.h>
#endif
#ifdef HAVE_NET_IF_H
#include <net/if.h>
#endif
#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#endif
#endif /* defined s0l4r15 */
#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#ifdef TIME_WITH_SYS_TIME
#include <time.h>
#endif // TIME_WITH_SYS_TIME
#else // !HAVE_SYS_TIME_H
#include <time.h>
#endif
#ifndef RLIMIT_NOFILE
#define RLIMIT_NOFILE RLIMIT_OFILE
#endif


#ifdef __FD_SETSIZE
#undef __FD_SETSIZE
#endif
#ifdef FD_SETSIZE
#undef FD_SETSIZE
#endif
#define __FD_SETSIZE 8192
#define FD_SETSIZE __FD_SETSIZE

#define BUFSIZE         1024	/* to capture version info, etc. */
#define OSCOUNT          116

#if BYTE_ORDER == BIG_ENDIAN
#define ntohl(x)        (x)
#define ntohs(x)        (x)
#define htonl(x)        (x)
#define htons(x)        (x)
#endif

/* nsat prototypes */
int nread(int, int, void *, int);	// timeable read, f34r!
char *strunf(char *);		// convert line breaks to spaces
char *my_strnsubst(char *, int);	// remove single null's
void hook(int);			// timeout sighandler
void doh(int);			// critical sighandler
void ssh(int);			// interruption sighandler
int sysidle(int);		// check for active users
void sigset(void);		// preset sig actions
int safe_fork(void);		// error and stealth-checking fork
void usage(char *);		// print usage and die
void writepid(int);		// create pid file
int readpid(void);		// read and check pid file
int tsock(void);		// tcp socket
int usock(void);		// udp socket
int isock(void);		// icmp socket
void fdmax(void);
void rlmax(void);

#ifdef PARANOID_CHECK
int nicefile(char *);		// symlink check

#endif

/* mod prototypes */
int ftptest(int, char *);
int probe_bind(struct sockaddr_in, int);
void webscan(int);
void rpccheck(char *);
int sendpacket(unsigned long, int, int);
int getinput(int);
int do_logic(unsigned long int t0);
void snmpwalk(unsigned long);

#endif
