/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.MacUtility;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class FileProxy {
    private final File file;
    private final String lcname;
    private boolean checkedMacInfo;
    private String macType;
    private String macCreator;
    private byte[] contents;
    private boolean checkedImage;
    private BufferedImage image;

    public FileProxy(String string) {
        this(new File(string));
    }

    public FileProxy(String string, String string2) {
        this(new File(string, string2));
    }

    public FileProxy(File file, String string) {
        this(new File(file, string));
    }

    public FileProxy(File file) {
        this.file = file;
        this.lcname = file.getName().toLowerCase();
        this.checkedMacInfo = false;
        this.macType = null;
        this.macCreator = null;
        this.contents = null;
        this.checkedImage = false;
        this.image = null;
    }

    public boolean hasExtension(String ... stringArray) {
        for (String string : stringArray) {
            if (!(string = string.toLowerCase()).startsWith(".")) {
                string = "." + string;
            }
            if (!this.lcname.endsWith(string)) continue;
            return true;
        }
        return false;
    }

    private void checkMacInfo() {
        if (!this.checkedMacInfo) {
            this.macType = MacUtility.getType(this.file);
            this.macCreator = MacUtility.getCreator(this.file);
            this.checkedMacInfo = true;
        }
    }

    public boolean hasMacType(String string) {
        this.checkMacInfo();
        return string.equals(this.macType);
    }

    public boolean hasMacCreator(String string) {
        this.checkMacInfo();
        return string.equals(this.macCreator);
    }

    private void checkContents(int n) {
        if (this.contents == null || this.contents.length < n) {
            try {
                byte[] byArray = new byte[n];
                FileInputStream fileInputStream = new FileInputStream(this.file);
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)fileInputStream.read();
                }
                fileInputStream.close();
                this.contents = byArray;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public boolean startsWith(byte ... byArray) {
        this.checkContents(byArray.length);
        if (this.contents == null || this.contents.length < byArray.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (this.contents[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(int ... nArray) {
        this.checkContents(nArray.length);
        if (this.contents == null || this.contents.length < nArray.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.contents[i] == (byte)nArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isImage() {
        if (this.checkedImage) {
            return this.image != null;
        }
        try {
            this.image = ImageIO.read(this.file);
            this.checkedImage = true;
            return this.image != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public BufferedImage getImage() {
        if (this.checkedImage) {
            return this.image;
        }
        try {
            this.image = ImageIO.read(this.file);
            this.checkedImage = true;
            return this.image;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public File getFile() {
        return this.file;
    }
}

