/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.IDGenerator;
import com.kreative.bitsnpicas.PointSizeGenerator;
import com.kreative.bitsnpicas.geos.GEOSFontFile;
import com.kreative.bitsnpicas.geos.GEOSFontPointSize;
import com.kreative.bitsnpicas.geos.GEOSFontStrike;
import com.kreative.bitsnpicas.geos.UTF8StrikeEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class GEOSBitmapFontExporter
implements BitmapFontExporter {
    private IDGenerator idgen;
    private PointSizeGenerator sizegen;
    private boolean mega;
    private boolean kerning;
    private boolean utf8;
    private static final String VP = "[Vv][Ee][Rr]([.]|[Ss]([.]|[Ii][Oo][Nn])?)? *";

    public GEOSBitmapFontExporter(IDGenerator iDGenerator, PointSizeGenerator pointSizeGenerator) {
        this.idgen = iDGenerator;
        this.sizegen = pointSizeGenerator;
        this.mega = false;
        this.kerning = false;
        this.utf8 = false;
    }

    public GEOSBitmapFontExporter(IDGenerator iDGenerator, PointSizeGenerator pointSizeGenerator, boolean bl, boolean bl2, boolean bl3) {
        this.idgen = iDGenerator;
        this.sizegen = pointSizeGenerator;
        this.mega = bl;
        this.kerning = bl2;
        this.utf8 = bl3;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontToStream(bitmapFont, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        bitmapFont.autoFillNames();
        String string = bitmapFont.getName(1);
        int n = this.idgen.generateID(bitmapFont);
        int n2 = this.sizegen.generatePointSize(bitmapFont);
        String string2 = bitmapFont.getName(10);
        if (string2 == null || string2.length() == 0) {
            string2 = "Available in " + n2 + " point.";
        }
        GEOSFontPointSize gEOSFontPointSize = new GEOSFontPointSize(n2);
        if (this.mega) {
            gEOSFontPointSize.megaStrikes = new GEOSFontStrike[6];
            gEOSFontPointSize.megaStrikes[0] = this.createStrike(bitmapFont, 32, 0, 16, 96, false, true);
            gEOSFontPointSize.megaStrikes[1] = this.createStrike(bitmapFont, 48, 16, 16, 96, false, true);
            gEOSFontPointSize.megaStrikes[2] = this.createStrike(bitmapFont, 64, 32, 16, 96, false, true);
            gEOSFontPointSize.megaStrikes[3] = this.createStrike(bitmapFont, 80, 48, 16, 96, false, true);
            gEOSFontPointSize.megaStrikes[4] = this.createStrike(bitmapFont, 96, 64, 16, 96, false, true);
            gEOSFontPointSize.megaStrikes[5] = this.createStrike(bitmapFont, 112, 80, 16, 96, false, true);
            gEOSFontPointSize.megaStrikeIndex = this.createStrike(bitmapFont, 32, 0, 96, 96, this.utf8, false);
            gEOSFontPointSize.utf8Map = gEOSFontPointSize.megaStrikeIndex.utf8Map;
        } else {
            gEOSFontPointSize.strike = this.createStrike(bitmapFont, 32, 0, 96, 96, this.utf8, true);
            gEOSFontPointSize.utf8Map = gEOSFontPointSize.strike.utf8Map;
        }
        if (this.utf8) {
            gEOSFontPointSize.utf8Strikes = new HashMap<UTF8StrikeEntry, GEOSFontStrike>();
            int n3 = 0;
            for (int i = 128; i < 0x110000; i += 64) {
                if (GEOSBitmapFontExporter.containsAnyChars(bitmapFont, i, 64)) {
                    gEOSFontPointSize.utf8Map.set(i, n3 >> 8, n3 & 0xFF, 256);
                    gEOSFontPointSize.utf8Strikes.put(new UTF8StrikeEntry(n3 >> 8, n3 & 0xFF, 256), this.createStrike(bitmapFont, i, 0, 64, 64, false, true));
                }
                ++n3;
            }
        }
        GEOSFontFile gEOSFontFile = new GEOSFontFile();
        gEOSFontFile.setFontName(string);
        gEOSFontFile.setClassTextString(GEOSBitmapFontExporter.getClassText(bitmapFont));
        gEOSFontFile.setDescriptionString(string2);
        gEOSFontFile.setFontID(n);
        gEOSFontFile.setFontPointSize(n2, gEOSFontPointSize);
        gEOSFontFile.recalculate();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        gEOSFontFile.write(dataOutputStream);
        dataOutputStream.flush();
    }

    private GEOSFontStrike createStrike(BitmapFont bitmapFont, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        BitmapFontGlyph bitmapFontGlyph;
        int n5;
        GEOSFontStrike gEOSFontStrike = new GEOSFontStrike(n4, this.kerning, bl);
        gEOSFontStrike.height = bitmapFont.getLineAscent() + bitmapFont.getLineDescent();
        gEOSFontStrike.ascent = bitmapFont.getLineAscent() - 1;
        for (n5 = 0; n5 < n2; ++n5) {
            gEOSFontStrike.xCoord[n5 + 1] = ++gEOSFontStrike.rowWidth;
        }
        n5 = n;
        int n6 = n2;
        int n7 = 0;
        while (n7 < n3) {
            bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n5);
            if (bitmapFontGlyph != null) {
                gEOSFontStrike.rowWidth += this.getWidth(bitmapFontGlyph);
                if (this.kerning) {
                    gEOSFontStrike.offsetWidths[n6] = this.getOffsetWidth(bitmapFontGlyph);
                }
            }
            gEOSFontStrike.xCoord[n6 + 1] = gEOSFontStrike.rowWidth;
            ++n7;
            ++n6;
            ++n5;
        }
        for (n5 = n2 + n3; n5 < n4; ++n5) {
            gEOSFontStrike.xCoord[n5 + 1] = ++gEOSFontStrike.rowWidth;
        }
        gEOSFontStrike.rowWidth = (gEOSFontStrike.rowWidth + 7) / 8;
        if (bl2) {
            gEOSFontStrike.bitmap = new byte[gEOSFontStrike.rowWidth * gEOSFontStrike.height];
            n5 = n;
            n6 = n2;
            n7 = 0;
            while (n7 < n3) {
                bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n5);
                if (bitmapFontGlyph != null) {
                    byte[][] byArray = this.convertGlyph(bitmapFont, bitmapFontGlyph, gEOSFontStrike.height);
                    gEOSFontStrike.setGlyph(n6, byArray);
                }
                ++n7;
                ++n6;
                ++n5;
            }
        }
        return gEOSFontStrike;
    }

    private int getWidth(BitmapFontGlyph bitmapFontGlyph) {
        int n = bitmapFontGlyph.getCharacterWidth();
        if (this.kerning) {
            int n2 = bitmapFontGlyph.getGlyphOffset();
            int n3 = n - n2 - bitmapFontGlyph.getGlyphWidth();
            if (n2 < 0) {
                n -= n2;
            }
            if (n3 < 0) {
                n -= n3;
            }
        }
        return n;
    }

    private GEOSFontStrike.OffsetWidth getOffsetWidth(BitmapFontGlyph bitmapFontGlyph) {
        int n = bitmapFontGlyph.getCharacterWidth();
        int n2 = bitmapFontGlyph.getGlyphOffset();
        if (n2 > 0) {
            n2 = 0;
        }
        return new GEOSFontStrike.OffsetWidth(n2, n);
    }

    private byte[][] convertGlyph(BitmapFont bitmapFont, BitmapFontGlyph bitmapFontGlyph, int n) {
        int n2 = bitmapFontGlyph.getCharacterWidth();
        int n3 = -bitmapFontGlyph.getGlyphOffset();
        int n4 = bitmapFontGlyph.getGlyphAscent() - bitmapFont.getLineAscent();
        if (this.kerning) {
            int n5 = bitmapFontGlyph.getGlyphOffset();
            int n6 = n2 - n5 - bitmapFontGlyph.getGlyphWidth();
            if (n5 < 0) {
                n2 -= n5;
                n3 = 0;
            }
            if (n6 < 0) {
                n2 -= n6;
            }
        }
        byte[][] byArray = bitmapFontGlyph.getGlyph();
        byte[][] byArray2 = new byte[n][n2];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n) {
            if (n7 >= 0 && n7 < byArray.length) {
                int n9 = n3;
                int n10 = 0;
                while (n10 < n2) {
                    if (n9 >= 0 && n9 < byArray[n7].length) {
                        byArray2[n8][n10] = byArray[n7][n9];
                    }
                    ++n10;
                    ++n9;
                }
            }
            ++n8;
            ++n7;
        }
        return byArray2;
    }

    private static boolean containsAnyChars(BitmapFont bitmapFont, int n, int n2) {
        while (n2-- > 0) {
            if (!bitmapFont.containsCharacter(n++)) continue;
            return true;
        }
        return false;
    }

    private static String getClassText(BitmapFont bitmapFont) {
        String string = bitmapFont.getName(5);
        if (string == null) {
            string = "";
        } else if ((string = string.replaceAll(VP, "V").trim()).length() > 0) {
            string = " " + string;
        }
        int n = string.length();
        if (n >= 16) {
            return string.substring(n - 16);
        }
        int n2 = 16 - n;
        String string2 = bitmapFont.getName(1);
        if (string2 == null) {
            string2 = "";
        }
        while (string2.length() < n2) {
            string2 = string2 + " ";
        }
        return string2.substring(0, n2) + string;
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontToStream(bitmapFont, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

