/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.UTF8StrikeEntry;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTF8StrikeIndex
extends TreeSet<UTF8StrikeEntry> {
    private static final long serialVersionUID = 1L;

    public void read(byte[] byArray) {
        this.clear();
        int n = 0;
        while (n + 4 <= byArray.length) {
            int n2 = byArray[n + 0] & 0xFF;
            int n3 = byArray[n + 1] & 0xFF;
            int n4 = byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8;
            if (n2 == 0 && n3 == 0 && n4 == 0) break;
            this.add(new UTF8StrikeEntry(n2, n3, n4));
            n += 4;
        }
    }

    public byte[] write() {
        byte[] byArray = new byte[this.size() * 4];
        int n = 0;
        for (UTF8StrikeEntry uTF8StrikeEntry : this) {
            byArray[n + 0] = (byte)uTF8StrikeEntry.recordIndex;
            byArray[n + 1] = (byte)uTF8StrikeEntry.sectorIndex;
            byArray[n + 2] = (byte)uTF8StrikeEntry.length;
            byArray[n + 3] = (byte)(uTF8StrikeEntry.length >> 8);
            n += 4;
        }
        return byArray;
    }
}

