/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.WindingOrder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageBitmapFontImporter
implements BitmapFontImporter {
    public int matte = -1;
    public int startX = 0;
    public int startY = 0;
    public int cellWidth = 8;
    public int cellHeight = 8;
    public int ascent = 7;
    public int deltaX = 0;
    public int deltaY = 0;
    public int columnCount = 0;
    public int rowCount = 0;
    public WindingOrder order = WindingOrder.LTR_TTB;
    public boolean invert = false;
    public int threshold = 128;
    public List<Integer> encoding = null;

    public PreviewResult preview(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = this.startY;
        for (n = 0; n4 + this.cellHeight <= n3 && (this.rowCount <= 0 || n < this.rowCount); ++n) {
            n4 += this.cellHeight + this.deltaY;
        }
        int n5 = this.startX;
        for (n4 = 0; n5 + this.cellWidth <= n2 && (this.columnCount <= 0 || n4 < this.columnCount); ++n4) {
            n5 += this.cellWidth + this.deltaX;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(new Color(this.matte));
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.setColor(new Color(-2139062144, true));
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.dispose();
        PreviewResult previewResult = new PreviewResult(bufferedImage2, n * n4);
        int[] nArray = new int[this.cellHeight * this.cellWidth];
        int n6 = this.startY;
        for (int i = 0; i < n; ++i) {
            int n7 = this.startX;
            for (int j = 0; j < n4; ++j) {
                bufferedImage.getRGB(n7, n6, this.cellWidth, this.cellHeight, nArray, 0, this.cellWidth);
                int n8 = 0;
                for (int k = 0; k < this.cellHeight; ++k) {
                    int n9 = 0;
                    while (n9 < this.cellWidth) {
                        int n10 = nArray[n8] >> 24 & 0xFF;
                        int n11 = (nArray[n8] >> 16 & 0xFF) * n10 / 255;
                        int n12 = (nArray[n8] >> 8 & 0xFF) * n10 / 255;
                        int n13 = (nArray[n8] >> 0 & 0xFF) * n10 / 255;
                        int n14 = (30 * (n11 += (this.matte >> 16 & 0xFF) * (255 - n10) / 255) + 59 * (n12 += (this.matte >> 8 & 0xFF) * (255 - n10) / 255) + 11 * (n13 += (this.matte >> 0 & 0xFF) * (255 - n10) / 255)) / 100;
                        if (this.invert) {
                            n14 = 255 - n14;
                        }
                        if (this.threshold > 0) {
                            n14 = n14 < this.threshold ? 0 : 255;
                        }
                        nArray[n8] = 0xFF000000 | n14 << 16 | n14 << 8 | n14 << 0;
                        if (this.deltaX <= 0 && (n9 == 0 || n9 == this.cellWidth - 1)) {
                            int n15 = n8;
                            nArray[n15] = nArray[n15] ^ 0xFF0000;
                        } else if (this.deltaY <= 0 && (k == 0 || k == this.cellHeight - 1)) {
                            int n16 = n8;
                            nArray[n16] = nArray[n16] ^ 0xFF0000;
                        } else if (k == this.ascent) {
                            int n17 = n8;
                            nArray[n17] = nArray[n17] ^ 0xFFFF;
                        }
                        ++n9;
                        ++n8;
                    }
                }
                n8 = this.order.getIndex(n, n4, i, j);
                bufferedImage2.setRGB(n7, n6, this.cellWidth, this.cellHeight, nArray, 0, this.cellWidth);
                previewResult.points[n8] = new Point(n7, n6);
                n7 += this.cellWidth + this.deltaX;
            }
            n6 += this.cellHeight + this.deltaY;
        }
        return previewResult;
    }

    public BitmapFont importFont(BufferedImage bufferedImage) {
        int n;
        BitmapFont bitmapFont = new BitmapFont(this.ascent, this.cellHeight - this.ascent, this.ascent, this.cellHeight - this.ascent, 0, 0, 0);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = this.startY;
        for (n = 0; n4 + this.cellHeight <= n3 && (this.rowCount <= 0 || n < this.rowCount); ++n) {
            n4 += this.cellHeight + this.deltaY;
        }
        int n5 = this.startX;
        for (n4 = 0; n5 + this.cellWidth <= n2 && (this.columnCount <= 0 || n4 < this.columnCount); ++n4) {
            n5 += this.cellWidth + this.deltaX;
        }
        int[] nArray = new int[this.cellHeight * this.cellWidth];
        int n6 = this.startY;
        for (int i = 0; i < n; ++i) {
            int n7 = this.startX;
            for (int j = 0; j < n4; ++j) {
                byte[][] byArray = new byte[this.cellHeight][this.cellWidth];
                bufferedImage.getRGB(n7, n6, this.cellWidth, this.cellHeight, nArray, 0, this.cellWidth);
                int n8 = 0;
                for (int k = 0; k < this.cellHeight; ++k) {
                    int n9 = 0;
                    while (n9 < this.cellWidth) {
                        int n10 = nArray[n8] >> 24 & 0xFF;
                        int n11 = (nArray[n8] >> 16 & 0xFF) * n10 / 255;
                        int n12 = (nArray[n8] >> 8 & 0xFF) * n10 / 255;
                        int n13 = (nArray[n8] >> 0 & 0xFF) * n10 / 255;
                        int n14 = (30 * (n11 += (this.matte >> 16 & 0xFF) * (255 - n10) / 255) + 59 * (n12 += (this.matte >> 8 & 0xFF) * (255 - n10) / 255) + 11 * (n13 += (this.matte >> 0 & 0xFF) * (255 - n10) / 255)) / 100;
                        if (this.invert) {
                            n14 = 255 - n14;
                        }
                        if (this.threshold > 0) {
                            n14 = n14 < this.threshold ? 0 : 255;
                        }
                        byArray[k][n9] = (byte)(255 - n14);
                        ++n9;
                        ++n8;
                    }
                }
                n8 = this.order.getIndex(n, n4, i, j);
                BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArray, 0, this.cellWidth, this.ascent);
                if (this.encoding == null || this.encoding.isEmpty()) {
                    bitmapFont.putCharacter(983040 + n8, bitmapFontGlyph);
                } else if (n8 < this.encoding.size()) {
                    Integer n15 = this.encoding.get(n8);
                    if (n15 != null && n15 >= 0) {
                        bitmapFont.putCharacter(n15, bitmapFontGlyph);
                    }
                } else {
                    bitmapFont.putCharacter(983040 + n8 - this.encoding.size(), bitmapFontGlyph);
                }
                n7 += this.cellWidth + this.deltaX;
            }
            n6 += this.cellHeight + this.deltaY;
        }
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BitmapFont[] bitmapFontArray = this.importFont(byteArrayInputStream);
        byteArrayInputStream.close();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        BitmapFont bitmapFont = this.importFont(bufferedImage);
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BitmapFont[] bitmapFontArray = this.importFont(fileInputStream);
        fileInputStream.close();
        return bitmapFontArray;
    }

    public static final class PreviewResult {
        public final BufferedImage preview;
        public final Point[] points;

        private PreviewResult(BufferedImage bufferedImage, int n) {
            this.preview = bufferedImage;
            this.points = new Point[n];
        }
    }
}

