/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import com.kreative.bitsnpicas.mover.FONDEntry;
import com.kreative.bitsnpicas.mover.MoverFile;
import com.kreative.bitsnpicas.mover.ResourceBundle;
import com.kreative.rsrc.MacResource;
import com.kreative.rsrc.MacResourceArray;
import com.kreative.rsrc.MacResourceFile;
import com.kreative.rsrc.MacResourceProvider;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class NFNTBitmapFontImporter
implements BitmapFontImporter {
    private GlyphList encoding;
    private static final int[] MACROMAN = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 8984, 10003, 9670, 63743, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 196, 197, 199, 201, 209, 214, 220, 225, 224, 226, 228, 227, 229, 231, 233, 232, 234, 235, 237, 236, 238, 239, 241, 243, 242, 244, 246, 245, 250, 249, 251, 252, 8224, 176, 162, 163, 167, 8226, 182, 223, 174, 169, 8482, 180, 168, 8800, 198, 216, 8734, 177, 8804, 8805, 165, 181, 8706, 8721, 8719, 960, 8747, 170, 186, 937, 230, 248, 191, 161, 172, 8730, 402, 8776, 8710, 171, 187, 8230, 160, 192, 195, 213, 338, 339, 8211, 8212, 8220, 8221, 8216, 8217, 247, 9674, 255, 376, 8260, 8364, 8249, 8250, 64257, 64258, 8225, 183, 8218, 8222, 8240, 194, 202, 193, 203, 200, 205, 206, 207, 204, 211, 212, 63743, 210, 218, 219, 217, 305, 710, 732, 175, 728, 729, 730, 184, 733, 731, 711};

    public NFNTBitmapFontImporter() {
        this.encoding = null;
    }

    public NFNTBitmapFontImporter(GlyphList glyphList) {
        this.encoding = glyphList;
    }

    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        MacResourceArray macResourceArray = new MacResourceArray(byArray);
        BitmapFont[] bitmapFontArray = this.importFont((MacResourceProvider)macResourceArray);
        macResourceArray.close();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(File file) throws IOException {
        MacResourceFile macResourceFile = new MacResourceFile(file, "r", 0);
        BitmapFont[] bitmapFontArray = this.importFont((MacResourceProvider)macResourceFile);
        macResourceFile.close();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        MacResourceArray macResourceArray = new MacResourceArray(byteArrayOutputStream.toByteArray());
        BitmapFont[] bitmapFontArray = this.importFont((MacResourceProvider)macResourceArray);
        macResourceArray.close();
        return bitmapFontArray;
    }

    public BitmapFont[] importFont(MacResourceProvider macResourceProvider) throws IOException {
        ArrayList<BitmapFont> arrayList = new ArrayList<BitmapFont>();
        MoverFile moverFile = new MoverFile(macResourceProvider);
        int n = moverFile.size();
        for (int i = 0; i < n; ++i) {
            for (BitmapFont bitmapFont : this.importFont(moverFile.get(i))) {
                arrayList.add(bitmapFont);
            }
        }
        return arrayList.toArray(new BitmapFont[arrayList.size()]);
    }

    public BitmapFont[] importFont(ResourceBundle resourceBundle) throws IOException {
        ArrayList<BitmapFont> arrayList = new ArrayList<BitmapFont>();
        if (resourceBundle.fond != null) {
            HashMap<Short, byte[]> hashMap = new HashMap<Short, byte[]>();
            for (MacResource object : resourceBundle.resources) {
                if (object.type != 1313230420 && (object.type != 1179602516 || hashMap.containsKey(object.id))) continue;
                hashMap.put(object.id, object.data);
            }
            for (FONDEntry fONDEntry : resourceBundle.fond.entries) {
                if (fONDEntry.size == 0) continue;
                arrayList.add(this.importFont((byte[])hashMap.get((short)fONDEntry.id), resourceBundle.fond.id, fONDEntry.size, fONDEntry.style, resourceBundle.fond.name));
            }
        }
        return arrayList.toArray(new BitmapFont[arrayList.size()]);
    }

    private BitmapFont importFont(byte[] byArray, int n, int n2, int n3, String string) throws IOException {
        int n4;
        int n5;
        int n6;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        dataInputStream.readShort();
        int n7 = dataInputStream.readShort();
        short s = dataInputStream.readShort();
        dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        dataInputStream.readShort();
        int n8 = dataInputStream.readShort();
        int n9 = dataInputStream.readUnsignedShort();
        if (s3 > 0) {
            n9 |= s3 << 16;
        }
        short s4 = dataInputStream.readShort();
        int n10 = dataInputStream.readShort();
        short s5 = dataInputStream.readShort();
        int n11 = dataInputStream.readUnsignedShort();
        byte[][] byArray2 = new byte[n8][n11 * 2];
        for (int i = 0; i < n8; ++i) {
            dataInputStream.readFully(byArray2[i]);
        }
        short[] sArray = new short[s - n7 + 3];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = dataInputStream.readShort();
        }
        dataInputStream.skip(2 * (n9 - (5 + n11 * n8 + (s - n7 + 3))));
        byte[] byArray3 = new byte[s - n7 + 2];
        byte[] byArray4 = new byte[s - n7 + 2];
        for (int i = 0; i < byArray3.length && i < byArray4.length; ++i) {
            byArray3[i] = dataInputStream.readByte();
            byArray4[i] = dataInputStream.readByte();
        }
        dataInputStream.close();
        byteArrayInputStream.close();
        byte[][] byArray5 = new byte[n8][n11 * 16];
        for (n6 = 0; n6 < n8; ++n6) {
            int n12 = 0;
            for (n5 = 0; n5 < byArray2[n6].length && n12 < byArray5[n6].length; ++n5) {
                for (n4 = 0; n12 < byArray5[n6].length && n4 < 8; ++n12, ++n4) {
                    if ((byArray2[n6][n5] << n4 & 0x80) == 0) continue;
                    byArray5[n6][n12] = -1;
                }
            }
        }
        n6 = s4;
        n5 = n10;
        while (n6 + n5 < n2) {
            if (n6 + n5 < n2) {
                ++n6;
            }
            if (n6 + n5 >= n2) continue;
            ++n5;
        }
        while (n6 + n5 > n2) {
            if (n6 + n5 > n2) {
                --n6;
            }
            if (n6 + n5 <= n2) continue;
            --n5;
        }
        BitmapFont bitmapFont = new BitmapFont(n6, n5, s4, n10, 0, 0, s5);
        n4 = 0;
        for (int i = n7; i <= s; ++i) {
            int n13;
            int n14;
            if (byArray4[n4] != -1 && (n14 = (sArray[n4 + 1] & 0xFFFF) - (n13 = sArray[n4] & 0xFFFF)) >= 0 && n13 + n14 <= n11 * 16) {
                int n15;
                int n16;
                int n17;
                byte[][] byArray6 = new byte[n8][n14];
                for (n17 = 0; n17 < n8; ++n17) {
                    n16 = 0;
                    int n18 = n13;
                    while (n16 < n14) {
                        byArray6[n17][n16] = byArray5[n17][n18];
                        ++n16;
                        ++n18;
                    }
                }
                n17 = byArray3[n4] + s2;
                n16 = byArray4[n4] & 0xFF;
                BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArray6, n17, n16, s4);
                int n19 = n15 = this.encoding != null ? this.encoding.get(i) : MACROMAN[i];
                if (n15 >= 0) {
                    bitmapFont.putCharacter(n15, bitmapFontGlyph);
                }
            }
            ++n4;
        }
        bitmapFont.setName(1, string);
        bitmapFont.setName(2, NFNTBitmapFontImporter.fontStyleToString(n3));
        bitmapFont.setXHeight();
        bitmapFont.setCapHeight();
        return bitmapFont;
    }

    private static String fontStyleToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append(" Bold");
        }
        if ((n & 2) != 0) {
            stringBuffer.append(" Italic");
        }
        if ((n & 4) != 0) {
            stringBuffer.append(" Underline");
        }
        if ((n & 8) != 0) {
            stringBuffer.append(" Outline");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append(" Shadow");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append(" Condensed");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append(" Extended");
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString().trim() : "Normal";
    }
}

