/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class DebugWinFNT {
    public static final int CHARSET_CP1252 = 0;
    public static final int CHARSET_DEFAULT = 1;
    public static final int CHARSET_SYMBOL = 2;
    public static final int CHARSET_MAC = 77;
    public static final int CHARSET_CP932 = 128;
    public static final int CHARSET_CP949 = 129;
    public static final int CHARSET_CP1361 = 130;
    public static final int CHARSET_CP936 = 134;
    public static final int CHARSET_CP950 = 136;
    public static final int CHARSET_CP1253 = 161;
    public static final int CHARSET_CP1254 = 162;
    public static final int CHARSET_CP1258 = 163;
    public static final int CHARSET_CP1255 = 177;
    public static final int CHARSET_CP1256 = 178;
    public static final int CHARSET_CP1257 = 186;
    public static final int CHARSET_CP1251 = 204;
    public static final int CHARSET_CP874 = 222;
    public static final int CHARSET_CP1250 = 238;
    public static final int CHARSET_OEM = 255;

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            System.out.println(string);
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(string));
                DebugWinFNT.debugWinFNT(new DataInputStream(new BufferedInputStream(fileInputStream)));
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("  ERROR: " + iOException);
            }
        }
    }

    private static void debugWinFNT(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = dataInputStream.readUnsignedShort();
        if (n6 < 1 || n6 > 3) {
            throw new IOException("bad magic number: " + n6);
        }
        int n7 = Integer.reverseBytes(dataInputStream.readInt());
        if (n7 < 118) {
            throw new IOException("bad size: " + n7);
        }
        byte[] byArray = new byte[n7];
        dataInputStream.readFully(byArray, 6, n7 - 6);
        dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 6, n7 - 6));
        byte[] byArray2 = new byte[60];
        dataInputStream.readFully(byArray2);
        for (n5 = 0; n5 < 60 && byArray2[n5] != 0; ++n5) {
        }
        String string = new String(byArray2, 0, n5, "CP1252");
        int n8 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        if ((n8 & 1) != 0) {
            throw new IOException("vector fonts are not supported");
        }
        int n9 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n10 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n11 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n12 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n13 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n14 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n15 = dataInputStream.readUnsignedByte();
        int n16 = dataInputStream.readUnsignedByte();
        int n17 = dataInputStream.readUnsignedByte();
        int n18 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n19 = dataInputStream.readUnsignedByte();
        int n20 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n21 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n22 = dataInputStream.readUnsignedByte();
        int n23 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n24 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n25 = dataInputStream.readUnsignedByte();
        int n26 = dataInputStream.readUnsignedByte();
        int n27 = dataInputStream.readUnsignedByte();
        int n28 = dataInputStream.readUnsignedByte();
        int n29 = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
        int n30 = Integer.reverseBytes(dataInputStream.readInt());
        int n31 = Integer.reverseBytes(dataInputStream.readInt());
        int n32 = Integer.reverseBytes(dataInputStream.readInt());
        int n33 = Integer.reverseBytes(dataInputStream.readInt());
        int n34 = dataInputStream.readUnsignedByte();
        int n35 = n6 >= 3 ? Integer.reverseBytes(dataInputStream.readInt()) : 0;
        int n36 = n6 >= 3 ? Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF : 0;
        int n37 = n6 >= 3 ? Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF : 0;
        int n38 = n6 >= 3 ? Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF : 0;
        int n39 = n6 >= 3 ? Integer.reverseBytes(dataInputStream.readInt()) : 0;
        byte[] byArray3 = new byte[16];
        if (n6 >= 3) {
            dataInputStream.readFully(byArray3);
        }
        for (n4 = n30; n4 < n7 && byArray[n4] != 0; ++n4) {
        }
        String string2 = new String(byArray, n30, n4 - n30, "CP1252");
        for (n3 = n31; n3 < n7 && byArray[n3] != 0; ++n3) {
        }
        String string3 = new String(byArray, n31, n3 - n31, "CP1252");
        System.out.println("Magic:\t" + n6);
        System.out.println("Size:\t" + n7);
        System.out.println("Copyrt:\t" + string);
        System.out.println("Type:\t" + n8);
        System.out.println("Points:\t" + n9);
        System.out.println("VrtRes:\t" + n10);
        System.out.println("HrzRes:\t" + n11);
        System.out.println("Ascent:\t" + n12);
        System.out.println("IntLdg:\t" + n13);
        System.out.println("ExtLdg:\t" + n14);
        System.out.println("Italic:\t" + n15);
        System.out.println("Undrln:\t" + n16);
        System.out.println("Stkout:\t" + n17);
        System.out.println("Weight:\t" + n18);
        System.out.println("Charst:\t" + n19);
        System.out.println("PixWid:\t" + n20);
        System.out.println("PixHgt:\t" + n21);
        System.out.println("PchFam:\t" + n22);
        System.out.println("AvgWid:\t" + n23);
        System.out.println("MaxWid:\t" + n24);
        System.out.println("FrstCh:\t" + n25);
        System.out.println("LastCh:\t" + n26);
        System.out.println("DfltCh:\t" + n27);
        System.out.println("BrkCh:\t" + n28);
        System.out.println("WidByt:\t" + n29);
        System.out.println("Device:\t" + n30 + "\t" + string2);
        System.out.println("Face:\t" + n31 + "\t" + string3);
        System.out.println("BitPtr:\t" + n32);
        System.out.println("BitOfs:\t" + n33);
        System.out.println("Rsrvd:\t" + n34);
        System.out.println("Flags:\t" + n35);
        System.out.println("ASpace:\t" + n36);
        System.out.println("BSpace:\t" + n37);
        System.out.println("CSpace:\t" + n38);
        System.out.println("ClrPtr:\t" + n39);
        System.out.print("Rsrvd1:\t");
        for (byte by : byArray3) {
            System.out.print(by + " ");
        }
        System.out.println();
        int n40 = n26 - n25 + 2;
        int[] nArray = new int[n40];
        int[] nArray2 = new int[n40];
        int[] nArray3 = new int[n40];
        int[] nArray4 = new int[n40];
        int[] nArray5 = new int[n40];
        int[] nArray6 = new int[n40];
        if (n6 < 3) {
            for (n2 = 0; n2 < n40; ++n2) {
                nArray[n2] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                nArray2[n2] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                nArray3[n2] = n21;
            }
        } else {
            for (n2 = 0; n2 < n40; ++n2) {
                nArray[n2] = Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                nArray2[n2] = Integer.reverseBytes(dataInputStream.readInt());
                nArray3[n2] = (n35 & 0xF0) < 32 ? n21 : Short.reverseBytes(dataInputStream.readShort()) & 0xFFFF;
                if ((n35 & 0xF) < 4) continue;
                nArray4[n2] = Integer.reverseBytes(dataInputStream.readInt());
                nArray5[n2] = Integer.reverseBytes(dataInputStream.readInt());
                nArray6[n2] = Integer.reverseBytes(dataInputStream.readInt());
            }
        }
        System.out.println("CharTable:");
        for (n2 = 0; n2 < n40; ++n2) {
            System.out.println("\t" + nArray[n2] + "\t" + nArray2[n2] + "\t" + nArray3[n2] + "\t" + nArray4[n2] + "\t" + nArray5[n2] + "\t" + nArray6[n2]);
        }
        byte[][][] byArrayArray = new byte[n40][][];
        for (n = 0; n < n40; ++n) {
            byArrayArray[n] = new byte[nArray3[n]][nArray[n]];
            int n41 = nArray2[n];
            int n42 = 0;
            while (n42 < nArray3[n]) {
                int n43 = n41;
                int n44 = 0;
                while (n44 < nArray[n]) {
                    for (int i = 128; n44 < nArray[n] && i != 0; ++n44, i >>= 1) {
                        if ((byArray[n43] & i) == 0) continue;
                        byArrayArray[n][n42][n44] = -1;
                    }
                    n43 += nArray3[n];
                }
                ++n42;
                ++n41;
            }
        }
        System.out.println("Bitmaps:");
        for (n = 0; n < n40; ++n) {
            System.out.println("\t" + n + ":");
            for (byte[] byArray4 : byArrayArray[n]) {
                System.out.print("\t\t");
                for (byte by : byArray4) {
                    System.out.print(by == 0 ? "." : "#");
                }
                System.out.println();
            }
        }
    }
}

