/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.u8m;

import com.kreative.bitsnpicas.u8m.U8MGlyph;
import com.kreative.bitsnpicas.u8m.U8MGlyphTable;
import com.kreative.bitsnpicas.u8m.U8MMapData;
import com.kreative.bitsnpicas.u8m.U8MMapTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class U8MFile {
    public static final int MAGIC_NUMBER = 1429745485;
    public String familyName;
    public int familyID;
    public int style;
    public int pointSize;
    public int glyphTableLocation;
    public int glyphTableSize;
    public int mapTableLocation;
    public int mapTableSize;
    public final int[] nativeMapIndex = new int[4];
    public final int[] lowBMPMapIndex = new int[32];
    public final int[] highBMPMapIndex = new int[16];
    public final int[] astralMapIndex = new int[6];
    public int lineAscent;
    public int lineDescent;
    public int lineGap;
    public int lineHeight;
    public final U8MMapTable maps = new U8MMapTable();
    public final U8MGlyphTable glyphs = new U8MGlyphTable();

    public int createMap() {
        int n = this.maps.size();
        this.maps.add(new U8MMapData());
        return n;
    }

    public int createGlyph() {
        int n = this.glyphs.size();
        this.glyphs.add(new U8MGlyph());
        return n;
    }

    public int getNativeGlyphIndex(int n) {
        if (n < 0 || n > 255) {
            return 0;
        }
        int n2 = this.nativeMapIndex[n >> 6];
        if (n2 == 0) {
            return 0;
        }
        return ((U8MMapData)this.maps.get(n2)).mapGet(n & 0x3F);
    }

    public int getLowBMPGlyphIndex(int n) {
        if (n < 0 || n > 2047) {
            return 0;
        }
        int n2 = this.lowBMPMapIndex[n >> 6];
        if (n2 == 0) {
            return 0;
        }
        return ((U8MMapData)this.maps.get(n2)).mapGet(n & 0x3F);
    }

    public int getHighBMPGlyphIndex(int n) {
        if (n < 0 || n > 65535) {
            return 0;
        }
        int n2 = this.highBMPMapIndex[n >> 12];
        if (n2 == 0) {
            return 0;
        }
        if ((n2 = ((U8MMapData)this.maps.get(n2)).mapGet(n >> 6 & 0x3F)) == 0) {
            return 0;
        }
        return ((U8MMapData)this.maps.get(n2)).mapGet(n & 0x3F);
    }

    public int getAstralGlyphIndex(int n) {
        if (n < 0 || n > 0x17FFFF) {
            return 0;
        }
        int n2 = this.astralMapIndex[n >> 18];
        if (n2 == 0) {
            return 0;
        }
        if ((n2 = ((U8MMapData)this.maps.get(n2)).mapGet(n >> 12 & 0x3F)) == 0) {
            return 0;
        }
        if ((n2 = ((U8MMapData)this.maps.get(n2)).mapGet(n >> 6 & 0x3F)) == 0) {
            return 0;
        }
        return ((U8MMapData)this.maps.get(n2)).mapGet(n & 0x3F);
    }

    public int getUnicodeGlyphIndex(int n) {
        int n2 = this.getLowBMPGlyphIndex(n);
        if (n2 != 0) {
            return n2;
        }
        n2 = this.getHighBMPGlyphIndex(n);
        if (n2 != 0) {
            return n2;
        }
        return this.getAstralGlyphIndex(n);
    }

    public void setNativeGlyphIndex(int n, int n2) {
        if (n < 0 || n > 255) {
            return;
        }
        int n3 = this.nativeMapIndex[n >> 6];
        if (n3 == 0) {
            this.nativeMapIndex[n >> 6] = n3 = this.createMap();
        }
        ((U8MMapData)this.maps.get(n3)).mapPut(n & 0x3F, n2);
    }

    public void setLowBMPGlyphIndex(int n, int n2) {
        if (n < 0 || n > 2047) {
            return;
        }
        int n3 = this.lowBMPMapIndex[n >> 6];
        if (n3 == 0) {
            this.lowBMPMapIndex[n >> 6] = n3 = this.createMap();
        }
        ((U8MMapData)this.maps.get(n3)).mapPut(n & 0x3F, n2);
    }

    public void setHighBMPGlyphIndex(int n, int n2) {
        U8MMapData u8MMapData;
        if (n < 0 || n > 65535) {
            return;
        }
        int n3 = this.highBMPMapIndex[n >> 12];
        if (n3 == 0) {
            this.highBMPMapIndex[n >> 12] = n3 = this.createMap();
        }
        if ((n3 = (u8MMapData = (U8MMapData)this.maps.get(n3)).mapGet(n >> 6 & 0x3F)) == 0) {
            n3 = this.createMap();
            u8MMapData.mapPut(n >> 6 & 0x3F, n3);
        }
        ((U8MMapData)this.maps.get(n3)).mapPut(n & 0x3F, n2);
    }

    public void setAstralGlyphIndex(int n, int n2) {
        U8MMapData u8MMapData;
        if (n < 0 || n > 0x17FFFF) {
            return;
        }
        int n3 = this.astralMapIndex[n >> 18];
        if (n3 == 0) {
            this.astralMapIndex[n >> 18] = n3 = this.createMap();
        }
        if ((n3 = (u8MMapData = (U8MMapData)this.maps.get(n3)).mapGet(n >> 12 & 0x3F)) == 0) {
            n3 = this.createMap();
            u8MMapData.mapPut(n >> 12 & 0x3F, n3);
        }
        if ((n3 = (u8MMapData = (U8MMapData)this.maps.get(n3)).mapGet(n >> 6 & 0x3F)) == 0) {
            n3 = this.createMap();
            u8MMapData.mapPut(n >> 6 & 0x3F, n3);
        }
        ((U8MMapData)this.maps.get(n3)).mapPut(n & 0x3F, n2);
    }

    public void setUnicodeGlyphIndex(int n, int n2) {
        if (n >= 65536) {
            this.setAstralGlyphIndex(n, n2);
        } else if (n >= 2048) {
            this.setHighBMPGlyphIndex(n, n2);
        } else {
            this.setLowBMPGlyphIndex(n, n2);
        }
    }

    public int setLocations(int n) {
        if (((n += 256) & 0xFF) != 0) {
            n = (n | 0xFF) + 1;
        }
        this.mapTableLocation = n;
        this.mapTableSize = this.maps.size();
        if (((n = this.maps.setMapLocations(n)) & 0xFF) != 0) {
            n = (n | 0xFF) + 1;
        }
        this.glyphTableLocation = n;
        this.glyphTableSize = this.glyphs.size();
        n = this.glyphs.setBitmapLocations(n);
        return n;
    }

    public void readHeader(DataInput dataInput) throws IOException {
        int n;
        if (dataInput.readInt() != 1429745485) {
            throw new IOException("bad magic");
        }
        int n2 = dataInput.readUnsignedByte();
        byte[] byArray = new byte[118];
        dataInput.readFully(byArray);
        if (dataInput.readByte() != 0) {
            throw new IOException("bad name terminator");
        }
        this.familyName = new String(byArray, 0, Math.min(n2, 118), "UTF-8");
        this.familyID = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        this.style = dataInput.readUnsignedByte();
        this.pointSize = dataInput.readUnsignedByte();
        this.glyphTableLocation = (Short.reverseBytes(dataInput.readShort()) & 0xFFFF) << 8;
        this.glyphTableSize = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        this.mapTableLocation = (Short.reverseBytes(dataInput.readShort()) & 0xFFFF) << 8;
        this.mapTableSize = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        for (n = 0; n < 4; ++n) {
            this.nativeMapIndex[n] = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        }
        for (n = 0; n < 32; ++n) {
            this.lowBMPMapIndex[n] = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        }
        for (n = 0; n < 16; ++n) {
            this.highBMPMapIndex[n] = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        }
        for (n = 0; n < 6; ++n) {
            this.astralMapIndex[n] = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        }
        this.lineAscent = dataInput.readUnsignedByte();
        this.lineDescent = dataInput.readUnsignedByte();
        this.lineGap = dataInput.readUnsignedByte();
        this.lineHeight = dataInput.readUnsignedByte();
    }

    public void writeHeader(DataOutput dataOutput) throws IOException {
        int n;
        dataOutput.writeInt(1429745485);
        if (this.familyName == null) {
            dataOutput.write(new byte[120]);
        } else {
            byte[] byArray = this.familyName.getBytes("UTF-8");
            int n2 = Math.min(byArray.length, 118);
            dataOutput.writeByte(n2);
            dataOutput.write(byArray, 0, n2);
            dataOutput.write(new byte[118 - n2]);
            dataOutput.writeByte(0);
        }
        dataOutput.writeShort(Short.reverseBytes((short)this.familyID));
        dataOutput.writeByte(this.style);
        dataOutput.writeByte(this.pointSize);
        dataOutput.writeShort(Short.reverseBytes((short)(this.glyphTableLocation >> 8)));
        dataOutput.writeShort(Short.reverseBytes((short)this.glyphTableSize));
        dataOutput.writeShort(Short.reverseBytes((short)(this.mapTableLocation >> 8)));
        dataOutput.writeShort(Short.reverseBytes((short)this.mapTableSize));
        for (n = 0; n < 4; ++n) {
            dataOutput.writeShort(Short.reverseBytes((short)this.nativeMapIndex[n]));
        }
        for (n = 0; n < 32; ++n) {
            dataOutput.writeShort(Short.reverseBytes((short)this.lowBMPMapIndex[n]));
        }
        for (n = 0; n < 16; ++n) {
            dataOutput.writeShort(Short.reverseBytes((short)this.highBMPMapIndex[n]));
        }
        for (n = 0; n < 6; ++n) {
            dataOutput.writeShort(Short.reverseBytes((short)this.astralMapIndex[n]));
        }
        dataOutput.writeByte(this.lineAscent);
        dataOutput.writeByte(this.lineDescent);
        dataOutput.writeByte(this.lineGap);
        dataOutput.writeByte(this.lineHeight);
    }

    public void read(RandomAccessFile randomAccessFile, long l) throws IOException {
        Object object2;
        this.readHeader(randomAccessFile);
        this.maps.clear();
        randomAccessFile.seek(l + (long)this.mapTableLocation);
        for (int i = 0; i < this.mapTableSize; ++i) {
            object2 = new U8MMapData();
            ((U8MMapData)object2).readHeader(randomAccessFile);
            this.maps.add(object2);
        }
        for (Object object2 : this.maps) {
            if (((U8MMapData)object2).mapLocation == 0) continue;
            randomAccessFile.seek(l + (long)((U8MMapData)object2).mapLocation);
            ((U8MMapData)object2).readData(randomAccessFile);
        }
        this.glyphs.clear();
        randomAccessFile.seek(l + (long)this.glyphTableLocation);
        for (int i = 0; i < this.glyphTableSize; ++i) {
            object2 = new U8MGlyph();
            ((U8MGlyph)object2).readGlyphRecord(randomAccessFile);
            this.glyphs.add(object2);
        }
        for (Object object2 : this.glyphs) {
            if (((U8MGlyph)object2).bitmapLocation == 0) continue;
            randomAccessFile.seek(l + (long)((U8MGlyph)object2).bitmapLocation);
            ((U8MGlyph)object2).readBitmapRecord(randomAccessFile);
        }
    }

    public void write(RandomAccessFile randomAccessFile, int n, long l) throws IOException {
        this.setLocations(n);
        this.writeHeader(randomAccessFile);
        randomAccessFile.seek(l + (long)this.mapTableLocation);
        for (Object object : this.maps) {
            ((U8MMapData)object).writeHeader(randomAccessFile);
        }
        for (Object object : this.maps) {
            if (((U8MMapData)object).mapLocation == 0) continue;
            randomAccessFile.seek(l + (long)((U8MMapData)object).mapLocation);
            ((U8MMapData)object).writeData(randomAccessFile);
        }
        randomAccessFile.seek(l + (long)this.glyphTableLocation);
        for (Object object : this.glyphs) {
            ((U8MGlyph)object).writeGlyphRecord(randomAccessFile);
        }
        for (Object object : this.glyphs) {
            if (((U8MGlyph)object).bitmapLocation == 0) continue;
            randomAccessFile.seek(l + (long)((U8MGlyph)object).bitmapLocation);
            ((U8MGlyph)object).writeBitmapRecord(randomAccessFile);
        }
    }
}

