/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.u8m;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class U8MMapEntry
implements Comparable<U8MMapEntry> {
    public int firstIndexValue;
    public int lastIndexValue;
    public int firstOutdexValue;

    public int lastOutdexValue() {
        return this.lastIndexValue - this.firstIndexValue + this.firstOutdexValue;
    }

    public boolean contains(int n) {
        return n >= this.firstIndexValue && n <= this.lastIndexValue;
    }

    public int get(int n) {
        return n - this.firstIndexValue + this.firstOutdexValue;
    }

    public int size() {
        return this.lastIndexValue - this.firstIndexValue + 1;
    }

    public void read(DataInput dataInput) throws IOException {
        this.firstIndexValue = dataInput.readUnsignedByte();
        this.lastIndexValue = dataInput.readUnsignedByte();
        this.firstOutdexValue = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.firstIndexValue);
        dataOutput.writeByte(this.lastIndexValue);
        dataOutput.writeShort(Short.reverseBytes((short)this.firstOutdexValue));
    }

    @Override
    public int compareTo(U8MMapEntry u8MMapEntry) {
        return this.firstIndexValue - u8MMapEntry.firstIndexValue;
    }

    public boolean equals(Object object) {
        if (object instanceof U8MMapEntry) {
            U8MMapEntry u8MMapEntry = (U8MMapEntry)object;
            return this.firstIndexValue == u8MMapEntry.firstIndexValue && this.lastIndexValue == u8MMapEntry.lastIndexValue && this.firstOutdexValue == u8MMapEntry.firstOutdexValue;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.firstIndexValue, this.lastIndexValue, this.firstOutdexValue});
    }
}

