/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.unicode.ttflib;

import com.kreative.unicode.ttflib.TtcFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtcFile {
    private List<TtcFont> fonts;

    public TtcFile(File file) throws IOException {
        this.read(file);
    }

    public TtcFile(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public TtcFile(byte[] byArray) throws IOException {
        this.read(byArray);
    }

    private void read(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.read(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    private void read(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[65536];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        this.read(byteArrayOutputStream.toByteArray());
    }

    private void read(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.read(dataInputStream, new HashMap<Long, byte[]>());
        dataInputStream.close();
        byteArrayInputStream.close();
    }

    private void read(DataInputStream dataInputStream, Map<Long, byte[]> map) throws IOException {
        this.fonts = new ArrayList<TtcFont>();
        dataInputStream.readInt();
        dataInputStream.readInt();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            TtcFont ttcFont = new TtcFont();
            ttcFont.readHead(dataInputStream);
            this.fonts.add(ttcFont);
        }
        for (TtcFont ttcFont : this.fonts) {
            ttcFont.readBody(dataInputStream, map);
        }
        this.fonts = Collections.unmodifiableList(this.fonts);
    }

    public List<TtcFont> getFonts() {
        return this.fonts;
    }
}

