{
"/*\n"
"    Dot Mask\n"
"    Authors: cgwg, Timothy Lottes\n"
"    License: GPL\n"
"    \n"
"    Note: This shader is just the dotmask functions from cgwg's CRT shader and crt-lottes.\n"
"*/\n"
"\n"
"// Parameter lines go here:\n"
"#pragma parameter shadowMask \"Mask Style\" 4.0 0.0 4.0 1.0\n"
"#pragma parameter DOTMASK_STRENGTH \"CGWG Dot Mask Strength\" 0.2 0.0 1.0 0.01\n"
"#pragma parameter maskDark \"Lottes maskDark\" 0.7 0.0 2.0 0.1\n"
"#pragma parameter maskLight \"Lottes maskLight\" 1.2 0.0 2.0 0.1\n"
"\n"
"#if defined(VERTEX)\n"
"\n"
"   #if __VERSION__ >= 130\n"
"      #define COMPAT_VARYING out\n"
"      #define COMPAT_ATTRIBUTE in\n"
"      #define COMPAT_TEXTURE texture\n"
"   #else\n"
"      #define COMPAT_VARYING varying\n"
"      #define COMPAT_ATTRIBUTE attribute\n"
"      #define COMPAT_TEXTURE texture2D\n"
"   #endif\n"
"\n"
"   #ifdef GL_ES\n"
"      #define COMPAT_PRECISION mediump\n"
"   #else\n"
"      #define COMPAT_PRECISION\n"
"   #endif\n"
"\n"
"COMPAT_ATTRIBUTE vec4 VertexCoord;\n"
"COMPAT_ATTRIBUTE vec4 COLOR;\n"
"COMPAT_ATTRIBUTE vec4 TexCoord;\n"
"COMPAT_VARYING vec4 COL0;\n"
"COMPAT_VARYING vec4 TEX0;\n"
"\n"
"uniform mat4 MVPMatrix;\n"
"uniform COMPAT_PRECISION int FrameDirection;\n"
"uniform COMPAT_PRECISION int FrameCount;\n"
"uniform COMPAT_PRECISION vec2 OutputSize;\n"
"uniform COMPAT_PRECISION vec2 TextureSize;\n"
"uniform COMPAT_PRECISION vec2 InputSize;\n"
"\n"
"// vertex compatibility #defines\n"
"#define vTexCoord TEX0.xy\n"
"#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize\n"
"#define outsize vec4(OutputSize, 1.0 / OutputSize)\n"
"\n"
"void main()\n"
"{\n"
"      gl_Position = MVPMatrix * VertexCoord;\n"
"      COL0 = COLOR;\n"
"      TEX0.xy = TexCoord.xy;\n"
"}\n"
"\n"
"#elif defined(FRAGMENT)\n"
"\n"
"   #if __VERSION__ >= 130\n"
"      #define COMPAT_VARYING in\n"
"      #define COMPAT_TEXTURE texture\n"
"      out vec4 FragColor;\n"
"   #else\n"
"      #define COMPAT_VARYING varying\n"
"      #define FragColor gl_FragColor\n"
"      #define COMPAT_TEXTURE texture2D\n"
"   #endif\n"
"\n"
"   #ifdef GL_ES\n"
"      #ifdef GL_FRAGMENT_PRECISION_HIGH\n"
"         precision highp float;\n"
"      #else\n"
"         precision mediump float;\n"
"      #endif\n"
"      \n"
"      #define COMPAT_PRECISION mediump\n"
"   #else\n"
"      #define COMPAT_PRECISION\n"
"   #endif\n"
"\n"
"uniform COMPAT_PRECISION int FrameDirection;\n"
"uniform COMPAT_PRECISION int FrameCount;\n"
"uniform COMPAT_PRECISION vec2 OutputSize;\n"
"uniform COMPAT_PRECISION vec2 TextureSize;\n"
"uniform COMPAT_PRECISION vec2 InputSize;\n"
"uniform sampler2D Texture;\n"
"COMPAT_VARYING vec4 TEX0;\n"
"\n"
"// fragment compatibility #defines\n"
"#define Source Texture\n"
"#define vTexCoord TEX0.xy\n"
"#define SourceSize vec4(TextureSize, 1.0 / TextureSize) //either TextureSize or InputSize\n"
"#define outsize vec4(OutputSize, 1.0 / OutputSize)\n"
"\n"
"#ifdef PARAMETER_UNIFORM\n"
"// All parameter floats need to have COMPAT_PRECISION in front of them\n"
"uniform COMPAT_PRECISION float shadowMask;\n"
"uniform COMPAT_PRECISION float DOTMASK_STRENGTH;\n"
"uniform COMPAT_PRECISION float maskDark;\n"
"uniform COMPAT_PRECISION float maskLight;\n"
"#else\n"
"#define shadowMask 3.0\n"
"#define DOTMASK_STRENGTH 0.3\n"
"#define maskDark 0.5\n"
"#define maskLight 1.5\n"
"#endif\n"
"\n"
"#define mod_factor vTexCoord.x * SourceSize.x * outsize.x / SourceSize.x\n"
"\n"
"// Shadow mask.\n"
"vec3 Mask(vec2 pos)\n"
"{\n"
"   vec3 mask = vec3(maskDark, maskDark, maskDark);\n"
"   \n"
"   // Very compressed TV style shadow mask.\n"
"   if (shadowMask == 1.0)\n"
"   {\n"
"      float line = maskLight;\n"
"      float odd  = 0.0;\n"
"\n"
"      if (fract(pos.x/6.0) < 0.5)\n"
"         odd = 1.0;\n"
"      if (fract((pos.y + odd)/2.0) < 0.5)\n"
"         line = maskDark;\n"
"\n"
"      pos.x = fract(pos.x/3.0);\n"
"    \n"
"      if      (pos.x < 0.333) mask.r = maskLight;\n"
"      else if (pos.x < 0.666) mask.g = maskLight;\n"
"      else                    mask.b = maskLight;\n"
"      mask*=line;  \n"
"   } \n"
"\n"
"   // Aperture-grille.\n"
"   else if (shadowMask == 2.0)\n"
"   {\n"
"      pos.x = fract(pos.x/3.0);\n"
"\n"
"      if      (pos.x < 0.333) mask.r = maskLight;\n"
"      else if (pos.x < 0.666) mask.g = maskLight;\n"
"      else                    mask.b = maskLight;\n"
"   } \n"
"\n"
"   // Stretched VGA style shadow mask (same as prior shaders).\n"
"   else if (shadowMask == 3.0)\n"
"   {\n"
"      pos.x += pos.y*3.0;\n"
"      pos.x  = fract(pos.x/6.0);\n"
"\n"
"      if      (pos.x < 0.333) mask.r = maskLight;\n"
"      else if (pos.x < 0.666) mask.g = maskLight;\n"
"      else                    mask.b = maskLight;\n"
"   }\n"
"\n"
"   // VGA style shadow mask.\n"
"   else if (shadowMask == 4.0)\n"
"   {\n"
"      pos.xy = floor(pos.xy*vec2(1.0, 0.5));\n"
"      pos.x += pos.y*3.0;\n"
"      pos.x  = fract(pos.x/6.0);\n"
"\n"
"      if      (pos.x < 0.333) mask.r = maskLight;\n"
"      else if (pos.x < 0.666) mask.g = maskLight;\n"
"      else                    mask.b = maskLight;\n"
"   }\n"
"\n"
"   return mask;\n"
"}\n"
"\n"
"void main()\n"
"{\n"
"   vec3 res = pow(COMPAT_TEXTURE(Source, vTexCoord).rgb, vec3(2.2,2.2,2.2));\n"
"\n"
"   float mask = 1.0 - DOTMASK_STRENGTH;\n"
"\n"
"   //cgwg's dotmask emulation:\n"
"   //Output pixels are alternately tinted green and magenta\n"
"   vec3 dotMaskWeights = mix(vec3(1.0, mask, 1.0),\n"
"                             vec3(mask, 1.0, mask),\n"
"                             floor(mod(mod_factor, 2.0)));\n"
"   if (shadowMask == 0.) \n"
"   {\n"
"      res *= dotMaskWeights;\n"
"   }\n"
"   else \n"
"   {\n"
"      res *= Mask(floor(1.000001 * gl_FragCoord.xy + vec2(0.5,0.5)));\n"
"   }\n"
"   \n"
"      FragColor = vec4(pow(res, vec3(1.0/2.2, 1.0/2.2, 1.0/2.2)), 1.0);\n"
"} \n"
"#endif\n"
},
