/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.system;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.graylog.plugins.collector.system.AutoValue_CollectorSystemConfiguration;
import org.joda.time.Period;

@JsonAutoDetect
@AutoValue
public abstract class CollectorSystemConfiguration {
    private static final Period DEFAULT_EXPIRATION_PERIOD = Period.days((int)14);
    private static final Period DEFAULT_INACTIVE_THRESHOLD = Period.minutes((int)1);
    private static final Period DEFAULT_UPDATE_INTERVAL = Period.seconds((int)30);
    private static final boolean DEFAULT_SEND_STATUS = true;
    private static final boolean DEFAULT_CONFIG_OVERRIDE = false;

    @JsonProperty(value="collector_expiration_threshold")
    public abstract Period collectorExpirationThreshold();

    @JsonProperty(value="collector_inactive_threshold")
    public abstract Period collectorInactiveThreshold();

    @JsonProperty(value="collector_update_interval")
    public abstract Period collectorUpdateInterval();

    @JsonProperty(value="collector_send_status")
    public abstract boolean collectorSendStatus();

    @JsonProperty(value="collector_configuration_override")
    public abstract boolean collectorConfigurationOverride();

    @JsonCreator
    public static CollectorSystemConfiguration create(@JsonProperty(value="collector_expiration_threshold") Period expirationThreshold, @JsonProperty(value="collector_inactive_threshold") Period inactiveThreshold, @JsonProperty(value="collector_update_interval") @Nullable Period updateInterval, @JsonProperty(value="collector_send_status") @Nullable Boolean sendStatus, @JsonProperty(value="collector_configuration_override") @Nullable Boolean configurationOverride) {
        return CollectorSystemConfiguration.builder().collectorExpirationThreshold(expirationThreshold).collectorInactiveThreshold(inactiveThreshold).collectorUpdateInterval((Period)MoreObjects.firstNonNull((Object)updateInterval, (Object)DEFAULT_UPDATE_INTERVAL)).collectorSendStatus((Boolean)MoreObjects.firstNonNull((Object)sendStatus, (Object)true)).collectorConfigurationOverride((Boolean)MoreObjects.firstNonNull((Object)configurationOverride, (Object)false)).build();
    }

    public static CollectorSystemConfiguration defaultConfiguration() {
        return CollectorSystemConfiguration.builder().collectorExpirationThreshold(DEFAULT_EXPIRATION_PERIOD).collectorInactiveThreshold(DEFAULT_INACTIVE_THRESHOLD).collectorUpdateInterval(DEFAULT_UPDATE_INTERVAL).collectorSendStatus(true).collectorConfigurationOverride(false).build();
    }

    public static Builder builder() {
        return new AutoValue_CollectorSystemConfiguration.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder collectorExpirationThreshold(Period var1);

        public abstract Builder collectorInactiveThreshold(Period var1);

        public abstract Builder collectorUpdateInterval(Period var1);

        public abstract Builder collectorSendStatus(boolean var1);

        public abstract Builder collectorConfigurationOverride(boolean var1);

        public abstract CollectorSystemConfiguration build();
    }
}

