/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import io.searchbox.params.SearchType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Search
extends AbstractAction<SearchResult> {
    private String query;
    private List<Sort> sortList = new LinkedList<Sort>();
    protected List<String> includePatternList = new ArrayList<String>();
    protected List<String> excludePatternList = new ArrayList<String>();

    protected Search(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.sortList = builder.sortList;
        this.includePatternList = builder.includePatternList;
        this.excludePatternList = builder.excludePatternList;
        this.setURI(this.buildURI());
    }

    protected Search(TemplateBuilder templatedBuilder) {
        super(templatedBuilder);
        this.query = templatedBuilder.query;
        this.sortList = templatedBuilder.sortList;
        this.includePatternList = templatedBuilder.includePatternList;
        this.excludePatternList = templatedBuilder.excludePatternList;
        this.setURI(this.buildURI() + "/template");
    }

    @Override
    public SearchResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, ObjectMapper objectMapper) throws IOException {
        return this.createNewElasticSearchResult(new SearchResult(objectMapper), responseBody, statusCode, reasonPhrase, objectMapper);
    }

    public String getIndex() {
        return this.indexName;
    }

    public String getType() {
        return this.typeName;
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_search";
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(ObjectMapper objectMapper) throws IOException {
        String data;
        if (this.sortList.isEmpty() && this.includePatternList.isEmpty() && this.excludePatternList.isEmpty()) {
            data = this.query;
        } else {
            ObjectNode queryObject = (ObjectNode)objectMapper.readTree(this.query);
            if (queryObject == null) {
                queryObject = objectMapper.createObjectNode();
            }
            if (!this.sortList.isEmpty()) {
                ArrayNode sortArray = Search.normalizeSortClause(queryObject, objectMapper);
                for (Sort sort : this.sortList) {
                    sortArray.add(sort.toJsonObject(objectMapper));
                }
            }
            if (!this.includePatternList.isEmpty() || !this.excludePatternList.isEmpty()) {
                ObjectNode sourceObject = Search.normalizeSourceClause(queryObject, objectMapper);
                Search.addPatternListToSource(sourceObject, "include", this.includePatternList, objectMapper);
                Search.addPatternListToSource(sourceObject, "exclude", this.excludePatternList, objectMapper);
            }
            data = objectMapper.writeValueAsString((Object)queryObject);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayNode normalizeSortClause(ObjectNode queryObject, ObjectMapper objectMapper) {
        ArrayNode sortArray;
        if (queryObject.has("sort")) {
            JsonNode sortElement = queryObject.get("sort");
            if (sortElement.isArray()) {
                sortArray = (ArrayNode)sortElement;
            } else if (sortElement.isObject()) {
                sortArray = objectMapper.createArrayNode();
                sortArray.add(sortElement);
            } else {
                if (!sortElement.isTextual()) throw new IllegalArgumentException("_source must be an array, an object or a string");
                String sortField = sortElement.asText();
                sortArray = objectMapper.createArrayNode();
                queryObject.set("sort", (JsonNode)sortArray);
                String order = "_score".equals(sortField) ? "desc" : "asc";
                ObjectNode sortOrder = objectMapper.createObjectNode();
                sortOrder.set("order", (JsonNode)new TextNode(order));
                ObjectNode sortDefinition = objectMapper.createObjectNode();
                sortDefinition.set(sortField, (JsonNode)sortOrder);
                sortArray.add((JsonNode)sortDefinition);
            }
        } else {
            sortArray = objectMapper.createArrayNode();
        }
        queryObject.set("sort", (JsonNode)sortArray);
        return sortArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ObjectNode normalizeSourceClause(ObjectNode queryObject, ObjectMapper objectMapper) {
        ObjectNode sourceObject;
        if (queryObject.has("_source")) {
            JsonNode sourceElement = queryObject.get("_source");
            if (sourceElement.isObject()) {
                sourceObject = (ObjectNode)sourceElement;
            } else if (sourceElement.isArray()) {
                sourceObject = objectMapper.createObjectNode();
                queryObject.set("_source", (JsonNode)sourceObject);
                sourceObject.set("include", sourceElement);
            } else {
                if (!sourceElement.isBoolean()) throw new IllegalArgumentException("_source must be an object, an array or a boolean");
                sourceObject = objectMapper.createObjectNode();
            }
        } else {
            sourceObject = objectMapper.createObjectNode();
        }
        queryObject.set("_source", (JsonNode)sourceObject);
        return sourceObject;
    }

    private static void addPatternListToSource(ObjectNode sourceObject, String rule, List<String> patternList, ObjectMapper objectMapper) {
        if (!patternList.isEmpty()) {
            ArrayNode ruleArray;
            if (sourceObject.has(rule)) {
                ruleArray = (ArrayNode)sourceObject.get(rule);
            } else {
                ruleArray = objectMapper.createArrayNode();
                sourceObject.set(rule, (JsonNode)ruleArray);
            }
            for (String pattern : patternList) {
                ruleArray.add(pattern);
            }
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query, this.sortList, this.includePatternList, this.excludePatternList);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Search rhs = (Search)obj;
        return super.equals(obj) && Objects.equals(this.query, rhs.query) && Objects.equals(this.sortList, rhs.sortList) && Objects.equals(this.includePatternList, rhs.includePatternList) && Objects.equals(this.excludePatternList, rhs.excludePatternList);
    }

    public static class TemplateBuilder
    extends Builder {
        public TemplateBuilder(String templatedQuery) {
            super(templatedQuery);
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }

    public static class VersionBuilder
    extends Builder {
        public VersionBuilder(String query) {
            super(query);
            this.setParameter("version", "true");
        }
    }

    public static class Builder
    extends AbstractMultiTypeActionBuilder<Search, Builder> {
        protected String query;
        protected List<Sort> sortList = new LinkedList<Sort>();
        protected List<String> includePatternList = new ArrayList<String>();
        protected List<String> excludePatternList = new ArrayList<String>();

        public Builder(String query) {
            this.query = query;
        }

        public Builder setSearchType(SearchType searchType) {
            return (Builder)this.setParameter("search_type", (Object)searchType);
        }

        public Builder addSort(Sort sort) {
            this.sortList.add(sort);
            return this;
        }

        public Builder addSourceExcludePattern(String excludePattern) {
            this.excludePatternList.add(excludePattern);
            return this;
        }

        public Builder addSourceIncludePattern(String includePattern) {
            this.includePatternList.add(includePattern);
            return this;
        }

        public Builder addSort(Collection<Sort> sorts) {
            this.sortList.addAll(sorts);
            return this;
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }
}

