/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.BucketAggregation;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class HistogramAggregation
extends BucketAggregation {
    public static final String TYPE = "histogram";
    private List<Histogram> histograms = new LinkedList<Histogram>();

    public HistogramAggregation(String name, JsonNode histogramAggregation) {
        super(name, histogramAggregation);
        if (histogramAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && histogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isArray()) {
            this.parseBuckets(histogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)));
        }
    }

    private void parseBuckets(JsonNode bucketsSource) {
        for (JsonNode bucket : bucketsSource) {
            Histogram histogram = new Histogram(bucket, bucket.get(String.valueOf((Object)AggregationField.KEY)).asLong(), (Long)bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).asLong());
            this.histograms.add(histogram);
        }
    }

    public List<Histogram> getBuckets() {
        return this.histograms;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HistogramAggregation rhs = (HistogramAggregation)obj;
        return super.equals(obj) && Objects.equals(this.histograms, rhs.histograms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.histograms);
    }

    public static class Histogram
    extends Bucket {
        private Long key;

        Histogram(JsonNode bucket, Long key, Long count) {
            super(bucket, count);
            this.key = key;
        }

        public Long getKey() {
            return this.key;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Histogram rhs = (Histogram)obj;
            return super.equals(obj) && Objects.equals(this.key, rhs.key);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.key);
        }
    }
}

