/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.ValueSourceScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRefBuilder;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.mutable.MutableValue;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.mutable.MutableValueFloat;

public abstract class FunctionValues {
    public byte byteVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public short shortVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public float floatVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public int intVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public long longVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public double doubleVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public String strVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public boolean boolVal(int doc) {
        return this.intVal(doc) != 0;
    }

    public boolean bytesVal(int doc, BytesRefBuilder target) {
        String s = this.strVal(doc);
        if (s == null) {
            target.clear();
            return false;
        }
        target.copyChars(s);
        return true;
    }

    public Object objectVal(int doc) {
        return Float.valueOf(this.floatVal(doc));
    }

    public boolean exists(int doc) {
        return true;
    }

    public int ordVal(int doc) {
        throw new UnsupportedOperationException();
    }

    public int numOrd() {
        throw new UnsupportedOperationException();
    }

    public abstract String toString(int var1);

    public ValueFiller getValueFiller() {
        return new ValueFiller(){
            private final MutableValueFloat mval = new MutableValueFloat();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) {
                this.mval.value = FunctionValues.this.floatVal(doc);
            }
        };
    }

    public void byteVal(int doc, byte[] vals) {
        throw new UnsupportedOperationException();
    }

    public void shortVal(int doc, short[] vals) {
        throw new UnsupportedOperationException();
    }

    public void floatVal(int doc, float[] vals) {
        throw new UnsupportedOperationException();
    }

    public void intVal(int doc, int[] vals) {
        throw new UnsupportedOperationException();
    }

    public void longVal(int doc, long[] vals) {
        throw new UnsupportedOperationException();
    }

    public void doubleVal(int doc, double[] vals) {
        throw new UnsupportedOperationException();
    }

    public void strVal(int doc, String[] vals) {
        throw new UnsupportedOperationException();
    }

    public Explanation explain(int doc) {
        return Explanation.match(this.floatVal(doc), this.toString(doc), new Explanation[0]);
    }

    public ValueSourceScorer getScorer(LeafReaderContext readerContext) {
        return new ValueSourceScorer(readerContext, this){

            @Override
            public boolean matches(int doc) {
                return true;
            }
        };
    }

    public ValueSourceScorer getRangeScorer(LeafReaderContext readerContext, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        float lower = lowerVal == null ? Float.NEGATIVE_INFINITY : Float.parseFloat(lowerVal);
        float upper = upperVal == null ? Float.POSITIVE_INFINITY : Float.parseFloat(upperVal);
        final float l = lower;
        final float u = upper;
        if (includeLower && includeUpper) {
            return new ValueSourceScorer(readerContext, this){

                @Override
                public boolean matches(int doc) {
                    if (!FunctionValues.this.exists(doc)) {
                        return false;
                    }
                    float docVal = FunctionValues.this.floatVal(doc);
                    return docVal >= l && docVal <= u;
                }
            };
        }
        if (includeLower && !includeUpper) {
            return new ValueSourceScorer(readerContext, this){

                @Override
                public boolean matches(int doc) {
                    if (!FunctionValues.this.exists(doc)) {
                        return false;
                    }
                    float docVal = FunctionValues.this.floatVal(doc);
                    return docVal >= l && docVal < u;
                }
            };
        }
        if (!includeLower && includeUpper) {
            return new ValueSourceScorer(readerContext, this){

                @Override
                public boolean matches(int doc) {
                    if (!FunctionValues.this.exists(doc)) {
                        return false;
                    }
                    float docVal = FunctionValues.this.floatVal(doc);
                    return docVal > l && docVal <= u;
                }
            };
        }
        return new ValueSourceScorer(readerContext, this){

            @Override
            public boolean matches(int doc) {
                if (!FunctionValues.this.exists(doc)) {
                    return false;
                }
                float docVal = FunctionValues.this.floatVal(doc);
                return docVal > l && docVal < u;
            }
        };
    }

    public static abstract class ValueFiller {
        public abstract MutableValue getValue();

        public abstract void fillValue(int var1);
    }
}

