/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.LongToDoubleFunction;
import java.util.function.ToDoubleBiFunction;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FieldComparatorSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.LongValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.LongValuesSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.SortField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;

public abstract class DoubleValuesSource {
    public static final DoubleValuesSource SCORES = new DoubleValuesSource(){

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            assert (scores != null);
            return scores;
        }

        @Override
        public boolean needsScores() {
            return true;
        }
    };

    public abstract DoubleValues getValues(LeafReaderContext var1, DoubleValues var2) throws IOException;

    public abstract boolean needsScores();

    public SortField getSortField(boolean reverse) {
        return new DoubleValuesSortField(this, reverse);
    }

    public final LongValuesSource toLongValuesSource() {
        return new LongValuesSource(){

            @Override
            public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
                final DoubleValues in = DoubleValuesSource.this.getValues(ctx, scores);
                return new LongValues(){

                    @Override
                    public long longValue() throws IOException {
                        return (long)in.doubleValue();
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return in.advanceExact(doc);
                    }
                };
            }

            @Override
            public boolean needsScores() {
                return DoubleValuesSource.this.needsScores();
            }
        };
    }

    public static DoubleValuesSource fromField(String field, LongToDoubleFunction decoder) {
        return new FieldValuesSource(field, decoder);
    }

    public static DoubleValuesSource fromDoubleField(String field) {
        return DoubleValuesSource.fromField(field, Double::longBitsToDouble);
    }

    public static DoubleValuesSource fromFloatField(String field) {
        return DoubleValuesSource.fromField(field, v -> Float.intBitsToFloat((int)v));
    }

    public static DoubleValuesSource fromLongField(String field) {
        return DoubleValuesSource.fromField(field, v -> v);
    }

    public static DoubleValuesSource fromIntField(String field) {
        return DoubleValuesSource.fromLongField(field);
    }

    public static DoubleValuesSource constant(final double value) {
        return new DoubleValuesSource(){

            @Override
            public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
                return new DoubleValues(){

                    @Override
                    public double doubleValue() throws IOException {
                        return value;
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return true;
                    }
                };
            }

            @Override
            public boolean needsScores() {
                return false;
            }

            public String toString() {
                return "constant(" + value + ")";
            }
        };
    }

    public static DoubleValuesSource function(final DoubleValuesSource in, final DoubleUnaryOperator function) {
        return new DoubleValuesSource(){

            @Override
            public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
                final DoubleValues inputs = in.getValues(ctx, scores);
                return new DoubleValues(){

                    @Override
                    public double doubleValue() throws IOException {
                        return function.applyAsDouble(inputs.doubleValue());
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return inputs.advanceExact(doc);
                    }
                };
            }

            @Override
            public boolean needsScores() {
                return in.needsScores();
            }
        };
    }

    public static DoubleValuesSource scoringFunction(final DoubleValuesSource in, final ToDoubleBiFunction<Double, Double> function) {
        return new DoubleValuesSource(){

            @Override
            public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
                final DoubleValues inputs = in.getValues(ctx, scores);
                return new DoubleValues(){

                    @Override
                    public double doubleValue() throws IOException {
                        return function.applyAsDouble(inputs.doubleValue(), scores.doubleValue());
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return inputs.advanceExact(doc);
                    }
                };
            }

            @Override
            public boolean needsScores() {
                return true;
            }
        };
    }

    public static DoubleValues fromScorer(final Scorer scorer) {
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return scorer.score();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                assert (scorer.docID() == doc);
                return true;
            }
        };
    }

    private static DoubleValues toDoubleValues(final NumericDocValues in, final Bits matchingBits, final LongToDoubleFunction map) {
        return new DoubleValues(){
            int current = -1;

            @Override
            public double doubleValue() throws IOException {
                return map.applyAsDouble(in.get(this.current));
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.current = target;
                return matchingBits.get(target);
            }
        };
    }

    private static NumericDocValues asNumericDocValues(final DoubleValuesHolder in, Double missingValue, final DoubleToLongFunction converter) {
        final long missing = converter.applyAsLong(missingValue);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                try {
                    if (in.values.advanceExact(docID)) {
                        return converter.applyAsLong(in.values.doubleValue());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return missing;
            }
        };
    }

    private static class DoubleValuesComparatorSource
    extends FieldComparatorSource {
        private final DoubleValuesSource producer;

        public DoubleValuesComparatorSource(DoubleValuesSource producer) {
            this.producer = producer;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
            return new FieldComparator.DoubleComparator(numHits, fieldname, 0.0){
                LeafReaderContext ctx;
                DoubleValuesHolder holder;
                {
                    super(numHits, field, missingValue);
                    this.holder = new DoubleValuesHolder();
                }

                @Override
                protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                    this.ctx = context;
                    return DoubleValuesSource.asNumericDocValues(this.holder, (Double)this.missingValue, Double::doubleToLongBits);
                }

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.holder.values = producer.getValues(this.ctx, DoubleValuesSource.fromScorer(scorer));
                }
            };
        }
    }

    private static class DoubleValuesHolder {
        DoubleValues values;

        private DoubleValuesHolder() {
        }
    }

    private static class DoubleValuesSortField
    extends SortField {
        final DoubleValuesSource producer;

        public DoubleValuesSortField(DoubleValuesSource producer, boolean reverse) {
            super(producer.toString(), new DoubleValuesComparatorSource(producer), reverse);
            this.producer = producer;
        }

        @Override
        public boolean needsScores() {
            return this.producer.needsScores();
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder("<");
            buffer.append(this.getField()).append(">");
            if (this.reverse) {
                buffer.append("!");
            }
            return buffer.toString();
        }
    }

    private static class FieldValuesSource
    extends DoubleValuesSource {
        final String field;
        final LongToDoubleFunction decoder;

        private FieldValuesSource(String field, LongToDoubleFunction decoder) {
            this.field = field;
            this.decoder = decoder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldValuesSource that = (FieldValuesSource)o;
            return Objects.equals(this.field, that.field) && Objects.equals(this.decoder, that.decoder);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.decoder);
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            NumericDocValues values = DocValues.getNumeric(ctx.reader(), this.field);
            Bits matchingBits = DocValues.getDocsWithField(ctx.reader(), this.field);
            return DoubleValuesSource.toDoubleValues(values, matchingBits, this.decoder::applyAsDouble);
        }

        @Override
        public boolean needsScores() {
            return false;
        }
    }
}

