/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FilterLeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.CompiledAutomaton;

final class TermVectorFilteredLeafReader
extends FilterLeafReader {
    private final Terms filterTerms;

    TermVectorFilteredLeafReader(LeafReader baseLeafReader, Terms filterTerms) {
        super(baseLeafReader);
        this.filterTerms = filterTerms;
    }

    @Override
    public Fields fields() throws IOException {
        return new TermVectorFilteredFields(this.in.fields(), this.filterTerms);
    }

    private static final class TermVectorFilteredTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private final TermsEnum baseTermsEnum;

        TermVectorFilteredTermsEnum(TermsEnum baseTermsEnum, TermsEnum filteredTermsEnum) {
            super(filteredTermsEnum);
            this.baseTermsEnum = baseTermsEnum;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            this.moveToCurrentTerm();
            return this.baseTermsEnum.postings(reuse, flags);
        }

        void moveToCurrentTerm() throws IOException {
            BytesRef currentTerm = this.in.term();
            boolean termInBothTermsEnum = this.baseTermsEnum.seekExact(currentTerm);
            if (!termInBothTermsEnum) {
                throw new IllegalStateException("Term vector term " + currentTerm + " does not appear in full index.");
            }
        }
    }

    private static final class TermsFilteredTerms
    extends FilterLeafReader.FilterTerms {
        private final Terms filterTerms;

        TermsFilteredTerms(Terms baseTerms, Terms filterTerms) {
            super(baseTerms);
            this.filterTerms = filterTerms;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new TermVectorFilteredTermsEnum(this.in.iterator(), this.filterTerms.iterator());
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new TermVectorFilteredTermsEnum(this.in.iterator(), this.filterTerms.intersect(compiled, startTerm));
        }
    }

    private static final class TermVectorFilteredFields
    extends FilterLeafReader.FilterFields {
        private final Terms filterTerms;

        TermVectorFilteredFields(Fields baseFields, Terms filterTerms) {
            super(baseFields);
            this.filterTerms = filterTerms;
        }

        @Override
        public Terms terms(String field) throws IOException {
            return new TermsFilteredTerms(this.in.terms(field), this.filterTerms);
        }
    }
}

