/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.util;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BitUtil;

public class MortonEncoder {
    private MortonEncoder() {
    }

    public static final long encode(double latitude, double longitude) {
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        int latEnc = GeoEncodingUtils.encodeLatitude(latitude) ^ Integer.MIN_VALUE;
        int lonEnc = GeoEncodingUtils.encodeLongitude(longitude) ^ Integer.MIN_VALUE;
        return BitUtil.interleave(lonEnc, latEnc);
    }

    public static final long encodeCeil(double latitude, double longitude) {
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        int latEnc = GeoEncodingUtils.encodeLatitudeCeil(latitude) ^ Integer.MIN_VALUE;
        int lonEnc = GeoEncodingUtils.encodeLongitudeCeil(longitude) ^ Integer.MIN_VALUE;
        return BitUtil.interleave(lonEnc, latEnc);
    }

    public static final double decodeLatitude(long hash) {
        return GeoEncodingUtils.decodeLatitude((int)BitUtil.deinterleave(hash >>> 1) ^ Integer.MIN_VALUE);
    }

    public static final double decodeLongitude(long hash) {
        return GeoEncodingUtils.decodeLongitude((int)BitUtil.deinterleave(hash) ^ Integer.MIN_VALUE);
    }

    public static String geoTermToString(long term) {
        StringBuilder s = new StringBuilder(64);
        int numberOfLeadingZeros = Long.numberOfLeadingZeros(term);
        for (int i = 0; i < numberOfLeadingZeros; ++i) {
            s.append('0');
        }
        if (term != 0L) {
            s.append(Long.toBinaryString(term));
        }
        return s.toString();
    }
}

