/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.delete;

import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportDeleteIndexTemplateAction
extends TransportMasterNodeAction<DeleteIndexTemplateRequest, DeleteIndexTemplateResponse> {
    private final MetaDataIndexTemplateService indexTemplateService;

    @Inject
    public TransportDeleteIndexTemplateAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/template/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, DeleteIndexTemplateRequest::new);
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected DeleteIndexTemplateResponse newResponse() {
        return new DeleteIndexTemplateResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteIndexTemplateRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, "");
    }

    @Override
    protected void masterOperation(final DeleteIndexTemplateRequest request, ClusterState state, final ActionListener<DeleteIndexTemplateResponse> listener) {
        this.indexTemplateService.removeTemplates(new MetaDataIndexTemplateService.RemoveRequest(request.name()).masterTimeout(request.masterNodeTimeout()), new MetaDataIndexTemplateService.RemoveListener(){

            @Override
            public void onResponse(MetaDataIndexTemplateService.RemoveResponse response) {
                listener.onResponse(new DeleteIndexTemplateResponse(response.acknowledged()));
            }

            @Override
            public void onFailure(Exception e) {
                TransportDeleteIndexTemplateAction.this.logger.debug(() -> new ParameterizedMessage("failed to delete templates [{}]", (Object)request.name()), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }
}

