/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.IntArrayList;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.get.MultiGetRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;

public class MultiGetShardRequest
extends SingleShardRequest<MultiGetShardRequest> {
    private int shardId;
    private String preference;
    boolean realtime = true;
    boolean refresh;
    IntArrayList locations;
    List<MultiGetRequest.Item> items;

    public MultiGetShardRequest() {
    }

    MultiGetShardRequest(MultiGetRequest multiGetRequest, String index, int shardId) {
        super(index);
        this.shardId = shardId;
        this.locations = new IntArrayList();
        this.items = new ArrayList<MultiGetRequest.Item>();
        this.preference = multiGetRequest.preference;
        this.realtime = multiGetRequest.realtime;
        this.refresh = multiGetRequest.refresh;
    }

    @Override
    public ActionRequestValidationException validate() {
        return super.validateNonNullIndex();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiGetShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public MultiGetShardRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetShardRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    void add(int location, MultiGetRequest.Item item) {
        this.locations.add(location);
        this.items.add(item);
    }

    @Override
    public String[] indices() {
        String[] indices = new String[this.items.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.items.get(i).index();
        }
        return indices;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.items = new ArrayList<MultiGetRequest.Item>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            this.items.add(MultiGetRequest.Item.readItem(in));
        }
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.realtime = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            this.items.get(i).writeTo(out);
        }
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        out.writeBoolean(this.realtime);
    }
}

