/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class CoordinateCollection<E extends CoordinateCollection<E>>
extends ShapeBuilder {
    protected final List<Coordinate> coordinates;

    protected CoordinateCollection(List<Coordinate> coordinates) {
        if (coordinates == null || coordinates.size() == 0) {
            throw new IllegalArgumentException("cannot create point collection with empty set of points");
        }
        this.coordinates = coordinates;
    }

    protected CoordinateCollection(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.coordinates = new ArrayList<Coordinate>(size);
        for (int i = 0; i < size; ++i) {
            this.coordinates.add(CoordinateCollection.readFromStream(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.coordinates.size());
        for (Coordinate point : this.coordinates) {
            CoordinateCollection.writeCoordinateTo(point, out);
        }
    }

    private E thisRef() {
        return (E)this;
    }

    public E coordinate(double longitude, double latitude) {
        return this.coordinate(new Coordinate(longitude, latitude));
    }

    public E coordinate(Coordinate coordinate) {
        this.coordinates.add(coordinate);
        return this.thisRef();
    }

    public E coordinates(Coordinate ... coordinates) {
        return this.coordinates(Arrays.asList(coordinates));
    }

    public E coordinates(Collection<? extends Coordinate> coordinates) {
        this.coordinates.addAll(coordinates);
        return this.thisRef();
    }

    protected Coordinate[] coordinates(boolean closed) {
        Coordinate[] result = this.coordinates.toArray(new Coordinate[this.coordinates.size() + (closed ? 1 : 0)]);
        if (closed) {
            result[result.length - 1] = result[0];
        }
        return result;
    }

    protected XContentBuilder coordinatesToXcontent(XContentBuilder builder, boolean closed) throws IOException {
        builder.startArray();
        for (Coordinate coord : this.coordinates) {
            CoordinateCollection.toXContent(builder, coord);
        }
        if (closed) {
            Coordinate start = this.coordinates.get(0);
            Coordinate end = this.coordinates.get(this.coordinates.size() - 1);
            if (start.x != end.x || start.y != end.y) {
                CoordinateCollection.toXContent(builder, this.coordinates.get(0));
            }
        }
        builder.endArray();
        return builder;
    }
}

