/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSet;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.EnvironmentAwareCommand;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.KeyStoreWrapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;

class CreateKeyStoreCommand
extends EnvironmentAwareCommand {
    CreateKeyStoreCommand() {
        super("Creates a new elasticsearch keystore");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        Path keystoreFile = KeyStoreWrapper.keystorePath(env.configFile());
        if (Files.exists(keystoreFile, new LinkOption[0]) && !terminal.promptYesNo("An elasticsearch keystore already exists. Overwrite?", false)) {
            terminal.println("Exiting without creating keystore.");
            return;
        }
        char[] password = new char[]{};
        KeyStoreWrapper keystore = KeyStoreWrapper.create(password);
        keystore.save(env.configFile());
        terminal.println("Created elasticsearch keystore in " + env.configFile());
    }
}

