/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.AlreadyExpiredException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.EnabledAttributeMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.LegacyLongFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.Mapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParseContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.SourceToParse;

public class TTLFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_ttl";
    public static final String CONTENT_TYPE = "_ttl";
    private EnabledAttributeMapper enabledState;
    private long defaultTTL;

    private TTLFieldMapper(Settings indexSettings) {
        this(Defaults.TTL_FIELD_TYPE.clone(), Defaults.ENABLED_STATE, -1L, indexSettings);
    }

    private TTLFieldMapper(MappedFieldType fieldType, EnabledAttributeMapper enabled, long defaultTTL, Settings indexSettings) {
        super("_ttl", fieldType, Defaults.TTL_FIELD_TYPE, indexSettings);
        if (enabled.enabled && Version.indexCreated(indexSettings).onOrAfter(Version.V_5_0_0_alpha4)) {
            throw new IllegalArgumentException("[_ttl] is removed in 5.0. As a replacement, you should use time based indexes or cron a delete-by-query with a range query on a timestamp field.");
        }
        this.enabledState = enabled;
        this.defaultTTL = defaultTTL;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public long defaultTTL() {
        return this.defaultTTL;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException, MapperParsingException {
        if (context.sourceToParse().ttl() < 0L) {
            long ttl = context.parser().currentToken() == XContentParser.Token.VALUE_STRING ? TimeValue.parseTimeValue(context.parser().text(), null, "ttl").millis() : context.parser().longValue(true);
            if (ttl <= 0L) {
                throw new MapperParsingException("TTL value must be > 0. Illegal value provided [" + ttl + "]");
            }
            context.sourceToParse().ttl(ttl);
        }
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException, AlreadyExpiredException {
        if (this.enabledState.enabled) {
            long ttl = context.sourceToParse().ttl();
            if (ttl <= 0L && this.defaultTTL > 0L) {
                ttl = this.defaultTTL;
                context.sourceToParse().ttl(ttl);
            }
            if (ttl > 0L) {
                long timestamp = context.sourceToParse().timestamp();
                long expire = new Date(timestamp + ttl).getTime();
                long now = System.currentTimeMillis();
                if (context.sourceToParse().origin() == SourceToParse.Origin.PRIMARY && now >= expire) {
                    throw new AlreadyExpiredException(context.sourceToParse().index(), context.sourceToParse().type(), context.sourceToParse().id(), timestamp, ttl, now);
                }
                fields.add(new LegacyLongFieldMapper.CustomLongNumericField(expire, this.fieldType()));
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabledState == Defaults.ENABLED_STATE && this.defaultTTL == -1L) {
            return builder;
        }
        builder.startObject("_ttl");
        if (includeDefaults || this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (includeDefaults || this.defaultTTL != -1L && this.enabledState.enabled) {
            builder.field("default", this.defaultTTL);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected String contentType() {
        return "_ttl";
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        TTLFieldMapper ttlMergeWith = (TTLFieldMapper)mergeWith;
        if (ttlMergeWith.enabledState != Defaults.ENABLED_STATE) {
            if (this.enabledState == EnabledAttributeMapper.ENABLED && ttlMergeWith.enabledState == EnabledAttributeMapper.DISABLED) {
                throw new IllegalArgumentException("_ttl cannot be disabled once it was enabled.");
            }
            this.enabledState = ttlMergeWith.enabledState;
        }
        if (ttlMergeWith.defaultTTL != -1L && this.enabledState == EnabledAttributeMapper.ENABLED) {
            this.defaultTTL = ttlMergeWith.defaultTTL;
        }
    }

    public static final class TTLFieldType
    extends LegacyLongFieldMapper.LongFieldType {
        public TTLFieldType() {
        }

        protected TTLFieldType(TTLFieldType ref) {
            super(ref);
        }

        @Override
        public TTLFieldType clone() {
            return new TTLFieldType(this);
        }

        @Override
        public Object valueForDisplay(Object value) {
            long now = System.currentTimeMillis();
            Long val = (Long)super.valueForDisplay(value);
            return val - now;
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_5_0_0_alpha4)) {
                throw new IllegalArgumentException("[_ttl] is removed in 5.0. As a replacement, you should use time based indexes or cron a delete-by-query with a range query on a timestamp field.");
            }
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    EnabledAttributeMapper enabledState = XContentMapValues.lenientNodeBooleanValue(fieldNode, fieldName) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                    builder.enabled(enabledState);
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("default")) continue;
                TimeValue ttlTimeValue = XContentMapValues.nodeTimeValue(fieldNode, null);
                if (ttlTimeValue != null) {
                    builder.defaultTTL(ttlTimeValue.millis());
                }
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            Settings indexSettings = context.mapperService().getIndexSettings().getSettings();
            return new TTLFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, TTLFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;
        private long defaultTTL = -1L;

        public Builder() {
            super("_ttl", Defaults.TTL_FIELD_TYPE, Defaults.FIELD_TYPE);
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabledState = enabled;
            return (Builder)this.builder;
        }

        public Builder defaultTTL(long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return (Builder)this.builder;
        }

        @Override
        public TTLFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(false);
            return new TTLFieldMapper(this.fieldType, this.enabledState, this.defaultTTL, context.indexSettings());
        }
    }

    public static class Defaults
    extends LegacyLongFieldMapper.Defaults {
        public static final String NAME = "_ttl";
        public static final TTLFieldType TTL_FIELD_TYPE = new TTLFieldType();
        public static final EnabledAttributeMapper ENABLED_STATE;
        public static final long DEFAULT = -1L;

        static {
            TTL_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            TTL_FIELD_TYPE.setStored(true);
            TTL_FIELD_TYPE.setTokenized(false);
            TTL_FIELD_TYPE.setNumericPrecisionStep(16);
            TTL_FIELD_TYPE.setName("_ttl");
            TTL_FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            TTL_FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            TTL_FIELD_TYPE.freeze();
            ENABLED_STATE = EnabledAttributeMapper.UNSET_DISABLED;
        }
    }
}

