/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.indices;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;

public class TermsLookup
implements Writeable,
ToXContent {
    private String index;
    private final String type;
    private final String id;
    private final String path;
    private String routing;

    public TermsLookup(TermsLookup copy) {
        this(copy.index, copy.type, copy.id, copy.path);
        this.routing = copy.routing;
    }

    public TermsLookup(String index, String type, String id, String path) {
        if (id == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the id.");
        }
        if (type == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the type.");
        }
        if (path == null) {
            throw new IllegalArgumentException("[terms] query lookup element requires specifying the path.");
        }
        this.index = index;
        this.type = type;
        this.id = id;
        this.path = path;
    }

    public TermsLookup(StreamInput in) throws IOException {
        this.type = in.readString();
        this.id = in.readString();
        this.path = in.readString();
        this.index = in.readOptionalString();
        this.routing = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeString(this.path);
        out.writeOptionalString(this.index);
        out.writeOptionalString(this.routing);
    }

    public String index() {
        return this.index;
    }

    public TermsLookup index(String index) {
        this.index = index;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String path() {
        return this.path;
    }

    public String routing() {
        return this.routing;
    }

    public TermsLookup routing(String routing) {
        this.routing = routing;
        return this;
    }

    public static TermsLookup parseTermsLookup(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String index = null;
        String type = null;
        String id = null;
        String path = null;
        String routing = null;
        String currentFieldName = "";
        block14: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                switch (currentFieldName) {
                    case "index": {
                        index = parser.textOrNull();
                        continue block14;
                    }
                    case "type": {
                        type = parser.text();
                        continue block14;
                    }
                    case "id": {
                        id = parser.text();
                        continue block14;
                    }
                    case "routing": {
                        routing = parser.textOrNull();
                        continue block14;
                    }
                    case "path": {
                        path = parser.text();
                        continue block14;
                    }
                }
                throw new ParsingException(parser.getTokenLocation(), "[terms] query does not support [" + currentFieldName + "] within lookup element", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[terms] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        return new TermsLookup(index, type, id, path).routing(routing);
    }

    public String toString() {
        return this.index + "/" + this.type + "/" + this.id + "/" + this.path;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.index != null) {
            builder.field("index", this.index);
        }
        builder.field("type", this.type);
        builder.field("id", this.id);
        builder.field("path", this.path);
        if (this.routing != null) {
            builder.field("routing", this.routing);
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.type, this.id, this.path, this.routing);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermsLookup other = (TermsLookup)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.type, other.type) && Objects.equals(this.id, other.id) && Objects.equals(this.path, other.path) && Objects.equals(this.routing, other.routing);
    }
}

