/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.ProcessorInfo;

public class IngestInfo
implements Writeable,
ToXContent {
    private final Set<ProcessorInfo> processors;

    public IngestInfo(List<ProcessorInfo> processors) {
        this.processors = new TreeSet<ProcessorInfo>(processors);
    }

    public IngestInfo(StreamInput in) throws IOException {
        this.processors = new TreeSet<ProcessorInfo>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.processors.add(new ProcessorInfo(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.write(this.processors.size());
        for (ProcessorInfo info : this.processors) {
            info.writeTo(out);
        }
    }

    public Iterable<ProcessorInfo> getProcessors() {
        return this.processors;
    }

    public boolean containsProcessor(String type) {
        return this.processors.contains(new ProcessorInfo(type));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("ingest");
        builder.startArray("processors");
        for (ProcessorInfo info : this.processors) {
            info.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestInfo that = (IngestInfo)o;
        return Objects.equals(this.processors, that.processors);
    }

    public int hashCode() {
        return Objects.hash(this.processors);
    }
}

