/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.get.UpgradeStatusRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.get.UpgradeStatusResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.Tuple;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestBuilderListener;

public class RestUpgradeAction
extends BaseRestHandler {
    public RestUpgradeAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_upgrade", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_upgrade", this);
        controller.registerHandler(RestRequest.Method.GET, "/_upgrade", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_upgrade", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method().equals((Object)RestRequest.Method.GET)) {
            return this.handleGet(request, client);
        }
        if (request.method().equals((Object)RestRequest.Method.POST)) {
            return this.handlePost(request, client);
        }
        throw new IllegalArgumentException("illegal method [" + (Object)((Object)request.method()) + "] for request [" + request.path() + "]");
    }

    private BaseRestHandler.RestChannelConsumer handleGet(final RestRequest request, NodeClient client) {
        UpgradeStatusRequest statusRequest = new UpgradeStatusRequest(Strings.splitStringByCommaToArray(request.param("index")));
        statusRequest.indicesOptions(IndicesOptions.fromRequest(request, statusRequest.indicesOptions()));
        return channel -> client.admin().indices().upgradeStatus(statusRequest, (ActionListener<UpgradeStatusResponse>)new RestBuilderListener<UpgradeStatusResponse>(channel){

            @Override
            public RestResponse buildResponse(UpgradeStatusResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                response.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    private BaseRestHandler.RestChannelConsumer handlePost(final RestRequest request, NodeClient client) {
        UpgradeRequest upgradeReq = new UpgradeRequest(Strings.splitStringByCommaToArray(request.param("index")));
        upgradeReq.indicesOptions(IndicesOptions.fromRequest(request, upgradeReq.indicesOptions()));
        upgradeReq.upgradeOnlyAncientSegments(request.paramAsBoolean("only_ancient_segments", false));
        return channel -> client.admin().indices().upgrade(upgradeReq, (ActionListener<UpgradeResponse>)new RestBuilderListener<UpgradeResponse>(channel){

            @Override
            public RestResponse buildResponse(UpgradeResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, request, response);
                builder.startObject("upgraded_indices");
                for (Map.Entry<String, Tuple<Version, String>> entry : response.versions().entrySet()) {
                    builder.startObject(entry.getKey());
                    builder.field("upgrade_version", entry.getValue().v1());
                    builder.field("oldest_lucene_segment_version", entry.getValue().v2());
                    builder.endObject();
                }
                builder.endObject();
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

