/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lease.Releasables;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.SignificantTermsAggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.ContextIndexSearcher;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class SignificantStringTermsAggregator
extends StringTermsAggregator {
    protected long numCollectedDocs;
    protected final SignificantTermsAggregatorFactory termsAggFactory;
    private final SignificanceHeuristic significanceHeuristic;

    public SignificantStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, SearchContext aggregationContext, Aggregator parent, SignificanceHeuristic significanceHeuristic, SignificantTermsAggregatorFactory termsAggFactory, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, valuesSource, null, format, bucketCountThresholds, includeExclude, aggregationContext, parent, Aggregator.SubAggCollectionMode.DEPTH_FIRST, false, pipelineAggregators, metaData);
        this.significanceHeuristic = significanceHeuristic;
        this.termsAggFactory = termsAggFactory;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        return new LeafBucketCollectorBase(super.getLeafCollector(ctx, sub), null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                super.collect(doc, bucket);
                ++SignificantStringTermsAggregator.this.numCollectedDocs;
            }
        };
    }

    @Override
    public SignificantStringTerms buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long supersetSize = this.termsAggFactory.getSupersetNumDocs();
        long subsetSize = this.numCollectedDocs;
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        SignificantStringTerms.Bucket spare = null;
        int i = 0;
        while ((long)i < this.bucketOrds.size()) {
            int docCount = this.bucketDocCount(i);
            if ((long)docCount >= this.bucketCountThresholds.getShardMinDocCount()) {
                if (spare == null) {
                    spare = new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, 0L, 0L, null, this.format);
                }
                this.bucketOrds.get(i, spare.termBytes);
                spare.subsetDf = docCount;
                spare.subsetSize = subsetSize;
                spare.supersetDf = this.termsAggFactory.getBackgroundFrequency(spare.termBytes);
                spare.supersetSize = supersetSize;
                spare.updateScore(this.significanceHeuristic);
                spare.bucketOrd = i;
                spare = ordered.insertWithOverflow(spare);
            }
            ++i;
        }
        SignificantStringTerms.Bucket[] list = new SignificantStringTerms.Bucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            SignificantStringTerms.Bucket bucket = (SignificantStringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf(bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return new SignificantStringTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, subsetSize, supersetSize, this.significanceHeuristic, Arrays.asList(list));
    }

    @Override
    public SignificantStringTerms buildEmptyAggregation() {
        ContextIndexSearcher searcher = this.context.searcher();
        IndexReader topReader = searcher.getIndexReader();
        int supersetSize = topReader.numDocs();
        return new SignificantStringTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, 0L, (long)supersetSize, this.significanceHeuristic, Collections.emptyList());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds, this.termsAggFactory);
    }
}

