/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.geocentroid;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.geo.GeoPoint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.geocentroid.GeoCentroid;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalGeoCentroid
extends InternalAggregation
implements GeoCentroid {
    private final GeoPoint centroid;
    private final long count;

    public InternalGeoCentroid(String name, GeoPoint centroid, long count, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        assert (centroid == null == (count == 0L));
        this.centroid = centroid;
        assert (count >= 0L);
        this.count = count;
    }

    public InternalGeoCentroid(StreamInput in) throws IOException {
        super(in);
        this.count = in.readVLong();
        if (in.readBoolean()) {
            long hash = in.readLong();
            this.centroid = new GeoPoint(GeoPointField.decodeLatitude(hash), GeoPointField.decodeLongitude(hash));
        } else {
            this.centroid = null;
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (this.centroid != null) {
            out.writeBoolean(true);
            out.writeLong(GeoPointField.encodeLatLon(this.centroid.lat(), this.centroid.lon()));
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getWriteableName() {
        return "geo_centroid";
    }

    @Override
    public GeoPoint centroid() {
        return this.centroid;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public InternalGeoCentroid doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double lonSum = Double.NaN;
        double latSum = Double.NaN;
        int totalCount = 0;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoCentroid centroidAgg = (InternalGeoCentroid)aggregation;
            if (centroidAgg.count <= 0L) continue;
            totalCount = (int)((long)totalCount + centroidAgg.count);
            if (Double.isNaN(lonSum)) {
                lonSum = (double)centroidAgg.count * centroidAgg.centroid.getLon();
                latSum = (double)centroidAgg.count * centroidAgg.centroid.getLat();
                continue;
            }
            lonSum += (double)centroidAgg.count * centroidAgg.centroid.getLon();
            latSum += (double)centroidAgg.count * centroidAgg.centroid.getLat();
        }
        GeoPoint result = Double.isNaN(lonSum) ? null : new GeoPoint(latSum / (double)totalCount, lonSum / (double)totalCount);
        return new InternalGeoCentroid(this.name, result, totalCount, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String coordinate;
            switch (coordinate = path.get(0)) {
                case "value": {
                    return this.centroid;
                }
                case "lat": {
                    return this.centroid.lat();
                }
                case "lon": {
                    return this.centroid.lon();
                }
                case "count": {
                    return this.count;
                }
            }
            throw new IllegalArgumentException("Found unknown path element [" + coordinate + "] in [" + this.getName() + "]");
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(Fields.CENTROID.getPreferredName()).field("lat", this.centroid.lat()).field("lon", this.centroid.lon()).endObject();
        }
        builder.field(Fields.COUNT.getPreferredName(), this.count);
        return builder;
    }

    static class Fields {
        static final ParseField CENTROID = new ParseField("location", new String[0]);
        static final ParseField COUNT = new ParseField("count", new String[0]);
        static final ParseField CENTROID_LAT = new ParseField("lat", new String[0]);
        static final ParseField CENTROID_LON = new ParseField("lon", new String[0]);

        Fields() {
        }
    }
}

