/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ExecutableScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.Script;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.SearchScript;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchParseException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetricAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public class ScriptedMetricAggregatorFactory
extends AggregatorFactory<ScriptedMetricAggregatorFactory> {
    private final Function<Map<String, Object>, SearchScript> mapScript;
    private final Function<Map<String, Object>, ExecutableScript> combineScript;
    private final Script reduceScript;
    private final Map<String, Object> params;
    private final Function<Map<String, Object>, ExecutableScript> initScript;

    public ScriptedMetricAggregatorFactory(String name, Function<Map<String, Object>, SearchScript> mapScript, Function<Map<String, Object>, ExecutableScript> initScript, Function<Map<String, Object>, ExecutableScript> combineScript, Script reduceScript, Map<String, Object> params, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.mapScript = mapScript;
        this.initScript = initScript;
        this.combineScript = combineScript;
        this.reduceScript = reduceScript;
        this.params = params;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return ScriptedMetricAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        Map<String, Object> params = this.params;
        if (params != null) {
            params = ScriptedMetricAggregatorFactory.deepCopyParams(params, this.context);
        } else {
            params = new HashMap<String, Object>();
            params.put("_agg", new HashMap());
        }
        ExecutableScript initScript = this.initScript.apply(params);
        SearchScript mapScript = this.mapScript.apply(params);
        ExecutableScript combineScript = this.combineScript.apply(params);
        Script reduceScript = ScriptedMetricAggregatorFactory.deepCopyScript(this.reduceScript, this.context);
        if (initScript != null) {
            initScript.run();
        }
        return new ScriptedMetricAggregator(this.name, mapScript, combineScript, reduceScript, params, this.context, parent, pipelineAggregators, metaData);
    }

    private static Script deepCopyScript(Script script, SearchContext context) {
        if (script != null) {
            Map<String, Object> params = script.getParams();
            if (params != null) {
                params = ScriptedMetricAggregatorFactory.deepCopyParams(params, context);
            }
            return new Script(script.getType(), script.getLang(), script.getIdOrCode(), params);
        }
        return null;
    }

    private static <T> T deepCopyParams(T original, SearchContext context) {
        Object clone;
        if (original instanceof Map) {
            Map originalMap = (Map)original;
            HashMap clonedMap = new HashMap();
            for (Map.Entry e : originalMap.entrySet()) {
                clonedMap.put(ScriptedMetricAggregatorFactory.deepCopyParams(e.getKey(), context), ScriptedMetricAggregatorFactory.deepCopyParams(e.getValue(), context));
            }
            clone = clonedMap;
        } else if (original instanceof List) {
            List originalList = (List)original;
            ArrayList clonedList = new ArrayList();
            for (Object o : originalList) {
                clonedList.add(ScriptedMetricAggregatorFactory.deepCopyParams(o, context));
            }
            clone = clonedList;
        } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Short || original instanceof Byte || original instanceof Float || original instanceof Double || original instanceof Character || original instanceof Boolean) {
            clone = original;
        } else {
            throw new SearchParseException(context, "Can only clone primitives, String, ArrayList, and HashMap. Found: " + original.getClass().getCanonicalName(), null);
        }
        return clone;
    }
}

