/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.MapperService;

public class LeafDocLookup
implements Map<String, ScriptDocValues<?>> {
    private final Map<String, ScriptDocValues<?>> localCacheFieldData = new HashMap(4);
    private final MapperService mapperService;
    private final IndexFieldDataService fieldDataService;
    @Nullable
    private final String[] types;
    private final LeafReaderContext reader;
    private int docId = -1;

    LeafDocLookup(MapperService mapperService, IndexFieldDataService fieldDataService, @Nullable String[] types, LeafReaderContext reader) {
        this.mapperService = mapperService;
        this.fieldDataService = fieldDataService;
        this.types = types;
        this.reader = reader;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public IndexFieldDataService fieldDataService() {
        return this.fieldDataService;
    }

    public void setDocument(int docId) {
        this.docId = docId;
    }

    @Override
    public ScriptDocValues<?> get(Object key) {
        String fieldName = key.toString();
        ScriptDocValues scriptValues = this.localCacheFieldData.get(fieldName);
        if (scriptValues == null) {
            final MappedFieldType fieldType = this.mapperService.fullName(fieldName);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + fieldName + "] in mapping with types " + Arrays.toString(this.types));
            }
            scriptValues = (ScriptDocValues)AccessController.doPrivileged(new PrivilegedAction<ScriptDocValues<?>>(){

                @Override
                public ScriptDocValues<?> run() {
                    return LeafDocLookup.this.fieldDataService.getForField(fieldType).load(LeafDocLookup.this.reader).getScriptValues();
                }
            });
            this.localCacheFieldData.put(fieldName, scriptValues);
        }
        scriptValues.setNextDocId(this.docId);
        return scriptValues;
    }

    @Override
    public boolean containsKey(Object key) {
        MappedFieldType fieldType;
        String fieldName = key.toString();
        ScriptDocValues<?> scriptValues = this.localCacheFieldData.get(fieldName);
        return scriptValues != null || (fieldType = this.mapperService.fullName(fieldName)) != null;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> put(String key, ScriptDocValues<?> value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScriptDocValues<?> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends ScriptDocValues<?>> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ScriptDocValues<?>> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, ScriptDocValues<?>>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

